/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.edit.itemsfilter;

import com.ibm.uma.Artifact;
import com.ibm.uma.ContentElement;
import com.ibm.uma.ContentPackage;
import com.ibm.uma.CustomCategory;
import com.ibm.uma.DescribableElement;
import com.ibm.uma.Domain;
import com.ibm.uma.MethodElement;
import com.ibm.uma.MethodPlugin;
import com.ibm.uma.Process;
import com.ibm.uma.ProcessComponent;
import com.ibm.uma.VariabilityElement;
import com.ibm.uma.WorkProductType;
import commonj.sdo.DataObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.epf.library.edit.itemsfilter.ContentCategoriesGroupItemProvider;
import org.eclipse.epf.library.edit.itemsfilter.FilterConstants;
import org.eclipse.epf.library.edit.util.MethodElementUtil;
import org.eclipse.epf.library.edit.util.ModelStructure;
import org.eclipse.epf.library.edit.util.TngUtil;

public class FilterHelper {
    private String pattern;
    private String filterTypeStr;
    private Pattern regexPattern;
    private String tabStr;
    private Object contentElement;
    private List alreadySelectedList = new ArrayList();
    private boolean showPresentationName = false;

    public FilterHelper(Object contentElement, String tabStr, String pattern, String filterTypeStr, List alreadySelectedList) {
        this.contentElement = contentElement;
        this.tabStr = tabStr;
        this.filterTypeStr = filterTypeStr;
        this.alreadySelectedList = alreadySelectedList;
        this.pattern = pattern;
    }

    public List getAlreadySelectedList() {
        return this.alreadySelectedList;
    }

    public void setAlreadySelectedList(List alreadySelectedList) {
        this.alreadySelectedList = alreadySelectedList;
    }

    public boolean matchPattern(Object obj) {
        if (TngUtil.showPresentationNames) {
            return this.matchPatternOnPresentationName(obj);
        }
        if (this.filterTypeStr == null || this.pattern == null || this.pattern.equalsIgnoreCase("")) {
            return true;
        }
        if (this.filterTypeStr.equalsIgnoreCase(this.tabStr)) {
            if (obj instanceof ContentElement) {
                Matcher m = this.regexPattern.matcher(((ContentElement)obj).getName());
                boolean found = m.matches();
                if (found) {
                    return true;
                }
                if (obj instanceof CustomCategory) {
                    return this.hasMatchedChildCustomCategory((CustomCategory)obj);
                }
                if (obj instanceof Artifact) {
                    EObject container = ((Artifact)obj).eContainer();
                    if (container instanceof Artifact && (m = this.regexPattern.matcher(((MethodElement)container).getName())).matches()) {
                        return true;
                    }
                    return this.hasMatchedArtifact((Artifact)obj);
                }
                return false;
            }
            if (obj instanceof ProcessComponent || obj instanceof Process) {
                Matcher m = this.regexPattern.matcher(((MethodElement)obj).getName());
                boolean found = m.matches();
                return found;
            }
            return true;
        }
        if (this.filterTypeStr.equalsIgnoreCase(FilterConstants.CONTENT_PACKAGES)) {
            Matcher m;
            DataObject container;
            if (obj instanceof ContentPackage) {
                Matcher m2 = this.regexPattern.matcher(((ContentPackage)obj).getName());
                boolean found = m2.matches();
                return found || this.hasMatchedChild((ContentPackage)obj);
            }
            return !(obj instanceof ContentElement) || !((container = ((ContentElement)obj).getContainer()) instanceof ContentPackage) || (m = this.regexPattern.matcher(((MethodElement)container).getName())).matches();
        }
        if (this.filterTypeStr.equalsIgnoreCase(FilterConstants.METHO_PLUGINS)) {
            if (obj instanceof MethodPlugin) {
                Matcher m = this.regexPattern.matcher(((MethodPlugin)obj).getName());
                boolean found = m.matches();
                return found;
            }
            return true;
        }
        return true;
    }

    private boolean hasMatchedChildCustomCategory(CustomCategory topCategory) {
        List list = topCategory.getCategorizedElements();
        Iterator iter = list.iterator();
        while (iter.hasNext()) {
            Object object = iter.next();
            if (!(object instanceof CustomCategory)) continue;
            CustomCategory category = (CustomCategory)object;
            Matcher marcher = this.regexPattern.matcher(category.getName());
            if (marcher.matches()) {
                return true;
            }
            if (!this.hasMatchedChildCustomCategory(category)) continue;
            return true;
        }
        return false;
    }

    private boolean hasMatchedArtifact(Artifact artifact) {
        List list = artifact.getContainedArtifacts();
        Iterator iter = list.iterator();
        while (iter.hasNext()) {
            Object object = iter.next();
            if (!(object instanceof Artifact)) continue;
            Artifact subartifact = (Artifact)object;
            Matcher marcher = this.regexPattern.matcher(subartifact.getName());
            if (marcher.matches()) {
                return true;
            }
            if (!this.hasMatchedArtifact(subartifact)) continue;
            return true;
        }
        return false;
    }

    private boolean hasMatchedChild(ContentPackage pkg) {
        Iterator iter = pkg.getChildPackages().iterator();
        while (iter.hasNext()) {
            Object childPkg = iter.next();
            if (!(childPkg instanceof ContentPackage)) continue;
            ContentPackage contentPkg = (ContentPackage)childPkg;
            Matcher marcher = this.regexPattern.matcher(contentPkg.getName());
            if (marcher.matches()) {
                return true;
            }
            if (!this.hasMatchedChild(contentPkg)) continue;
            return true;
        }
        return false;
    }

    public String getFilterTypeStr() {
        return this.filterTypeStr;
    }

    public String getPattern() {
        return this.pattern;
    }

    public Pattern getRegexPattern() {
        return this.regexPattern;
    }

    public String getTabStr() {
        return this.tabStr;
    }

    public boolean checkVariability(Object obj) {
        VariabilityElement variabilityObject;
        return this.contentElement instanceof ContentElement && (variabilityObject = ((ContentElement)this.contentElement).getVariabilityBasedOnElement()) != null && obj.equals(variabilityObject);
    }

    public Object getContentElement() {
        return this.contentElement;
    }

    public void setContentElement(Object contentElement) {
        this.contentElement = contentElement;
    }

    public void setFilterTypeStr(String filterTypeStr) {
        this.filterTypeStr = filterTypeStr;
    }

    public void setPattern(String pattern) {
        this.pattern = pattern;
    }

    public void setRegexPattern(Pattern regexPattern) {
        this.regexPattern = regexPattern;
    }

    public void setTabStr(String tabStr) {
        this.tabStr = tabStr;
    }

    public String[] getPathBasedOnTabString(String tabStr) {
        if (FilterConstants.contentElementStrs.contains(tabStr)) {
            return ModelStructure.DEFAULT.coreContentPath;
        }
        if (tabStr.equals(FilterConstants.ROLESETS) || tabStr.equals(FilterConstants.ROLE_SET_GROUPINGS)) {
            return ModelStructure.DEFAULT.roleSetPath;
        }
        if (tabStr.equals(FilterConstants.DISCIPLINES) || tabStr.equals(FilterConstants.DISCIPLINE_GROUPINGS)) {
            return ModelStructure.DEFAULT.disciplineDefinitionPath;
        }
        if (tabStr.equals(FilterConstants.TOOLS)) {
            return ModelStructure.DEFAULT.toolPath;
        }
        if (tabStr.equals(FilterConstants.WORKPRODUCTTYPES)) {
            return ModelStructure.DEFAULT.workProductTypePath;
        }
        if (tabStr.equals(FilterConstants.DOMAINS)) {
            return ModelStructure.DEFAULT.domainPath;
        }
        if (tabStr.equals(FilterConstants.CUSTOM_CATEGORIES)) {
            return ModelStructure.DEFAULT.customCategoryPath;
        }
        return ModelStructure.DEFAULT.coreContentPath;
    }

    public boolean checkObjectAccepted(Object obj) {
        if (!this.matchPattern(obj)) {
            return false;
        }
        if (this.getAlreadySelectedList() != null && this.getAlreadySelectedList().contains(obj)) {
            return false;
        }
        if (this.checkVariability(obj)) {
            return false;
        }
        return obj instanceof MethodPlugin || this.contentElement == null || !obj.equals(this.contentElement);
    }

    public boolean acceptMethodPlugin(Object obj) {
        if (this.contentElement != null) {
            return MethodElementUtil.getAllModels(this.contentElement).contains(obj);
        }
        return true;
    }

    public boolean acceptContentPackage(Object obj) {
        return !((ContentPackage)obj).getChildPackages().isEmpty() || !((ContentPackage)obj).getContentElements().isEmpty();
    }

    public boolean isObjectInSelectedItems(Object obj) {
        return this.getAlreadySelectedList() == null || !this.getAlreadySelectedList().contains(obj);
    }

    public boolean isContributor(ContentElement element) {
        return false;
    }

    public boolean matchPatternForAllFilter(Object obj) {
        if (this.filterTypeStr == null) {
            return true;
        }
        if (this.filterTypeStr.equals(FilterConstants.ALL_ELEMENTS)) {
            return this.matchPattern(obj);
        }
        if (this.filterTypeStr.equals(FilterConstants.DISCIPLINES)) {
            if (obj instanceof MethodPlugin) {
                return true;
            }
            if (obj instanceof ContentElement) {
                if (this.pattern == null || this.pattern.equalsIgnoreCase("")) {
                    return true;
                }
                Matcher m = this.regexPattern.matcher(((ContentElement)obj).getName());
                boolean found = m.matches();
                return found;
            }
            if (obj instanceof ContentCategoriesGroupItemProvider) {
                Collection list = ((ContentCategoriesGroupItemProvider)obj).getChildren(obj);
                return !list.isEmpty();
            }
            return false;
        }
        if (this.filterTypeStr.equals(FilterConstants.WORKPRODUCTTYPES)) {
            if (obj instanceof WorkProductType) {
                Matcher m = this.regexPattern.matcher(((ContentElement)obj).getName());
                boolean found = m.matches();
                return found;
            }
            return false;
        }
        if (this.filterTypeStr.equals(FilterConstants.DOMAINS)) {
            if (obj instanceof Domain) {
                Matcher m = this.regexPattern.matcher(((ContentElement)obj).getName());
                boolean found = m.matches();
                return found;
            }
            return false;
        }
        return true;
    }

    public boolean matchPatternBasedOnType(Object obj) {
        if (obj instanceof ContentElement || obj instanceof ProcessComponent || obj instanceof Process) {
            if (this.pattern == null || this.pattern.equalsIgnoreCase("")) {
                return true;
            }
            Matcher m = this.regexPattern.matcher(((MethodElement)obj).getName());
            boolean found = m.matches();
            if (found) {
                return true;
            }
            if (obj instanceof CustomCategory) {
                return this.hasMatchedChildCustomCategory((CustomCategory)obj);
            }
            return false;
        }
        return true;
    }

    public boolean matchPatternOnPresentationName(Object obj) {
        if (this.filterTypeStr == null || this.pattern == null || this.pattern.equalsIgnoreCase("")) {
            return true;
        }
        if (this.filterTypeStr.equalsIgnoreCase(this.tabStr)) {
            if (obj instanceof ContentElement) {
                Matcher m = this.regexPattern.matcher(((DescribableElement)obj).getPresentationName());
                boolean found = m.matches();
                if (found) {
                    return true;
                }
                if (obj instanceof CustomCategory) {
                    return this.hasMatchedChildCustomCategory((CustomCategory)obj, true);
                }
                if (obj instanceof Artifact) {
                    EObject container = ((Artifact)obj).eContainer();
                    if (container instanceof Artifact && (m = this.regexPattern.matcher(((DescribableElement)container).getPresentationName())).matches()) {
                        return true;
                    }
                    return this.hasMatchedArtifact((Artifact)obj, true);
                }
                return false;
            }
            if (obj instanceof ProcessComponent || obj instanceof Process) {
                Matcher m = this.regexPattern.matcher(((MethodElement)obj).getName());
                boolean found = m.matches();
                return found;
            }
            return true;
        }
        if (this.filterTypeStr.equalsIgnoreCase(FilterConstants.CONTENT_PACKAGES)) {
            Matcher m;
            DataObject container;
            if (obj instanceof ContentPackage) {
                Matcher m2 = this.regexPattern.matcher(((ContentPackage)obj).getName());
                boolean found = m2.matches();
                return found || this.hasMatchedChild((ContentPackage)obj);
            }
            return !(obj instanceof ContentElement) || !((container = ((ContentElement)obj).getContainer()) instanceof ContentPackage) || (m = this.regexPattern.matcher(((MethodElement)container).getName())).matches();
        }
        if (this.filterTypeStr.equalsIgnoreCase(FilterConstants.METHO_PLUGINS)) {
            if (obj instanceof MethodPlugin) {
                Matcher m = this.regexPattern.matcher(((MethodPlugin)obj).getName());
                boolean found = m.matches();
                return found;
            }
            return true;
        }
        return true;
    }

    private boolean hasMatchedChildCustomCategory(CustomCategory topCategory, boolean showPresentationName) {
        List list = topCategory.getCategorizedElements();
        Iterator iter = list.iterator();
        while (iter.hasNext()) {
            Matcher marcher;
            Object object = iter.next();
            if (!(object instanceof CustomCategory)) continue;
            CustomCategory category = (CustomCategory)object;
            String string = category.getName();
            if (showPresentationName) {
                string = category.getPresentationName();
            }
            if ((marcher = this.regexPattern.matcher(string)).matches()) {
                return true;
            }
            if (!this.hasMatchedChildCustomCategory(category, showPresentationName)) continue;
            return true;
        }
        return false;
    }

    private boolean hasMatchedArtifact(Artifact artifact, boolean showPresentationName) {
        List list = artifact.getContainedArtifacts();
        Iterator iter = list.iterator();
        while (iter.hasNext()) {
            Matcher marcher;
            Object object = iter.next();
            if (!(object instanceof Artifact)) continue;
            Artifact subartifact = (Artifact)object;
            String string = subartifact.getName();
            if (showPresentationName) {
                string = subartifact.getPresentationName();
            }
            if ((marcher = this.regexPattern.matcher(string)).matches()) {
                return true;
            }
            if (!this.hasMatchedArtifact(subartifact)) continue;
            return true;
        }
        return false;
    }

    public boolean isShowPresentationName() {
        return this.showPresentationName;
    }

    public void setShowPresentationName(boolean showPresentationName) {
        this.showPresentationName = showPresentationName;
    }
}

