/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.edit.process;

import com.ibm.uma.Activity;
import com.ibm.uma.Artifact;
import com.ibm.uma.BreakdownElement;
import com.ibm.uma.Deliverable;
import com.ibm.uma.WorkProduct;
import com.ibm.uma.WorkProductDescriptor;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.command.CopyCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.provider.ItemProviderAdapter;
import org.eclipse.emf.edit.provider.ViewerNotification;
import org.eclipse.epf.library.edit.command.IActionManager;
import org.eclipse.epf.library.edit.process.DescriptorItemProvider;
import org.eclipse.epf.library.edit.process.IBSItemProvider;
import org.eclipse.epf.library.edit.process.command.WorkProductDescriptorCreateCopyCommand;
import org.eclipse.epf.library.edit.util.ProcessUtil;
import org.eclipse.epf.library.edit.util.TngUtil;

public class WorkProductDescriptorItemProvider
extends DescriptorItemProvider {
    protected Activity activity;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public WorkProductDescriptorItemProvider(AdapterFactory adapterFactory, ItemProviderAdapter delegateItemProvider) {
        super(adapterFactory, delegateItemProvider);
    }

    public Activity getActivity(Object object) {
        Object parent = this.getParent(object);
        while (parent != null) {
            if (parent instanceof Activity) {
                return (Activity)parent;
            }
            AdapterFactory aFactory = TngUtil.getBestAdapterFactory(this.adapterFactory);
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = Class.forName("org.eclipse.emf.edit.provider.ITreeItemContentProvider");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            ItemProviderAdapter adapter = (ItemProviderAdapter)aFactory.adapt(parent, (Object)clazz);
            parent = adapter.getParent(parent);
        }
        return null;
    }

    private Object getDescriptor(Object parentDescriptor, Artifact artifact) {
        Activity activity = this.getActivity(parentDescriptor);
        if (activity == null) {
            return null;
        }
        List list = activity.getBreakdownElements();
        int size = list.size();
        int i = 0;
        while (i < size) {
            Object obj = list.get(i);
            if (obj instanceof WorkProductDescriptor && artifact == ((WorkProductDescriptor)obj).getWorkProduct()) {
                return obj;
            }
            ++i;
        }
        return null;
    }

    public Collection getChildrenFeatures(Object object) {
        return Collections.EMPTY_LIST;
    }

    public Collection getChildren(Object object) {
        WorkProductDescriptor wpDesc = (WorkProductDescriptor)object;
        Collection children = super.getChildren(object);
        Iterator iter = wpDesc.getDeliverableParts().iterator();
        while (iter.hasNext()) {
            WorkProductDescriptor desc = (WorkProductDescriptor)iter.next();
            if (!desc.getSuperActivities().isEmpty()) continue;
            children.add(desc);
        }
        if (wpDesc.getWorkProduct() instanceof Artifact) {
            Artifact artifact = (Artifact)wpDesc.getWorkProduct();
            List list = artifact.getContainedArtifacts();
            int i = 0;
            while (i < list.size()) {
                Object descriptor = this.getDescriptor(object, (Artifact)list.get(i));
                if (descriptor != null) {
                    children.add(descriptor);
                }
                ++i;
            }
        }
        AdapterFactory aFactory = TngUtil.getBestAdapterFactory(this.adapterFactory);
        Iterator iter2 = children.iterator();
        while (iter2.hasNext()) {
            Object e = iter2.next();
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = Class.forName("org.eclipse.emf.edit.provider.ITreeItemContentProvider");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            IBSItemProvider adapter = (IBSItemProvider)aFactory.adapt(e, (Object)clazz);
            adapter.setParent(object);
        }
        return children;
    }

    public void notifyChanged(Notification notification) {
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("com.ibm.uma.WorkProductDescriptor");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        switch (notification.getFeatureID((Class)clazz)) {
            case 19: 
            case 20: {
                this.fireNotifyChanged((Notification)new ViewerNotification(notification, notification.getNotifier(), false, true));
                return;
            }
            case 29: {
                List elements = ProcessUtil.getAffectedElements(notification, null);
                int eventType = notification.getEventType();
                boolean refresh = false;
                Iterator iter = elements.iterator();
                while (iter.hasNext()) {
                    BreakdownElement e = (BreakdownElement)iter.next();
                    if (eventType == 3 || eventType == 5) {
                        ProcessUtil.addToContainer(e, (ItemProviderAdapter)this, false);
                    }
                    if (!e.getSuperActivities().isEmpty()) {
                        this.fireNotifyChanged((Notification)new ViewerNotification(notification, (Object)e, false, true));
                        continue;
                    }
                    refresh = true;
                }
                if (refresh) {
                    this.fireNotifyChanged((Notification)new ViewerNotification(notification, notification.getNotifier(), true, false));
                }
                return;
            }
            case 6: {
                WorkProductDescriptor wpd = (WorkProductDescriptor)notification.getNotifier();
                this.fireNotifyChanged((Notification)new ViewerNotification(notification, (Object)wpd, false, true));
                if (wpd.getWorkProduct() instanceof Deliverable) {
                    Iterator iter = wpd.getDeliverableParts().iterator();
                    while (iter.hasNext()) {
                        Object descriptor = iter.next();
                        this.fireNotifyChanged((Notification)new ViewerNotification(notification, descriptor, false, true));
                    }
                }
                return;
            }
        }
        super.notifyChanged(notification);
    }

    public void setAttribute(Object object, String prop, String txt) {
        WorkProductDescriptor wpd = (WorkProductDescriptor)object;
        if (prop == "entry_state") {
            wpd.setActivityEntryState(txt);
        } else if (prop == "exit_state") {
            wpd.setActivityExitState(txt);
        } else {
            super.setAttribute(object, prop, txt);
        }
    }

    public Collection getEClasses() {
        return ProcessUtil.getPBSEclasses();
    }

    public void moveUp(Object obj, IActionManager actionMgr) {
        Object parent = this.getParent(obj);
        if (parent != null && parent instanceof Activity) {
            TngUtil.moveUp((Activity)parent, obj, this.getEClasses(), actionMgr);
        }
        if (parent != null && parent instanceof WorkProductDescriptor) {
            WorkProduct wp = ((WorkProductDescriptor)parent).getWorkProduct();
            if (wp instanceof Artifact) {
                Artifact artifact = (Artifact)wp;
                List list = artifact.getContainedArtifacts();
                WorkProduct objWP = ((WorkProductDescriptor)obj).getWorkProduct();
                int location = 0;
                int i = 0;
                while (i < list.size()) {
                    if (objWP.equals(list.get(i))) {
                        location = i;
                        break;
                    }
                    ++i;
                }
                ((EList)artifact.getContainedArtifacts()).move(location, location - 1);
            }
            Activity activity = this.getActivity(obj);
            TngUtil.moveUp(activity, obj, this.getEClasses(), actionMgr);
        }
    }

    public void moveDown(Object obj, IActionManager actionMgr) {
        Object parent = this.getParent(obj);
        if (parent != null && parent instanceof Activity) {
            TngUtil.moveDown((Activity)parent, obj, this.getEClasses(), actionMgr);
        }
        if (parent != null && parent instanceof WorkProductDescriptor) {
            WorkProduct wp = ((WorkProductDescriptor)parent).getWorkProduct();
            if (wp instanceof Artifact) {
                Artifact artifact = (Artifact)wp;
                List list = artifact.getContainedArtifacts();
                WorkProduct objWP = ((WorkProductDescriptor)obj).getWorkProduct();
                int location = 0;
                int i = 0;
                while (i < list.size()) {
                    if (objWP.equals(list.get(i))) {
                        location = i;
                        break;
                    }
                    ++i;
                }
                ((EList)artifact.getContainedArtifacts()).move(location, location + 1);
            }
            Activity activity = this.getActivity(obj);
            TngUtil.moveDown(activity, obj, this.getEClasses(), actionMgr);
        }
    }

    protected Command createCreateCopyCommand(EditingDomain domain, EObject owner, CopyCommand.Helper helper) {
        return new WorkProductDescriptorCreateCopyCommand(domain, owner, helper);
    }
}

