/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.edit.process.command;

import com.ibm.uma.Activity;
import com.ibm.uma.BreakdownElement;
import com.ibm.uma.CapabilityPattern;
import com.ibm.uma.DeliveryProcess;
import com.ibm.uma.DescribableElement;
import com.ibm.uma.Process;
import com.ibm.uma.ProcessPackage;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.epf.library.edit.process.command.BSDropCommand;
import org.eclipse.epf.library.edit.ui.IActionTypeProvider;
import org.eclipse.epf.library.edit.util.ActivityHandler;
import org.eclipse.epf.library.edit.util.ProcessUtil;
import org.eclipse.epf.library.edit.util.TngUtil;
import org.eclipse.jface.viewers.Viewer;

public class ActivityDropCommand
extends BSDropCommand {
    private Viewer viewer;
    private List oldPatterns;
    private List patterns;
    private Process targetProcess;
    private boolean isDeliveryProcess;
    private boolean canExtend;
    private int type;

    public ActivityDropCommand(Activity target, List activities, Viewer viewer) {
        super(target, activities);
        this.viewer = viewer;
        this.targetProcess = TngUtil.getOwningProcess((BreakdownElement)target);
        this.isDeliveryProcess = this.targetProcess instanceof DeliveryProcess;
        if (this.isDeliveryProcess) {
            this.oldPatterns = new ArrayList(((DeliveryProcess)this.targetProcess).getIncludesPatterns());
        }
        Iterator iter = activities.iterator();
        while (iter.hasNext()) {
            Process proc = TngUtil.getOwningProcess((BreakdownElement)iter.next());
            if (!(proc instanceof CapabilityPattern) || proc == this.targetProcess) continue;
            this.canExtend = true;
            break;
        }
    }

    public void setType(int type) {
        this.type = type;
    }

    public void execute() {
        IActionTypeProvider actionTypeProvider = (IActionTypeProvider)this.viewer;
        if (this.canExtend && this.viewer != null) {
            this.viewer = null;
            actionTypeProvider.execute(this);
            return;
        }
        super.execute();
    }

    protected boolean preExecute() {
        if (!super.preExecute()) {
            return false;
        }
        ActivityHandler activityHandler = new ActivityHandler();
        if (this.isDeliveryProcess) {
            this.patterns = new ArrayList();
        }
        Iterator iter = this.dropElements.iterator();
        while (iter.hasNext()) {
            Object element = iter.next();
            if (!(element instanceof Activity)) continue;
            Activity act = (Activity)element;
            Process proc = TngUtil.getOwningProcess((BreakdownElement)act);
            if (proc instanceof CapabilityPattern && proc != this.targetProcess) {
                if (this.type == 2) {
                    activityHandler.extend(act);
                    if (this.patterns == null) continue;
                    this.patterns.add(proc);
                    continue;
                }
                activityHandler.copy(act);
                continue;
            }
            activityHandler.copy(act);
        }
        this.dropElements = activityHandler.getActivities();
        return !this.dropElements.isEmpty();
    }

    protected void doExecute() {
        Iterator itor = this.dropElements.iterator();
        ProcessPackage pkg = (ProcessPackage)this.activity.eContainer();
        while (itor.hasNext()) {
            Activity act = (Activity)itor.next();
            List breakdownElements = this.activity.getBreakdownElements();
            if (breakdownElements.size() > 0) {
                ActivityDropCommand.setName(breakdownElements, act);
                ActivityDropCommand.setDefaultPresentationName(breakdownElements, act);
            }
            if (act.eContainer() != null && act.eContainer().eContainer() != pkg) {
                pkg.getChildPackages().add(act.eContainer());
            }
            if (this.patterns == null || this.patterns.isEmpty()) continue;
            DeliveryProcess proc = (DeliveryProcess)this.targetProcess;
            Iterator iter = this.patterns.iterator();
            while (iter.hasNext()) {
                Object pattern = iter.next();
                if (proc.getIncludesPatterns().contains(pattern)) continue;
                proc.getIncludesPatterns().add(pattern);
            }
        }
        this.activity.getBreakdownElements().addAll(this.dropElements);
        this.getModifiedResources().add(this.activity.eResource());
    }

    protected void doUndo() {
        this.activity.getBreakdownElements().removeAll(this.dropElements);
        if (this.isDeliveryProcess) {
            DeliveryProcess proc = (DeliveryProcess)this.targetProcess;
            proc.getIncludesPatterns().clear();
            proc.getIncludesPatterns().addAll(this.oldPatterns);
        }
    }

    public static void setName(List siblings, Activity e) {
        String baseName = e.getName();
        if (!ActivityDropCommand.isNameTaken(siblings, (DescribableElement)e, baseName)) {
            return;
        }
        int i = 1;
        while (true) {
            String name;
            if (!ActivityDropCommand.isNameTaken(siblings, (DescribableElement)e, name = String.valueOf(baseName) + '_' + i)) {
                e.setName(name);
                return;
            }
            ++i;
        }
    }

    public static void setDefaultPresentationName(List siblings, Activity e) {
        String basePresentationName = ProcessUtil.getPresentationName((BreakdownElement)e);
        if (!ActivityDropCommand.isPresentationNameTaken(siblings, (DescribableElement)e, basePresentationName)) {
            return;
        }
        int i = 1;
        while (true) {
            String name;
            if (!ActivityDropCommand.isPresentationNameTaken(siblings, (DescribableElement)e, name = String.valueOf(basePresentationName) + '_' + i)) {
                e.setPresentationName(name);
                return;
            }
            ++i;
        }
    }

    private static boolean isNameTaken(List siblings, DescribableElement e, String name) {
        int i = siblings.size() - 1;
        while (i > -1) {
            BreakdownElement sibling = (BreakdownElement)siblings.get(i);
            if (sibling != e && name.equals(sibling.getName())) {
                return true;
            }
            --i;
        }
        return false;
    }

    private static boolean isPresentationNameTaken(List siblings, DescribableElement e, String name) {
        int i = siblings.size() - 1;
        while (i > -1) {
            BreakdownElement sibling = (BreakdownElement)siblings.get(i);
            if (sibling != e && name.equals(ProcessUtil.getPresentationName(sibling))) {
                return true;
            }
            --i;
        }
        return false;
    }
}

