/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.edit.process.command;

import com.ibm.uma.Activity;
import com.ibm.uma.BreakdownElement;
import com.ibm.uma.Role;
import com.ibm.uma.RoleDescriptor;
import com.ibm.uma.TaskDescriptor;
import com.ibm.uma.TeamProfile;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.eclipse.emf.common.command.AbstractCommand;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.ItemProviderAdapter;
import org.eclipse.epf.library.edit.TngAdapterFactory;
import org.eclipse.epf.library.edit.command.IResourceAwareCommand;
import org.eclipse.epf.library.edit.ui.UserInteractionHelper;
import org.eclipse.epf.library.edit.util.ProcessUtil;

public class AssignPrimaryPerformerToTaskDescriptor
extends AbstractCommand
implements IResourceAwareCommand {
    private RoleDescriptor newRoleDesc = null;
    private RoleDescriptor oldRoleDesc = null;
    private Role role;
    private Activity activity;
    private TaskDescriptor taskDesc;
    private Collection modifiedResources;
    boolean descExists = false;
    private TeamProfile team;
    static /* synthetic */ Class class$0;

    public AssignPrimaryPerformerToTaskDescriptor(TaskDescriptor taskDesc, Role role) {
        ItemProviderAdapter adapter;
        Object parent;
        this.role = role;
        this.taskDesc = taskDesc;
        this.oldRoleDesc = taskDesc.getPerformedPrimarilyBy();
        ComposedAdapterFactory aFactory = TngAdapterFactory.INSTANCE.getWBS_ComposedAdapterFactory();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.emf.edit.provider.ITreeItemContentProvider");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((parent = (adapter = (ItemProviderAdapter)aFactory.adapt((Notifier)taskDesc, (Object)clazz)).getParent((Object)taskDesc)) instanceof Activity) {
            this.activity = (Activity)parent;
        }
        this.modifiedResources = new HashSet();
        if (this.activity.eResource() != null) {
            this.modifiedResources.add(this.activity.eResource());
        }
        if (taskDesc.eResource() != null) {
            this.modifiedResources.add(taskDesc.eResource());
        }
    }

    public void execute() {
        List breakdownElements = this.activity.getBreakdownElements();
        int i = 0;
        while (i < breakdownElements.size()) {
            Role elementRole;
            BreakdownElement element = (BreakdownElement)breakdownElements.get(i);
            if (element instanceof RoleDescriptor && this.role.equals(elementRole = ((RoleDescriptor)element).getRole())) {
                this.descExists = true;
                this.newRoleDesc = (RoleDescriptor)element;
                break;
            }
            ++i;
        }
        if (!this.descExists) {
            this.newRoleDesc = ProcessUtil.createRoleDescriptor(this.role);
        }
        this.team = UserInteractionHelper.getTeam(this.activity, this.role);
        this.redo();
    }

    public void redo() {
        this.taskDesc.setPerformedPrimarilyBy(this.newRoleDesc);
        if (!this.descExists) {
            this.activity.getBreakdownElements().add(this.newRoleDesc);
        }
        if (this.team != null) {
            this.team.getTeamRoles().add(this.newRoleDesc);
        }
    }

    public void undo() {
        this.taskDesc.setPerformedPrimarilyBy(this.oldRoleDesc);
        if (!this.descExists) {
            this.activity.getBreakdownElements().remove(this.newRoleDesc);
        }
        if (this.team != null) {
            this.team.getTeamRoles().remove(this.newRoleDesc);
        }
    }

    protected boolean prepare() {
        return true;
    }

    public Collection getModifiedResources() {
        return this.modifiedResources;
    }
}

