/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.edit.process.command;

import com.ibm.uma.Activity;
import com.ibm.uma.BreakdownElement;
import com.ibm.uma.CapabilityPattern;
import com.ibm.uma.DeliveryProcess;
import com.ibm.uma.Process;
import com.ibm.uma.ProcessComponent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.IdentityCommand;
import org.eclipse.emf.common.command.UnexecutableCommand;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.command.DragAndDropCommand;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.epf.library.edit.command.IResourceAwareCommand;
import org.eclipse.epf.library.edit.command.ResourceAwareCompoundCommand;
import org.eclipse.epf.library.edit.process.command.ActivityDropCommand;
import org.eclipse.epf.library.edit.ui.ExposedAdapterFactoryContentProvider;
import org.eclipse.epf.library.edit.util.ExposedAdapterFactory;
import org.eclipse.epf.library.edit.util.TngUtil;
import org.eclipse.jface.viewers.Viewer;

public abstract class BSDragAndDropCommand
extends DragAndDropCommand
implements IResourceAwareCommand {
    public BSDragAndDropCommand(EditingDomain domain, Object owner, float location, int operations, int operation, Collection collection) {
        super(domain, owner, location, operations, operation, collection);
    }

    protected boolean prepareDropCopyOn() {
        return this.prepareDropLinkOn();
    }

    protected boolean prepareDropLinkOn() {
        boolean result;
        this.dragCommand = IdentityCommand.INSTANCE;
        this.dropCommand = UnexecutableCommand.INSTANCE;
        ArrayList list = new ArrayList();
        ArrayList actList = new ArrayList();
        Iterator iter = this.collection.iterator();
        while (iter.hasNext()) {
            Object obj = iter.next();
            obj = TngUtil.unwrap(obj);
            if (TngUtil.isLocked((EObject)this.owner)) {
                return false;
            }
            if (this.accept(obj)) {
                list.add(obj);
                continue;
            }
            if (!(obj instanceof Activity)) continue;
            Process srcProc = TngUtil.getOwningProcess((BreakdownElement)obj);
            Process targetProc = TngUtil.getOwningProcess((BreakdownElement)this.owner);
            if (srcProc instanceof DeliveryProcess && targetProc instanceof CapabilityPattern) continue;
            actList.add(obj);
        }
        if (list.isEmpty() && actList.isEmpty()) {
            result = false;
        } else {
            ResourceAwareCompoundCommand cmd = new ResourceAwareCompoundCommand();
            if (!list.isEmpty()) {
                cmd.append(this.createDropCommand(this.owner, list));
            }
            if (!actList.isEmpty()) {
                cmd.append(new ActivityDropCommand((Activity)this.owner, actList, this.getTargetViewer()));
            }
            this.dropCommand = cmd;
            result = this.dropCommand.canExecute();
        }
        return result;
    }

    private Viewer getTargetViewer() {
        if (this.domain instanceof AdapterFactoryEditingDomain) {
            Process proc = TngUtil.getOwningProcess((BreakdownElement)this.owner);
            AdapterFactory adapterFactory = ((AdapterFactoryEditingDomain)this.domain).getAdapterFactory();
            if (adapterFactory instanceof ExposedAdapterFactory) {
                Iterator iter = Collections.unmodifiableList(((ExposedAdapterFactory)adapterFactory).getChangeListeners()).iterator();
                while (iter.hasNext()) {
                    Viewer viewer;
                    Object listener = iter.next();
                    if (!(listener instanceof ExposedAdapterFactoryContentProvider) || !((viewer = ((ExposedAdapterFactoryContentProvider)((Object)listener)).getViewer()).getInput() instanceof ProcessComponent) || ((ProcessComponent)viewer.getInput()).getProcess() != proc) continue;
                    return viewer;
                }
            }
        }
        return null;
    }

    public Collection getModifiedResources() {
        if (this.dropCommand instanceof IResourceAwareCommand) {
            return ((IResourceAwareCommand)this.dropCommand).getModifiedResources();
        }
        return Collections.EMPTY_LIST;
    }

    protected abstract boolean accept(Object var1);

    protected abstract Command createDropCommand(Object var1, List var2);
}

