/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.edit.process.command;

import com.ibm.uma.Activity;
import com.ibm.uma.BreakdownElement;
import com.ibm.uma.DescribableElement;
import com.ibm.uma.Descriptor;
import com.ibm.uma.MethodConfiguration;
import com.ibm.uma.MethodElement;
import com.ibm.uma.MethodPackage;
import com.ibm.uma.MethodPlugin;
import com.ibm.uma.Process;
import com.ibm.uma.Role;
import com.ibm.uma.RoleDescriptor;
import com.ibm.uma.Task;
import com.ibm.uma.TaskDescriptor;
import com.ibm.uma.UmaPackage;
import com.ibm.uma.WorkProductDescriptor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.command.AbstractCommand;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.epf.library.edit.IConfigurationApplicator;
import org.eclipse.epf.library.edit.Providers;
import org.eclipse.epf.library.edit.category.ObjectLinkItemProvider;
import org.eclipse.epf.library.edit.command.IResourceAwareCommand;
import org.eclipse.epf.library.edit.ui.UserInteractionHelper;
import org.eclipse.epf.library.edit.util.ProcessUtil;
import org.eclipse.epf.library.edit.util.TngUtil;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Display;

public abstract class BSDropCommand
extends AbstractCommand
implements IResourceAwareCommand {
    protected Activity activity;
    protected List dropElements;
    private Set modifiedResources;
    protected List elementsToAddToDefaultConfig;
    private HashSet addedObjects;
    private Process process;
    private boolean addedToDefaultConfig = false;
    protected boolean synchronize = false;
    protected ArrayList taskDescList;
    protected ArrayList taskDescriptorsToUpdate;
    protected Set descriptorsToRefresh;
    private Map descriptorToOldRefreshableFeaturesMap;
    protected Map descriptorToNewFeatureValuesMap;
    private HashMap wpdToOldResponsibleRoleMap;
    private Map taskDescToNewStepsMap;
    private HashMap descriptorToOldFeatureValuesMap;
    protected boolean canceled;
    private MethodConfiguration config;
    private List synchFeatures;

    public BSDropCommand(Activity activity, List dropElements) {
        this.activity = activity;
        this.process = TngUtil.getOwningProcess((BreakdownElement)activity);
        this.dropElements = new ArrayList();
        Iterator iter = dropElements.iterator();
        while (iter.hasNext()) {
            Object element = TngUtil.unwrap(iter.next());
            if (element instanceof ObjectLinkItemProvider) {
                element = ((ObjectLinkItemProvider)((Object)element)).getTarget();
            }
            if (this.dropElements.contains(element) || element instanceof EObject && ((EObject)element).eIsProxy()) continue;
            this.dropElements.add(element);
        }
    }

    public BSDropCommand(Activity activity, List dropElements, boolean synch) {
        this(activity, dropElements);
        this.synchronize = synch;
    }

    public BSDropCommand(Activity activity, List dropElements, MethodConfiguration config, List synchFeatures) {
        this(activity, dropElements, true);
        this.config = config;
        this.synchFeatures = synchFeatures;
    }

    public MethodConfiguration getMethodConfiguration() {
        if (this.config == null) {
            this.config = TngUtil.getOwningProcess((BreakdownElement)this.activity).getDefaultContext();
        }
        return this.config;
    }

    public void dispose() {
        if (this.dropElements != null) {
            this.dropElements.clear();
        }
        if (this.modifiedResources != null) {
            this.modifiedResources.clear();
        }
        if (this.elementsToAddToDefaultConfig != null) {
            this.elementsToAddToDefaultConfig.clear();
        }
        if (this.addedObjects != null) {
            this.addedObjects.clear();
        }
        if (this.descriptorToOldRefreshableFeaturesMap != null) {
            this.descriptorToOldRefreshableFeaturesMap.clear();
        }
        if (this.taskDescList != null) {
            this.taskDescList.clear();
        }
        if (this.taskDescToNewStepsMap != null) {
            this.taskDescToNewStepsMap.clear();
        }
        if (this.wpdToOldResponsibleRoleMap != null) {
            this.wpdToOldResponsibleRoleMap.clear();
        }
        if (this.taskDescriptorsToUpdate != null) {
            this.taskDescriptorsToUpdate.clear();
        }
        if (this.descriptorsToRefresh != null) {
            this.descriptorsToRefresh.clear();
        }
        this.process = null;
        this.activity = null;
        super.dispose();
    }

    public Collection getModifiedResources() {
        if (this.modifiedResources == null) {
            this.modifiedResources = new HashSet();
            if (this.activity.eResource() != null) {
                this.modifiedResources.add(this.activity.eResource());
            }
        }
        return this.modifiedResources;
    }

    private boolean clearDescriptor(Descriptor descriptor) {
        boolean ret = ProcessUtil.clearDescriptor(descriptor, this.descriptorToOldRefreshableFeaturesMap);
        if (ret && descriptor instanceof TaskDescriptor) {
            if (this.taskDescriptorsToUpdate == null) {
                this.taskDescriptorsToUpdate = new ArrayList();
            }
            this.taskDescriptorsToUpdate.add(descriptor);
        }
        return ret;
    }

    protected boolean preExecute() {
        boolean b;
        boolean bl = b = !this.dropElements.isEmpty();
        if (b) {
            this.descriptorToNewFeatureValuesMap = new HashMap();
            if (this.synchronize) {
                this.descriptorsToRefresh = new HashSet();
            }
        }
        return b;
    }

    private boolean addToDefaultConfiguration() {
        if (this.elementsToAddToDefaultConfig == null) {
            Object element;
            this.elementsToAddToDefaultConfig = new ArrayList();
            Iterator iter = this.dropElements.iterator();
            while (iter.hasNext()) {
                element = iter.next();
                switch (UserInteractionHelper.checkAgainstDefaultConfiguration(this.process, element)) {
                    case 0: {
                        iter.remove();
                        break;
                    }
                    case 2: {
                        this.elementsToAddToDefaultConfig.add(element);
                        break;
                    }
                    case -1: {
                        return false;
                    }
                }
            }
            if (!this.elementsToAddToDefaultConfig.isEmpty()) {
                this.addedObjects = new HashSet();
                iter = this.elementsToAddToDefaultConfig.iterator();
                while (iter.hasNext()) {
                    element = (EObject)iter.next();
                    ProcessUtil.addToDefaultConfiguration(this.process, element, this.addedObjects);
                }
                if (!this.addedObjects.isEmpty()) {
                    this.getModifiedResources().add(this.process.getDefaultContext().eResource());
                }
                this.addedToDefaultConfig = true;
            }
        }
        return true;
    }

    public void execute() {
        BusyIndicator.showWhile((Display)Display.getCurrent(), (Runnable)new Runnable(){

            public void run() {
                if (BSDropCommand.this.addToDefaultConfiguration() && BSDropCommand.this.preExecute()) {
                    BSDropCommand.this.redo();
                }
            }
        });
    }

    public void redo() {
        if (!this.addedToDefaultConfig) {
            this.addToDefaultConfiguration();
        }
        this.updateDescriptors();
        this.doExecute();
    }

    private void updateDescriptors() {
        if (this.synchronize) {
            this.clearDescriptors();
        }
        Iterator iter = this.descriptorToNewFeatureValuesMap.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            Descriptor desc = (Descriptor)entry.getKey();
            Map featureMap = (Map)entry.getValue();
            Iterator iterator = featureMap.entrySet().iterator();
            while (iterator.hasNext()) {
                entry = iterator.next();
                EStructuralFeature feature = (EStructuralFeature)entry.getKey();
                if (feature.isMany()) {
                    if (!((List)desc.eGet(feature)).addAll((Collection)entry.getValue())) continue;
                    System.out.println("BSDropCommand.updateDescriptors(): changed");
                    System.out.println(" descriptor: " + desc);
                    System.out.println(" feature: " + feature);
                    continue;
                }
                Object oldValue = desc.eGet(feature);
                if (oldValue == entry.getValue()) continue;
                this.saveOldFeatureValue(desc, feature, oldValue);
                desc.eSet(feature, entry.getValue());
                System.out.println("BSDropCommand.updateDescriptors(): changed");
                System.out.println(" descriptor: " + desc);
                System.out.println(" feature: " + feature);
            }
        }
        if (this.synchronize) {
            iter = this.descriptorsToRefresh.iterator();
            while (iter.hasNext()) {
                String presName;
                Descriptor descriptor = (Descriptor)iter.next();
                MethodElement e = ProcessUtil.getAssociatedElement(descriptor);
                if (!descriptor.getName().equals(e.getName())) {
                    this.saveOldFeatureValue(descriptor, (EStructuralFeature)UmaPackage.eINSTANCE.getNamedElement_Name(), descriptor.getName());
                    descriptor.setName(e.getName());
                    System.out.println("BSDropCommand.updateDescriptors(): name changed " + descriptor);
                }
                if (!(e instanceof DescribableElement) || (presName = ((DescribableElement)e).getPresentationName()).equals(descriptor.getPresentationName())) continue;
                this.saveOldFeatureValue(descriptor, (EStructuralFeature)UmaPackage.eINSTANCE.getDescribableElement_PresentationName(), descriptor.getPresentationName());
                descriptor.setPresentationName(presName);
                System.out.println("BSDropCommand.updateDescriptors(): presentation name changed " + descriptor);
            }
        }
        this.updateTaskDescriptors();
        this.setResponsibleRole();
    }

    private void saveOldFeatureValue(Descriptor desc, EStructuralFeature feature, Object value) {
        HashMap<EStructuralFeature, Object> featureMap;
        if (this.descriptorToOldFeatureValuesMap == null) {
            this.descriptorToOldFeatureValuesMap = new HashMap();
        }
        if ((featureMap = (HashMap<EStructuralFeature, Object>)this.descriptorToOldFeatureValuesMap.get(desc)) == null) {
            featureMap = new HashMap<EStructuralFeature, Object>();
            this.descriptorToOldFeatureValuesMap.put(desc, featureMap);
        }
        featureMap.put(feature, value);
    }

    private void undoUpdateDescriptors() {
        EStructuralFeature feature;
        Iterator iterator;
        Map featureMap;
        Descriptor desc;
        Map.Entry entry;
        Iterator iter;
        this.undoSetResponsibleRole();
        this.undoUpdateTaskDescriptors();
        if (this.descriptorToNewFeatureValuesMap != null) {
            iter = this.descriptorToNewFeatureValuesMap.entrySet().iterator();
            while (iter.hasNext()) {
                entry = iter.next();
                desc = (Descriptor)entry.getKey();
                featureMap = (Map)entry.getValue();
                iterator = featureMap.entrySet().iterator();
                while (iterator.hasNext()) {
                    entry = iterator.next();
                    feature = (EStructuralFeature)entry.getKey();
                    if (!feature.isMany()) continue;
                    ((List)desc.eGet(feature)).removeAll((Collection)entry.getValue());
                }
            }
        }
        if (this.descriptorToOldFeatureValuesMap != null) {
            iter = this.descriptorToOldFeatureValuesMap.entrySet().iterator();
            while (iter.hasNext()) {
                entry = iter.next();
                desc = (Descriptor)entry.getKey();
                featureMap = (Map)entry.getValue();
                iterator = featureMap.entrySet().iterator();
                while (iterator.hasNext()) {
                    entry = iterator.next();
                    feature = (EStructuralFeature)entry.getKey();
                    desc.eSet(feature, entry.getValue());
                }
            }
        }
        if (this.synchronize) {
            this.undoClearDescriptors();
        }
    }

    private void clearDescriptors() {
        if (this.descriptorToOldRefreshableFeaturesMap == null) {
            this.descriptorToOldRefreshableFeaturesMap = new HashMap();
            if (!this.descriptorsToRefresh.isEmpty()) {
                Iterator iter = this.descriptorsToRefresh.iterator();
                while (iter.hasNext()) {
                    this.clearDescriptor((Descriptor)iter.next());
                }
            }
        }
    }

    private void updateTaskDescriptors() {
        if (this.taskDescriptorsToUpdate != null) {
            if (this.taskDescToNewStepsMap == null) {
                this.taskDescToNewStepsMap = new HashMap();
            }
            IConfigurationApplicator configApplicator = Providers.getConfigurationApplicator();
            Iterator iter = this.taskDescriptorsToUpdate.iterator();
            while (iter.hasNext()) {
                TaskDescriptor taskDesc = (TaskDescriptor)iter.next();
                Task task = taskDesc.getTask();
                if (task == null || task.eIsProxy()) continue;
                List steps = (List)configApplicator.getReference(task.getPresentation(), UmaPackage.eINSTANCE.getContentDescription_Sections(), this.config);
                ArrayList newSteps = new ArrayList();
                taskDesc.getSelectedSteps().retainAll(steps);
                Iterator iter1 = steps.iterator();
                while (iter1.hasNext()) {
                    Object step = iter1.next();
                    if (taskDesc.getSelectedSteps().contains(step)) continue;
                    newSteps.add(step);
                }
                if (newSteps.isEmpty()) continue;
                taskDesc.getSelectedSteps().addAll(newSteps);
                this.taskDescToNewStepsMap.put(taskDesc, newSteps);
                System.out.println("BSDropCommand.updateTaskDescriptors(): changed");
            }
        }
    }

    private void undoUpdateTaskDescriptors() {
        if (this.taskDescToNewStepsMap != null) {
            Iterator iter = this.taskDescToNewStepsMap.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry entry = iter.next();
                TaskDescriptor taskDesc = (TaskDescriptor)entry.getKey();
                taskDesc.getSelectedSteps().removeAll((Collection)entry.getValue());
            }
        }
    }

    private void setResponsibleRole() {
        if (this.wpdToOldResponsibleRoleMap == null) {
            this.wpdToOldResponsibleRoleMap = new HashMap();
        }
        List brElements = this.activity.getBreakdownElements();
        ArrayList wpDescList = new ArrayList();
        ArrayList roleDescriptors = new ArrayList();
        Iterator itor = brElements.iterator();
        while (itor.hasNext()) {
            Object obj = itor.next();
            if (obj instanceof WorkProductDescriptor) {
                wpDescList.add(obj);
                continue;
            }
            if (!(obj instanceof RoleDescriptor)) continue;
            roleDescriptors.add(obj);
        }
        itor = roleDescriptors.iterator();
        while (itor.hasNext()) {
            RoleDescriptor roleDesc = (RoleDescriptor)itor.next();
            Role role = roleDesc.getRole();
            if (role == null) continue;
            List responsibleWorkProducts = role.getResponsibleFor();
            int j = wpDescList.size() - 1;
            while (j > -1) {
                WorkProductDescriptor wpDesc = (WorkProductDescriptor)wpDescList.get(j);
                if (responsibleWorkProducts.contains(wpDesc.getWorkProduct()) && wpDesc.getResponsibleRole() != roleDesc) {
                    this.wpdToOldResponsibleRoleMap.put(wpDesc, wpDesc.getResponsibleRole());
                    wpDesc.setResponsibleRole(roleDesc);
                    System.out.println("BSDropCommand.setResponsibleRole(): changed");
                }
                --j;
            }
        }
    }

    public void undo() {
        if (this.addedObjects != null && !this.addedObjects.isEmpty()) {
            MethodConfiguration config = this.process.getDefaultContext();
            Iterator iter = this.addedObjects.iterator();
            while (iter.hasNext()) {
                Object element = iter.next();
                if (element instanceof MethodPlugin) {
                    config.getMethodPluginSelection().remove(element);
                    continue;
                }
                if (!(element instanceof MethodPackage)) continue;
                config.getMethodPackageSelection().remove(element);
            }
            this.addedToDefaultConfig = false;
        }
        this.undoUpdateDescriptors();
        this.doUndo();
    }

    private void undoClearDescriptors() {
        Iterator iter = this.descriptorToOldRefreshableFeaturesMap.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            Descriptor desc = (Descriptor)entry.getKey();
            Map featureMap = (Map)entry.getValue();
            Iterator iterator = featureMap.entrySet().iterator();
            while (iterator.hasNext()) {
                entry = iterator.next();
                desc.eSet((EStructuralFeature)entry.getKey(), entry.getValue());
            }
        }
    }

    private void undoSetResponsibleRole() {
        Iterator iter = this.wpdToOldResponsibleRoleMap.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            WorkProductDescriptor wpd = (WorkProductDescriptor)entry.getKey();
            wpd.setResponsibleRole((RoleDescriptor)entry.getValue());
        }
    }

    protected boolean prepare() {
        return true;
    }

    protected abstract void doExecute();

    protected abstract void doUndo();

    public static interface IExecutor {
        public boolean preExecute();

        public void doExcecute();

        public void doUndo();
    }
}

