/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.edit.process.command;

import com.ibm.uma.Activity;
import com.ibm.uma.Artifact;
import com.ibm.uma.BreakdownElement;
import com.ibm.uma.Deliverable;
import com.ibm.uma.MethodConfiguration;
import com.ibm.uma.ProcessPackage;
import com.ibm.uma.RoleDescriptor;
import com.ibm.uma.Task;
import com.ibm.uma.TaskDescriptor;
import com.ibm.uma.VariabilityElement;
import com.ibm.uma.WorkProduct;
import com.ibm.uma.WorkProductDescriptor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.util.AbstractTreeIterator;
import org.eclipse.epf.library.edit.process.command.BSDropCommand;
import org.eclipse.epf.library.edit.ui.UserInteractionHelper;
import org.eclipse.epf.library.edit.util.ProcessUtil;
import org.eclipse.epf.library.edit.util.TngUtil;

public class PBSDropCommand
extends BSDropCommand {
    private ArrayList wpDescList;
    private ArrayList roleDescList;
    private Map wpDescToDeliverableParts;
    private HashMap wpdToDeliverableDescriptorMap;

    public PBSDropCommand(Activity activity, List workProducts) {
        super(activity, workProducts);
        this.activity = activity;
        Iterator iter = this.dropElements.iterator();
        while (iter.hasNext()) {
            Object element = iter.next();
            if (element instanceof WorkProduct) continue;
            iter.remove();
        }
    }

    public PBSDropCommand(Activity activity, List dropElements, boolean synch) {
        super(activity, dropElements, synch);
    }

    public PBSDropCommand(Activity activity, List dropElements, MethodConfiguration config, List synchFeatures) {
        super(activity, dropElements, config, synchFeatures);
    }

    protected boolean preExecute() {
        if (!super.preExecute()) {
            return false;
        }
        this.wpDescList = new ArrayList();
        this.taskDescList = new ArrayList();
        this.roleDescList = new ArrayList();
        this.wpDescToDeliverableParts = new HashMap();
        this.wpdToDeliverableDescriptorMap = new HashMap();
        MethodConfiguration config = TngUtil.getOwningProcess((BreakdownElement)this.activity).getDefaultContext();
        Iterator iter = new ArrayList(this.dropElements).iterator();
        while (iter.hasNext()) {
            Object element = iter.next();
            if (!(element instanceof Artifact)) continue;
            AbstractTreeIterator iterator = new AbstractTreeIterator(element, false){

                protected Iterator getChildren(Object object) {
                    return ((Artifact)object).getContainedArtifacts().iterator();
                }
            };
            while (iterator.hasNext()) {
                Object subArtifact = iterator.next();
                if (this.dropElements.contains(subArtifact)) continue;
                this.dropElements.add(subArtifact);
            }
        }
        int i = 0;
        while (i < this.dropElements.size()) {
            List tasks;
            WorkProductDescriptor wpDesc;
            WorkProduct wp = (WorkProduct)this.dropElements.get(i);
            if (TngUtil.isContributor((VariabilityElement)wp)) {
                wp = (WorkProduct)TngUtil.getBase((VariabilityElement)wp);
            }
            if ((wpDesc = (WorkProductDescriptor)ProcessUtil.getDescriptor((Object)wp, this.activity)) == null) {
                wpDesc = ProcessUtil.createWorkProductDescriptor(wp, config, this.wpDescToDeliverableParts);
                this.wpDescList.add(wpDesc);
                WorkProductDescriptor descriptor = UserInteractionHelper.getDeliverable(this.activity, wp);
                if (descriptor != null) {
                    this.wpdToDeliverableDescriptorMap.put(wpDesc, descriptor);
                }
            } else {
                if (this.descriptorsToRefresh != null) {
                    this.descriptorsToRefresh.add(wpDesc);
                }
                if (wp instanceof Deliverable) {
                    ProcessUtil.createDeliverableParts(wpDesc, (Deliverable)wp, config, this.wpDescToDeliverableParts);
                }
            }
            if (!this.synchronize && (tasks = ProcessUtil.getTasksForWorkProduct(wp, config)) != null && tasks.size() > 0) {
                List selectedTasks = UserInteractionHelper.selectTasks(tasks, wp);
                if (selectedTasks != null && !selectedTasks.isEmpty()) {
                    int j = 0;
                    while (j < selectedTasks.size()) {
                        Task task = (Task)selectedTasks.get(j);
                        PBSDropCommand.addToDescriptorLists(task, this.activity, this.taskDescList, this.roleDescList, this.wpDescList, this.wpDescToDeliverableParts, this.descriptorsToRefresh, this.descriptorToNewFeatureValuesMap, config);
                        ++j;
                    }
                } else {
                    PBSDropCommand.addResponsibleRole(wpDesc, this.activity, this.roleDescList, this.descriptorsToRefresh);
                }
            }
            ++i;
        }
        return !this.taskDescList.isEmpty() || !this.roleDescList.isEmpty() || !this.wpDescList.isEmpty() || !this.wpDescToDeliverableParts.isEmpty() || !this.wpdToDeliverableDescriptorMap.isEmpty() || this.descriptorsToRefresh != null && !this.descriptorsToRefresh.isEmpty() || this.descriptorToNewFeatureValuesMap != null && !this.descriptorToNewFeatureValuesMap.isEmpty();
    }

    protected void doExecute() {
        ProcessPackage pkg;
        Map.Entry entry;
        Iterator iter;
        if (!this.wpdToDeliverableDescriptorMap.isEmpty()) {
            iter = this.wpdToDeliverableDescriptorMap.entrySet().iterator();
            while (iter.hasNext()) {
                entry = iter.next();
                WorkProductDescriptor deliverable = (WorkProductDescriptor)entry.getValue();
                deliverable.getDeliverableParts().add(entry.getKey());
            }
        }
        this.activity.getBreakdownElements().addAll(this.wpDescList);
        this.activity.getBreakdownElements().addAll(this.taskDescList);
        this.activity.getBreakdownElements().addAll(this.roleDescList);
        if (!this.wpDescToDeliverableParts.isEmpty()) {
            iter = this.wpDescToDeliverableParts.entrySet().iterator();
            while (iter.hasNext()) {
                entry = iter.next();
                WorkProductDescriptor wpDesc = (WorkProductDescriptor)entry.getKey();
                wpDesc.getDeliverableParts().addAll((Collection)entry.getValue());
            }
        }
        if ((pkg = (ProcessPackage)this.activity.eContainer()) != null) {
            pkg.getProcessElements().addAll(this.taskDescList);
            pkg.getProcessElements().addAll(this.roleDescList);
            pkg.getProcessElements().addAll(this.wpDescList);
            Iterator iter2 = this.wpDescToDeliverableParts.values().iterator();
            while (iter2.hasNext()) {
                pkg.getProcessElements().addAll((Collection)iter2.next());
            }
        }
        this.getModifiedResources().add(this.activity.eResource());
    }

    protected void doUndo() {
        ProcessPackage pkg;
        Map.Entry entry;
        Iterator iter;
        this.activity.getBreakdownElements().removeAll(this.wpDescList);
        this.activity.getBreakdownElements().removeAll(this.roleDescList);
        this.activity.getBreakdownElements().removeAll(this.taskDescList);
        if (!this.wpDescToDeliverableParts.isEmpty()) {
            iter = this.wpDescToDeliverableParts.entrySet().iterator();
            while (iter.hasNext()) {
                entry = iter.next();
                WorkProductDescriptor wpDesc = (WorkProductDescriptor)entry.getKey();
                wpDesc.getDeliverableParts().removeAll((Collection)entry.getValue());
            }
        }
        if (!this.wpdToDeliverableDescriptorMap.isEmpty()) {
            iter = this.wpdToDeliverableDescriptorMap.entrySet().iterator();
            while (iter.hasNext()) {
                entry = iter.next();
                WorkProductDescriptor deliverable = (WorkProductDescriptor)entry.getValue();
                deliverable.getDeliverableParts().remove(entry.getKey());
            }
        }
        if ((pkg = (ProcessPackage)this.activity.eContainer()) != null) {
            pkg.getProcessElements().removeAll(this.taskDescList);
            pkg.getProcessElements().removeAll(this.roleDescList);
            pkg.getProcessElements().removeAll(this.wpDescList);
            Iterator iter2 = this.wpDescToDeliverableParts.values().iterator();
            while (iter2.hasNext()) {
                pkg.getProcessElements().removeAll((Collection)iter2.next());
            }
        }
    }

    public Collection getAffectedObjects() {
        if (this.wpDescList != null) {
            return this.wpDescList;
        }
        return super.getAffectedObjects();
    }

    static boolean addToDescriptorLists(Task task, Activity activity, List taskDescList, List roleDescList, List wpDescList, Map wpDescToDeliverableParts, Set descriptorsToRefresh, Map descriptorToNewFeatureValuesMap, MethodConfiguration config) {
        TaskDescriptor desc = ProcessUtil.createTaskDescriptor(task, activity, roleDescList, wpDescList, wpDescToDeliverableParts, null, descriptorsToRefresh, descriptorToNewFeatureValuesMap, config);
        if (desc != null && taskDescList != null && !taskDescList.contains(desc)) {
            taskDescList.add(desc);
        }
        return desc != null;
    }

    static void addResponsibleRole(WorkProductDescriptor wpDesc, Activity activity, List roleDescList, Set descriptorsToRefresh) {
        RoleDescriptor roleDesc = ProcessUtil.createRoleDescriptor(wpDesc, activity, roleDescList, descriptorsToRefresh);
        if (roleDesc != null && !roleDescList.contains(roleDesc)) {
            roleDescList.add(roleDesc);
        }
    }
}

