/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.edit.process.command;

import com.ibm.uma.Deliverable;
import com.ibm.uma.Descriptor;
import com.ibm.uma.RoleDescriptor;
import com.ibm.uma.TaskDescriptor;
import com.ibm.uma.UmaPackage;
import com.ibm.uma.WorkProductDescriptor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;

public final class ProcessCommandUtil {
    public static final EStructuralFeature[] DESCRIPTOR_REFRESHABLE_FEATURES = new EStructuralFeature[]{UmaPackage.eINSTANCE.getMethodElement_BriefDescription()};
    public static final EStructuralFeature[] TASK_DESCRIPTOR_REFRESHABLE_FEATURES = new EStructuralFeature[]{UmaPackage.eINSTANCE.getTaskDescriptor_AdditionallyPerformedBy(), UmaPackage.eINSTANCE.getTaskDescriptor_MandatoryInput(), UmaPackage.eINSTANCE.getTaskDescriptor_OptionalInput(), UmaPackage.eINSTANCE.getTaskDescriptor_Output(), UmaPackage.eINSTANCE.getTaskDescriptor_PerformedPrimarilyBy(), UmaPackage.eINSTANCE.getTaskDescriptor_SelectedSteps()};
    public static final EStructuralFeature[] ROLE_DESCRIPTOR_REFRESHABLE_FEATURES = new EStructuralFeature[]{UmaPackage.eINSTANCE.getRoleDescriptor_ResponsibleFor()};
    public static final EStructuralFeature[] WORK_PRODUCT_REFRESHABLE_FEATURES = new EStructuralFeature[0];

    public static Map createRefreshableFeatureMap(Descriptor descriptor) {
        WorkProductDescriptor wpd;
        HashMap<EReference, List> featureMap = new HashMap<EReference, List>();
        ProcessCommandUtil.addToFeatureMap((EObject)descriptor, DESCRIPTOR_REFRESHABLE_FEATURES, featureMap);
        if (descriptor instanceof TaskDescriptor) {
            ProcessCommandUtil.addToFeatureMap((EObject)descriptor, TASK_DESCRIPTOR_REFRESHABLE_FEATURES, featureMap);
        } else if (descriptor instanceof RoleDescriptor) {
            ProcessCommandUtil.addToFeatureMap((EObject)descriptor, ROLE_DESCRIPTOR_REFRESHABLE_FEATURES, featureMap);
        } else if (descriptor instanceof WorkProductDescriptor && (wpd = (WorkProductDescriptor)descriptor).getWorkProduct() instanceof Deliverable) {
            EReference feature = UmaPackage.eINSTANCE.getWorkProductDescriptor_DeliverableParts();
            featureMap.put(feature, wpd.getDeliverableParts());
        }
        return featureMap;
    }

    private static void addToFeatureMap(EObject eObject, EStructuralFeature[] features, Map featureMap) {
        int i = 0;
        while (i < features.length) {
            EStructuralFeature feature = features[i];
            ArrayList value = eObject.eGet(feature);
            if (feature.isMany()) {
                value = new ArrayList(value);
            }
            featureMap.put(feature, value);
            ++i;
        }
    }

    public static Map clearRefreshableFeatures(Descriptor descriptor) {
        Map featureMap = ProcessCommandUtil.createRefreshableFeatureMap(descriptor);
        Iterator iter = featureMap.keySet().iterator();
        while (iter.hasNext()) {
            EStructuralFeature feature = (EStructuralFeature)iter.next();
            if (feature instanceof EAttribute) {
                descriptor.eSet(feature, feature.getDefaultValue());
                continue;
            }
            if (feature.isMany()) {
                List list = (List)descriptor.eGet(feature);
                switch (list.size()) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        list.remove(0);
                        break;
                    }
                    default: {
                        list.clear();
                        break;
                    }
                }
                continue;
            }
            descriptor.eSet(feature, feature.getDefaultValue());
        }
        return featureMap;
    }
}

