/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.edit.process.command;

import com.ibm.uma.Activity;
import com.ibm.uma.BreakdownElement;
import com.ibm.uma.Descriptor;
import com.ibm.uma.MethodConfiguration;
import com.ibm.uma.MethodElement;
import com.ibm.uma.Process;
import com.ibm.uma.Role;
import com.ibm.uma.RoleDescriptor;
import com.ibm.uma.Task;
import com.ibm.uma.TaskDescriptor;
import com.ibm.uma.WorkProduct;
import com.ibm.uma.WorkProductDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.CommonPlugin;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.common.util.AbstractTreeIterator;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.epf.library.edit.IConfigurator;
import org.eclipse.epf.library.edit.LibraryEditPlugin;
import org.eclipse.epf.library.edit.LibraryEditResources;
import org.eclipse.epf.library.edit.Providers;
import org.eclipse.epf.library.edit.command.IResourceAwareCommand;
import org.eclipse.epf.library.edit.process.command.BSDropCommand;
import org.eclipse.epf.library.edit.process.command.OBSDropCommand;
import org.eclipse.epf.library.edit.process.command.PBSDropCommand;
import org.eclipse.epf.library.edit.process.command.WBSDropCommand;
import org.eclipse.epf.library.edit.ui.UserInteractionHelper;
import org.eclipse.epf.library.edit.util.ProcessUtil;
import org.eclipse.epf.library.edit.util.TngUtil;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Display;

public class SynchronizeCommand
extends CompoundCommand
implements IResourceAwareCommand {
    private Collection elements;
    private IConfigurator configurator;
    protected boolean aborted;
    private ArrayList deleteList;
    protected boolean preExecSuccessful;
    protected List deleteCommandList;
    protected boolean successful;
    private ArrayList descriptorsToDelete;
    private MethodConfiguration config;
    private List synchFeatures;

    public SynchronizeCommand(Collection elements) {
        super(LibraryEditResources.getString("LibraryEdit.AutoSynchronizeCommand.label"));
        this.elements = elements;
    }

    public SynchronizeCommand(Collection elements, MethodConfiguration config, List synchFeatures) {
        super(LibraryEditResources.getString("LibraryEdit.AutoSynchronizeCommand.label"));
        this.elements = elements;
        this.config = config;
        this.synchFeatures = synchFeatures;
    }

    public boolean initilize() {
        if (this.elements == null || this.elements.isEmpty()) {
            return false;
        }
        this.deleteCommandList = new ArrayList();
        this.deleteList = new ArrayList();
        Iterator iter = this.elements.iterator();
        while (iter.hasNext()) {
            Object element = iter.next();
            this.addToDeleteList(element, this.deleteList);
        }
        this.elements.removeAll(this.deleteList);
        iter = this.elements.iterator();
        while (iter.hasNext()) {
            Object object = iter.next();
            if (object instanceof Descriptor) {
                WorkProduct wp;
                Descriptor descriptor = (Descriptor)object;
                if (!descriptor.getIsSynchronizedWithSource().booleanValue() || this.deleteList.contains(descriptor)) continue;
                Activity act = (Activity)descriptor.getSuperActivities().get(0);
                if (object instanceof TaskDescriptor) {
                    Task task = ((TaskDescriptor)object).getTask();
                    if (task == null) continue;
                    this.append(new WBSDropCommand(act, Collections.singletonList(task), this.config, this.synchFeatures));
                    continue;
                }
                if (object instanceof RoleDescriptor) {
                    Role role = ((RoleDescriptor)object).getRole();
                    if (role == null) continue;
                    this.append(new OBSDropCommand(act, Collections.singletonList(role), this.config, this.synchFeatures));
                    continue;
                }
                if (!(object instanceof WorkProductDescriptor) || (wp = ((WorkProductDescriptor)object).getWorkProduct()) == null) continue;
                this.append(new PBSDropCommand(act, Collections.singletonList(wp), this.config, this.synchFeatures));
                continue;
            }
            if (!(object instanceof Activity)) continue;
            this.appendCommands((Activity)object);
        }
        return !this.deleteList.isEmpty() || !this.commandList.isEmpty();
    }

    private void appendCommands(Activity activity) {
        ArrayList<Task> tasks = new ArrayList<Task>();
        ArrayList<Role> roles = new ArrayList<Role>();
        ArrayList<WorkProduct> workProducts = new ArrayList<WorkProduct>();
        ArrayList activities = new ArrayList();
        Iterator iter = activity.getBreakdownElements().iterator();
        while (iter.hasNext()) {
            Object element = iter.next();
            if (element instanceof Descriptor) {
                WorkProduct wp;
                if (!((Descriptor)element).getIsSynchronizedWithSource().booleanValue() || this.deleteList.contains(element)) continue;
                if (element instanceof TaskDescriptor) {
                    Task task = ((TaskDescriptor)element).getTask();
                    if (task == null) continue;
                    tasks.add(task);
                    continue;
                }
                if (element instanceof RoleDescriptor) {
                    Role role = ((RoleDescriptor)element).getRole();
                    if (role == null) continue;
                    roles.add(role);
                    continue;
                }
                if (!(element instanceof WorkProductDescriptor) || (wp = ((WorkProductDescriptor)element).getWorkProduct()) == null) continue;
                workProducts.add(wp);
                continue;
            }
            if (!(element instanceof Activity)) continue;
            activities.add(element);
        }
        if (!tasks.isEmpty()) {
            this.append(new WBSDropCommand(activity, tasks, this.config, this.synchFeatures));
        }
        if (!roles.isEmpty()) {
            this.append(new OBSDropCommand(activity, roles, this.config, this.synchFeatures));
        }
        if (!workProducts.isEmpty()) {
            this.append(new PBSDropCommand(activity, workProducts, this.config, this.synchFeatures));
        }
        iter = activities.iterator();
        while (iter.hasNext()) {
            this.appendCommands((Activity)iter.next());
        }
    }

    public Collection getModifiedResources() {
        HashSet modifiedResources = new HashSet();
        Iterator iter = this.commandList.iterator();
        while (iter.hasNext()) {
            IResourceAwareCommand cmd = (IResourceAwareCommand)iter.next();
            modifiedResources.addAll(cmd.getModifiedResources());
        }
        return modifiedResources;
    }

    public void execute() {
        Command cmd;
        if (!this.deleteList.isEmpty() && (cmd = this.delete(this.deleteList)) != null) {
            this.deleteCommandList.add(cmd);
        }
        if (!this.aborted) {
            IRunnableWithProgress runnable = new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    SynchronizeCommand.this.preExecSuccessful = SynchronizeCommand.this.preExecute();
                }
            };
            UserInteractionHelper.runWithProgress(runnable, null);
            if (this.preExecSuccessful) {
                BusyIndicator.showWhile((Display)Display.getCurrent(), (Runnable)new Runnable(){

                    public void run() {
                        SynchronizeCommand.this.superRedo();
                        SynchronizeCommand.this.successful = true;
                    }
                });
            }
            if (this.successful) {
                Command cmd2;
                if (this.descriptorsToDelete == null) {
                    AbstractTreeIterator iter = new AbstractTreeIterator(this.elements, false){

                        protected Iterator getChildren(Object object) {
                            if (object == SynchronizeCommand.this.elements) {
                                return SynchronizeCommand.this.elements.iterator();
                            }
                            if (object instanceof Activity) {
                                return ((Activity)object).getBreakdownElements().iterator();
                            }
                            return Collections.EMPTY_LIST.iterator();
                        }
                    };
                    this.descriptorsToDelete = new ArrayList();
                    while (iter.hasNext()) {
                        Object element = iter.next();
                        if (!(element instanceof Descriptor) || ProcessUtil.checkDescriptorReferences(this.descriptorsToDelete, (Descriptor)element)) continue;
                        this.descriptorsToDelete.add(element);
                    }
                }
                if (!this.descriptorsToDelete.isEmpty() && (cmd2 = this.delete(this.descriptorsToDelete)) != null) {
                    this.deleteCommandList.add(cmd2);
                }
                LibraryEditPlugin.getDefault().getMsgDialog().displayInfo(this.getLabel(), LibraryEditResources.getString("LibraryEdit.AutoSynchronizeCommand.sucessful"));
            }
        }
    }

    private void superRedo() {
        super.redo();
    }

    public void redo() {
        this.execute();
    }

    public boolean isSucessful() {
        return this.successful;
    }

    protected boolean preExecute() {
        ListIterator commands = this.commandList.listIterator();
        while (commands.hasNext()) {
            BSDropCommand command = (BSDropCommand)commands.next();
            if (command.preExecute()) continue;
            return false;
        }
        return true;
    }

    protected Command delete(List elements) {
        return null;
    }

    private IConfigurator getConfigurator() {
        if (this.configurator == null) {
            Process proc = TngUtil.getOwningProcess((BreakdownElement)this.elements.iterator().next());
            MethodConfiguration config = proc.getDefaultContext();
            this.configurator = Providers.getConfiguratorFactory().createConfigurator(config);
        }
        return this.configurator;
    }

    private void addToDeleteList(Object element, List deleteList) {
        if (element instanceof Descriptor) {
            MethodElement e = ProcessUtil.getAssociatedElement((Descriptor)element);
            if (!this.getConfigurator().accept(e)) {
                deleteList.add(element);
            }
        } else if (element instanceof Activity) {
            Iterator iter = ((Activity)element).getBreakdownElements().iterator();
            while (iter.hasNext()) {
                this.addToDeleteList(iter.next(), deleteList);
            }
        }
    }

    private void superUndo() {
        super.undo();
    }

    public void undo() {
        BusyIndicator.showWhile((Display)Display.getCurrent(), (Runnable)new Runnable(){

            public void run() {
                SynchronizeCommand.this.superUndo();
                if (!SynchronizeCommand.this.deleteCommandList.isEmpty()) {
                    ListIterator commands = SynchronizeCommand.this.deleteCommandList.listIterator(SynchronizeCommand.this.deleteCommandList.size());
                    while (commands.hasPrevious()) {
                        try {
                            Command command = (Command)commands.previous();
                            command.undo();
                            continue;
                        }
                        catch (RuntimeException exception) {
                            commands.next();
                            try {
                                while (commands.hasNext()) {
                                    Command command = (Command)commands.next();
                                    command.redo();
                                }
                            }
                            catch (RuntimeException nestedException) {
                                CommonPlugin.INSTANCE.log((Object)new WrappedException(CommonPlugin.INSTANCE.getString("_UI_IgnoreException_exception"), (Exception)nestedException).fillInStackTrace());
                            }
                        }
                        throw exception;
                    }
                }
            }
        });
    }

    protected boolean prepare() {
        return true;
    }
}

