/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.edit.ui;

import com.ibm.uma.Activity;
import com.ibm.uma.BreakdownElement;
import com.ibm.uma.Deliverable;
import com.ibm.uma.Descriptor;
import com.ibm.uma.MethodElement;
import com.ibm.uma.MethodLibrary;
import com.ibm.uma.NamedElement;
import com.ibm.uma.Process;
import com.ibm.uma.Role;
import com.ibm.uma.TeamProfile;
import com.ibm.uma.WorkProduct;
import com.ibm.uma.WorkProductDescriptor;
import com.ibm.uma.util.ContentDescriptionFactory;
import com.ibm.uma.util.MessageException;
import com.ibm.uma.util.UmaUtil;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.CommonPlugin;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.epf.common.serviceability.MsgBox;
import org.eclipse.epf.library.edit.IConfigurator;
import org.eclipse.epf.library.edit.LibraryEditPlugin;
import org.eclipse.epf.library.edit.LibraryEditResources;
import org.eclipse.epf.library.edit.Providers;
import org.eclipse.epf.library.edit.TngAdapterFactory;
import org.eclipse.epf.library.edit.ui.DeliverableSelection;
import org.eclipse.epf.library.edit.ui.TeamSelection;
import org.eclipse.epf.library.edit.util.ProcessUtil;
import org.eclipse.epf.library.edit.util.TngUtil;
import org.eclipse.epf.library.edit.validation.IValidator;
import org.eclipse.epf.uma.ecore.impl.MultiResourceEObject;
import org.eclipse.epf.uma.ecore.util.OppositeFeature;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ListSelectionDialog;

public final class UserInteractionHelper {
    static /* synthetic */ Class class$0;

    private UserInteractionHelper() {
    }

    public static int checkAgainstDefaultConfiguration(Process proc, Object object) {
        Object e = TngUtil.unwrap(object);
        if (!(e instanceof MethodElement)) {
            return 0;
        }
        IConfigurator configurator = Providers.getConfiguratorFactory().createConfigurator(proc.getDefaultContext());
        if (configurator.accept(e)) {
            return 1;
        }
        String msg = LibraryEditResources.formatString("LibraryEdit.ui.UserInteractionHelper.defaultconfigcheck", ((MethodElement)e).getName());
        int ret = MsgBox.prompt((String)msg);
        System.out.println("UserInteractionHelper.checkAgainstDefaultConfiguration(): element=" + e + ", path=" + TngUtil.getLabelWithPath(e));
        switch (ret) {
            case 64: {
                IStatus status = TngUtil.checkEdit((EObject)proc.getDefaultContext(), null);
                if (!status.isOK()) {
                    return 0;
                }
                return 2;
            }
            case 128: {
                return 0;
            }
            case 256: {
                return -1;
            }
        }
        return 0;
    }

    public static List selectTasks(List taskList, WorkProduct wp) {
        AdapterFactoryLabelProvider labelProvider = new AdapterFactoryLabelProvider((AdapterFactory)TngAdapterFactory.INSTANCE.getNavigatorView_ComposedAdapterFactory());
        AdapterFactoryContentProvider contentProvider = new AdapterFactoryContentProvider((AdapterFactory)TngAdapterFactory.INSTANCE.getNavigatorView_ComposedAdapterFactory()){

            public Object[] getElements(Object object) {
                return ((List)object).toArray();
            }
        };
        ListSelectionDialog dlg = new ListSelectionDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (Object)taskList, (IStructuredContentProvider)contentProvider, (ILabelProvider)labelProvider, String.valueOf(LibraryEditResources.getString("LibraryEdit.ui.UserInteractionHelper.wplistdlgtitle0")) + wp.getName() + LibraryEditResources.getString("LibraryEdit.ui.UserInteractionHelper.wplistdlgtitle1"));
        dlg.setTitle(LibraryEditResources.getString("LibraryEdit.ui.UserInteractionHelper.tasks"));
        dlg.setBlockOnOpen(true);
        dlg.open();
        Object[] objs = dlg.getResult();
        labelProvider.dispose();
        contentProvider.dispose();
        ArrayList<Object> selectedTasks = new ArrayList<Object>();
        if (objs != null && objs.length > 0) {
            int i = 0;
            while (i < objs.length) {
                selectedTasks.add(objs[i]);
                ++i;
            }
        }
        return selectedTasks;
    }

    public static List selectWorkProducts(List wpList, Role role) {
        AdapterFactoryLabelProvider labelProvider = new AdapterFactoryLabelProvider((AdapterFactory)TngAdapterFactory.INSTANCE.getNavigatorView_ComposedAdapterFactory());
        AdapterFactoryContentProvider contentProvider = new AdapterFactoryContentProvider((AdapterFactory)TngAdapterFactory.INSTANCE.getNavigatorView_ComposedAdapterFactory()){

            public Object[] getElements(Object object) {
                return ((List)object).toArray();
            }
        };
        ListSelectionDialog dlg = new ListSelectionDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (Object)wpList, (IStructuredContentProvider)contentProvider, (ILabelProvider)labelProvider, String.valueOf(LibraryEditResources.getString("LibraryEdit.ui.UserInteractionHelper.rolelistdlgtitle0")) + role.getName() + LibraryEditResources.getString("LibraryEdit.ui.UserInteractionHelper.rolelistdlgtitle1"));
        dlg.setTitle(LibraryEditResources.getString("LibraryEdit.ui.UserInteractionHelper.workproducts"));
        dlg.setBlockOnOpen(true);
        dlg.open();
        Object[] objs = dlg.getResult();
        labelProvider.dispose();
        contentProvider.dispose();
        ArrayList<Object> selectedWps = new ArrayList<Object>();
        if (objs != null && objs.length > 0) {
            int i = 0;
            while (i < objs.length) {
                selectedWps.add(objs[i]);
                ++i;
            }
        }
        return selectedWps;
    }

    public static String requestName(Object child, EStructuralFeature nameFeature, String title, final IValidator validator) {
        IInputValidator inputValidator = new IInputValidator(){

            public String isValid(String newText) {
                if (validator != null) {
                    return UserInteractionHelper.getSimpleErrorMessage(validator.isValid(newText));
                }
                return null;
            }
        };
        InputDialog inputDialog = new InputDialog(Display.getCurrent().getActiveShell(), title, LibraryEditResources.getString("LibraryEdit.UserInteractionHelper.ProcessPackage.Name"), "", inputValidator);
        if (inputDialog.open() == 0) {
            return inputDialog.getValue();
        }
        return null;
    }

    public static String getSimpleErrorMessage(String msg) {
        if (msg == null) {
            return null;
        }
        int s = msg.indexOf(58);
        String prefix = "";
        if (s >= 0) {
            prefix = msg.substring(0, s);
            String emptyElementNameErrorMsg = LibraryEditResources.getString("LibraryEdit.emptyElementNameError.msg");
            String dupContentFileErrorMsg = LibraryEditResources.getString("LibraryEdit.duplicateContentFileError.msg");
            String dupElementNameErrorMsg = LibraryEditResources.getString("LibraryEdit.duplicateElementNameError.msg");
            if (emptyElementNameErrorMsg != null && emptyElementNameErrorMsg.startsWith(prefix)) {
                return LibraryEditResources.getString("LibraryEdit.emptyElementNameError.simple.msg");
            }
            if (dupContentFileErrorMsg != null && dupContentFileErrorMsg.startsWith(prefix)) {
                return LibraryEditResources.getString("LibraryEdit.duplicateContentFileError.simple.msg");
            }
            if (dupElementNameErrorMsg != null && dupElementNameErrorMsg.startsWith(prefix)) {
                return LibraryEditResources.getString("LibraryEdit.duplicateElementNameError.simple.msg");
            }
        }
        s = s < 0 ? 0 : ++s;
        int t = msg.indexOf(10);
        if (t < 0) {
            t = msg.length();
        }
        return msg.substring(s, t).trim();
    }

    public static TeamProfile getTeam(Activity activity, Role role) {
        ArrayList teamList = new ArrayList();
        ComposedAdapterFactory adapterFactory = TngAdapterFactory.INSTANCE.getOBS_ComposedAdapterFactory();
        UserInteractionHelper.getTeamsInScope((AdapterFactory)adapterFactory, (BreakdownElement)activity, role, teamList);
        if (teamList.size() == 1) {
            return (TeamProfile)teamList.get(0);
        }
        if (teamList.size() > 1) {
            return TeamSelection.getSelectedTeam(teamList, role);
        }
        return null;
    }

    private static void getTeamsInScope(AdapterFactory adapterFactory, BreakdownElement e, Role role, List teamList) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.emf.edit.provider.ITreeItemContentProvider");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ITreeItemContentProvider itemProvider = (ITreeItemContentProvider)adapterFactory.adapt((Notifier)e, (Object)clazz);
        Collection children = itemProvider.getChildren((Object)e);
        Iterator itor = children.iterator();
        while (itor.hasNext()) {
            TeamProfile team;
            List roles;
            Object obj = itor.next();
            if (!(obj instanceof TeamProfile) || !(roles = ProcessUtil.getRoles((team = (TeamProfile)obj).getTeamRoles())).contains(role)) continue;
            teamList.add(obj);
        }
        Object currentParent = itemProvider.getParent((Object)e);
        if (currentParent != null) {
            UserInteractionHelper.getTeamsInScope(adapterFactory, (BreakdownElement)currentParent, role, teamList);
        }
    }

    public static final boolean runWithProgress(final Runnable runnable, final String msg) {
        final MultiStatus status = new MultiStatus(LibraryEditPlugin.INSTANCE.getSymbolicName(), 0, LibraryEditResources.getString("LibraryEdit.error.reason"), null);
        IRunnableWithProgress operation = new IRunnableWithProgress(){

            /*
             * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                monitor.beginTask(msg, -1);
                monitor.subTask("");
                try {
                    try {
                        runnable.run();
                    }
                    catch (RuntimeException e) {
                        String msg2;
                        if (e instanceof MessageException) {
                            msg2 = e.getMessage();
                        } else {
                            StringWriter strWriter = new StringWriter();
                            e.printStackTrace(new PrintWriter(strWriter));
                            msg2 = strWriter.toString();
                        }
                        status.add((IStatus)new Status(4, LibraryEditPlugin.INSTANCE.getSymbolicName(), 0, msg2, (Throwable)e));
                    }
                }
                catch (Throwable throwable) {
                    Object var5_6 = null;
                    monitor.done();
                    throw throwable;
                }
                {
                    Object var5_7 = null;
                }
                monitor.done();
            }
        };
        try {
            Shell shell = MsgBox.getDefaultShell();
            ProgressMonitorDialog monitorDlg = new ProgressMonitorDialog(shell);
            monitorDlg.run(true, false, operation);
            if (status.isOK()) {
                return true;
            }
            LibraryEditPlugin.getDefault().getMsgDialog().displayError(LibraryEditResources.getString("LibraryEdit.errorDialog.title"), LibraryEditResources.getString("LibraryEdit.error.msgWithDetails"), (IStatus)status);
        }
        catch (Exception exception) {
            CommonPlugin.INSTANCE.log((Object)exception);
        }
        return false;
    }

    public static final boolean runWithProgress(IRunnableWithProgress runnable, String msg) {
        return UserInteractionHelper.runWithProgress(runnable, false, msg);
    }

    public static final boolean runWithProgress(final IRunnableWithProgress runnable, boolean canCancel, final String msg) {
        final MultiStatus status = new MultiStatus(LibraryEditPlugin.INSTANCE.getSymbolicName(), 0, LibraryEditResources.getString("LibraryEdit.error.reason"), null);
        IRunnableWithProgress operation = new IRunnableWithProgress(){

            /*
             * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                monitor.beginTask(msg, -1);
                monitor.subTask("");
                try {
                    try {
                        runnable.run(monitor);
                    }
                    catch (RuntimeException e) {
                        String msg2;
                        LibraryEditPlugin.INSTANCE.log(e);
                        if (e instanceof MessageException) {
                            msg2 = e.getMessage();
                        } else {
                            StringWriter strWriter = new StringWriter();
                            e.printStackTrace(new PrintWriter(strWriter));
                            msg2 = strWriter.toString();
                        }
                        status.add((IStatus)new Status(4, LibraryEditPlugin.INSTANCE.getSymbolicName(), 0, msg2, (Throwable)e));
                    }
                }
                catch (Throwable throwable) {
                    Object var5_6 = null;
                    monitor.done();
                    throw throwable;
                }
                {
                    Object var5_7 = null;
                }
                monitor.done();
            }
        };
        try {
            Shell shell = MsgBox.getDefaultShell();
            ProgressMonitorDialog monitorDlg = new ProgressMonitorDialog(shell);
            monitorDlg.run(true, canCancel, operation);
            if (status.isOK()) {
                return true;
            }
            LibraryEditPlugin.getDefault().getMsgDialog().displayError(LibraryEditResources.getString("LibraryEdit.errorDialog.title"), LibraryEditResources.getString("LibraryEdit.error.msgWithDetails"), (IStatus)status);
        }
        catch (Exception exception) {
            CommonPlugin.INSTANCE.log((Object)exception);
        }
        return false;
    }

    public static final boolean runWithProgress(final IRunnableWithProgress runnable, ProgressMonitorDialog monitorDlg, boolean canCancel, final String msg) {
        final MultiStatus status = new MultiStatus(LibraryEditPlugin.INSTANCE.getSymbolicName(), 0, LibraryEditResources.getString("LibraryEdit.error.reason"), null);
        IRunnableWithProgress operation = new IRunnableWithProgress(){

            /*
             * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                monitor.beginTask(msg, -1);
                monitor.subTask("");
                try {
                    try {
                        runnable.run(monitor);
                    }
                    catch (RuntimeException e) {
                        String msg2;
                        if (e instanceof MessageException) {
                            msg2 = e.getMessage();
                        } else {
                            StringWriter strWriter = new StringWriter();
                            e.printStackTrace(new PrintWriter(strWriter));
                            msg2 = strWriter.toString();
                        }
                        status.add((IStatus)new Status(4, LibraryEditPlugin.INSTANCE.getSymbolicName(), 0, msg2, (Throwable)e));
                    }
                }
                catch (Throwable throwable) {
                    Object var5_6 = null;
                    monitor.done();
                    throw throwable;
                }
                {
                    Object var5_7 = null;
                }
                monitor.done();
            }
        };
        try {
            monitorDlg.run(true, canCancel, operation);
            if (status.isOK()) {
                return true;
            }
            LibraryEditPlugin.getDefault().getMsgDialog().displayError(LibraryEditResources.getString("LibraryEdit.errorDialog.title"), LibraryEditResources.getString("LibraryEdit.error.msgWithDetails"), (IStatus)status);
        }
        catch (Exception exception) {
            CommonPlugin.INSTANCE.log((Object)exception);
        }
        return false;
    }

    public static WorkProductDescriptor getDeliverable(Activity activity, WorkProduct wp) {
        ArrayList deliverableList = new ArrayList();
        ComposedAdapterFactory adapterFactory = TngAdapterFactory.INSTANCE.getPBS_ComposedAdapterFactory();
        UserInteractionHelper.getDeliverablesInScope((AdapterFactory)adapterFactory, (BreakdownElement)activity, wp, deliverableList);
        if (deliverableList.size() == 1) {
            return (WorkProductDescriptor)deliverableList.get(0);
        }
        if (deliverableList.size() > 1) {
            return DeliverableSelection.getSelectedDeliverable(deliverableList, wp);
        }
        return null;
    }

    private static void getDeliverablesInScope(AdapterFactory adapterFactory, BreakdownElement e, WorkProduct wp, List deliverableList) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.emf.edit.provider.ITreeItemContentProvider");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ITreeItemContentProvider itemProvider = (ITreeItemContentProvider)adapterFactory.adapt((Notifier)e, (Object)clazz);
        Collection children = itemProvider.getChildren((Object)e);
        Iterator itor = children.iterator();
        while (itor.hasNext()) {
            WorkProductDescriptor wpDesc;
            List parts;
            Object obj = itor.next();
            if (!(obj instanceof WorkProductDescriptor) || !(ProcessUtil.getAssociatedElement((Descriptor)((WorkProductDescriptor)obj)) instanceof Deliverable) || !(parts = ProcessUtil.getAssociatedElementList((wpDesc = (WorkProductDescriptor)obj).getDeliverableParts())).contains(wp)) continue;
            deliverableList.add(obj);
        }
        Object currentParent = itemProvider.getParent((Object)e);
        if (currentParent != null) {
            UserInteractionHelper.getDeliverablesInScope(adapterFactory, (BreakdownElement)currentParent, wp, deliverableList);
        }
    }

    public static IStatus checkModify(EObject element, Shell shell) {
        if (TngUtil.isLocked(element)) {
            String msg = MessageFormat.format(LibraryEditResources.getString("LibraryEdit.UserInteractionHelper.lockedPlugin"), UmaUtil.getMethodPlugin((EObject)element).getName());
            return new Status(4, LibraryEditPlugin.INSTANCE.getId(), 0, msg, null);
        }
        return TngUtil.checkEdit(element, shell);
    }

    public static IStatus checkModify(Collection modifiedResources, Shell shell) {
        String[] paths = new String[modifiedResources.size()];
        int i = 0;
        Iterator iter = modifiedResources.iterator();
        while (iter.hasNext()) {
            Resource resource = (Resource)iter.next();
            paths[i++] = resource.getURI().toFileString();
        }
        return ContentDescriptionFactory.getFileManager().checkModify(paths, (Object)shell);
    }

    public static boolean checkModifyOpposite(MethodElement featureOwner, EStructuralFeature feature, MethodElement element) {
        NamedElement oldOppositeFeatureValue;
        OppositeFeature oppositeFeature = MultiResourceEObject.getOppositeFeature((EStructuralFeature)feature);
        MultiResourceEObject mrEObj = (MultiResourceEObject)element;
        if (oppositeFeature != null && !oppositeFeature.isMany() && (oldOppositeFeatureValue = (NamedElement)mrEObj.getOppositeFeatureMap().get(oppositeFeature)) != null && (oldOppositeFeatureValue instanceof MethodLibrary || oldOppositeFeatureValue.eContainer() != null) && oldOppositeFeatureValue.eResource() != null) {
            String msg = MessageFormat.format(LibraryEditResources.getString("LibraryEdit.UserInteractionHelper.errRelationshipExists"), element.getName(), TngUtil.getLabelWithPath(oldOppositeFeatureValue), featureOwner.getName());
            LibraryEditPlugin.INSTANCE.getMsgDialog().displayError(LibraryEditResources.getString("LibraryEdit.errorDialog.title"), msg);
            return false;
        }
        return true;
    }
}

