/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.edit.util;

import com.ibm.uma.DescribableElement;
import com.ibm.uma.Guidance;
import com.ibm.uma.MethodElement;
import com.ibm.uma.ProcessComponent;
import com.ibm.uma.ProcessPackage;
import java.util.Comparator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.epf.library.edit.util.TngUtil;

public final class Comparators {
    public static final Comparator DEFAULT_COMPARATOR = new Comparator(){

        public int compare(Object o1, Object o2) {
            if (o1 == o2) {
                return 0;
            }
            if (o1 instanceof MethodElement && o2 instanceof MethodElement) {
                return ((MethodElement)o1).getName().compareToIgnoreCase(((MethodElement)o2).getName());
            }
            Object o1unwrap = TngUtil.unwrap(o1);
            Object o2unwrap = TngUtil.unwrap(o2);
            if (o1unwrap instanceof MethodElement && o2unwrap instanceof MethodElement) {
                return ((MethodElement)o1unwrap).getName().compareToIgnoreCase(((MethodElement)o2unwrap).getName());
            }
            return 0;
        }
    };
    public static final Comparator GUIDANCE_TYPE_COMPARATOR = new TypeComparator(){

        protected int getOrderId(Object obj) {
            if (obj instanceof Guidance) {
                int id = ((Guidance)obj).eClass().getClassifierID();
                if (id == 84) {
                    id = Integer.MAX_VALUE;
                }
                return id;
            }
            return -1;
        }
    };
    public static final Comparator PROCESS_PACKAGE_COMPARATOR = new TypeComparator(){

        protected int getOrderId(Object obj) {
            if (obj instanceof ProcessComponent) {
                return Integer.MAX_VALUE;
            }
            if (obj instanceof ProcessPackage) {
                return 0;
            }
            return -1;
        }
    };
    public static final Comparator PRESENTATION_NAME_COMPARATOR = new Comparator(){

        public int compare(Object o1, Object o2) {
            if (o1 == o2) {
                return 0;
            }
            if (o1 instanceof DescribableElement && o2 instanceof DescribableElement) {
                return ((DescribableElement)o1).getPresentationName().compareToIgnoreCase(((DescribableElement)o2).getPresentationName());
            }
            Object o1unwrap = TngUtil.unwrap(o1);
            Object o2unwrap = TngUtil.unwrap(o2);
            if (o1unwrap instanceof DescribableElement && o2unwrap instanceof DescribableElement) {
                return ((DescribableElement)o1unwrap).getPresentationName().compareToIgnoreCase(((DescribableElement)o2unwrap).getPresentationName());
            }
            return 0;
        }
    };

    private static abstract class TypeComparator
    implements Comparator {
        TypeComparator() {
        }

        protected abstract int getOrderId(Object var1);

        public int compare(Object o1, Object o2) {
            if (o1 == o2) {
                return 0;
            }
            int ret = 0;
            ret = this.getOrderId((EObject)o1) - this.getOrderId((EObject)o2);
            if (ret == 0) {
                return DEFAULT_COMPARATOR.compare(o1, o2);
            }
            return ret;
        }
    }
}

