/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.edit.util;

import com.ibm.uma.Activity;
import com.ibm.uma.Artifact;
import com.ibm.uma.BreakdownElement;
import com.ibm.uma.CompositeRole;
import com.ibm.uma.ContentPackage;
import com.ibm.uma.Deliverable;
import com.ibm.uma.Descriptor;
import com.ibm.uma.MethodConfiguration;
import com.ibm.uma.MethodElement;
import com.ibm.uma.MethodPlugin;
import com.ibm.uma.Process;
import com.ibm.uma.ProcessComponent;
import com.ibm.uma.ProcessContribution;
import com.ibm.uma.ProcessPackage;
import com.ibm.uma.Role;
import com.ibm.uma.RoleDescriptor;
import com.ibm.uma.Task;
import com.ibm.uma.TaskDescriptor;
import com.ibm.uma.TeamProfile;
import com.ibm.uma.UmaFactory;
import com.ibm.uma.UmaPackage;
import com.ibm.uma.VariabilityElement;
import com.ibm.uma.VariabilityType;
import com.ibm.uma.WorkBreakdownElement;
import com.ibm.uma.WorkOrder;
import com.ibm.uma.WorkProduct;
import com.ibm.uma.WorkProductDescriptor;
import com.ibm.uma.provider.UmaEditPlugin;
import com.ibm.uma.util.AssociationHelper;
import com.ibm.uma.util.UmaUtil;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.notify.impl.NotificationImpl;
import org.eclipse.emf.common.util.AbstractTreeIterator;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.provider.AdapterFactoryTreeIterator;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.IChangeNotifier;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;
import org.eclipse.emf.edit.provider.IWrapperItemProvider;
import org.eclipse.emf.edit.provider.ItemProviderAdapter;
import org.eclipse.emf.edit.provider.ViewerNotification;
import org.eclipse.epf.common.utils.StrUtil;
import org.eclipse.epf.library.edit.IConfigurationApplicator;
import org.eclipse.epf.library.edit.IFilter;
import org.eclipse.epf.library.edit.LibraryEditResources;
import org.eclipse.epf.library.edit.Providers;
import org.eclipse.epf.library.edit.TngAdapterFactory;
import org.eclipse.epf.library.edit.command.IActionManager;
import org.eclipse.epf.library.edit.process.BSActivityItemProvider;
import org.eclipse.epf.library.edit.process.BreakdownElementWrapperItemProvider;
import org.eclipse.epf.library.edit.process.IBSItemProvider;
import org.eclipse.epf.library.edit.process.WorkProductDescriptorWrapperItemProvider;
import org.eclipse.epf.library.edit.process.command.BSDropCommand;
import org.eclipse.epf.library.edit.process.command.ProcessCommandUtil;
import org.eclipse.epf.library.edit.process.command.WBSDropCommand;
import org.eclipse.epf.library.edit.ui.ExposedAdapterFactoryContentProvider;
import org.eclipse.epf.library.edit.ui.UserInteractionHelper;
import org.eclipse.epf.library.edit.util.ExposedAdapterFactory;
import org.eclipse.epf.library.edit.util.MethodElementUtil;
import org.eclipse.epf.library.edit.util.ModelStructure;
import org.eclipse.epf.library.edit.util.TngUtil;
import org.eclipse.jface.viewers.Viewer;

public final class ProcessUtil {
    private static Collection OBSEclasses = null;
    private static Collection WBSEclasses = null;
    private static Collection PBSEclasses = null;
    private static Collection extendAndContributeVariabilityTypes = null;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;

    private static Collection getExtendAndContributeVariabilityTypes() {
        if (extendAndContributeVariabilityTypes == null) {
            extendAndContributeVariabilityTypes = new ArrayList();
            extendAndContributeVariabilityTypes.add(VariabilityType.EXTENDS_LITERAL);
            extendAndContributeVariabilityTypes.add(VariabilityType.CONTRIBUTES_LITERAL);
        }
        return extendAndContributeVariabilityTypes;
    }

    private static Class chooseType(BreakdownElement e) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.ibm.uma.BreakdownElement");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return clazz;
    }

    private static String checkNameInScope(AdapterFactory adapterFactory, BreakdownElement e, EStructuralFeature feature, String name, IFilter childFilter) {
        Object currentParent;
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.emf.edit.provider.ITreeItemContentProvider");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ITreeItemContentProvider itemProvider = (ITreeItemContentProvider)adapterFactory.adapt((Notifier)e, (Object)clazz);
        Object parent = currentParent = itemProvider.getParent((Object)e);
        while (parent != null) {
            String msg = TngUtil.checkName(adapterFactory, parent, (Object)e, childFilter, feature, name);
            if (msg != null) {
                return msg;
            }
            Class<?> clazz2 = class$1;
            if (clazz2 == null) {
                try {
                    clazz2 = Class.forName("org.eclipse.emf.edit.provider.ITreeItemContentProvider");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            itemProvider = (ITreeItemContentProvider)adapterFactory.adapt(parent, (Object)clazz2);
            parent = itemProvider.getParent(parent);
        }
        if (currentParent != null) {
            AdapterFactoryTreeIterator iter = new AdapterFactoryTreeIterator(adapterFactory, currentParent, false);
            while (iter.hasNext()) {
                String childName;
                Object child = TngUtil.unwrap(iter.next());
                if (child == e || !childFilter.accept(child) || !name.equalsIgnoreCase(childName = (String)((EObject)child).eGet(feature))) continue;
                return LibraryEditResources.formatString("LibraryEdit.duplicateElementNameError.msg", name);
            }
        }
        return null;
    }

    public static String checkName(AdapterFactory adapterFactory, final BreakdownElement e, EStructuralFeature feature, String name) {
        Class type = ProcessUtil.chooseType(e);
        String msg = TngUtil.checkName(adapterFactory, e, type, feature, name);
        if (msg != null) {
            return msg;
        }
        IFilter childFilter = null;
        if (e instanceof TeamProfile) {
            childFilter = new IFilter(){

                public boolean accept(Object obj) {
                    return e instanceof TeamProfile;
                }
            };
        } else if (e instanceof WorkProductDescriptor && ((WorkProductDescriptor)e).getWorkProduct() instanceof Deliverable) {
            childFilter = new IFilter(){

                public boolean accept(Object obj) {
                    return e instanceof WorkProductDescriptor && ((WorkProductDescriptor)e).getWorkProduct() instanceof Deliverable;
                }
            };
        }
        if (childFilter != null) {
            return ProcessUtil.checkNameInScope(adapterFactory, e, feature, name, childFilter);
        }
        return null;
    }

    public static String checkBreakdownElementName(AdapterFactory adapterFactory, BreakdownElement e, String name) {
        return ProcessUtil.checkName(adapterFactory, e, (EStructuralFeature)UmaPackage.eINSTANCE.getNamedElement_Name(), name);
    }

    public static String checkBreakdownElementPresentationName(AdapterFactory adapterFactory, BreakdownElement e, String name) {
        if ((name == null || name.length() == 0) && ProcessUtil.isExtendingOrContributing(e)) {
            BreakdownElement base = (BreakdownElement)((VariabilityElement)e).getVariabilityBasedOnElement();
            name = ProcessUtil.getPresentationName(base);
        }
        return ProcessUtil.checkName(adapterFactory, e, (EStructuralFeature)UmaPackage.eINSTANCE.getDescribableElement_PresentationName(), name);
    }

    public static Object getRootProcess(AdapterFactory adapterFactory, ItemProviderAdapter adapter, Object obj) {
        Object parent = adapter.getParent(obj);
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.emf.edit.provider.ITreeItemContentProvider");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        adapter = (ItemProviderAdapter)adapterFactory.adapt(parent, (Object)clazz);
        if (parent == null) {
            return obj;
        }
        return ProcessUtil.getRootProcess(adapterFactory, adapter, parent);
    }

    public static Collection getWBSEclasses() {
        if (WBSEclasses == null) {
            WBSEclasses = new HashSet();
            WBSEclasses.add(UmaPackage.eINSTANCE.getTaskDescriptor());
            WBSEclasses.add(UmaPackage.eINSTANCE.getActivity());
            WBSEclasses.add(UmaPackage.eINSTANCE.getMilestone());
        }
        return WBSEclasses;
    }

    public static Collection getOBSEclasses() {
        if (OBSEclasses == null) {
            OBSEclasses = new HashSet();
            OBSEclasses.add(UmaPackage.eINSTANCE.getRoleDescriptor());
            OBSEclasses.add(UmaPackage.eINSTANCE.getActivity());
            OBSEclasses.add(UmaPackage.eINSTANCE.getMilestone());
            OBSEclasses.add(UmaPackage.eINSTANCE.getTeamProfile());
            OBSEclasses.add(UmaPackage.eINSTANCE.getCompositeRole());
        }
        return OBSEclasses;
    }

    public static Collection getPBSEclasses() {
        if (PBSEclasses == null) {
            PBSEclasses = new HashSet();
            PBSEclasses.add(UmaPackage.eINSTANCE.getWorkProductDescriptor());
            PBSEclasses.add(UmaPackage.eINSTANCE.getActivity());
            PBSEclasses.add(UmaPackage.eINSTANCE.getMilestone());
        }
        return PBSEclasses;
    }

    public static boolean isFirstElement(AdapterFactory adapterFactory, ItemProviderAdapter itemProvider, Object obj) {
        LinkedList siblings = ProcessUtil.getSiblings(adapterFactory, itemProvider, obj);
        if (siblings != null && !siblings.isEmpty()) {
            return siblings.getFirst() == obj;
        }
        return false;
    }

    public static LinkedList getSiblings(AdapterFactory adapterFactory, ItemProviderAdapter itemProvider, Object obj) {
        ITreeItemContentProvider parentItemProvider;
        Object parent = itemProvider.getParent(obj);
        if (parent == null) {
            return null;
        }
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.emf.edit.provider.ITreeItemContentProvider");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((parentItemProvider = (ITreeItemContentProvider)adapterFactory.adapt(parent, (Object)clazz)) != null) {
            return new LinkedList(parentItemProvider.getChildren(parent));
        }
        return null;
    }

    public static boolean isLastElement(AdapterFactory adapterFactory, ItemProviderAdapter itemProvider, Object obj) {
        LinkedList siblings = ProcessUtil.getSiblings(adapterFactory, itemProvider, obj);
        if (siblings != null) {
            return siblings.getLast() == obj;
        }
        return false;
    }

    public static List getAffectedElements(Notification notification, IFilter filter) {
        ArrayList<Object> affectedElements = new ArrayList<Object>();
        switch (notification.getEventType()) {
            case 3: {
                Object obj = notification.getNewValue();
                if (filter != null && !filter.accept(obj)) break;
                affectedElements.add(obj);
                break;
            }
            case 5: {
                Iterator iter = ((Collection)notification.getNewValue()).iterator();
                while (iter.hasNext()) {
                    Object element = iter.next();
                    if (filter != null && !filter.accept(element)) continue;
                    affectedElements.add(element);
                }
                break;
            }
            case 4: {
                Object obj = notification.getOldValue();
                if (filter != null && !filter.accept(obj)) break;
                affectedElements.add(obj);
                break;
            }
            case 6: {
                Iterator iter = ((Collection)notification.getOldValue()).iterator();
                while (iter.hasNext()) {
                    Object element = iter.next();
                    if (filter != null && !filter.accept(element)) continue;
                    affectedElements.add(element);
                }
                break;
            }
            case 7: {
                Object obj = notification.getNewValue();
                if (obj instanceof Collection) {
                    Iterator iter = ((Collection)obj).iterator();
                    while (iter.hasNext()) {
                        Object element = iter.next();
                        if (filter != null && !filter.accept(element)) continue;
                        affectedElements.add(element);
                    }
                    break;
                }
                if (filter != null && !filter.accept(obj)) break;
                affectedElements.add(obj);
            }
        }
        return affectedElements;
    }

    public static boolean isRefreshRequired(Notification notification, IFilter filter) {
        switch (notification.getEventType()) {
            case 3: {
                Object obj = notification.getNewValue();
                if (filter != null && !filter.accept(obj)) break;
                return true;
            }
            case 5: {
                Iterator iter = ((Collection)notification.getNewValue()).iterator();
                while (iter.hasNext()) {
                    Object element = iter.next();
                    if (filter != null && !filter.accept(element)) continue;
                    return true;
                }
                break;
            }
            case 4: {
                Object obj = notification.getOldValue();
                if (filter != null && !filter.accept(obj)) break;
                return true;
            }
            case 6: {
                Iterator iter = ((Collection)notification.getOldValue()).iterator();
                while (iter.hasNext()) {
                    Object element = iter.next();
                    if (filter != null && !filter.accept(element)) continue;
                    return true;
                }
                break;
            }
            case 7: {
                Object obj = notification.getNewValue();
                if (obj instanceof Collection) {
                    Iterator iter = ((Collection)obj).iterator();
                    while (iter.hasNext()) {
                        Object element = iter.next();
                        if (filter != null && !filter.accept(element)) continue;
                        return true;
                    }
                    break;
                }
                if (filter != null && !filter.accept(obj)) break;
                return true;
            }
        }
        return false;
    }

    public static void addToContainer(BreakdownElement e, ItemProviderAdapter itemProvider) {
        ProcessUtil.addToContainer(e, itemProvider, true);
    }

    public static void addToContainer(BreakdownElement e, ItemProviderAdapter itemProvider, boolean move) {
        EObject container;
        ProcessPackage pkg = null;
        Object parent = itemProvider.getParent((Object)e);
        if (parent instanceof EObject && (container = ((EObject)parent).eContainer()) instanceof ProcessPackage) {
            pkg = (ProcessPackage)container;
        }
        if (pkg == null) {
            return;
        }
        if (e instanceof Activity) {
            ProcessPackage oldPkg;
            Activity act = (Activity)e;
            if (act.eContainer() == null) {
                ProcessPackage newPkg = UmaFactory.eINSTANCE.createProcessPackage();
                newPkg.setName(act.getName());
                pkg.getChildPackages().add(newPkg);
                newPkg.getProcessElements().add(e);
            } else if (move && (oldPkg = (ProcessPackage)act.eContainer()).eContainer() != pkg) {
                pkg.getChildPackages().add(oldPkg);
            }
        } else if (e.eContainer() == null) {
            pkg.getProcessElements().add(e);
        } else if (move && e.eContainer() != pkg) {
            pkg.getProcessElements().add(e);
        }
    }

    public static void setParent(Object child, Object parent, AdapterFactory adapterFactory) {
        Object adapter;
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.emf.edit.provider.ITreeItemContentProvider");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((adapter = adapterFactory.adapt(child, (Object)clazz)) instanceof IBSItemProvider) {
            ((IBSItemProvider)adapter).setParent(parent);
        } else {
            System.out.println(String.valueOf(LibraryEditResources.getString("LibraryEdit.util.ProcessUtil.err_setparent")) + child);
            System.out.println(String.valueOf(LibraryEditResources.getString("LibraryEdit.util.ProcessUtil.childadapter")) + adapter);
        }
    }

    public static TaskDescriptor createTaskDescriptor(Task task) {
        TaskDescriptor taskDesc = UmaFactory.eINSTANCE.createTaskDescriptor();
        taskDesc.setTask(task);
        taskDesc.setName(task.getName());
        taskDesc.setPresentationName(StrUtil.isBlank((String)task.getPresentationName()) ? task.getName() : task.getPresentationName());
        return taskDesc;
    }

    public static RoleDescriptor createRoleDescriptor(Role role) {
        RoleDescriptor roleDesc = UmaFactory.eINSTANCE.createRoleDescriptor();
        roleDesc.setRole(role);
        String presentationName = role.getPresentationName();
        roleDesc.setName(role.getName());
        roleDesc.setPresentationName(StrUtil.isBlank((String)presentationName) ? role.getName() : presentationName);
        return roleDesc;
    }

    public static WorkProductDescriptor createWorkProductDescriptor(WorkProduct wp) {
        WorkProductDescriptor wpDesc = UmaFactory.eINSTANCE.createWorkProductDescriptor();
        wpDesc.setWorkProduct(wp);
        wpDesc.setName(wp.getName());
        wpDesc.setPresentationName(StrUtil.isBlank((String)wp.getPresentationName()) ? wp.getName() : wp.getPresentationName());
        return wpDesc;
    }

    public static WorkProductDescriptor createWorkProductDescriptor(WorkProduct wp, MethodConfiguration config, Map wpDescToDeliverableParts) {
        WorkProductDescriptor wpd = ProcessUtil.createWorkProductDescriptor(wp);
        if (wp instanceof Deliverable && wpDescToDeliverableParts != null) {
            ProcessUtil.createDeliverableParts(wpd, (Deliverable)wp, config, wpDescToDeliverableParts);
        }
        return wpd;
    }

    public static void createDeliverableParts(WorkProductDescriptor wpd, Deliverable deliverable, MethodConfiguration config, Map wpDescToDeliverableParts) {
        IConfigurationApplicator configApplicator = Providers.getConfigurationApplicator();
        List deliveredWPs = (List)configApplicator.getReference((VariabilityElement)deliverable, UmaPackage.eINSTANCE.getDeliverable_DeliveredWorkProducts(), config);
        ArrayList<WorkProductDescriptor> parts = new ArrayList<WorkProductDescriptor>();
        if (wpd.getDeliverableParts().isEmpty()) {
            Iterator iter = deliveredWPs.iterator();
            while (iter.hasNext()) {
                parts.add(ProcessUtil.createWorkProductDescriptor((WorkProduct)iter.next(), config, wpDescToDeliverableParts));
            }
            wpDescToDeliverableParts.put(wpd, parts);
        } else {
            Iterator iter = deliveredWPs.iterator();
            while (iter.hasNext()) {
                WorkProduct workProduct = (WorkProduct)iter.next();
                WorkProductDescriptor desc = (WorkProductDescriptor)ProcessUtil.getDescriptor((Object)workProduct, wpd.getDeliverableParts());
                if (desc == null) {
                    parts.add(ProcessUtil.createWorkProductDescriptor(workProduct, config, wpDescToDeliverableParts));
                    continue;
                }
                if (!(workProduct instanceof Deliverable)) continue;
                ProcessUtil.createDeliverableParts(desc, (Deliverable)workProduct, config, wpDescToDeliverableParts);
            }
            if (!parts.isEmpty()) {
                wpDescToDeliverableParts.put(wpd, parts);
            }
        }
    }

    public static Viewer getViewer(AdapterFactory adapterFactory, Process proc) {
        if (adapterFactory instanceof ExposedAdapterFactory) {
            Iterator iter = Collections.unmodifiableList(((ExposedAdapterFactory)adapterFactory).getChangeListeners()).iterator();
            while (iter.hasNext()) {
                Viewer viewer;
                Object listener = iter.next();
                if (!(listener instanceof ExposedAdapterFactoryContentProvider) || !((viewer = ((ExposedAdapterFactoryContentProvider)((Object)listener)).getViewer()).getInput() instanceof ProcessComponent) || ((ProcessComponent)viewer.getInput()).getProcess() != proc) continue;
                return viewer;
            }
        }
        return null;
    }

    public static boolean refreshNeeded(AdapterFactory adapterFactory, BSActivityItemProvider itemProvider) {
        BSActivityItemProvider adapter;
        Object element;
        Process process = (Process)itemProvider.getTopItem();
        if (process == null) {
            return false;
        }
        Viewer viewer = ProcessUtil.getViewer(adapterFactory, process);
        if (viewer != null && viewer.getControl() != null && !viewer.getControl().isDisposed()) {
            return true;
        }
        Iterator iter = TngUtil.getContributors((VariabilityElement)process);
        while (iter.hasNext()) {
            element = iter.next();
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = Class.forName("org.eclipse.emf.edit.provider.ITreeItemContentProvider");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (!ProcessUtil.refreshNeeded(adapterFactory, adapter = (BSActivityItemProvider)adapterFactory.adapt(element, (Object)clazz))) continue;
            return true;
        }
        iter = TngUtil.getGeneralizers((VariabilityElement)process, VariabilityType.EXTENDS_LITERAL);
        while (iter.hasNext()) {
            element = iter.next();
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = Class.forName("org.eclipse.emf.edit.provider.ITreeItemContentProvider");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (!ProcessUtil.refreshNeeded(adapterFactory, adapter = (BSActivityItemProvider)adapterFactory.adapt(element, (Object)clazz))) continue;
            return true;
        }
        return false;
    }

    public static void updateIDs(AdapterFactory factory, Process proc) {
        int id = 0;
        AdapterFactoryTreeIterator iter = new AdapterFactoryTreeIterator(factory, (Object)proc);
        while (iter.hasNext()) {
            IBSItemProvider itemProvider;
            Object adapter;
            Object obj = iter.next();
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = Class.forName("org.eclipse.emf.edit.provider.ITreeItemContentProvider");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (!((adapter = factory.adapt(obj, (Object)clazz)) instanceof IBSItemProvider) || (itemProvider = (IBSItemProvider)adapter) == null || !(TngUtil.unwrap(obj) instanceof WorkBreakdownElement)) continue;
            itemProvider.setId(id++);
        }
    }

    public static void refreshViewer(AdapterFactory factory, Process proc) {
        Viewer viewer = ProcessUtil.getViewer(factory, proc);
        if (viewer != null && viewer.getControl() != null && !viewer.getControl().isDisposed()) {
            viewer.refresh();
        }
    }

    public static void refreshIDsInViewers(ExposedAdapterFactory adapterFactory) {
        Iterator iter = Collections.unmodifiableList(adapterFactory.getChangeListeners()).iterator();
        while (iter.hasNext()) {
            BSActivityItemProvider itemProvider;
            Viewer viewer;
            Object listener = iter.next();
            if (!(listener instanceof ExposedAdapterFactoryContentProvider) || (viewer = ((ExposedAdapterFactoryContentProvider)((Object)listener)).getViewer()) == null || viewer.getControl() == null || viewer.getControl().isDisposed() || !(viewer.getInput() instanceof ProcessComponent)) continue;
            Process proc = ((ProcessComponent)viewer.getInput()).getProcess();
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = Class.forName("org.eclipse.emf.edit.provider.ITreeItemContentProvider");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (!(itemProvider = (BSActivityItemProvider)adapterFactory.adapt((Notifier)proc, (Object)clazz)).isRefreshAllIDsRequired()) continue;
            ProcessUtil.updateIDs((AdapterFactory)adapterFactory, proc);
            viewer.refresh();
            itemProvider.setRefreshAllIDsRequired(false);
        }
    }

    public static String checkPredecessorList(WorkBreakdownElement e, List predIdList, AdapterFactory adapterFactory, Object process, List predecessors) {
        ArrayList beList = new ArrayList();
        ArrayList allElements = new ArrayList();
        AdapterFactoryTreeIterator iter = new AdapterFactoryTreeIterator(adapterFactory, process);
        while (iter.hasNext()) {
            Object obj = iter.next();
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = Class.forName("org.eclipse.emf.edit.provider.ITreeItemContentProvider");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            IBSItemProvider itemProvider = (IBSItemProvider)adapterFactory.adapt(obj, (Object)clazz);
            Integer id = new Integer(itemProvider.getId());
            obj = TngUtil.unwrap(obj);
            allElements.add(obj);
            if (!predIdList.contains(id)) continue;
            beList.add(obj);
        }
        int size = beList.size();
        int i = 0;
        while (i < size) {
            Object obj = beList.get(i);
            if (obj instanceof WorkBreakdownElement) {
                WorkBreakdownElement pred = (WorkBreakdownElement)obj;
                if (ProcessUtil.checkCircular(e, pred, allElements)) {
                    return LibraryEditResources.getString("LibraryEdit.util.ProcessUtil.err_same_breakdown_element");
                }
                if (TngUtil.isSubelementOf(pred, e, adapterFactory)) {
                    return LibraryEditResources.getString("LibraryEdit.util.ProcessUtil.err_same_sub_element");
                }
                if (TngUtil.isSuperElementOf(pred, e, adapterFactory)) {
                    return LibraryEditResources.getString("LibraryEdit.util.ProcessUtil.err_child_element");
                }
            } else {
                return LibraryEditResources.getString("LibraryEdit.util.ProcessUtil.err_wrong_element");
            }
            ++i;
        }
        if (predecessors != null) {
            predecessors.addAll(beList);
        }
        return null;
    }

    public static boolean checkCircular(WorkBreakdownElement successor, WorkBreakdownElement predecessor, List list) {
        return false;
    }

    public static void getAllPredecessorList(WorkBreakdownElement predecessor, List list, List predList) {
        if (!predList.contains(predecessor)) {
            predList.add(predecessor);
        }
        Iterator iter = predecessor.getLinkToPredecessor().iterator();
        while (iter.hasNext()) {
            WorkOrder element = (WorkOrder)iter.next();
            WorkBreakdownElement pred = element.getPred();
            if (pred == predecessor || !list.contains(pred) || predList.contains(pred)) continue;
            predList.add(pred);
            ProcessUtil.getAllPredecessorList(pred, list, predList);
        }
    }

    public static String checkPredecessorList(WorkBreakdownElement e, String predList, AdapterFactory adapterFactory, Object topAct, List predecessors) {
        ArrayList<Integer> idList = new ArrayList<Integer>();
        StringTokenizer tokens = new StringTokenizer(predList, ",");
        while (tokens.hasMoreTokens()) {
            Integer id;
            String token = tokens.nextToken().trim();
            try {
                id = new Integer(token);
            }
            catch (NumberFormatException numberFormatException) {
                return LibraryEditResources.getString("LibraryEdit.invalidPredecessorError.msg");
            }
            idList.add(id);
        }
        return ProcessUtil.checkPredecessorList(e, idList, adapterFactory, topAct, predecessors);
    }

    public static void addToDefaultConfiguration(Process proc, EObject e, Set addedObjects) {
        MethodConfiguration config = proc.getDefaultContext();
        if (e instanceof Task) {
            ProcessUtil.addTaskToDefaultConfiguration(proc, (Task)e, addedObjects, true);
        } else if (e instanceof WorkProduct) {
            WorkProduct wp = (WorkProduct)e;
            ProcessUtil.addWPToDefaultConfiguration(proc, wp, addedObjects);
            List tasks = ProcessUtil.getTasksForWorkProduct(wp, config);
            Iterator iter = tasks.iterator();
            while (iter.hasNext()) {
                ProcessUtil.addTaskToDefaultConfiguration(proc, (Task)iter.next(), addedObjects, false);
            }
        } else if (!(e instanceof Role) && e instanceof Activity) {
            TngUtil.addToConfiguration(config, (EObject)UmaUtil.getProcessComponent((MethodElement)((Activity)e)), addedObjects);
        }
    }

    private static void addTaskToDefaultConfiguration(Process proc, Task task, Set addedObjects, boolean includeWorkProducts) {
        MethodConfiguration config = proc.getDefaultContext();
        TngUtil.addToConfiguration(config, (EObject)task, addedObjects);
        ArrayList<Role> dependencies = new ArrayList<Role>();
        dependencies.addAll(task.getAdditionallyPerformedBy());
        dependencies.add(task.getPerformedBy());
        Iterator iter = dependencies.iterator();
        while (iter.hasNext()) {
            TngUtil.addToConfiguration(config, (EObject)iter.next(), addedObjects);
        }
        if (includeWorkProducts) {
            dependencies.clear();
            dependencies.addAll(task.getOptionalInput());
            dependencies.addAll(task.getOutput());
            dependencies.addAll(task.getMandatoryInput());
            iter = dependencies.iterator();
            while (iter.hasNext()) {
                ProcessUtil.addWPToDefaultConfiguration(proc, (WorkProduct)iter.next(), addedObjects);
            }
        }
        iter = task.getSteps().iterator();
        while (iter.hasNext()) {
            VariabilityElement step = (VariabilityElement)iter.next();
            VariabilityElement base = step.getVariabilityBasedOnElement();
            if (base == null) continue;
            TngUtil.addToConfiguration(config, (EObject)base, addedObjects);
        }
    }

    private static void addWPToDefaultConfiguration(Process proc, WorkProduct wp, Set addedObjects) {
        MethodConfiguration config = proc.getDefaultContext();
        TngUtil.addToConfiguration(config, (EObject)wp, addedObjects);
        if (wp instanceof Deliverable) {
            Iterator iter = ((Deliverable)wp).getDeliveredWorkProducts().iterator();
            while (iter.hasNext()) {
                TngUtil.addToConfiguration(config, (EObject)iter.next(), addedObjects);
            }
        }
    }

    public static void updateTaskDescriptorSteps(Activity activity, TaskDescriptor taskDesc) {
        if (taskDesc == null) {
            return;
        }
        Task task = taskDesc.getTask();
        IConfigurationApplicator configApplicator = Providers.getConfigurationApplicator();
        MethodConfiguration config = TngUtil.getOwningProcess((BreakdownElement)activity).getDefaultContext();
        List steps = (List)configApplicator.getReference((VariabilityElement)task, UmaPackage.eINSTANCE.getTask_Steps(), config);
        Iterator iter = steps.iterator();
        while (iter.hasNext()) {
            Object step = iter.next();
            if (taskDesc.getSelectedSteps().contains(step)) continue;
            taskDesc.getSelectedSteps().add(step);
        }
    }

    private static void addFeatureValue(Map descriptorToNewFeatureValuesMap, EObject object, EStructuralFeature feature, Object value) {
        HashMap<EStructuralFeature, Object> featureMap = (HashMap<EStructuralFeature, Object>)descriptorToNewFeatureValuesMap.get(object);
        if (featureMap == null) {
            featureMap = new HashMap<EStructuralFeature, Object>();
            descriptorToNewFeatureValuesMap.put(object, featureMap);
        }
        if (feature.isMany()) {
            ArrayList<Object> list = (ArrayList<Object>)featureMap.get(feature);
            if (list == null) {
                list = new ArrayList<Object>();
                featureMap.put(feature, list);
            }
            list.add(value);
        } else {
            featureMap.put(feature, value);
        }
    }

    private static void addFeatureValues(Map descriptorToNewFeatureValuesMap, EObject object, EStructuralFeature feature, Collection values) {
        ArrayList list;
        HashMap featureMap = (HashMap)descriptorToNewFeatureValuesMap.get(object);
        if (featureMap == null) {
            featureMap = new HashMap();
            descriptorToNewFeatureValuesMap.put(object, featureMap);
        }
        if ((list = (ArrayList)featureMap.get(feature)) == null) {
            list = new ArrayList();
            featureMap.put(feature, list);
        }
        list.addAll(values);
    }

    public static TaskDescriptor createTaskDescriptor(Task task, Activity activity, List roleDescriptors, List wpDescriptors, Map wpdToDeliverablePartsMap, Map wpdToDeliverableDescriptorMap, Set descriptorsToRefresh, Map descriptorToNewFeatureValuesMap, MethodConfiguration config) {
        if (TngUtil.isContributor((VariabilityElement)task)) {
            task = (Task)TngUtil.getBase((VariabilityElement)task);
        }
        TaskDescriptor taskDesc = (TaskDescriptor)ProcessUtil.getDescriptor((Object)task, activity);
        boolean isNewTaskDescriptor = false;
        if (taskDesc == null) {
            taskDesc = ProcessUtil.createTaskDescriptor(task);
            isNewTaskDescriptor = true;
        } else if (descriptorsToRefresh != null) {
            descriptorsToRefresh.add(taskDesc);
        }
        IConfigurationApplicator configApplicator = Providers.getConfigurationApplicator();
        List steps = (List)configApplicator.getReference(task.getPresentation(), UmaPackage.eINSTANCE.getContentDescription_Sections(), config);
        if (isNewTaskDescriptor) {
            taskDesc.getSelectedSteps().addAll(steps);
        }
        if (roleDescriptors != null) {
            List additionalPerformers;
            Role role = (Role)configApplicator.getReference((VariabilityElement)task, UmaPackage.eINSTANCE.getTask_PerformedBy(), config);
            if (role != null) {
                RoleDescriptor primaryRoleDesc = (RoleDescriptor)ProcessUtil.getDescriptor((Object)role, activity);
                boolean isNewRoleDescriptor = false;
                if (primaryRoleDesc == null && (primaryRoleDesc = (RoleDescriptor)ProcessUtil.getInheritedDescriptor(role, activity)) == null && (primaryRoleDesc = (RoleDescriptor)ProcessUtil.getDescriptor((Object)role, roleDescriptors)) == null) {
                    primaryRoleDesc = ProcessUtil.createRoleDescriptor(role);
                    isNewRoleDescriptor = true;
                    roleDescriptors.add(primaryRoleDesc);
                }
                if (descriptorsToRefresh != null && !isNewRoleDescriptor) {
                    descriptorsToRefresh.add(primaryRoleDesc);
                }
                if (isNewTaskDescriptor && isNewRoleDescriptor) {
                    taskDesc.setPerformedPrimarilyBy(primaryRoleDesc);
                } else {
                    ProcessUtil.addFeatureValue(descriptorToNewFeatureValuesMap, (EObject)taskDesc, (EStructuralFeature)UmaPackage.eINSTANCE.getTaskDescriptor_PerformedPrimarilyBy(), primaryRoleDesc);
                }
            }
            if ((additionalPerformers = (List)configApplicator.getReference((VariabilityElement)task, UmaPackage.eINSTANCE.getTask_AdditionallyPerformedBy(), config)) != null) {
                int j = 0;
                while (j < additionalPerformers.size()) {
                    Role roleObj = (Role)additionalPerformers.get(j);
                    RoleDescriptor roleDesc = (RoleDescriptor)ProcessUtil.getDescriptor((Object)roleObj, activity);
                    boolean isNewRoleDescriptor = false;
                    if (roleDesc == null && (roleDesc = (RoleDescriptor)ProcessUtil.getInheritedDescriptor(roleObj, activity)) == null && (roleDesc = (RoleDescriptor)ProcessUtil.getDescriptor((Object)roleObj, roleDescriptors)) == null) {
                        roleDesc = ProcessUtil.createRoleDescriptor(roleObj);
                        isNewRoleDescriptor = true;
                        roleDescriptors.add(roleDesc);
                    }
                    if (descriptorsToRefresh != null && !isNewRoleDescriptor) {
                        descriptorsToRefresh.add(roleDesc);
                    }
                    if (isNewTaskDescriptor && isNewRoleDescriptor) {
                        taskDesc.getAdditionallyPerformedBy().add(roleDesc);
                    } else {
                        ProcessUtil.addFeatureValue(descriptorToNewFeatureValuesMap, (EObject)taskDesc, (EStructuralFeature)UmaPackage.eINSTANCE.getTaskDescriptor_AdditionallyPerformedBy(), roleDesc);
                    }
                    ++j;
                }
            }
        }
        if (wpDescriptors != null) {
            ProcessUtil.collectWorkProductDescrtiptors(taskDesc, UmaPackage.eINSTANCE.getTask_MandatoryInput(), (EStructuralFeature)UmaPackage.eINSTANCE.getTaskDescriptor_MandatoryInput(), config, activity, wpDescriptors, wpdToDeliverablePartsMap, wpdToDeliverableDescriptorMap, descriptorsToRefresh, descriptorToNewFeatureValuesMap);
            ProcessUtil.collectWorkProductDescrtiptors(taskDesc, UmaPackage.eINSTANCE.getTask_OptionalInput(), (EStructuralFeature)UmaPackage.eINSTANCE.getTaskDescriptor_OptionalInput(), config, activity, wpDescriptors, wpdToDeliverablePartsMap, wpdToDeliverableDescriptorMap, descriptorsToRefresh, descriptorToNewFeatureValuesMap);
            ProcessUtil.collectWorkProductDescrtiptors(taskDesc, UmaPackage.eINSTANCE.getTask_Output(), (EStructuralFeature)UmaPackage.eINSTANCE.getTaskDescriptor_Output(), config, activity, wpDescriptors, wpdToDeliverablePartsMap, wpdToDeliverableDescriptorMap, descriptorsToRefresh, descriptorToNewFeatureValuesMap);
        }
        if (isNewTaskDescriptor) {
            return taskDesc;
        }
        return null;
    }

    public static RoleDescriptor createRoleDescriptor(WorkProductDescriptor wpDesc, Activity activity, List roleDescriptors, Set descriptorsToRefresh) {
        WorkProduct wp;
        if (wpDesc != null && (wp = wpDesc.getWorkProduct()) != null) {
            Role role;
            if (TngUtil.isContributor((VariabilityElement)wp)) {
                wp = (WorkProduct)TngUtil.getBase((VariabilityElement)wp);
            }
            if ((role = AssociationHelper.getResponsibleRole((WorkProduct)wp)) != null) {
                if (TngUtil.isContributor((VariabilityElement)role)) {
                    role = (Role)TngUtil.getBase((VariabilityElement)role);
                }
                boolean isNewDescriptor = false;
                RoleDescriptor roleDesc = (RoleDescriptor)ProcessUtil.getDescriptor((Object)role, activity);
                if (roleDesc == null && (roleDesc = (RoleDescriptor)ProcessUtil.getInheritedDescriptor(role, activity)) == null && (roleDesc = (RoleDescriptor)ProcessUtil.getDescriptor((Object)role, roleDescriptors)) == null) {
                    roleDesc = ProcessUtil.createRoleDescriptor(role);
                    roleDescriptors.add(roleDesc);
                    isNewDescriptor = true;
                }
                if (!isNewDescriptor && descriptorsToRefresh != null) {
                    descriptorsToRefresh.add(roleDesc);
                }
                return roleDesc;
            }
        }
        return null;
    }

    public static boolean clearDescriptor(Descriptor descriptor, Map descriptorToOldRefreshableFeaturesMap) {
        if (descriptorToOldRefreshableFeaturesMap != null && !descriptorToOldRefreshableFeaturesMap.containsKey(descriptor)) {
            descriptorToOldRefreshableFeaturesMap.put(descriptor, ProcessCommandUtil.clearRefreshableFeatures(descriptor));
            return true;
        }
        return false;
    }

    private static void collectWorkProductDescrtiptors(TaskDescriptor taskDescriptor, EReference taskFeature, EStructuralFeature taskDescriptorFeature, MethodConfiguration config, Activity activity, List wpDescriptors, Map wpdToDeliverablePartsMap, Map wpdToDeliverableDescriptorMap, Set descriptorsToRefresh, Map descriptorToNewFeatureValuesMap) {
        List workProducts = (List)Providers.getConfigurationApplicator().getReference((VariabilityElement)taskDescriptor.getTask(), taskFeature, config);
        ArrayList list = new ArrayList();
        ProcessUtil.createWorkProductDescriptors(workProducts, list, activity, wpDescriptors, wpdToDeliverablePartsMap, wpdToDeliverableDescriptorMap, descriptorsToRefresh);
        if (!list.isEmpty()) {
            ProcessUtil.addFeatureValues(descriptorToNewFeatureValuesMap, (EObject)taskDescriptor, taskDescriptorFeature, list);
        }
    }

    static void createWorkProductDescriptors(List workProducts, List featureValue, Activity activity, List wpDescriptors, Map wpdToDeliverablePartsMap, Map wpdToDeliverableDescriptorMap, Set descriptorsToRefresh) {
        if (workProducts != null) {
            MethodConfiguration config = TngUtil.getOwningProcess((BreakdownElement)activity).getDefaultContext();
            boolean wasEmpty = featureValue.isEmpty();
            int j = 0;
            while (j < workProducts.size()) {
                WorkProduct wpObj = (WorkProduct)workProducts.get(j);
                if (wpObj != null) {
                    WorkProductDescriptor wpDesc;
                    if (TngUtil.isContributor((VariabilityElement)wpObj)) {
                        wpObj = (WorkProduct)TngUtil.getBase((VariabilityElement)wpObj);
                    }
                    if ((wpDesc = (WorkProductDescriptor)ProcessUtil.getDescriptor((Object)wpObj, activity)) == null && (wpDesc = (WorkProductDescriptor)ProcessUtil.getInheritedDescriptor(wpObj, activity)) == null) {
                        wpDesc = (WorkProductDescriptor)ProcessUtil.getDescriptor((Object)wpObj, wpDescriptors);
                        if (wpDesc == null) {
                            wpDesc = ProcessUtil.createWorkProductDescriptor(wpObj, config, wpdToDeliverablePartsMap);
                            wpDescriptors.add(wpDesc);
                            WorkProductDescriptor descriptor = UserInteractionHelper.getDeliverable(activity, wpObj);
                            if (descriptor != null) {
                                wpdToDeliverableDescriptorMap.put(wpDesc, descriptor);
                            }
                        } else {
                            if (descriptorsToRefresh != null) {
                                descriptorsToRefresh.add(wpDesc);
                            }
                            if (wpObj instanceof Deliverable && wpdToDeliverablePartsMap != null) {
                                ProcessUtil.createDeliverableParts(wpDesc, (Deliverable)wpObj, config, wpdToDeliverablePartsMap);
                            }
                        }
                    }
                    if (wasEmpty || !featureValue.contains(wpDesc)) {
                        featureValue.add(wpDesc);
                    }
                }
                ++j;
            }
        }
    }

    public static Object getInheritedDescriptor(Object obj, Activity activity) {
        ArrayList brElements = new ArrayList();
        while (!activity.getVariabilityType().equals(VariabilityType.NA_LITERAL)) {
            VariabilityElement element = activity.getVariabilityBasedOnElement();
            if (!(element instanceof Activity)) continue;
            Activity baseActivity = (Activity)element;
            brElements.addAll(baseActivity.getBreakdownElements());
            activity = baseActivity;
        }
        return ProcessUtil.getDescriptor(obj, brElements);
    }

    public static Object getDescriptor(Object obj, Activity activity) {
        return ProcessUtil.getDescriptor(obj, activity.getBreakdownElements());
    }

    public static Object getDescriptor(Object obj, List descriptorList) {
        int j = 0;
        while (j < descriptorList.size()) {
            Object object = descriptorList.get(j);
            Task elementObj = null;
            if (object instanceof TaskDescriptor) {
                elementObj = ((TaskDescriptor)object).getTask();
            } else if (object instanceof WorkProductDescriptor) {
                elementObj = ((WorkProductDescriptor)object).getWorkProduct();
            } else if (object instanceof RoleDescriptor) {
                elementObj = ((RoleDescriptor)object).getRole();
            }
            if (obj.equals(elementObj)) {
                return object;
            }
            ++j;
        }
        return null;
    }

    public static MethodElement getAssociatedElement(Descriptor descriptor) {
        if (descriptor instanceof RoleDescriptor) {
            return ((RoleDescriptor)descriptor).getRole();
        }
        if (descriptor instanceof TaskDescriptor) {
            return ((TaskDescriptor)descriptor).getTask();
        }
        if (descriptor instanceof WorkProductDescriptor) {
            return ((WorkProductDescriptor)descriptor).getWorkProduct();
        }
        return null;
    }

    public static Collection getAllChildren(ProcessContribution procContrib, Collection ownChildren, AdapterFactory adapterFactory) {
        Process baseProc = procContrib.getBaseProcess();
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.emf.edit.provider.ITreeItemContentProvider");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        BSActivityItemProvider adapter = (BSActivityItemProvider)adapterFactory.adapt((Notifier)baseProc, (Object)clazz);
        adapter.setTopItem(baseProc);
        List allChildren = adapter.wrap((Activity)procContrib, adapter.getChildren(baseProc));
        Iterator iter = ownChildren.iterator();
        while (iter.hasNext()) {
            TngUtil.addTo(allChildren, (BreakdownElement)iter.next(), procContrib, adapterFactory);
        }
        return allChildren;
    }

    public static void disposeWrappers(Collection children) {
        if (children == null) {
            return;
        }
        Iterator iter = children.iterator();
        while (iter.hasNext()) {
            Object element = iter.next();
            if (!(element instanceof IWrapperItemProvider)) continue;
            ((IWrapperItemProvider)element).dispose();
        }
    }

    public static List getTasksForWorkProduct(WorkProduct wp, MethodConfiguration config) {
        ArrayList<Task> tasks = new ArrayList<Task>();
        List models = MethodElementUtil.getAllModels(wp);
        if (config != null) {
            Iterator iter = models.iterator();
            while (iter.hasNext()) {
                Object plugin = iter.next();
                if (config.getMethodPluginSelection().contains(plugin)) continue;
                iter.remove();
            }
        }
        IConfigurationApplicator configApplicator = Providers.getConfigurationApplicator();
        Iterator iter = models.iterator();
        while (iter.hasNext()) {
            MethodPlugin plugin = (MethodPlugin)iter.next();
            List allTasks = ProcessUtil.getAllTasks(plugin);
            Iterator iterator = allTasks.iterator();
            while (iterator.hasNext()) {
                Task task = (Task)iterator.next();
                List outputWorkProducts = (List)configApplicator.getReference((VariabilityElement)task, UmaPackage.eINSTANCE.getTask_Output(), config);
                if (!outputWorkProducts.contains(wp) || tasks.contains(task)) continue;
                tasks.add(task);
            }
        }
        return tasks;
    }

    public static List getWorkProductsForRole(Role role, MethodConfiguration config) {
        ArrayList<WorkProduct> wps = new ArrayList<WorkProduct>();
        List models = MethodElementUtil.getAllModels(role);
        if (config != null) {
            Iterator iter = models.iterator();
            while (iter.hasNext()) {
                Object plugin = iter.next();
                if (config.getMethodPluginSelection().contains(plugin)) continue;
                iter.remove();
            }
        }
        IConfigurationApplicator configApplicator = Providers.getConfigurationApplicator();
        Iterator iter = models.iterator();
        while (iter.hasNext()) {
            MethodPlugin plugin = (MethodPlugin)iter.next();
            List allWorkProducts = ProcessUtil.getAllWorkProducts(plugin);
            Iterator iterator = allWorkProducts.iterator();
            while (iterator.hasNext()) {
                WorkProduct wp = (WorkProduct)iterator.next();
                List responsibleWorkProducts = (List)configApplicator.getReference((VariabilityElement)role, UmaPackage.eINSTANCE.getRole_ResponsibleFor(), config);
                if (!responsibleWorkProducts.contains(wp) || wps.contains(wp)) continue;
                wps.add(wp);
            }
        }
        return wps;
    }

    public static List getAllWorkProducts(MethodPlugin plugin) {
        ContentPackage coreContentPkg = UmaUtil.findContentPackage((MethodPlugin)plugin, (String[])ModelStructure.DEFAULT.coreContentPath);
        AbstractTreeIterator iter = new AbstractTreeIterator(coreContentPkg, false){
            private static final long serialVersionUID = 3833752066324837937L;

            protected Iterator getChildren(Object object) {
                Object element;
                if (!(object instanceof ContentPackage)) {
                    return Collections.EMPTY_LIST.iterator();
                }
                ContentPackage pkg = (ContentPackage)object;
                ArrayList children = new ArrayList();
                Iterator iterator = pkg.getChildPackages().iterator();
                while (iterator.hasNext()) {
                    element = iterator.next();
                    if (!(element instanceof ContentPackage)) continue;
                    children.add(element);
                }
                iterator = pkg.getContentElements().iterator();
                while (iterator.hasNext()) {
                    element = iterator.next();
                    if (!(element instanceof WorkProduct) || TngUtil.isContributor((VariabilityElement)element)) continue;
                    children.add(element);
                }
                return children.iterator();
            }
        };
        ArrayList methodElements = new ArrayList();
        while (iter.hasNext()) {
            Object e = iter.next();
            if (!(e instanceof WorkProduct)) continue;
            methodElements.add(e);
        }
        return methodElements;
    }

    public static List getAllTasks(MethodPlugin plugin) {
        ContentPackage coreContentPkg = UmaUtil.findContentPackage((MethodPlugin)plugin, (String[])ModelStructure.DEFAULT.coreContentPath);
        AbstractTreeIterator iter = new AbstractTreeIterator(coreContentPkg, false){
            private static final long serialVersionUID = 3833752066324837937L;

            protected Iterator getChildren(Object object) {
                Object element;
                if (!(object instanceof ContentPackage)) {
                    return Collections.EMPTY_LIST.iterator();
                }
                ContentPackage pkg = (ContentPackage)object;
                ArrayList children = new ArrayList();
                Iterator iterator = pkg.getChildPackages().iterator();
                while (iterator.hasNext()) {
                    element = iterator.next();
                    if (!(element instanceof ContentPackage)) continue;
                    children.add(element);
                }
                iterator = pkg.getContentElements().iterator();
                while (iterator.hasNext()) {
                    element = iterator.next();
                    if (!(element instanceof Task) || TngUtil.isContributor((VariabilityElement)element)) continue;
                    children.add(element);
                }
                return children.iterator();
            }
        };
        ArrayList tasks = new ArrayList();
        while (iter.hasNext()) {
            Object e = iter.next();
            if (!(e instanceof Task)) continue;
            tasks.add(e);
        }
        return tasks;
    }

    public static boolean isExtendingOrContributing(BreakdownElement e) {
        return TngUtil.isGeneralizer(e, ProcessUtil.getExtendAndContributeVariabilityTypes());
    }

    public static String getPresentationName(BreakdownElement e) {
        if ((e.getPresentationName() == null || e.getPresentationName().length() == 0) && ProcessUtil.isExtendingOrContributing(e)) {
            BreakdownElement base = (BreakdownElement)((VariabilityElement)e).getVariabilityBasedOnElement();
            return ProcessUtil.getPresentationName(base);
        }
        return e.getPresentationName();
    }

    public static String getLabelWithPath(BreakdownElement e) {
        StringBuffer path = new StringBuffer(e.getName());
        Process proc = TngUtil.getOwningProcess(e);
        if (proc != null) {
            path.append(", ");
            MethodPlugin plugin = UmaUtil.getMethodPlugin((EObject)proc);
            if (plugin != null) {
                path.append(plugin.getName());
            }
            if (e != proc) {
                path.append('/').append(proc.getName());
            }
        }
        return path.toString();
    }

    public static void getModelInfo(BreakdownElement e, Object adapter, StringBuffer modelInfo) {
        if (e instanceof VariabilityElement) {
            VariabilityElement ve = (VariabilityElement)e;
            VariabilityElement base = ve.getVariabilityBasedOnElement();
            if (base != null) {
                VariabilityType type = ve.getVariabilityType();
                if (modelInfo.length() > 0) {
                    modelInfo.append("; ");
                }
                String pattern = null;
                if (type == VariabilityType.CONTRIBUTES_LITERAL) {
                    pattern = LibraryEditResources.getString("LibraryEdit.util.ProcessUtil.contributesto");
                } else if (type == VariabilityType.EXTENDS_LITERAL) {
                    pattern = LibraryEditResources.getString("LibraryEdit.process.extends");
                } else if (type == VariabilityType.REPLACES_LITERAL) {
                    pattern = LibraryEditResources.getString("LibraryEdit.process.replaces");
                }
                if (pattern != null) {
                    String path = ProcessUtil.getLabelWithPath((BreakdownElement)base);
                    modelInfo.append(MessageFormat.format(pattern, path));
                    ProcessUtil.getModelInfo((BreakdownElement)base, adapter, modelInfo);
                }
            }
        } else if (adapter instanceof BreakdownElementWrapperItemProvider) {
            BreakdownElementWrapperItemProvider wrapper = (BreakdownElementWrapperItemProvider)adapter;
            wrapper.getOwner();
            if (wrapper.getFeature() != null) {
                modelInfo.append(TngUtil.getFeatureText(wrapper.getFeature()));
            } else if (wrapper instanceof WorkProductDescriptorWrapperItemProvider) {
                ProcessUtil.getModelInfoForWorkProductDescriptor(modelInfo, (WorkProductDescriptor)TngUtil.unwrap(wrapper));
            }
        }
    }

    public static String getAttribute(Object object, String property, Object adapter) {
        WorkProductDescriptor wpd;
        BreakdownElement e = (BreakdownElement)TngUtil.unwrap(object);
        if (property == "id") {
            if (e instanceof WorkBreakdownElement && adapter instanceof IBSItemProvider) {
                return String.valueOf(((IBSItemProvider)adapter).getId());
            }
        } else if (property == "name") {
            if (adapter instanceof IItemLabelProvider) {
                return ((IItemLabelProvider)adapter).getText((Object)e);
            }
        } else {
            if (property == "presentation_name") {
                return ProcessUtil.getPresentationName(e);
            }
            if (property == "predecessors") {
                if (adapter instanceof IBSItemProvider) {
                    return ((IBSItemProvider)adapter).getPredecessors().toString();
                }
            } else if (property == "is_event_driven") {
                if (e instanceof WorkBreakdownElement) {
                    return String.valueOf(((WorkBreakdownElement)e).getIsEventDriven());
                }
            } else if (property == "is_ongoing") {
                if (e instanceof WorkBreakdownElement) {
                    return String.valueOf(((WorkBreakdownElement)e).getIsOngoing());
                }
            } else if (property == "is_repeatable") {
                if (e instanceof WorkBreakdownElement) {
                    return String.valueOf(((WorkBreakdownElement)e).getIsRepeatable());
                }
            } else {
                if (property == "prefix") {
                    return e.getPrefix();
                }
                if (property == "model_info") {
                    StringBuffer modelInfo = new StringBuffer();
                    ProcessUtil.getModelInfo(e, adapter, modelInfo);
                    return modelInfo.toString();
                }
                if (property == "type") {
                    WorkProduct wp;
                    String typeName = null;
                    if (object instanceof WorkProductDescriptor && (wp = ((WorkProductDescriptor)object).getWorkProduct()) != null) {
                        typeName = String.valueOf(wp.eClass().getName()) + "Descriptor";
                    }
                    if (typeName == null && object instanceof EObject) {
                        typeName = ((EObject)object).eClass().getName();
                    }
                    if (typeName != null) {
                        return UmaEditPlugin.INSTANCE.getString("_UI_" + typeName + "_type");
                    }
                } else if (property == "teams") {
                    if (e instanceof RoleDescriptor) {
                        return ProcessUtil.getTeams((RoleDescriptor)e);
                    }
                    if (e instanceof TeamProfile) {
                        return TngUtil.getPresentationName(((TeamProfile)e).getSuperTeam());
                    }
                }
            }
        }
        if (property == "entry_state") {
            if (object instanceof WorkProductDescriptor) {
                wpd = (WorkProductDescriptor)object;
                return TngUtil.checkNull(wpd.getActivityEntryState());
            }
        } else if (property == "exit_state") {
            if (object instanceof WorkProductDescriptor) {
                wpd = (WorkProductDescriptor)object;
                return TngUtil.checkNull(wpd.getActivityExitState());
            }
        } else if (property == "deliverable") {
            if (object instanceof WorkProductDescriptor) {
                List deliverables = AssociationHelper.getDeliverableDescriptors((WorkProductDescriptor)((WorkProductDescriptor)object));
                if (deliverables.isEmpty()) {
                    return "";
                }
                StringBuffer strBuf = new StringBuffer();
                int max = deliverables.size() - 1;
                int i = 0;
                while (i < max) {
                    strBuf.append(TngUtil.getPresentationName(deliverables.get(i))).append(',');
                    ++i;
                }
                strBuf.append(TngUtil.getPresentationName(deliverables.get(max)));
                return strBuf.toString();
            }
        } else {
            if (property == "is_optional") {
                return String.valueOf(e.getIsOptional());
            }
            if (property == "is_planned") {
                return String.valueOf(e.getIsPlanned());
            }
            if (property == "has_multiple_occurrences") {
                return String.valueOf(e.getHasMultipleOccurrences());
            }
        }
        return "";
    }

    private static String getTeams(RoleDescriptor roleDescriptor) {
        List teamProfiles = AssociationHelper.getTeamProfiles((RoleDescriptor)roleDescriptor);
        if (teamProfiles.isEmpty()) {
            return "";
        }
        StringBuffer strBuf = new StringBuffer();
        int max = teamProfiles.size() - 1;
        int i = 0;
        while (i < max) {
            strBuf.append(TngUtil.getPresentationName(teamProfiles.get(i))).append(',');
            ++i;
        }
        strBuf.append(TngUtil.getPresentationName(teamProfiles.get(max)));
        return strBuf.toString();
    }

    public static void setAttribute(WorkBreakdownElement e, String prop, String txt) {
        if (prop == "name") {
            e.setName(txt);
        } else if (prop == "prefix") {
            e.setPrefix(txt);
        } else if (prop == "is_event_driven") {
            e.setIsEventDriven(Boolean.valueOf(txt));
        } else if (prop == "is_ongoing") {
            e.setIsOngoing(Boolean.valueOf(txt));
        } else if (prop == "is_repeatable") {
            e.setIsRepeatable(Boolean.valueOf(txt));
        }
    }

    public static void setAttribute(IActionManager actionMgr, BreakdownElement e, String prop, String txt) {
        if (prop == "name") {
            actionMgr.doAction(1, (EObject)e, (EStructuralFeature)UmaPackage.eINSTANCE.getNamedElement_Name(), txt, -1);
        } else if (prop == "prefix") {
            actionMgr.doAction(1, (EObject)e, (EStructuralFeature)UmaPackage.eINSTANCE.getBreakdownElement_Prefix(), txt, -1);
        } else if (prop == "is_event_driven") {
            actionMgr.doAction(1, (EObject)e, (EStructuralFeature)UmaPackage.eINSTANCE.getWorkBreakdownElement_IsEventDriven(), Boolean.valueOf(txt), -1);
        } else if (prop == "is_ongoing") {
            actionMgr.doAction(1, (EObject)e, (EStructuralFeature)UmaPackage.eINSTANCE.getWorkBreakdownElement_IsOngoing(), Boolean.valueOf(txt), -1);
        } else if (prop == "is_repeatable") {
            actionMgr.doAction(1, (EObject)e, (EStructuralFeature)UmaPackage.eINSTANCE.getWorkBreakdownElement_IsRepeatable(), Boolean.valueOf(txt), -1);
        } else if (prop == "presentation_name") {
            actionMgr.doAction(1, (EObject)e, (EStructuralFeature)UmaPackage.eINSTANCE.getDescribableElement_PresentationName(), txt, -1);
        } else if (prop == "is_optional") {
            actionMgr.doAction(1, (EObject)e, (EStructuralFeature)UmaPackage.eINSTANCE.getBreakdownElement_IsOptional(), Boolean.valueOf(txt), -1);
        } else if (prop == "is_planned") {
            actionMgr.doAction(1, (EObject)e, (EStructuralFeature)UmaPackage.eINSTANCE.getBreakdownElement_IsPlanned(), Boolean.valueOf(txt), -1);
        } else if (prop == "has_multiple_occurrences") {
            actionMgr.doAction(1, (EObject)e, (EStructuralFeature)UmaPackage.eINSTANCE.getBreakdownElement_HasMultipleOccurrences(), Boolean.valueOf(txt), -1);
        } else if (e instanceof WorkProductDescriptor) {
            if (prop == "entry_state") {
                actionMgr.doAction(1, (EObject)e, (EStructuralFeature)UmaPackage.eINSTANCE.getWorkProductDescriptor_ActivityEntryState(), txt, -1);
            } else if (prop == "exit_state") {
                actionMgr.doAction(1, (EObject)e, (EStructuralFeature)UmaPackage.eINSTANCE.getWorkProductDescriptor_ActivityExitState(), txt, -1);
            }
        }
    }

    public static Activity generalize(Activity base, VariabilityType type) {
        Activity act = UmaFactory.eINSTANCE.createActivity();
        act.setName(base.getName());
        if (type == VariabilityType.REPLACES_LITERAL) {
            String presentationName = base.getPresentationName();
            act.setPresentationName(StrUtil.isBlank((String)presentationName) ? base.getName() : presentationName);
        }
        act.setVariabilityBasedOnElement((VariabilityElement)base);
        act.setVariabilityType(type);
        if (type == VariabilityType.EXTENDS_LITERAL) {
            Iterator iter = base.eClass().getEAllAttributes().iterator();
            while (iter.hasNext()) {
                EAttribute attribute = (EAttribute)iter.next();
                Class clazz = attribute.getEAttributeType().getInstanceClass();
                Class<?> clazz2 = class$2;
                if (clazz2 == null) {
                    try {
                        clazz2 = Class.forName("java.lang.Boolean");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (clazz != clazz2) continue;
                act.eSet((EStructuralFeature)attribute, base.eGet((EStructuralFeature)attribute));
            }
        }
        ArrayList<MethodElement> workOrders = new ArrayList<MethodElement>();
        Iterator iter = new ArrayList(base.getLinkToPredecessor()).iterator();
        while (iter.hasNext()) {
            workOrders.add(TngUtil.copy((MethodElement)((WorkOrder)iter.next())));
        }
        act.getLinkToPredecessor().addAll(workOrders);
        return act;
    }

    public static List getElementsInScope(AdapterFactory adapterFactory, BreakdownElement element, Class type, List items) {
        Object currentParent;
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.emf.edit.provider.ITreeItemContentProvider");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ITreeItemContentProvider itemProvider = (ITreeItemContentProvider)adapterFactory.adapt((Notifier)element, (Object)clazz);
        if (element instanceof Activity) {
            List children = ((Activity)element).getBreakdownElements();
            Iterator itor = children.iterator();
            while (itor.hasNext()) {
                Object obj = itor.next();
                if (!type.isInstance(obj) || items.contains(obj)) continue;
                items.add(obj);
            }
        }
        if ((currentParent = itemProvider.getParent((Object)element)) != null) {
            ProcessUtil.getElementsInScope(adapterFactory, (BreakdownElement)currentParent, type, items);
        }
        return items;
    }

    public static List getRoles(List roleDescList) {
        ArrayList<Role> roleList = new ArrayList<Role>();
        if (roleDescList != null) {
            Iterator itor = roleDescList.iterator();
            while (itor.hasNext()) {
                Object obj = itor.next();
                if (!(obj instanceof RoleDescriptor)) continue;
                Role role = ((RoleDescriptor)obj).getRole();
                roleList.add(role);
            }
        }
        return roleList;
    }

    public static List getAssociatedElementList(List descriptorList) {
        ArrayList<MethodElement> elementList = new ArrayList<MethodElement>();
        if (descriptorList != null) {
            Iterator itor = descriptorList.iterator();
            while (itor.hasNext()) {
                Object obj = itor.next();
                if (!(obj instanceof Descriptor)) continue;
                MethodElement element = ProcessUtil.getAssociatedElement((Descriptor)obj);
                elementList.add(element);
            }
        }
        return elementList;
    }

    public static BreakdownElement getTopBreakdownElement(ProcessComponent pc) {
        Adapter adapter;
        Process be = pc.getProcess();
        if (be == null) {
            return null;
        }
        ComposedAdapterFactory composedAdapterFactory = TngAdapterFactory.INSTANCE.getWBS_ComposedAdapterFactory();
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.emf.edit.provider.ITreeItemContentProvider");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (!((adapter = composedAdapterFactory.adapt((Notifier)be, (Object)clazz)) instanceof IBSItemProvider)) {
            return be;
        }
        IBSItemProvider itemProvider = (IBSItemProvider)adapter;
        if (itemProvider.getTopItem() == null) {
            itemProvider.setTopItem(be);
            ComposedAdapterFactory composedAdapterFactory2 = TngAdapterFactory.INSTANCE.getOBS_ComposedAdapterFactory();
            Class<?> clazz2 = class$1;
            if (clazz2 == null) {
                try {
                    clazz2 = class$1 = Class.forName("org.eclipse.emf.edit.provider.ITreeItemContentProvider");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            itemProvider = (IBSItemProvider)composedAdapterFactory2.adapt((Notifier)be, (Object)clazz2);
            itemProvider.setTopItem(be);
            ComposedAdapterFactory composedAdapterFactory3 = TngAdapterFactory.INSTANCE.getPBS_ComposedAdapterFactory();
            Class<?> clazz3 = class$1;
            if (clazz3 == null) {
                try {
                    clazz3 = class$1 = Class.forName("org.eclipse.emf.edit.provider.ITreeItemContentProvider");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            itemProvider = (IBSItemProvider)composedAdapterFactory3.adapt((Notifier)be, (Object)clazz3);
            itemProvider.setTopItem(be);
            ComposedAdapterFactory composedAdapterFactory4 = TngAdapterFactory.INSTANCE.getProcessComposedAdapterFactory();
            Class<?> clazz4 = class$1;
            if (clazz4 == null) {
                try {
                    clazz4 = class$1 = Class.forName("org.eclipse.emf.edit.provider.ITreeItemContentProvider");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            itemProvider = (IBSItemProvider)composedAdapterFactory4.adapt((Notifier)be, (Object)clazz4);
            itemProvider.setTopItem(be);
        }
        ProcessUtil.updateIDs((EObject)be, (Object)be);
        return be;
    }

    private static void updateIDs(EObject topAct, Object newObj) {
        AdapterFactoryTreeIterator iter;
        Process proc;
        boolean updateWholeProcess;
        ComposedAdapterFactory composedAdapterFactory = TngAdapterFactory.INSTANCE.getWBS_ComposedAdapterFactory();
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.emf.edit.provider.ITreeItemContentProvider");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ItemProviderAdapter adapter = (ItemProviderAdapter)composedAdapterFactory.adapt((Notifier)topAct, (Object)clazz);
        AdapterFactory factory = TngUtil.getBestAdapterFactory(adapter.getAdapterFactory());
        boolean bl = updateWholeProcess = topAct == newObj && topAct instanceof Process;
        if (updateWholeProcess) {
            proc = (Process)topAct;
            ProcessUtil.updateIDs(factory, proc);
            ProcessUtil.refreshViewer(factory, proc);
        } else {
            iter = new AdapterFactoryTreeIterator(factory, (Object)topAct);
            ProcessUtil.updateIDs(factory, iter, newObj);
        }
        ComposedAdapterFactory composedAdapterFactory2 = TngAdapterFactory.INSTANCE.getProcessComposedAdapterFactory();
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("org.eclipse.emf.edit.provider.ITreeItemContentProvider");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        adapter = (ItemProviderAdapter)composedAdapterFactory2.adapt((Notifier)topAct, (Object)clazz2);
        factory = TngUtil.getBestAdapterFactory(adapter.getAdapterFactory());
        if (updateWholeProcess) {
            proc = (Process)topAct;
            ProcessUtil.updateIDs(factory, proc);
            ProcessUtil.refreshViewer(factory, proc);
        } else {
            iter = new AdapterFactoryTreeIterator(factory, (Object)topAct);
            ProcessUtil.updateIDs(factory, iter, newObj);
        }
    }

    public static void updateIDs(AdapterFactory factory, AdapterFactoryTreeIterator iter, Object newObj) {
        Object obj;
        int id = 0;
        HashMap<Object, IBSItemProvider> changeMap = new HashMap<Object, IBSItemProvider>();
        while (iter.hasNext()) {
            obj = iter.next();
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = Class.forName("org.eclipse.emf.edit.provider.ITreeItemContentProvider");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            IBSItemProvider itemProvider = (IBSItemProvider)factory.adapt(obj, (Object)clazz);
            itemProvider.setId(id++);
            changeMap.put(obj, itemProvider);
        }
        Iterator iterator = changeMap.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            IChangeNotifier adapter = (IChangeNotifier)entry.getValue();
            obj = entry.getKey();
            adapter.fireNotifyChanged((Notification)new ViewerNotification((Notification)new NotificationImpl(1, obj, obj), obj, false, true));
        }
    }

    public static boolean checkDescriptorReferences(Descriptor descriptor, Descriptor obj) {
        Set<Descriptor> descriptors = descriptor != null ? Collections.singleton(descriptor) : Collections.EMPTY_SET;
        return ProcessUtil.checkDescriptorReferences(descriptors, obj);
    }

    public static boolean checkDescriptorReferences(Collection descriptors, Descriptor obj) {
        boolean referencesExists;
        block4: {
            block6: {
                block5: {
                    referencesExists = false;
                    if (!(obj instanceof RoleDescriptor)) break block5;
                    RoleDescriptor refObject = (RoleDescriptor)obj;
                    ArrayList list = new ArrayList();
                    list.addAll(refObject.getAssistsIn());
                    list.addAll(refObject.getResponsibleFor());
                    list.addAll(refObject.getPerformsAdditionally());
                    list.addAll(refObject.getPerformsAsOwner());
                    list.addAll(AssociationHelper.getTeamProfiles((RoleDescriptor)refObject));
                    Iterator refItor = list.iterator();
                    while (refItor.hasNext()) {
                        Object refItorObject = refItor.next();
                        if ((!(refItorObject instanceof Descriptor) || descriptors.contains(refItorObject)) && !(refItorObject instanceof TeamProfile)) continue;
                        referencesExists = true;
                        break block4;
                    }
                    break block4;
                }
                if (!(obj instanceof WorkProductDescriptor)) break block6;
                WorkProductDescriptor refObject = (WorkProductDescriptor)obj;
                ArrayList<RoleDescriptor> list = new ArrayList<RoleDescriptor>();
                list.addAll(refObject.getExternalInputTo());
                list.addAll(refObject.getImpactedBy());
                list.addAll(refObject.getImpacts());
                list.addAll(refObject.getMandatoryInputTo());
                list.addAll(refObject.getOptionalInputTo());
                list.addAll(refObject.getOutputFrom());
                list.add(refObject.getResponsibleRole());
                list.addAll(refObject.getDeliverableParts());
                Iterator refItor = list.iterator();
                while (refItor.hasNext()) {
                    Object refItorObject = refItor.next();
                    if (!(refItorObject instanceof Descriptor) || descriptors.contains(refItorObject)) continue;
                    referencesExists = true;
                    break;
                }
                if (!(refObject.getWorkProduct() instanceof Artifact)) break block4;
                List containedArtifacts = ((Artifact)refObject.getWorkProduct()).getContainedArtifacts();
                Artifact containerArtifact = ((Artifact)refObject.getWorkProduct()).getContainerArtifact();
                if (containedArtifacts.isEmpty() && containerArtifact == null) break block4;
                referencesExists = true;
                break block4;
            }
            if (obj instanceof TaskDescriptor) {
                TaskDescriptor refObject = (TaskDescriptor)obj;
                ArrayList<RoleDescriptor> list = new ArrayList<RoleDescriptor>();
                list.addAll(refObject.getAdditionallyPerformedBy());
                list.addAll(refObject.getAssistedBy());
                list.addAll(refObject.getExternalInput());
                list.addAll(refObject.getMandatoryInput());
                list.addAll(refObject.getOptionalInput());
                list.addAll(refObject.getOutput());
                list.add(refObject.getPerformedPrimarilyBy());
                Iterator refItor = list.iterator();
                while (refItor.hasNext()) {
                    Object refItorObject = refItor.next();
                    if (!(refItorObject instanceof Descriptor) || descriptors.contains(refItorObject)) continue;
                    referencesExists = true;
                    break;
                }
            }
        }
        return referencesExists;
    }

    public static CompositeRole createCompositeRole(CompositeRole obj) {
        CompositeRole compRole = UmaFactory.eINSTANCE.createCompositeRole();
        compRole.getAggregatedRoles().addAll(obj.getAggregatedRoles());
        String presentationName = obj.getPresentationName();
        compRole.setName(obj.getName());
        compRole.setPresentationName(StrUtil.isBlank((String)presentationName) ? obj.getName() : presentationName);
        return compRole;
    }

    public static void addTaskToActivity(Task task, Activity act) {
        WBSDropCommand cmd = new WBSDropCommand(act, Collections.singletonList(task));
        BSDropCommand.IExecutor executor = cmd.getExecutor();
        if (executor.preExecute()) {
            executor.doExcecute();
        }
    }

    public static boolean hasProcessNotOfType(ProcessPackage pkg, EClass processType) {
        Process proc;
        if (pkg instanceof ProcessComponent && (proc = ((ProcessComponent)pkg).getProcess()) != null && !processType.isInstance((Object)proc)) {
            return true;
        }
        Iterator iterator = pkg.getChildPackages().iterator();
        while (iterator.hasNext()) {
            Process proc2;
            Object childPkg = iterator.next();
            if (!(childPkg instanceof ProcessComponent ? (proc2 = ((ProcessComponent)childPkg).getProcess()) != null && !processType.isInstance((Object)proc2) : childPkg instanceof ProcessPackage && ProcessUtil.hasProcessNotOfType((ProcessPackage)childPkg, processType))) continue;
            return true;
        }
        return false;
    }

    public static Object findRoleDescriptor(TeamProfile team, RoleDescriptor roleDesc) {
        List teamRoles = team.getTeamRoles();
        Iterator itor = teamRoles.iterator();
        while (itor.hasNext()) {
            Role itorObjRole;
            Role objRole;
            List secondObjectAggRoles;
            List firstObjectAggRoles;
            Object itorObject = itor.next();
            if (!(roleDesc instanceof CompositeRole ? itorObject instanceof CompositeRole && (firstObjectAggRoles = ((CompositeRole)roleDesc).getAggregatedRoles()).equals(secondObjectAggRoles = ((CompositeRole)itorObject).getAggregatedRoles()) : roleDesc instanceof RoleDescriptor && itorObject instanceof RoleDescriptor && !(itorObject instanceof CompositeRole) && (objRole = roleDesc.getRole()).equals(itorObjRole = ((RoleDescriptor)itorObject).getRole()))) continue;
            return itorObject;
        }
        return null;
    }

    public static Map toColumnIndexToNameMap(String colNames) {
        HashMap<Integer, String> columnIndexToNameMap = new HashMap<Integer, String>();
        StringTokenizer tokens = new StringTokenizer(colNames, ",");
        int id = 0;
        while (tokens.hasMoreTokens()) {
            String token = tokens.nextToken();
            columnIndexToNameMap.put(new Integer(id), ProcessUtil.getColumnID(token));
            ++id;
        }
        return columnIndexToNameMap;
    }

    private static String getColumnID(String colName) {
        int i = 0;
        while (i < IBSItemProvider.COLUMNS.length) {
            String col = IBSItemProvider.COLUMNS[i];
            if (col.equals(colName)) {
                return col;
            }
            ++i;
        }
        return null;
    }

    public static List getVariabilityElement(Object owner) {
        ArrayList<MethodElement> baseElements = new ArrayList<MethodElement>();
        if (owner instanceof Activity) {
            Activity activity = (Activity)owner;
            while (!activity.getVariabilityType().equals(VariabilityType.NA_LITERAL)) {
                VariabilityElement element = activity.getVariabilityBasedOnElement();
                if (!(element instanceof Activity)) continue;
                Activity baseActivity = (Activity)element;
                List breakdownElements = baseActivity.getBreakdownElements();
                Iterator itor = breakdownElements.iterator();
                while (itor.hasNext()) {
                    MethodElement baseObj;
                    Object object = itor.next();
                    if (!(object instanceof Descriptor) || (baseObj = ProcessUtil.getAssociatedElement((Descriptor)object)) == null) continue;
                    baseElements.add(baseObj);
                }
                activity = baseActivity;
            }
        }
        return baseElements;
    }

    public static void removePredecessors(AdapterFactory factory, Process proc, List removedElements) {
        HashSet elements = new HashSet(removedElements);
        AdapterFactoryTreeIterator iter = new AdapterFactoryTreeIterator(factory, (Object)proc);
        while (iter.hasNext()) {
            IBSItemProvider itemProvider;
            Object obj = iter.next();
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = Class.forName("org.eclipse.emf.edit.provider.ITreeItemContentProvider");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((itemProvider = (IBSItemProvider)factory.adapt(obj, (Object)clazz)) == null || !(TngUtil.unwrap(obj) instanceof WorkBreakdownElement)) continue;
            Iterator iterator = itemProvider.getPredecessors().iterator();
            while (iterator.hasNext()) {
                Object e = TngUtil.unwrap(iterator.next());
                if (e instanceof ItemProviderAdapter) {
                    e = ((ItemProviderAdapter)e).getTarget();
                }
                if (!elements.contains(e)) continue;
                iterator.remove();
            }
        }
    }

    public static Activity contributeToActivity(BreakdownElementWrapperItemProvider adapter, AdapterFactory adapterFactory) {
        return ProcessUtil.contributeToActivity(adapter, new ArrayList());
    }

    public static Activity contributeToActivity(BreakdownElementWrapperItemProvider adapter, List createdActivities) {
        Object parent = adapter.getParent(null);
        BreakdownElement[] prevAndNext = ProcessUtil.getPreviousAndNext(adapter);
        if (parent instanceof BreakdownElementWrapperItemProvider) {
            parent = ProcessUtil.contributeToActivity((BreakdownElementWrapperItemProvider)parent, createdActivities);
        }
        Activity act = ProcessUtil.generialize(adapter, VariabilityType.CONTRIBUTES_LITERAL, prevAndNext);
        Activity parentAct = (Activity)parent;
        parentAct.getBreakdownElements().add(act);
        createdActivities.add(act);
        return act;
    }

    public static void replaceActivity(BreakdownElementWrapperItemProvider adapter, AdapterFactory adapterFactory) {
        ProcessUtil.replaceActivity(adapter, new ArrayList());
    }

    public static void replaceActivity(BreakdownElementWrapperItemProvider adapter, List createdActivities) {
        Object parent = adapter.getParent(null);
        BreakdownElement[] prevAndNext = ProcessUtil.getPreviousAndNext(adapter);
        if (parent instanceof BreakdownElementWrapperItemProvider) {
            parent = ProcessUtil.contributeToActivity((BreakdownElementWrapperItemProvider)parent, createdActivities);
        }
        Activity act = ProcessUtil.generialize(adapter, VariabilityType.REPLACES_LITERAL, prevAndNext);
        Activity parentAct = (Activity)parent;
        parentAct.getBreakdownElements().add(act);
        createdActivities.add(act);
    }

    static BreakdownElement[] getPreviousAndNext(BreakdownElementWrapperItemProvider adapter) {
        Object parent = adapter.getParent(null);
        AdapterFactory adapterFactory = TngUtil.getBestAdapterFactory(adapter.getAdapterFactory());
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.emf.edit.provider.ITreeItemContentProvider");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ITreeItemContentProvider itemProvider = (ITreeItemContentProvider)adapterFactory.adapt(parent, (Object)clazz);
        List children = (List)itemProvider.getChildren(parent);
        int id = children.indexOf(adapter) + 1;
        BreakdownElement next = null;
        if (id < children.size()) {
            next = (BreakdownElement)TngUtil.unwrap(children.get(id));
        }
        BreakdownElement prev = null;
        if ((id -= 2) > -1) {
            prev = (BreakdownElement)TngUtil.unwrap(children.get(id));
        }
        BreakdownElement[] prevAndNext = new BreakdownElement[]{prev, next};
        return prevAndNext;
    }

    static Activity generialize(BreakdownElementWrapperItemProvider adapter, VariabilityType type, BreakdownElement[] prevAndNext) {
        Class<?> clazz;
        AdapterFactory adapterFactory = TngUtil.getBestAdapterFactory(adapter.getAdapterFactory());
        Activity act = ProcessUtil.generalize((Activity)adapter.getValue(), type);
        act.setPresentedAfter(prevAndNext[1]);
        BreakdownElement prev = prevAndNext[0];
        if (prev != null) {
            prev.setPresentedAfter((BreakdownElement)act);
        }
        if ((clazz = class$1) == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.emf.edit.provider.ITreeItemContentProvider");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        IBSItemProvider bsItemProvider = (IBSItemProvider)adapterFactory.adapt((Notifier)act, (Object)clazz);
        bsItemProvider.setExpanded(adapter.isExpanded());
        return act;
    }

    public static Process getImmediateBaseProcess(BreakdownElementWrapperItemProvider itemProvider) {
        Activity inheritor = ProcessUtil.getInheritor(itemProvider);
        if (inheritor != null) {
            return TngUtil.getOwningProcess((BreakdownElement)inheritor.getVariabilityBasedOnElement());
        }
        return null;
    }

    public static Activity getInheritor(BreakdownElementWrapperItemProvider itemProvider) {
        if (itemProvider.isReadOnly()) {
            Object parent = itemProvider.getParent(itemProvider);
            while (parent != null) {
                if (parent instanceof BreakdownElementWrapperItemProvider) {
                    parent = ((BreakdownElementWrapperItemProvider)parent).getParent(parent);
                    continue;
                }
                return (Activity)parent;
            }
        }
        return null;
    }

    public static List getParentList(Object from, BreakdownElementWrapperItemProvider wrapper) {
        ArrayList<MethodElement> parentList = new ArrayList<MethodElement>();
        AdapterFactory adapterFactory = wrapper.getAdapterFactory();
        Object parent = wrapper.getParent(wrapper);
        while (parent != from && parent != null) {
            ItemProviderAdapter adapter;
            MethodElement e;
            Object obj = TngUtil.unwrap(parent);
            if (obj instanceof MethodElement) {
                e = (MethodElement)obj;
                if (parent instanceof ITreeItemContentProvider) {
                    adapter = (ITreeItemContentProvider)parent;
                } else {
                    Class<?> clazz = class$1;
                    if (clazz == null) {
                        try {
                            clazz = Class.forName("org.eclipse.emf.edit.provider.ITreeItemContentProvider");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    adapter = (ITreeItemContentProvider)adapterFactory.adapt(parent, (Object)clazz);
                }
                parent = adapter.getParent(parent);
            } else {
                adapter = (ItemProviderAdapter)obj;
                e = (MethodElement)adapter.getTarget();
                parent = adapter.getParent(parent);
            }
            parentList.add(0, e);
        }
        return parentList;
    }

    public static List getWrappers(BreakdownElementWrapperItemProvider wrapper) {
        List<Object> adapterFactories = Arrays.asList(TngAdapterFactory.INSTANCE.getWBS_ComposedAdapterFactory(), TngAdapterFactory.INSTANCE.getOBS_ComposedAdapterFactory(), TngAdapterFactory.INSTANCE.getPBS_ComposedAdapterFactory());
        AdapterFactory rootAdapterFactory = TngUtil.getBestAdapterFactory(wrapper.getAdapterFactory());
        int index = adapterFactories.indexOf(rootAdapterFactory);
        Object proc = wrapper.getTopItem();
        ArrayList<Object> wrappers = new ArrayList<Object>();
        Iterator<Object> iter = adapterFactories.iterator();
        while (iter.hasNext()) {
            AdapterFactory adapterFactory = (AdapterFactory)iter.next();
            if (adapterFactory == rootAdapterFactory) continue;
            ArrayList<Object> objects = new ArrayList<Object>(ProcessUtil.getParentList(proc, wrapper));
            Object e = TngUtil.unwrap(wrapper);
            objects.add(e);
            Object object = proc;
            Iterator iter1 = objects.iterator();
            block3: while (iter1.hasNext()) {
                Object element = iter1.next();
                Class<?> clazz = class$1;
                if (clazz == null) {
                    try {
                        clazz = Class.forName("org.eclipse.emf.edit.provider.ITreeItemContentProvider");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                ITreeItemContentProvider adapter = (ITreeItemContentProvider)adapterFactory.adapt(object, (Object)clazz);
                Iterator iterator = adapter.getChildren(object).iterator();
                while (iterator.hasNext()) {
                    Object child = iterator.next();
                    if (element != TngUtil.unwrap(child)) continue;
                    object = child;
                    continue block3;
                }
            }
            if (object instanceof BreakdownElementWrapperItemProvider) {
                wrappers.add(object);
                continue;
            }
            throw new RuntimeException("Could not find wrapper for " + e + " using adapter factory " + adapterFactory);
        }
        wrappers.add(index, wrapper);
        return wrappers;
    }

    public static void getModelInfoForWorkProductDescriptor(StringBuffer modelInfo, WorkProductDescriptor object) {
        String comma = ",";
        if (!object.getMandatoryInputTo().isEmpty()) {
            if (modelInfo.toString().length() > 0) {
                modelInfo.append(comma);
            }
            modelInfo.append(UmaEditPlugin.INSTANCE.getString("_UI_TaskDescriptor_mandatoryInput_feature"));
        }
        if (!object.getOptionalInputTo().isEmpty()) {
            if (modelInfo.toString().length() > 0) {
                modelInfo.append(comma);
            }
            modelInfo.append(UmaEditPlugin.INSTANCE.getString("_UI_TaskDescriptor_optionalInput_feature"));
        }
        if (!object.getOutputFrom().isEmpty()) {
            if (modelInfo.toString().length() > 0) {
                modelInfo.append(comma);
            }
            modelInfo.append(UmaEditPlugin.INSTANCE.getString("_UI_TaskDescriptor_output_feature"));
        }
    }
}

