/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.edit.util;

import com.ibm.uma.Activity;
import com.ibm.uma.BreakdownElement;
import com.ibm.uma.Constraint;
import com.ibm.uma.MethodConfiguration;
import com.ibm.uma.MethodElement;
import com.ibm.uma.Process;
import com.ibm.uma.RoleDescriptor;
import com.ibm.uma.TaskDescriptor;
import com.ibm.uma.TeamProfile;
import com.ibm.uma.VariabilityElement;
import com.ibm.uma.VariabilityType;
import com.ibm.uma.WorkBreakdownElement;
import com.ibm.uma.WorkProductDescriptor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;
import org.eclipse.emf.edit.provider.ItemProviderAdapter;
import org.eclipse.emf.edit.provider.WrapperItemProvider;
import org.eclipse.epf.library.edit.IConfigurator;
import org.eclipse.epf.library.edit.IFilter;
import org.eclipse.epf.library.edit.TngAdapterFactory;
import org.eclipse.epf.library.edit.process.BreakdownElementWrapperItemProvider;
import org.eclipse.epf.library.edit.util.ConfigurableComposedAdapterFactory;
import org.eclipse.epf.library.edit.util.ConstraintManager;
import org.eclipse.epf.library.edit.util.ProcessUtil;
import org.eclipse.epf.library.edit.util.TngUtil;

public class Suppression {
    private Process process;
    private Set suppressedExternalElementPaths;
    private boolean modified;
    private static final String WBS = "wbs";
    private static final String TBS = "tbs";
    private static final String WPBS = "wpbs";
    private static final String CBS = "cbs";
    private static final Map procToSuppressionMap = new HashMap();
    private static boolean autoInheritIntermediateSuppressedState = true;
    static /* synthetic */ Class class$0;

    public static final void clearCachedSuppressions() {
        procToSuppressionMap.clear();
    }

    public Suppression(Process process) {
        this.process = process;
        this.suppressedExternalElementPaths = this.loadSuppressedElementPaths();
    }

    public Process getProcess() {
        return this.process;
    }

    private Set loadSuppressedElementPaths() {
        Constraint rule = ConstraintManager.getConstraint((MethodElement)this.process, "", false);
        if (rule != null && rule.getBody().length() > 0) {
            HashSet<String> paths = new HashSet<String>();
            StringTokenizer tokens = new StringTokenizer(rule.getBody());
            while (tokens.hasMoreTokens()) {
                paths.add(tokens.nextToken());
            }
            return paths;
        }
        return null;
    }

    private Set getSuppressedExternalElementPaths() {
        if (this.suppressedExternalElementPaths == null) {
            this.suppressedExternalElementPaths = this.loadSuppressedElementPaths();
            if (this.suppressedExternalElementPaths == null) {
                this.suppressedExternalElementPaths = new HashSet();
            }
        }
        return this.suppressedExternalElementPaths;
    }

    public boolean hasSuppressed(Collection selection) {
        Iterator iter = selection.iterator();
        while (iter.hasNext()) {
            Object element = iter.next();
            if (!(element instanceof BreakdownElementWrapperItemProvider ? this.isSuppressed((BreakdownElementWrapperItemProvider)element) : element instanceof BreakdownElement && this.isSuppressed((BreakdownElement)element))) continue;
            return true;
        }
        return false;
    }

    public boolean canSuppress(Collection selection) {
        return this.canDo(selection, true);
    }

    public boolean canReveal(Collection selection) {
        return this.canDo(selection, false);
    }

    private boolean canDo(Collection selection, boolean suppressed) {
        Iterator iter = selection.iterator();
        while (iter.hasNext()) {
            Object e;
            BreakdownElementWrapperItemProvider wrapper;
            Object element = iter.next();
            if (!(element instanceof BreakdownElementWrapperItemProvider ? ((wrapper = (BreakdownElementWrapperItemProvider)element).isReadOnly() ? this.isInSuppressedList(wrapper) != suppressed : (e = TngUtil.unwrap(wrapper)) instanceof MethodElement && ((MethodElement)e).getSuppressed() != suppressed) : element instanceof MethodElement && ((MethodElement)element).getSuppressed() != suppressed)) continue;
            return true;
        }
        return false;
    }

    private boolean __isSuppressed(BreakdownElement e) {
        return Suppression.getSuppressed(e) != null;
    }

    private static boolean isDirectlySuppressed(MethodElement e) {
        VariabilityElement ve;
        VariabilityType variabilityType;
        Boolean b = e.getSuppressed();
        if (b != null && b.booleanValue()) {
            return true;
        }
        if (e instanceof VariabilityElement && ((variabilityType = (ve = (VariabilityElement)e).getVariabilityType()) == VariabilityType.EXTENDS_LITERAL || variabilityType == VariabilityType.CONTRIBUTES_LITERAL) && ve.getVariabilityBasedOnElement() != null) {
            return Suppression.isDirectlySuppressed((MethodElement)ve.getVariabilityBasedOnElement());
        }
        return false;
    }

    /*
     * Unable to fully structure code
     */
    private static BreakdownElement getSuppressed(BreakdownElement e) {
        if (!e.getSuppressed().booleanValue()) ** GOTO lbl5
        return e;
lbl-1000:
        // 1 sources

        {
            if (!(e = (BreakdownElement)e.getSuperActivities().get(0)).getSuppressed().booleanValue()) continue;
            return e;
lbl5:
            // 2 sources

            ** while (!e.getSuperActivities().isEmpty())
        }
lbl6:
        // 1 sources

        return null;
    }

    private boolean isInSuppressedList(BreakdownElementWrapperItemProvider wrapper) {
        if (this.suppressedExternalElementPaths == null) {
            return false;
        }
        String path = Suppression.getPath(wrapper);
        return this.suppressedExternalElementPaths.contains(path);
    }

    private BreakdownElement getSuppressed(BreakdownElementWrapperItemProvider wrapper) {
        return this.getSuppressed(wrapper, true);
    }

    private BreakdownElement getSuppressed(BreakdownElementWrapperItemProvider wrapper, boolean checkBase) {
        Activity inheritor;
        Process immediateBaseProc;
        Process proc;
        BreakdownElement suppressed;
        BreakdownElement suppressed2;
        BreakdownElement e = (BreakdownElement)TngUtil.unwrap(wrapper);
        if (!wrapper.isReadOnly()) {
            return Suppression.getSuppressed(e);
        }
        if (checkBase && (suppressed2 = Suppression.getSuppressed(e)) != null) {
            return suppressed2;
        }
        if (this.isInSuppressedList(wrapper)) {
            return e;
        }
        Object parent = wrapper.getParent(wrapper);
        if (parent instanceof BreakdownElement && (suppressed = Suppression.getSuppressed((BreakdownElement)parent)) != null) {
            return suppressed;
        }
        if (autoInheritIntermediateSuppressedState && (proc = TngUtil.getOwningProcess(e)) != (immediateBaseProc = TngUtil.getOwningProcess((BreakdownElement)(inheritor = ProcessUtil.getInheritor(wrapper)).getVariabilityBasedOnElement()))) {
            Suppression suppression;
            Object element;
            Object object = inheritor.getVariabilityBasedOnElement();
            ArrayList<BreakdownElement> objects = new ArrayList<BreakdownElement>(ProcessUtil.getParentList(inheritor, wrapper));
            objects.add(e);
            Iterator iter = objects.iterator();
            block2: while (iter.hasNext()) {
                element = iter.next();
                AdapterFactory adapterFactory = wrapper.getAdapterFactory();
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = Class.forName("org.eclipse.emf.edit.provider.ITreeItemContentProvider");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                ITreeItemContentProvider adapter = (ITreeItemContentProvider)adapterFactory.adapt(object, (Object)clazz);
                Iterator iterator = adapter.getChildren(object).iterator();
                while (iterator.hasNext()) {
                    Object child = iterator.next();
                    if (element != TngUtil.unwrap(child)) continue;
                    object = child;
                    continue block2;
                }
            }
            if (object instanceof BreakdownElementWrapperItemProvider && (element = (suppression = Suppression.getSuppression(immediateBaseProc)).getSuppressed((BreakdownElementWrapperItemProvider)object, false)) != null) {
                return element;
            }
        }
        if (parent instanceof BreakdownElementWrapperItemProvider) {
            return this.getSuppressed((BreakdownElementWrapperItemProvider)parent);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Suppression getSuppression(Process proc) {
        Suppression suppression = (Suppression)procToSuppressionMap.get(proc);
        if (suppression == null) {
            Map map = procToSuppressionMap;
            synchronized (map) {
                suppression = (Suppression)procToSuppressionMap.get(proc);
                if (suppression == null) {
                    suppression = new Suppression(proc);
                    procToSuppressionMap.put(proc, suppression);
                }
            }
        }
        return suppression;
    }

    private boolean __isSuppressed(BreakdownElementWrapperItemProvider wrapper) {
        return this.getSuppressed(wrapper) != null;
    }

    public void saveToModel() {
        if (this.suppressedExternalElementPaths == null) {
            return;
        }
        StringBuffer paths = new StringBuffer();
        Iterator iter = this.suppressedExternalElementPaths.iterator();
        while (iter.hasNext()) {
            String path = (String)iter.next();
            if (!this.isValid(path)) continue;
            paths.append(path).append(' ');
        }
        Constraint rule = ConstraintManager.getConstraint((MethodElement)this.process, "", true);
        rule.setBody(paths.toString());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean isValid(String path) {
        IConfigurator configurator;
        MethodConfiguration currentConfig;
        block22: {
            URI uri = URI.createURI((String)path);
            String type = uri.scheme();
            ConfigurableComposedAdapterFactory adapterFactory = null;
            if (WBS.equals(type)) {
                adapterFactory = (ConfigurableComposedAdapterFactory)TngAdapterFactory.INSTANCE.getWBS_ComposedAdapterFactory();
            } else if (TBS.equals(type)) {
                adapterFactory = (ConfigurableComposedAdapterFactory)TngAdapterFactory.INSTANCE.getOBS_ComposedAdapterFactory();
            } else if (WPBS.equals(type)) {
                adapterFactory = (ConfigurableComposedAdapterFactory)TngAdapterFactory.INSTANCE.getPBS_ComposedAdapterFactory();
            } else {
                if (!CBS.equals(type)) return false;
                adapterFactory = (ConfigurableComposedAdapterFactory)TngAdapterFactory.INSTANCE.getProcessComposedAdapterFactory();
            }
            currentConfig = null;
            configurator = null;
            IFilter filter = adapterFactory.getFilter();
            if (filter instanceof IConfigurator) {
                configurator = (IConfigurator)adapterFactory.getFilter();
                currentConfig = configurator.getMethodConfiguration();
                configurator.setMethodConfiguration(this.process.getDefaultContext());
            }
            try {
                String guid = uri.authority();
                if (!this.process.getGuid().equals(guid)) {
                    Object var16_9 = null;
                    if (configurator == null) return false;
                    configurator.setMethodConfiguration(currentConfig);
                    return false;
                }
                Object object = this.process;
                Class<?> clazz = class$0;
                if (clazz == null) {
                    Class<?> clazz2;
                    try {
                        clazz2 = Class.forName("org.eclipse.emf.edit.provider.ITreeItemContentProvider");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    clazz = class$0 = clazz2;
                }
                ITreeItemContentProvider adapter = (ITreeItemContentProvider)adapterFactory.adapt(object, (Object)clazz);
                int i = 0;
                while (true) {
                    if (i >= uri.segmentCount()) {
                        break block22;
                    }
                    guid = uri.segment(i);
                    Iterator iter = adapter.getChildren(object).iterator();
                    adapter = null;
                    while (iter.hasNext()) {
                        Object child = iter.next();
                        object = TngUtil.unwrap(child);
                        if (object instanceof MethodElement) {
                            if (!guid.equals(((MethodElement)object).getGuid())) continue;
                            if (child instanceof ITreeItemContentProvider) {
                                adapter = (ITreeItemContentProvider)child;
                                break;
                            }
                            Class<?> clazz3 = class$0;
                            if (clazz3 == null) {
                                try {
                                    clazz3 = Class.forName("org.eclipse.emf.edit.provider.ITreeItemContentProvider");
                                }
                                catch (ClassNotFoundException classNotFoundException) {
                                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                }
                            }
                            adapter = (ITreeItemContentProvider)adapterFactory.adapt(child, (Object)clazz3);
                            break;
                        }
                        ItemProviderAdapter itemProvider = (ItemProviderAdapter)object;
                        MethodElement e = (MethodElement)itemProvider.getTarget();
                        if (!guid.equals(e.getGuid())) continue;
                        adapter = (ITreeItemContentProvider)itemProvider;
                        break;
                    }
                    if (adapter == null) {
                        break;
                    }
                    ++i;
                }
            }
            catch (Throwable throwable) {
                Object var16_12 = null;
                if (configurator == null) throw throwable;
                configurator.setMethodConfiguration(currentConfig);
                throw throwable;
            }
            Object var16_10 = null;
            if (configurator == null) return false;
            configurator.setMethodConfiguration(currentConfig);
            return false;
        }
        Object var16_11 = null;
        if (configurator == null) return true;
        configurator.setMethodConfiguration(currentConfig);
        return true;
    }

    public boolean reveal(List selection) {
        boolean readOnlyElementAffected = false;
        Iterator iter = selection.iterator();
        while (iter.hasNext()) {
            Object element = iter.next();
            if (element instanceof BreakdownElementWrapperItemProvider) {
                BreakdownElementWrapperItemProvider wrapper = (BreakdownElementWrapperItemProvider)element;
                MethodElement e = (MethodElement)TngUtil.unwrap(wrapper);
                if (!wrapper.isReadOnly()) {
                    e.setSuppressed(Boolean.FALSE);
                    continue;
                }
                String path = Suppression.getPath(wrapper);
                this.getSuppressedExternalElementPaths().remove(path);
                readOnlyElementAffected = true;
                continue;
            }
            if (!(element instanceof MethodElement)) continue;
            ((MethodElement)element).setSuppressed(Boolean.FALSE);
        }
        this.modified = true;
        return readOnlyElementAffected;
    }

    private static String getViewType(BreakdownElementWrapperItemProvider wrapper) {
        Object e = TngUtil.unwrap(wrapper);
        if (e instanceof WorkBreakdownElement) {
            return WBS;
        }
        if (e instanceof TeamProfile || e instanceof RoleDescriptor) {
            return TBS;
        }
        if (e instanceof WorkProductDescriptor) {
            return WPBS;
        }
        return "";
    }

    private static String getPath(BreakdownElementWrapperItemProvider wrapper) {
        StringBuffer path = new StringBuffer();
        List parentList = ProcessUtil.getParentList(null, wrapper);
        if (!parentList.isEmpty()) {
            int lastIndex = parentList.size() - 1;
            if (parentList.get(lastIndex) instanceof TaskDescriptor) {
                parentList.remove(lastIndex);
            }
            Iterator iter = parentList.iterator();
            while (iter.hasNext()) {
                MethodElement e = (MethodElement)iter.next();
                path.append('/').append(e.getGuid());
            }
        }
        MethodElement e = (MethodElement)TngUtil.unwrap(wrapper);
        path.append('/').append(e.getGuid());
        String viewType = Suppression.getViewType(wrapper);
        path.insert(0, ":/").insert(0, viewType);
        return path.toString();
    }

    public boolean suppress(List selection) {
        boolean readOnlyElementSuppressed = false;
        Iterator iter = selection.iterator();
        while (iter.hasNext()) {
            Object element = iter.next();
            if (element instanceof BreakdownElementWrapperItemProvider) {
                BreakdownElementWrapperItemProvider wrapper = (BreakdownElementWrapperItemProvider)element;
                if (this.isSuppressed(wrapper)) continue;
                BreakdownElement e = (BreakdownElement)TngUtil.unwrap(wrapper);
                if (!wrapper.isReadOnly()) {
                    e.setSuppressed(Boolean.TRUE);
                    continue;
                }
                String path = Suppression.getPath(wrapper);
                this.getSuppressedExternalElementPaths().add(path);
                readOnlyElementSuppressed = true;
                continue;
            }
            if (!(element instanceof MethodElement)) continue;
            ((MethodElement)element).setSuppressed(Boolean.TRUE);
        }
        this.modified = true;
        return readOnlyElementSuppressed;
    }

    public boolean hasUnsuppressed(List selection) {
        Iterator iter = selection.iterator();
        while (iter.hasNext()) {
            Object element = iter.next();
            if (!(element instanceof BreakdownElementWrapperItemProvider ? !this.isSuppressed((BreakdownElementWrapperItemProvider)element) : element instanceof BreakdownElement && !this.isSuppressed((BreakdownElement)element))) continue;
            return true;
        }
        return false;
    }

    public boolean isSaveNeeded() {
        return this.modified;
    }

    public void saveIsDone() {
        this.modified = false;
    }

    public boolean isSuppressed(Object e) {
        if (e == null) {
            return true;
        }
        if (e instanceof BreakdownElementWrapperItemProvider) {
            return this.__isSuppressed((BreakdownElementWrapperItemProvider)e);
        }
        if (e instanceof BreakdownElement) {
            return this.__isSuppressed((BreakdownElement)e);
        }
        Object targetObj = null;
        if (e instanceof WrapperItemProvider) {
            targetObj = ((WrapperItemProvider)e).getValue();
        } else if (e instanceof ItemProviderAdapter) {
            targetObj = ((ItemProviderAdapter)e).getTarget();
        }
        if (targetObj != null && targetObj != e) {
            return this.isSuppressed(targetObj);
        }
        return false;
    }
}

