/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.edit.util;

import com.ibm.uma.Activity;
import com.ibm.uma.BreakdownElement;
import com.ibm.uma.ContentCategory;
import com.ibm.uma.ContentDescription;
import com.ibm.uma.ContentElement;
import com.ibm.uma.ContentPackage;
import com.ibm.uma.CustomCategory;
import com.ibm.uma.DescribableElement;
import com.ibm.uma.Discipline;
import com.ibm.uma.Domain;
import com.ibm.uma.Guidance;
import com.ibm.uma.MethodConfiguration;
import com.ibm.uma.MethodElement;
import com.ibm.uma.MethodLibrary;
import com.ibm.uma.MethodPackage;
import com.ibm.uma.MethodPlugin;
import com.ibm.uma.NamedElement;
import com.ibm.uma.Process;
import com.ibm.uma.ProcessComponent;
import com.ibm.uma.ProcessPackage;
import com.ibm.uma.Role;
import com.ibm.uma.RoleDescriptor;
import com.ibm.uma.RoleSet;
import com.ibm.uma.Tool;
import com.ibm.uma.UmaFactory;
import com.ibm.uma.UmaPackage;
import com.ibm.uma.VariabilityElement;
import com.ibm.uma.VariabilityType;
import com.ibm.uma.WorkBreakdownElement;
import com.ibm.uma.WorkOrder;
import com.ibm.uma.WorkProduct;
import com.ibm.uma.WorkProductDescriptor;
import com.ibm.uma.WorkProductType;
import com.ibm.uma.provider.MethodElementItemProvider;
import com.ibm.uma.provider.UmaEditPlugin;
import com.ibm.uma.provider.UmaItemProviderAdapterFactory;
import com.ibm.uma.util.AssociationHelper;
import com.ibm.uma.util.ContentDescriptionFactory;
import com.ibm.uma.util.IMethodLibraryPersister;
import com.ibm.uma.util.UmaUtil;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.MissingResourceException;
import java.util.Set;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CommandWrapper;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.AbstractTreeIterator;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.FeatureMap;
import org.eclipse.emf.ecore.util.FeatureMapUtil;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.emf.edit.command.AddCommand;
import org.eclipse.emf.edit.command.MoveCommand;
import org.eclipse.emf.edit.command.PasteFromClipboardCommand;
import org.eclipse.emf.edit.command.RemoveCommand;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.provider.AttributeValueWrapperItemProvider;
import org.eclipse.emf.edit.provider.ComposeableAdapterFactory;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.FeatureMapEntryWrapperItemProvider;
import org.eclipse.emf.edit.provider.IChangeNotifier;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;
import org.eclipse.emf.edit.provider.IWrapperItemProvider;
import org.eclipse.emf.edit.provider.ItemProviderAdapter;
import org.eclipse.emf.edit.provider.ViewerNotification;
import org.eclipse.epf.common.utils.NetUtil;
import org.eclipse.epf.common.utils.StrUtil;
import org.eclipse.epf.library.edit.FeatureValueWrapperItemProvider;
import org.eclipse.epf.library.edit.IDefaultNameSetter;
import org.eclipse.epf.library.edit.IFilter;
import org.eclipse.epf.library.edit.IGroupContainer;
import org.eclipse.epf.library.edit.LibraryEditPlugin;
import org.eclipse.epf.library.edit.LibraryEditResources;
import org.eclipse.epf.library.edit.TngAdapterFactory;
import org.eclipse.epf.library.edit.category.InheritedCategoryPackageListener;
import org.eclipse.epf.library.edit.category.ObjectLinkItemProvider;
import org.eclipse.epf.library.edit.category.UnsettableItemPropertyDescriptor;
import org.eclipse.epf.library.edit.command.IActionManager;
import org.eclipse.epf.library.edit.element.ContentPackageItemProvider;
import org.eclipse.epf.library.edit.process.command.MoveDownCommand;
import org.eclipse.epf.library.edit.process.command.MoveUpCommand;
import org.eclipse.epf.library.edit.util.LibraryEditConstants;
import org.eclipse.epf.library.edit.util.MethodElementUtil;
import org.eclipse.epf.library.edit.util.Misc;
import org.eclipse.epf.library.edit.util.ModelStructure;
import org.eclipse.epf.library.edit.util.ProcessUtil;
import org.eclipse.epf.library.edit.util.model.OrderInfo;
import org.eclipse.epf.library.edit.util.model.OrderInfoCollection;
import org.eclipse.epf.library.edit.util.model.util.StringResource;
import org.eclipse.epf.uma.ecore.impl.MultiResourceEObject;
import org.eclipse.epf.uma.ecore.util.OppositeFeature;

public final class TngUtil {
    public static final UmaItemProviderAdapterFactory umaItemProviderAdapterFactory = new UmaItemProviderAdapterFactory();
    public static final boolean DEBUG = LibraryEditPlugin.getPlugin().isDebugging();
    private static final String ELEMENT_TEXT = LibraryEditResources.getString("LibraryEdit.element.text");
    public static boolean showPresentationNames = false;
    public static final String TEMPLATE_FILESTRING_SEPARATOR = "|";
    private static final String TEMPLATE_FILESTRING_SEPARATOR_SPLITTER = "\\|";
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;
    static /* synthetic */ Class class$5;
    static /* synthetic */ Class class$6;
    static /* synthetic */ Class class$7;
    static /* synthetic */ Class class$8;
    static /* synthetic */ Class class$9;
    static /* synthetic */ Class class$10;
    static /* synthetic */ Class class$11;

    public static void removeAdapters(EObject eObj, Class cls) {
        Iterator adapters = eObj.eAdapters().iterator();
        while (adapters.hasNext()) {
            Adapter adapter = (Adapter)adapters.next();
            if (!cls.isInstance(adapter)) continue;
            adapters.remove();
        }
    }

    public static Object getAdapter(EObject eObj, Class cls) {
        Iterator adapters = eObj.eAdapters().iterator();
        while (adapters.hasNext()) {
            Adapter adapter = (Adapter)adapters.next();
            if (!cls.isInstance(adapter)) continue;
            return adapter;
        }
        return null;
    }

    public static Adapter adapt(AdapterFactory factory, Notifier notifier, Object type, Class viewType) {
        Iterator adapters = notifier.eAdapters().iterator();
        while (adapters.hasNext()) {
            Adapter adapter = (Adapter)adapters.next();
            if (!adapter.isAdapterForType(type) || !viewType.isInstance(adapter)) continue;
            return adapter;
        }
        return factory.adaptNew(notifier, type);
    }

    public static boolean isValidFileName(String name) {
        if (name == null) {
            return false;
        }
        return name.indexOf(47) == -1 && name.indexOf(92) == -1 && name.indexOf(58) == -1 && name.indexOf(42) == -1 && name.indexOf(63) == -1 && name.indexOf(34) == -1 && name.indexOf(60) == -1 && name.indexOf(62) == -1 && name.indexOf(124) == -1;
    }

    public static String checkName(NamedElement e, String name, Collection eClasses) {
        return TngUtil.checkName(e.eContainer(), e, name, TngUtil.getTypeText((EObject)e), eClasses);
    }

    public static String checkName(EObject parent, NamedElement e, String name, String elementTypeText, Collection eClasses) {
        String msg = TngUtil.checkElementName(name, elementTypeText);
        if (msg != null) {
            return msg;
        }
        if (parent == null) {
            return null;
        }
        EList children = parent.eContents();
        int i = 0;
        while (i < children.size()) {
            NamedElement child = (NamedElement)children.get(i);
            if (child != e && TngUtil.isEClassInstanceOf(eClasses, child) && name.equalsIgnoreCase(child.getName())) {
                return LibraryEditResources.formatString("LibraryEdit.duplicateElementNameError.msg", name);
            }
            ++i;
        }
        return null;
    }

    public static String checkName(EObject parent, NamedElement e, String name, String elementTypeText, IFilter childFilter) {
        String msg = TngUtil.checkElementName(name, elementTypeText);
        if (msg != null) {
            return msg;
        }
        if (parent == null) {
            return null;
        }
        EList children = parent.eContents();
        int i = 0;
        while (i < children.size()) {
            NamedElement child = (NamedElement)children.get(i);
            if (child != e && childFilter.accept(child) && name.equalsIgnoreCase(child.getName())) {
                return LibraryEditResources.formatString("LibraryEdit.duplicateElementNameError.msg", name);
            }
            ++i;
        }
        return null;
    }

    public static String checkName(File dir, Collection siblings, NamedElement e, String name, String elementTypeText, boolean isDir) {
        String msg = TngUtil.checkElementName(name, elementTypeText);
        if (msg != null) {
            return msg;
        }
        String fileName = name;
        if (!isDir) {
            fileName = String.valueOf(fileName) + ".xmi";
        }
        File file = new File(dir, fileName);
        File currentFile = null;
        if (e != null && e.eResource() != null) {
            currentFile = new File(e.eResource().getURI().toFileString());
            if (isDir) {
                currentFile = currentFile.getParentFile();
            }
        }
        if (file.exists() && !file.equals(currentFile)) {
            msg = LibraryEditResources.formatString("LibraryEdit.duplicateElementNameError.msg", name);
            Object[] params = new Object[]{file.isFile() ? LibraryEditResources.getString("LibraryEdit.file.text") : LibraryEditResources.getString("LibraryEdit.directory.text"), file};
            return MessageFormat.format(msg, params).toString();
        }
        Iterator iter = siblings.iterator();
        while (iter.hasNext()) {
            NamedElement child = (NamedElement)iter.next();
            if (child == e || !name.equalsIgnoreCase(child.getName())) continue;
            return LibraryEditResources.formatString("LibraryEdit.duplicateElementNameError.msg", name);
        }
        return null;
    }

    public static String checkElementName(String name, String elementTypeText) {
        if (name == null || name.trim().length() == 0) {
            return LibraryEditResources.formatString("LibraryEdit.emptyElementNameError.msg", elementTypeText.toLowerCase());
        }
        if (name.startsWith(" ")) {
            return LibraryEditResources.formatString("LibraryEdit.invalidElementNameError1.msg", name);
        }
        if (name.endsWith(".")) {
            return LibraryEditResources.formatString("LibraryEdit.invalidElementNameError2.msg", name);
        }
        if (!TngUtil.isValidFileName(name)) {
            return LibraryEditResources.formatString("LibraryEdit.invalidElementNameError3.msg", name);
        }
        return null;
    }

    public static String checkName(AdapterFactory adapterFactory, Object parent, Object e, final Class type, EStructuralFeature nameFeature, String newName) {
        IFilter childFilter = new IFilter(){

            public boolean accept(Object obj) {
                return type.isInstance(obj);
            }
        };
        return TngUtil.checkName(adapterFactory, parent, e, childFilter, nameFeature, newName);
    }

    public static String checkName(AdapterFactory adapterFactory, Object parent, Object e, IFilter childFilter, EStructuralFeature nameFeature, String newName) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.emf.edit.provider.ITreeItemContentProvider");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ITreeItemContentProvider adapter = (ITreeItemContentProvider)adapterFactory.adapt(parent, (Object)clazz);
        Collection children = adapter.getChildren(parent);
        Iterator iter = children.iterator();
        while (iter.hasNext()) {
            String name;
            Object child = TngUtil.unwrap(iter.next());
            if (child == e || !childFilter.accept(child) || !(name = (String)((EObject)child).eGet(nameFeature)).equalsIgnoreCase(newName)) continue;
            return LibraryEditResources.formatString("LibraryEdit.duplicateElementNameError.msg", name);
        }
        return null;
    }

    public static String checkName(AdapterFactory adapterFactory, Object e, Class type, EStructuralFeature nameFeature, String newName) {
        ITreeItemContentProvider adapter;
        Object parent;
        String elementType = e instanceof NamedElement ? TngUtil.getTypeText((EObject)((NamedElement)e)) : ELEMENT_TEXT;
        if (newName == null || newName.length() == 0) {
            return LibraryEditResources.formatString("LibraryEdit.emptyElementNameError.msg", elementType.toLowerCase());
        }
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.emf.edit.provider.ITreeItemContentProvider");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((parent = (adapter = (ITreeItemContentProvider)adapterFactory.adapt(e, (Object)clazz)).getParent(e)) == null) {
            return null;
        }
        return TngUtil.checkName(adapterFactory, parent, e, type, nameFeature, newName);
    }

    public static String checkActivityName(AdapterFactory adapterFactory, Object object, String name) {
        if (!(object instanceof Activity)) {
            return null;
        }
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("com.ibm.uma.Activity");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return TngUtil.checkName(adapterFactory, object, clazz, (EStructuralFeature)UmaPackage.eINSTANCE.getNamedElement_Name(), name);
    }

    public static String checkWBSActivityName(Object act, String name) {
        return TngUtil.checkActivityName((AdapterFactory)TngAdapterFactory.INSTANCE.getWBS_ComposedAdapterFactory(), act, name);
    }

    public static String checkWBSActivityPresentationName(Object act, String name) {
        if (!(act instanceof Activity)) {
            return null;
        }
        ComposedAdapterFactory composedAdapterFactory = TngAdapterFactory.INSTANCE.getWBS_ComposedAdapterFactory();
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("com.ibm.uma.Activity");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return TngUtil.checkName((AdapterFactory)composedAdapterFactory, act, clazz, (EStructuralFeature)UmaPackage.eINSTANCE.getDescribableElement_PresentationName(), name);
    }

    public static String checkWorkBreakdownElementPresentationName(Object act, String name) {
        if (!(act instanceof WorkBreakdownElement)) {
            return null;
        }
        ComposedAdapterFactory composedAdapterFactory = TngAdapterFactory.INSTANCE.getWBS_ComposedAdapterFactory();
        Class<?> clazz = class$2;
        if (clazz == null) {
            try {
                clazz = class$2 = Class.forName("com.ibm.uma.WorkBreakdownElement");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return TngUtil.checkName((AdapterFactory)composedAdapterFactory, act, clazz, (EStructuralFeature)UmaPackage.eINSTANCE.getDescribableElement_PresentationName(), name);
    }

    public static String checkWorkProductDescriptorPresentationName(Object act, String name) {
        if (!(act instanceof WorkProductDescriptor)) {
            return null;
        }
        ComposedAdapterFactory composedAdapterFactory = TngAdapterFactory.INSTANCE.getPBS_ComposedAdapterFactory();
        Class<?> clazz = class$3;
        if (clazz == null) {
            try {
                clazz = class$3 = Class.forName("com.ibm.uma.WorkProductDescriptor");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return TngUtil.checkName((AdapterFactory)composedAdapterFactory, act, clazz, (EStructuralFeature)UmaPackage.eINSTANCE.getDescribableElement_PresentationName(), name);
    }

    public static String checkRoleDescriptorPresentationName(Object act, String name) {
        if (!(act instanceof RoleDescriptor)) {
            return null;
        }
        ComposedAdapterFactory composedAdapterFactory = TngAdapterFactory.INSTANCE.getOBS_ComposedAdapterFactory();
        Class<?> clazz = class$4;
        if (clazz == null) {
            try {
                clazz = class$4 = Class.forName("com.ibm.uma.RoleDescriptor");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return TngUtil.checkName((AdapterFactory)composedAdapterFactory, act, clazz, (EStructuralFeature)UmaPackage.eINSTANCE.getDescribableElement_PresentationName(), name);
    }

    public static boolean isEClassInstanceOf(Collection eClasses, Object obj) {
        Iterator iter = eClasses.iterator();
        while (iter.hasNext()) {
            EClass eClass = (EClass)iter.next();
            if (!eClass.isInstance(obj)) continue;
            return true;
        }
        return false;
    }

    public static boolean isInstanceOf(Collection classes, Object obj) {
        Iterator iter = classes.iterator();
        while (iter.hasNext()) {
            Class clazz = (Class)iter.next();
            if (!clazz.isInstance(obj)) continue;
            return true;
        }
        return false;
    }

    public static AdapterFactory getBestAdapterFactory(AdapterFactory adapterFactory) {
        if (adapterFactory instanceof ComposeableAdapterFactory) {
            return ((ComposeableAdapterFactory)adapterFactory).getRootAdapterFactory();
        }
        return adapterFactory;
    }

    public static String getLabel(Object object) {
        return TngUtil.getLabel(object, "");
    }

    public static String getLabel(Object object, String alternativeLabel) {
        EObject eObj;
        if (object instanceof EObject && (eObj = (EObject)object).eIsProxy()) {
            String path = null;
            try {
                path = eObj.eResource().getResourceSet().getURIConverter().normalize(((InternalEObject)eObj).eProxyURI()).toFileString();
            }
            catch (Exception exception) {}
            path = path != null ? MessageFormat.format(" ''{0}''", path) : "";
            return LibraryEditResources.formatString("LibraryEdit.unresolved.text", path);
        }
        String label = null;
        if (showPresentationNames && object instanceof DescribableElement) {
            label = ((DescribableElement)object).getPresentationName();
        } else if (showPresentationNames && object instanceof ProcessComponent) {
            label = ((ProcessComponent)object).getProcess().getPresentationName();
        }
        if (label == null || label.trim().length() == 0) {
            label = ((NamedElement)object).getName();
        }
        return label == null ? alternativeLabel : label;
    }

    public static String getLabel(VariabilityElement object, String alternativeLabel, boolean preferBase) {
        String label = TngUtil.getLabel(object, alternativeLabel);
        if (preferBase && object.getVariabilityBasedOnElement() != null) {
            VariabilityType type = object.getVariabilityType();
            String variabilityTxt = null;
            if (type == VariabilityType.CONTRIBUTES_LITERAL) {
                variabilityTxt = LibraryEditResources.getString("LibraryEdit.contributesTo.text");
            } else if (type == VariabilityType.EXTENDS_LITERAL) {
                variabilityTxt = LibraryEditResources.getString("LibraryEdit.extends.text");
            } else if (type == VariabilityType.REPLACES_LITERAL) {
                variabilityTxt = LibraryEditResources.getString("LibraryEdit.replaces.text");
            }
            if (variabilityTxt != null) {
                MethodPlugin basePlugin = UmaUtil.getMethodPlugin((EObject)object.getVariabilityBasedOnElement());
                label = basePlugin != null ? LibraryEditResources.formatString("LibraryEdit.Util.labelpath.variabilitywithplugin.info", new String[]{label, variabilityTxt, TngUtil.getLabel(object.getVariabilityBasedOnElement(), alternativeLabel), basePlugin.getName()}) : LibraryEditResources.formatString("LibraryEdit.Util.labelpath.variability.info", new String[]{label, variabilityTxt, TngUtil.getLabel(object.getVariabilityBasedOnElement(), alternativeLabel)});
            }
        }
        return label;
    }

    public static void initializeProcessComponent(ProcessComponent component, EClass type) {
        Process proc = component.getProcess();
        if (proc == null) {
            proc = (Process)UmaFactory.eINSTANCE.create(type);
            component.setProcess(proc);
        }
    }

    public static BreakdownElement getParent(BreakdownElement be) {
        return null;
    }

    public static String checkNull(String str) {
        return str == null ? "" : str;
    }

    public static boolean descriptorExists(Role role, List roleDescriptorList) {
        int i = roleDescriptorList.size() - 1;
        while (i > -1) {
            RoleDescriptor roleDesc = (RoleDescriptor)roleDescriptorList.get(i);
            if (roleDesc.getRole() == role) {
                return true;
            }
            --i;
        }
        return false;
    }

    public static boolean descriptorExists(Object obj, Activity activity) {
        return ProcessUtil.getDescriptor(obj, activity) != null;
    }

    public static MethodElement copy(MethodElement element) {
        EcoreUtil.Copier copier = new EcoreUtil.Copier(){
            private static final long serialVersionUID = 3257846576033904691L;

            protected void copyReference(EReference eReference, EObject eObject, EObject copyEObject) {
                if (eObject.eIsSet((EStructuralFeature)eReference)) {
                    if (eReference.isMany()) {
                        List source = (List)eObject.eGet((EStructuralFeature)eReference);
                        InternalEList target = (InternalEList)copyEObject.eGet(this.getTarget((EStructuralFeature)eReference));
                        if (source.isEmpty()) {
                            target.clear();
                        } else {
                            OppositeFeature oppositeFeature = MultiResourceEObject.getOppositeFeature((EStructuralFeature)eReference);
                            boolean isBidirectional = eReference.getEOpposite() != null || oppositeFeature != null && !oppositeFeature.isMany();
                            int index = 0;
                            Iterator k = source.iterator();
                            while (k.hasNext()) {
                                Object referencedEObject = k.next();
                                Object copyReferencedEObject = this.get(referencedEObject);
                                if (copyReferencedEObject == null) {
                                    if (isBidirectional) continue;
                                    target.addUnique(index, referencedEObject);
                                    ++index;
                                    continue;
                                }
                                if (isBidirectional) {
                                    int position = target.indexOf(copyReferencedEObject);
                                    if (position == -1) {
                                        target.addUnique(index, copyReferencedEObject);
                                    } else if (index != position) {
                                        target.move(index, copyReferencedEObject);
                                    }
                                } else {
                                    target.addUnique(index, copyReferencedEObject);
                                }
                                ++index;
                            }
                        }
                    } else {
                        Object referencedEObject = eObject.eGet((EStructuralFeature)eReference);
                        if (referencedEObject == null) {
                            copyEObject.eSet(this.getTarget((EStructuralFeature)eReference), null);
                        } else {
                            Object copyReferencedEObject = this.get(referencedEObject);
                            if (copyReferencedEObject == null) {
                                if (eReference.getEOpposite() == null) {
                                    copyEObject.eSet(this.getTarget((EStructuralFeature)eReference), referencedEObject);
                                }
                            } else {
                                copyEObject.eSet(this.getTarget((EStructuralFeature)eReference), copyReferencedEObject);
                            }
                        }
                    }
                }
            }
        };
        MethodElement copy = (MethodElement)copier.copy((EObject)element);
        copier.copyReferences();
        copy.setGuid(null);
        TreeIterator iter = copy.eAllContents();
        while (iter.hasNext()) {
            Object e = iter.next();
            if (!(e instanceof MethodElement)) continue;
            ((MethodElement)e).setGuid(null);
        }
        return copy;
    }

    public static Collection addInheritedCategories(MethodPlugin basePlugin, InheritedCategoryPackageListener listener) {
        ContentPackage categoryPkg = listener.getCategoryPackage();
        ContentPackage baseCategoryPkg = UmaUtil.findContentPackage((MethodPlugin)basePlugin, (String[])Misc.getPathRelativeToPlugin((NamedElement)categoryPkg));
        if (InheritedCategoryPackageListener.getAdapter((EObject)baseCategoryPkg, categoryPkg) == null) {
            ArrayList<ContentCategory> inheritableList = new ArrayList<ContentCategory>();
            Iterator iterator = baseCategoryPkg.getContentElements().iterator();
            while (iterator.hasNext()) {
                Object element = iterator.next();
                ContentCategory baseCategory = (ContentCategory)element;
                if (baseCategory.getVariabilityBasedOnElement() != null) continue;
                inheritableList.add(baseCategory);
            }
            Collection inheritedList = listener.addInherited(inheritableList);
            baseCategoryPkg.eAdapters().add((Object)listener);
            return inheritedList;
        }
        return null;
    }

    public static VariabilityElement getBase(VariabilityElement c) {
        while (c.getVariabilityBasedOnElement() != null) {
            c = c.getVariabilityBasedOnElement();
        }
        return c;
    }

    public static IItemPropertyDescriptor adaptDescriptor(ContentCategory category, IItemPropertyDescriptor descriptor) {
        if (category.getVariabilityBasedOnElement() != null) {
            return new UnsettableItemPropertyDescriptor(descriptor);
        }
        return descriptor;
    }

    public static ContentCategory findInherited(Collection inheritedList, ContentCategory category) {
        Iterator iter = inheritedList.iterator();
        while (iter.hasNext()) {
            ContentCategory element = (ContentCategory)iter.next();
            if (element.getVariabilityBasedOnElement() == null || element.getVariabilityBasedOnElement() != category && element.getVariabilityBasedOnElement() != category.getVariabilityBasedOnElement()) continue;
            return element;
        }
        return null;
    }

    public static ContentCategory removeInherited(List inheritedList, ContentCategory category) {
        Iterator iter = inheritedList.iterator();
        while (iter.hasNext()) {
            ContentCategory element = (ContentCategory)iter.next();
            if (element.getVariabilityBasedOnElement() != category) continue;
            iter.remove();
            return element;
        }
        return null;
    }

    public static Object getDisciplineCategoriesItemProvider(MethodPlugin model) {
        IGroupContainer groupContainer;
        Class<?> clazz = class$5;
        if (clazz == null) {
            try {
                clazz = class$5 = Class.forName("org.eclipse.epf.library.edit.IGroupContainer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((groupContainer = (IGroupContainer)TngUtil.getAdapter((EObject)model, clazz)) != null) {
            groupContainer = (IGroupContainer)groupContainer.getGroupItemProvider(LibraryEditPlugin.INSTANCE.getString("_UI_Content_group"));
            return groupContainer.getGroupItemProvider(LibraryEditPlugin.INSTANCE.getString("_UI_Disciplines_group"));
        }
        return null;
    }

    public static void setDefaultName(List siblings, MethodElement e, String baseName) {
        if (e.getName() != null && e.getName().trim().length() > 0) {
            return;
        }
        if (!TngUtil.isNameTaken(siblings, e, baseName)) {
            e.setName(baseName);
            TngUtil.setPresentationName(e, baseName);
            return;
        }
        int i = 2;
        while (true) {
            String name;
            if (!TngUtil.isNameTaken(siblings, e, name = String.valueOf(baseName) + '_' + i)) {
                e.setName(name);
                TngUtil.setPresentationName(e, name);
                return;
            }
            ++i;
        }
    }

    private static void setPresentationName(MethodElement e, String baseName) {
        if (e instanceof DescribableElement) {
            DescribableElement de = (DescribableElement)e;
            StringBuffer presNameBuf = new StringBuffer();
            StringTokenizer st = new StringTokenizer(baseName, "_");
            while (st.hasMoreTokens()) {
                String aWord = st.nextToken();
                presNameBuf.append(String.valueOf(aWord.substring(0, 1).toUpperCase()) + aWord.substring(1) + " ");
            }
            de.setPresentationName(presNameBuf.toString().trim());
        }
    }

    private static boolean isNameTaken(List siblings, MethodElement e, String name) {
        int i = siblings.size() - 1;
        while (i > -1) {
            MethodElement sibling = (MethodElement)siblings.get(i);
            if (sibling != e && name.equals(sibling.getName())) {
                return true;
            }
            --i;
        }
        return false;
    }

    public static List extract(Collection collection, Class cls) {
        ArrayList list = new ArrayList();
        Iterator iter = collection.iterator();
        while (iter.hasNext()) {
            Object element = iter.next();
            if (!cls.isInstance(element)) continue;
            list.add(element);
        }
        return list;
    }

    public static void setDefaultName(IDefaultNameSetter defaultNameSetter, Notification msg) {
        int featureId;
        if (defaultNameSetter.getInterestedFeatureOwnerClass() != null && (featureId = msg.getFeatureID(defaultNameSetter.getInterestedFeatureOwnerClass())) == defaultNameSetter.getInterestedFeatureID()) {
            switch (msg.getEventType()) {
                case 3: {
                    defaultNameSetter.setDefaultName(msg.getNewValue());
                    break;
                }
                case 5: {
                    Iterator iter = ((Collection)msg.getNewValue()).iterator();
                    while (iter.hasNext()) {
                        defaultNameSetter.setDefaultName(iter.next());
                    }
                    break;
                }
            }
        }
    }

    public static void addExtendedChildren(ContentCategory baseCategory, MethodConfiguration methodConf, Collection children, String[] categoryPkgPath) {
        MethodPlugin basePlugin = UmaUtil.getMethodPlugin((EObject)baseCategory);
        Iterator iter = methodConf.getMethodPluginSelection().iterator();
        while (iter.hasNext()) {
            ItemProviderAdapter adapter;
            ContentCategory category;
            ContentPackage categoryPkg;
            MethodPlugin plugin = (MethodPlugin)iter.next();
            if (!Misc.isBaseOf(basePlugin, plugin) || (categoryPkg = UmaUtil.findContentPackage((MethodPlugin)plugin, (String[])categoryPkgPath)) == null || !methodConf.getMethodPackageSelection().contains(categoryPkg) || (category = TngUtil.findInherited(categoryPkg.getContentElements(), baseCategory)) == null) continue;
            ComposedAdapterFactory composedAdapterFactory = TngAdapterFactory.INSTANCE.getNavigatorView_ComposedAdapterFactory();
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = Class.forName("org.eclipse.emf.edit.provider.ITreeItemContentProvider");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((adapter = (ItemProviderAdapter)composedAdapterFactory.adapt((Notifier)category, (Object)clazz)) == null) {
                System.err.println("DisciplineGroupingItemProvider.addExtendedChildren(): could not find adapter for " + category);
            }
            Iterator iterator = adapter.getChildren((Object)category).iterator();
            while (iterator.hasNext()) {
                Object linkedObj;
                Object child = iterator.next();
                ContentElement element = null;
                if (child instanceof ContentElement) {
                    element = (ContentElement)child;
                } else if (child instanceof ObjectLinkItemProvider && (linkedObj = ((ObjectLinkItemProvider)((Object)child)).getLinkedObject()) instanceof ContentElement) {
                    element = (ContentElement)linkedObj;
                }
                if (element == null || element.getVariabilityBasedOnElement() != null) continue;
                children.add(child);
            }
            TngUtil.addExtendedChildren(category, methodConf, children, categoryPkgPath);
        }
    }

    public static void addTo(List allChildren, BreakdownElement child, Object owner, AdapterFactory adapterFactory) {
        BreakdownElement next = child.getPresentedAfter();
        int id = next == null ? -1 : TngUtil.indexOf(allChildren, next);
        if (id == -1) {
            allChildren.add(child);
        } else {
            allChildren.add(id, child);
        }
    }

    private static int indexOf(List mixedList, Object object) {
        int size = mixedList.size();
        int i = 0;
        while (i < size) {
            Object o = mixedList.get(i);
            if (o == object || o instanceof IWrapperItemProvider && object == ((IWrapperItemProvider)o).getValue()) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static List getAvailableBaseProcesses(MethodPlugin plugin, List processClasses) {
        ArrayList<Process> processes = new ArrayList<Process>();
        List allBasePlugins = Misc.getAllBase(plugin);
        allBasePlugins.add(0, plugin);
        Iterator iter = allBasePlugins.iterator();
        while (iter.hasNext()) {
            MethodPlugin basePlugin = (MethodPlugin)iter.next();
            Collection packages = TngUtil.getRootProcessPackages(basePlugin, processClasses);
            Iterator iterator = packages.iterator();
            while (iterator.hasNext()) {
                ProcessPackage pkg = (ProcessPackage)iterator.next();
                Iterator iterator1 = pkg.getChildPackages().iterator();
                while (iterator1.hasNext()) {
                    Process proc;
                    Object childPkg = iterator1.next();
                    if (!(childPkg instanceof ProcessComponent) || !TngUtil.isInstanceOf(processClasses, proc = ((ProcessComponent)childPkg).getProcess())) continue;
                    processes.add(proc);
                }
            }
        }
        return processes;
    }

    private static String[] getRootProcessPackagePath(Class procClass) {
        Class<?> clazz = class$6;
        if (clazz == null) {
            try {
                clazz = class$6 = Class.forName("com.ibm.uma.DeliveryProcess");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (procClass == clazz) {
            return ModelStructure.DEFAULT.deliveryProcessPath;
        }
        Class<?> clazz2 = class$7;
        if (clazz2 == null) {
            try {
                clazz2 = class$7 = Class.forName("com.ibm.uma.CapabilityPattern");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (procClass == clazz2) {
            return ModelStructure.DEFAULT.capabilityPatternPath;
        }
        Class<?> clazz3 = class$8;
        if (clazz3 == null) {
            try {
                clazz3 = class$8 = Class.forName("com.ibm.uma.ProcessPlanningTemplate");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (procClass == clazz3) {
            return ModelStructure.DEFAULT.processPlanningTemplatePath;
        }
        Class<?> clazz4 = class$9;
        if (clazz4 == null) {
            try {
                clazz4 = class$9 = Class.forName("com.ibm.uma.ProcessContribution");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (procClass == clazz4) {
            return ModelStructure.DEFAULT.processContributionPath;
        }
        return null;
    }

    private static Collection getRootProcessPackages(MethodPlugin plugin, Collection procClasses) {
        ArrayList<MethodPackage> packages = new ArrayList<MethodPackage>();
        Iterator iter = procClasses.iterator();
        while (iter.hasNext()) {
            MethodPackage pkg;
            Class clazz = (Class)iter.next();
            String[] path = TngUtil.getRootProcessPackagePath(clazz);
            if (path == null || !((pkg = UmaUtil.findMethodPackage((MethodPlugin)plugin, (String[])path)) instanceof ProcessPackage)) continue;
            packages.add(pkg);
        }
        return packages;
    }

    public static List getAllProcesses(MethodPlugin plugin) {
        ArrayList processes = new ArrayList();
        Iterator it = plugin.getMethodPackages().iterator();
        while (it.hasNext()) {
            MethodPackage pkg = (MethodPackage)it.next();
            TngUtil._iteratePackageForProcesses(pkg, processes);
        }
        return processes;
    }

    private static void _iteratePackageForProcesses(MethodPackage pkg, List processes) {
        Process p;
        if (pkg instanceof ProcessComponent && (p = ((ProcessComponent)pkg).getProcess()) != null && !processes.contains(p)) {
            processes.add(p);
        }
        Iterator it = pkg.getChildPackages().iterator();
        while (it.hasNext()) {
            TngUtil._iteratePackageForProcesses((MethodPackage)it.next(), processes);
        }
    }

    public static boolean isSubelementOf(Object parent, Object e, AdapterFactory adapterFactory) {
        if (parent == e) {
            return false;
        }
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.emf.edit.provider.ITreeItemContentProvider");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ITreeItemContentProvider adapter = (ITreeItemContentProvider)adapterFactory.adapt(parent, (Object)clazz);
        Iterator iter = adapter.getChildren(parent).iterator();
        while (iter.hasNext()) {
            Object element = iter.next();
            if (element == e) {
                return true;
            }
            if (!TngUtil.isSubelementOf(element, e, adapterFactory)) continue;
            return true;
        }
        return false;
    }

    public static boolean isSuperElementOf(Object child, Object e, AdapterFactory adapterFactory) {
        if (child == e) {
            return false;
        }
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.emf.edit.provider.ITreeItemContentProvider");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ITreeItemContentProvider adapter = (ITreeItemContentProvider)adapterFactory.adapt(e, (Object)clazz);
        Iterator iter = adapter.getChildren(e).iterator();
        while (iter.hasNext()) {
            Object element = iter.next();
            if (element == child) {
                return true;
            }
            if (!TngUtil.isSuperElementOf(child, element, adapterFactory)) continue;
            return true;
        }
        return false;
    }

    public static Object unwrap(Object obj) {
        if (obj instanceof IWrapperItemProvider) {
            while ((obj = ((IWrapperItemProvider)obj).getValue()) instanceof IWrapperItemProvider) {
            }
        } else if (obj instanceof CommandWrapper) {
            while ((obj = ((CommandWrapper)obj).getCommand()) instanceof CommandWrapper) {
            }
        } else if (obj instanceof ObjectLinkItemProvider) {
            obj = ((ObjectLinkItemProvider)((Object)obj)).getLinkedObject();
        }
        return obj;
    }

    public static Command unwrap(Command cmd) {
        while (cmd instanceof CommandWrapper) {
            cmd = ((CommandWrapper)cmd).getCommand();
        }
        return cmd;
    }

    public static boolean isBase(List elements, Object base) {
        Iterator iter = elements.iterator();
        while (iter.hasNext()) {
            Object element = iter.next();
            if (!(element instanceof VariabilityElement)) {
                return false;
            }
            if (base != ((VariabilityElement)element).getVariabilityBasedOnElement()) continue;
            return true;
        }
        return false;
    }

    public static String getPresentationName(Object e) {
        if (e instanceof ContentDescription) {
            e = ((ContentDescription)e).eContainer();
        }
        if (e == null) {
            return "";
        }
        String name = null;
        if (e instanceof DescribableElement) {
            name = ((DescribableElement)e).getPresentationName();
        }
        if (e instanceof MethodElement && StrUtil.isBlank((String)name)) {
            name = ((MethodElement)e).getName();
        }
        return name;
    }

    public static Process getOwningProcess(BreakdownElement e) {
        EObject container = e.eContainer();
        while (container != null && !(container instanceof ProcessComponent)) {
            container = container.eContainer();
        }
        if (container != null) {
            return ((ProcessComponent)container).getProcess();
        }
        return null;
    }

    public static boolean canReference(MethodElement source, MethodElement target) {
        MethodPlugin targetPlugin = UmaUtil.getMethodPlugin((EObject)target);
        MethodPlugin sourcePlugin = UmaUtil.getMethodPlugin((EObject)source);
        if (sourcePlugin == targetPlugin) {
            return true;
        }
        return Misc.isBaseOf(targetPlugin, sourcePlugin);
    }

    public static OrderInfo getOrderInfo(MethodElement e, String orderInfoName) {
        String str = e.getOrderingGuide();
        if (str == null || str.length() == 0) {
            return null;
        }
        StringResource res = new StringResource(str);
        try {
            res.load(null);
            if (res.getContents().isEmpty()) {
                return null;
            }
            OrderInfoCollection orderInfos = (OrderInfoCollection)res.getContents().get(0);
            Iterator iter = orderInfos.getOrderInfos().iterator();
            while (iter.hasNext()) {
                OrderInfo orderInfo = (OrderInfo)iter.next();
                if (!orderInfoName.equalsIgnoreCase(orderInfo.getName())) continue;
                return orderInfo;
            }
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        return null;
    }

    public static void refreshContributors(IChangeNotifier notifier, Notification notification, boolean contentRefresh, boolean labelUpdate) {
        Iterator iter = TngUtil.getContributors((VariabilityElement)notification.getNotifier());
        while (iter.hasNext()) {
            Object element = iter.next();
            notifier.fireNotifyChanged((Notification)new ViewerNotification(notification, element, contentRefresh, labelUpdate));
        }
    }

    public static boolean hasContributor(VariabilityElement e) {
        return TngUtil.hasGeneralizer(e, Collections.singleton(VariabilityType.CONTRIBUTES_LITERAL));
    }

    public static boolean hasGeneralizer(VariabilityElement e, Collection variabilityTypes) {
        Iterator iterator = AssociationHelper.getImmediateVarieties((VariabilityElement)e).iterator();
        while (iterator.hasNext()) {
            VariabilityElement element = (VariabilityElement)iterator.next();
            if (!variabilityTypes.contains(element.getVariabilityType())) continue;
            return true;
        }
        return false;
    }

    public static Iterator getGeneralizers(VariabilityElement e, final VariabilityType type) {
        return new AbstractTreeIterator(e, false){
            private static final long serialVersionUID = 3978145439449298483L;

            protected Iterator getChildren(Object object) {
                ArrayList<VariabilityElement> children = new ArrayList<VariabilityElement>();
                Iterator iterator = AssociationHelper.getImmediateVarieties((VariabilityElement)((VariabilityElement)object)).iterator();
                while (iterator.hasNext()) {
                    VariabilityElement element = (VariabilityElement)iterator.next();
                    if (type != null && element.getVariabilityType() != type) continue;
                    children.add(element);
                }
                return children.iterator();
            }
        };
    }

    public static Iterator getGeneralizers(VariabilityElement e) {
        return TngUtil.getGeneralizers(e, null);
    }

    public static Iterator getContributors(VariabilityElement e) {
        return TngUtil.getGeneralizers(e, VariabilityType.CONTRIBUTES_LITERAL);
    }

    public static ItemProviderAdapter getAdapter(MethodPlugin plugin, String[] path) {
        ComposedAdapterFactory composedAdapterFactory = TngAdapterFactory.INSTANCE.getNavigatorView_ComposedAdapterFactory();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.emf.edit.provider.ITreeItemContentProvider");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        IGroupContainer groups = (IGroupContainer)composedAdapterFactory.adapt((Notifier)plugin, (Object)clazz);
        int i = 0;
        while (i < path.length - 1) {
            if ((groups = (IGroupContainer)groups.getGroupItemProvider(path[i])) == null) {
                return null;
            }
            ++i;
        }
        return (ItemProviderAdapter)groups.getGroupItemProvider(path[i]);
    }

    private static void refreshAdapter(MethodPlugin plugin, String[] path, Notification msg) {
        if (plugin == null) {
            return;
        }
        ItemProviderAdapter adapter = TngUtil.getAdapter(plugin, path);
        if (adapter != null) {
            adapter.fireNotifyChanged((Notification)new ViewerNotification(msg, (Object)adapter, true, false));
        }
    }

    public static void refreshAdapter(String[] path, Notification notification) {
        EObject eObj = null;
        switch (notification.getEventType()) {
            case 3: {
                eObj = (EObject)notification.getNewValue();
                break;
            }
            case 5: {
                eObj = (EObject)new ArrayList((Collection)notification.getNewValue()).get(0);
                break;
            }
            case 4: {
                eObj = (EObject)notification.getOldValue();
                break;
            }
            case 6: {
                eObj = (EObject)new ArrayList((Collection)notification.getOldValue()).get(0);
            }
        }
        if (eObj != null) {
            MethodPlugin plugin = UmaUtil.getMethodPlugin((EObject)eObj);
            TngUtil.refreshAdapter(plugin, path, notification);
        }
    }

    public static void refreshUncategorizedTasksItemProvider(MethodPlugin plugin, Notification msg) {
        TngUtil.refreshAdapter(plugin, LibraryEditConstants.UNCATEGORIZED_TASKS_PATH, msg);
    }

    public static void refreshDomainUncategorizedWorkProductsItemProvider(MethodPlugin plugin, Notification msg) {
        TngUtil.refreshAdapter(plugin, LibraryEditConstants.UNCATEGORIZED_DOMAIN_WORKPRODUCTS_PATH, msg);
    }

    public static void refreshWorkProductTypeUncategorized(MethodPlugin plugin, Notification msg) {
        TngUtil.refreshAdapter(plugin, LibraryEditConstants.UNCATEGORIZED_WORKPRODUCTTYPE_WORKPRODUCTS_PATH, msg);
    }

    public static void refreshUncategorizedWorkProductsItemProviders(MethodPlugin plugin, Notification msg) {
        TngUtil.refreshDomainUncategorizedWorkProductsItemProvider(plugin, msg);
        TngUtil.refreshWorkProductTypeUncategorized(plugin, msg);
    }

    public static void refreshUncategorizedRolesItemProvider(MethodPlugin plugin, Notification msg) {
        TngUtil.refreshAdapter(plugin, LibraryEditConstants.UNCATEGORIZED_ROLES_PATH, msg);
    }

    public static void refreshUncategorizedToolMentorsItemProvider(MethodPlugin plugin, Notification msg) {
        TngUtil.refreshAdapter(plugin, LibraryEditConstants.UNCATEGORIZED_TOOLMENTORS_PATH, msg);
    }

    public static Object createWrapper(AdapterFactory adapterFactory, EObject object, EStructuralFeature feature, Object value, int index) {
        if (FeatureMapUtil.isFeatureMap((EStructuralFeature)feature)) {
            value = new FeatureMapEntryWrapperItemProvider((FeatureMap.Entry)value, object, (EAttribute)feature, index, adapterFactory);
        } else if (feature instanceof EAttribute) {
            value = new AttributeValueWrapperItemProvider(value, object, (EAttribute)feature, index, adapterFactory);
        } else if (!((EReference)feature).isContainment()) {
            value = new FeatureValueWrapperItemProvider(feature, value, object, adapterFactory);
        }
        return value;
    }

    public static Object getNavigatorParentItemProvider(Guidance guidance) {
        ContentPackageItemProvider itemProvider;
        EObject container = guidance.eContainer();
        if (!(container instanceof ContentPackage)) {
            return null;
        }
        Class<?> clazz = class$10;
        if (clazz == null) {
            try {
                clazz = class$10 = Class.forName("org.eclipse.epf.library.edit.element.ContentPackageItemProvider");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return (itemProvider = (ContentPackageItemProvider)TngUtil.getAdapter(container, clazz)) != null ? itemProvider.getGuidances() : null;
    }

    public static Object getNavigatorParentItemProvider(WorkProduct object) {
        ContentPackageItemProvider itemProvider;
        EObject contentPkg = object.eContainer();
        if (contentPkg == null) {
            return null;
        }
        Class<?> clazz = class$10;
        if (clazz == null) {
            try {
                clazz = class$10 = Class.forName("org.eclipse.epf.library.edit.element.ContentPackageItemProvider");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return (itemProvider = (ContentPackageItemProvider)TngUtil.getAdapter(contentPkg, clazz)) != null ? itemProvider.getWorkProducts() : null;
    }

    public static Object getColumnImage(Object object, String colName) {
        if (colName == "presentation_name") {
            Object adapter;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.emf.edit.provider.ITreeItemContentProvider");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((adapter = umaItemProviderAdapterFactory.adapt(object, (Object)clazz)) instanceof IItemLabelProvider) {
                return ((IItemLabelProvider)adapter).getImage(object);
            }
        }
        return null;
    }

    public static void moveUp(Activity activity, Object elementObj, Collection eClasses, IActionManager actionMgr) {
        MoveUpCommand cmd = new MoveUpCommand(activity, elementObj, eClasses);
        actionMgr.execute(cmd);
    }

    public static void moveDown(Activity activity, Object elementObj, Collection eClasses, IActionManager actionMgr) {
        MoveDownCommand cmd = new MoveDownCommand(activity, elementObj, eClasses);
        actionMgr.execute(cmd);
    }

    public static CustomCategory createRootCustomCategory(ContentPackage customCategoryPkg) {
        CustomCategory rootCustomCategory = UmaFactory.eINSTANCE.createCustomCategory();
        rootCustomCategory.setName(LibraryEditPlugin.INSTANCE.getString("_UI_Custom_Categories_group"));
        ContentPackage hiddenPkg = UmaUtil.findContentPackage((List)customCategoryPkg.getChildPackages(), (String)"Hidden");
        if (hiddenPkg == null) {
            hiddenPkg = UmaFactory.eINSTANCE.createContentPackage();
            hiddenPkg.setName("Hidden");
            customCategoryPkg.getChildPackages().add(hiddenPkg);
        }
        hiddenPkg.getContentElements().add(rootCustomCategory);
        return rootCustomCategory;
    }

    public static CustomCategory getRootCustomCategory(MethodPlugin plugin) {
        ContentPackage customCategoryPkg = UmaUtil.findContentPackage((MethodPlugin)plugin, (String[])ModelStructure.DEFAULT.customCategoryPath);
        if (customCategoryPkg == null) {
            return null;
        }
        ContentPackage hiddenPkg = UmaUtil.findContentPackage((List)customCategoryPkg.getChildPackages(), (String)"Hidden");
        if (hiddenPkg != null && !hiddenPkg.getContentElements().isEmpty()) {
            return (CustomCategory)hiddenPkg.getContentElements().get(0);
        }
        CustomCategory root = TngUtil.createRootCustomCategory(customCategoryPkg);
        Iterator iter = customCategoryPkg.getContentElements().iterator();
        while (iter.hasNext()) {
            Object element = iter.next();
            if (!(element instanceof CustomCategory)) continue;
            root.getCategorizedElements().add(element);
        }
        return root;
    }

    public static boolean isRootCustomCategory(CustomCategory category) {
        EObject pkg = category.eContainer();
        return pkg instanceof ContentPackage && "Hidden".equals(((ContentPackage)pkg).getName());
    }

    public static void saveContainerResource(EObject element, IMethodLibraryPersister persister) {
        Resource resource;
        if (element.eContainer() != null && (resource = element.eContainer().eResource()) != null && resource.isModified()) {
            try {
                persister.save(resource);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static ContentCategory findContributor(ContentPackage categoryPkg, ContentCategory baseCategory) {
        Iterator iter = categoryPkg.getContentElements().iterator();
        while (iter.hasNext()) {
            ContentCategory cat = (ContentCategory)iter.next();
            if (cat.getVariabilityBasedOnElement() != baseCategory) continue;
            return cat;
        }
        return null;
    }

    public static boolean isEmpty(ContentCategory category) {
        if (!category.getConceptsAndPapers().isEmpty() || !category.getSupportingMaterials().isEmpty()) {
            return false;
        }
        if (category instanceof Discipline) {
            return ((Discipline)category).getTasks().isEmpty();
        }
        if (category instanceof Domain) {
            return ((Domain)category).getWorkProducts().isEmpty();
        }
        if (category instanceof RoleSet) {
            return ((RoleSet)category).getRoles().isEmpty();
        }
        if (category instanceof Tool) {
            return ((Tool)category).getToolMentors().isEmpty();
        }
        if (category instanceof WorkProductType) {
            return ((WorkProductType)category).getWorkProducts().isEmpty();
        }
        if (category instanceof CustomCategory) {
            CustomCategory userDefinedCategory = (CustomCategory)category;
            return userDefinedCategory.getCategorizedElements().isEmpty();
        }
        throw new IllegalArgumentException("Unknown category: " + category);
    }

    private static void addToPackage(WorkOrder order, BreakdownElement e) {
        ((ProcessPackage)e.eContainer()).getProcessElements().add(order);
    }

    private static void removeFromPackage(WorkOrder order, BreakdownElement e) {
        ((ProcessPackage)e.eContainer()).getProcessElements().remove(order);
    }

    public static boolean handlePredecessorListChange(ItemProviderAdapter adapter, Notification notification) {
        Class<?> clazz = class$11;
        if (clazz == null) {
            try {
                clazz = class$11 = Class.forName("com.ibm.uma.BreakdownElement");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        switch (notification.getFeatureID((Class)clazz)) {
            case 21: {
                switch (notification.getEventType()) {
                    case 3: {
                        TngUtil.addToPackage((WorkOrder)notification.getNewValue(), (BreakdownElement)notification.getNotifier());
                        break;
                    }
                    case 5: {
                        Iterator iter = ((Collection)notification.getNewValue()).iterator();
                        while (iter.hasNext()) {
                            TngUtil.addToPackage((WorkOrder)iter.next(), (BreakdownElement)notification.getNotifier());
                        }
                        break;
                    }
                    case 4: {
                        TngUtil.removeFromPackage((WorkOrder)notification.getOldValue(), (BreakdownElement)notification.getNotifier());
                        break;
                    }
                    case 6: {
                        Iterator iter = ((Collection)notification.getOldValue()).iterator();
                        while (iter.hasNext()) {
                            TngUtil.removeFromPackage((WorkOrder)iter.next(), (BreakdownElement)notification.getNotifier());
                        }
                        break;
                    }
                }
                adapter.fireNotifyChanged((Notification)new ViewerNotification(notification, notification.getNotifier(), false, true));
                return true;
            }
        }
        return false;
    }

    public static List getGlobalPackages(MethodPlugin plugin) {
        ArrayList<ContentPackage> packages = new ArrayList<ContentPackage>();
        String[][] categoryPaths = ModelStructure.DEFAULT.getCategoryPaths();
        int i = 0;
        while (i < categoryPaths.length) {
            String[] path = categoryPaths[i];
            ContentPackage categoryPkg = UmaUtil.findContentPackage((MethodPlugin)plugin, (String[])path);
            if (categoryPkg != null) {
                packages.add(categoryPkg);
            }
            ++i;
        }
        return packages;
    }

    public static List getAllSystemPackages(MethodPlugin plugin) {
        ContentPackage hiddenPkg;
        ArrayList<Object> packages = new ArrayList<Object>();
        String[][] paths = ModelStructure.DEFAULT.getAllSystemPaths();
        int i = 0;
        while (i < paths.length) {
            String[] path = paths[i];
            MethodPackage pkg = UmaUtil.findMethodPackage((MethodPlugin)plugin, (String[])path);
            if (pkg != null && !packages.contains(pkg)) {
                packages.add(pkg);
                EObject o = pkg.eContainer();
                while (o instanceof MethodPackage && !packages.contains(o)) {
                    packages.add(o);
                    o = o.eContainer();
                }
            }
            ++i;
        }
        ContentPackage customCategoryPkg = UmaUtil.findContentPackage((MethodPlugin)plugin, (String[])ModelStructure.DEFAULT.customCategoryPath);
        if (customCategoryPkg != null && (hiddenPkg = UmaUtil.findContentPackage((List)customCategoryPkg.getChildPackages(), (String)"Hidden")) != null) {
            packages.add(hiddenPkg);
        }
        return packages;
    }

    public static boolean isPredefined(MethodElement e) {
        if (e instanceof CustomCategory && TngUtil.isRootCustomCategory((CustomCategory)e)) {
            return true;
        }
        String path = ModelStructure.toFilePath(Misc.getPathRelativeToPlugin((NamedElement)e));
        Iterator iter = ModelStructure.ALL_PREDEFINED_PATHS.iterator();
        while (iter.hasNext()) {
            String predefinePath = (String)iter.next();
            if (!predefinePath.startsWith(path)) continue;
            return true;
        }
        return false;
    }

    public static Object getWrapper(Collection wrappers, Object value) {
        if (wrappers == null) {
            return null;
        }
        Iterator iter = wrappers.iterator();
        while (iter.hasNext()) {
            IWrapperItemProvider wrapper = (IWrapperItemProvider)iter.next();
            if (wrapper.getValue() != value) continue;
            return wrapper;
        }
        return null;
    }

    public static MethodPackage getMethodPackage(EObject e) {
        while (!(e instanceof MethodPackage) && e != null) {
            e = e.eContainer();
        }
        return (MethodPackage)e;
    }

    private static boolean addTo(MethodConfiguration config, EObject object, Set addedObjects) {
        MethodPackage pkg = TngUtil.getMethodPackage(object);
        if (pkg != null && !config.getMethodPackageSelection().contains(pkg)) {
            config.getMethodPackageSelection().add(pkg);
            addedObjects.add(pkg);
            MethodPlugin plugin = UmaUtil.getMethodPlugin((EObject)pkg);
            if (config.getMethodPluginSelection().contains(plugin)) {
                config.getMethodPluginSelection().add(plugin);
                addedObjects.add(plugin);
            }
            return true;
        }
        return false;
    }

    public static boolean addToConfiguration(MethodConfiguration config, EObject object, Set addedObjects) {
        int size = addedObjects.size();
        TngUtil.addTo(config, object, addedObjects);
        if (object instanceof VariabilityElement) {
            VariabilityElement c = ((VariabilityElement)object).getVariabilityBasedOnElement();
            while (c != null) {
                TngUtil.addTo(config, (EObject)c, addedObjects);
                c = c.getVariabilityBasedOnElement();
            }
        }
        return addedObjects.size() > size;
    }

    public static IStatus checkEdit(EObject eObj, Object context) {
        if (((InternalEObject)eObj).eProxyURI() != null) {
            String location;
            URI containerURI;
            EObject proxy = eObj;
            String uri = ((InternalEObject)proxy).eProxyURI().toString();
            URI uRI = containerURI = proxy.eContainer() != null ? proxy.eContainer().eResource().getURI() : null;
            if (containerURI != null) {
                String string = location = containerURI != null ? containerURI.toFileString() : "";
                if (location.length() != 0) {
                    location = MessageFormat.format(" in ''{0}''", location);
                }
            } else {
                location = "";
            }
            String msg = MessageFormat.format(LibraryEditResources.getString("LibraryEdit.unresolvedObjectError.reason"), proxy.eClass().getName(), uri, location);
            return new Status(4, LibraryEditPlugin.INSTANCE.getSymbolicName(), 0, msg, null);
        }
        if (eObj.eResource() == null) {
            return new Status(0, LibraryEditPlugin.INSTANCE.getSymbolicName(), 0, "", null);
        }
        String path = eObj.eResource().getURI().toFileString();
        return ContentDescriptionFactory.getFileManager().checkModify(path, context);
    }

    public static String getMessage(IStatus status) {
        String msg = status.getMessage();
        if (status.isMultiStatus()) {
            StringBuffer strBuf = new StringBuffer(msg);
            IStatus[] statuses = status.getChildren();
            int i = 0;
            while (i < statuses.length) {
                strBuf.append('\n').append(statuses[i].getMessage());
                ++i;
            }
            msg = strBuf.toString();
        }
        if (msg == null || msg.length() == 0) {
            msg = LibraryEditResources.getString("LibraryEdit.util.tngutil.cannot_edit_resource");
        }
        return msg;
    }

    public static boolean isContributor(VariabilityElement ve) {
        if (ve.getVariabilityBasedOnElement() == null) {
            return false;
        }
        return ve.getVariabilityType() == VariabilityType.CONTRIBUTES_LITERAL;
    }

    public static boolean isGeneralizer(Object obj, Collection types) {
        if (!(obj instanceof VariabilityElement)) {
            return false;
        }
        VariabilityElement ve = (VariabilityElement)obj;
        if (ve.getVariabilityBasedOnElement() == null) {
            return false;
        }
        if (types == null) {
            return true;
        }
        return types.contains(ve.getVariabilityType());
    }

    public static String getTypeText(String typeKey) {
        try {
            return UmaEditPlugin.INSTANCE.getString("_UI_" + typeKey + "_type");
        }
        catch (MissingResourceException missingResourceException) {
            return UmaEditPlugin.INSTANCE.getString("_UI_Unknown_type");
        }
    }

    public static String getTypeText(EObject element) {
        String typeKey = element.eClass().getName();
        try {
            return UmaEditPlugin.INSTANCE.getString("_UI_" + typeKey + "_type");
        }
        catch (MissingResourceException missingResourceException) {
            return UmaEditPlugin.INSTANCE.getString("_UI_Unknown_type");
        }
    }

    public static String getFeatureText(Object feature) {
        if (feature instanceof EStructuralFeature) {
            return TngUtil.getFeatureText((EStructuralFeature)feature);
        }
        return "Unknown";
    }

    public static boolean isLocked(EObject object) {
        MethodPlugin plugin = UmaUtil.getMethodPlugin((EObject)object);
        if (plugin == null) {
            return false;
        }
        return plugin.getUserChangeable() == false;
    }

    public static boolean checkExist(Collection wrappers, Object e) {
        Iterator iterator = wrappers.iterator();
        while (iterator.hasNext()) {
            Object element = TngUtil.unwrap(iterator.next());
            if (element != e) continue;
            return true;
        }
        return false;
    }

    public static EStructuralFeature getContainingFeature(Object object, AdapterFactory adapterFactory) {
        ITreeItemContentProvider adapter;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.emf.edit.provider.ITreeItemContentProvider");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((adapter = (ITreeItemContentProvider)adapterFactory.adapt(object, (Object)clazz)) == null) {
            return null;
        }
        Object parent = adapter.getParent(object);
        if (!(parent instanceof EObject)) {
            return null;
        }
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("org.eclipse.emf.edit.provider.ITreeItemContentProvider");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((adapter = (ITreeItemContentProvider)adapterFactory.adapt(parent, (Object)clazz2)) instanceof MethodElementItemProvider) {
            EObject parentEObj = (EObject)parent;
            Iterator iter = ((MethodElementItemProvider)adapter).getChildrenFeatures(parent).iterator();
            while (iter.hasNext()) {
                EStructuralFeature f = (EStructuralFeature)iter.next();
                if (!(f.isMany() ? ((Collection)parentEObj.eGet(f)).contains(object) : parentEObj.eGet(f) == object)) continue;
                return f;
            }
        }
        return null;
    }

    public static String getFeatureText(EStructuralFeature feature) {
        String featureKey;
        switch (feature.getFeatureID()) {
            case 25: {
                return LibraryEditResources.getString("LibraryEdit.assists.text");
            }
        }
        if (feature instanceof EStructuralFeature) {
            EStructuralFeature eFeature = feature;
            featureKey = String.valueOf(eFeature.getEContainingClass().getName()) + "_" + eFeature.getName();
        } else {
            featureKey = LibraryEditResources.getString("LibraryEdit.unknown.text");
        }
        return UmaEditPlugin.INSTANCE.getString("_UI_" + featureKey + "_feature");
    }

    public static File getLibraryRootPath(EObject element) {
        EObject parent = element;
        while (parent != null && !(parent instanceof MethodLibrary)) {
            parent = parent.eContainer();
        }
        if (parent != null && parent.eResource() != null) {
            URI uri = parent.eResource().getURI();
            String path = uri.toFileString();
            File f = new File(path);
            return f.getParentFile();
        }
        return null;
    }

    public static java.net.URI getFullPathURI(EObject o, java.net.URI uri) {
        if (uri == null) {
            return uri;
        }
        try {
            URL url = uri.toURL();
            if (url != null) {
                return uri;
            }
        }
        catch (Exception exception) {}
        File f = TngUtil.getLibraryRootPath(o);
        if (f != null) {
            return new File(f, NetUtil.decodedFileUrl((String)uri.toString())).toURI();
        }
        return uri;
    }

    public static String toStackTraceString(Throwable e) {
        StringWriter strWriter = new StringWriter();
        e.printStackTrace(new PrintWriter(strWriter));
        return strWriter.toString();
    }

    public static String getLabelWithPath(Object object) {
        if (object instanceof BreakdownElement) {
            return ProcessUtil.getLabelWithPath((BreakdownElement)object);
        }
        if (object instanceof ContentDescription) {
            return TngUtil.getLabelWithPath(((ContentDescription)object).eContainer());
        }
        String[] str = Misc.getPathRelativeToPlugin((NamedElement)object);
        StringBuffer path = new StringBuffer(TngUtil.getLabel(object));
        if (object instanceof ContentElement && MethodElementUtil.getMethodModel(object) != null) {
            path.append(", ").append(MethodElementUtil.getMethodModel(object).getName());
            int i = 0;
            while (i < str.length) {
                String s = str[i];
                if (!("CoreContent".equals(s) || "Content".equalsIgnoreCase(s) || ((NamedElement)object).getName().equals(s))) {
                    path.append('/').append(s);
                }
                ++i;
            }
        }
        return path.toString();
    }

    public static EObject getOwner(Command command) {
        Object o;
        command = TngUtil.unwrap(command);
        EObject owner = null;
        if (command instanceof AddCommand) {
            owner = ((AddCommand)command).getOwner();
        } else if (command instanceof RemoveCommand) {
            owner = ((RemoveCommand)command).getOwner();
        } else if (command instanceof SetCommand) {
            owner = ((SetCommand)command).getOwner();
        } else if (command instanceof MoveCommand) {
            owner = ((MoveCommand)command).getOwner();
        } else if (command instanceof PasteFromClipboardCommand && (o = ((PasteFromClipboardCommand)command).getOwner()) instanceof EObject) {
            owner = (EObject)o;
        }
        return owner;
    }

    public static List convertTemplateAttachmentsToList(String attachmentString) {
        ArrayList<String> attachments = new ArrayList<String>();
        if (attachmentString == null) {
            attachmentString = "";
        }
        String[] files = attachmentString.split(TEMPLATE_FILESTRING_SEPARATOR_SPLITTER);
        int i = 0;
        while (i < files.length) {
            if (files[i].trim().length() > 0) {
                attachments.add(files[i]);
            }
            ++i;
        }
        return attachments;
    }

    public static String convertTemplateAttachmentsToString(List attachmentList) {
        String attachmentString = "";
        int i = 0;
        Iterator iter = attachmentList.iterator();
        while (iter.hasNext()) {
            String attachment = (String)iter.next();
            if (i++ > 0) {
                attachmentString = attachmentString.concat(TEMPLATE_FILESTRING_SEPARATOR);
            }
            attachmentString = attachmentString.concat(attachment);
        }
        return attachmentString;
    }

    public static boolean contains(Collection elements, Object e) {
        Iterator iter = elements.iterator();
        while (iter.hasNext()) {
            Object element = iter.next();
            if (element != e && e != TngUtil.unwrap(element)) continue;
            return true;
        }
        return false;
    }
}

