/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.edit.validation.internal;

import java.util.Collection;
import java.util.Iterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.epf.common.utils.StrUtil;
import org.eclipse.epf.library.edit.IFilter;
import org.eclipse.epf.library.edit.LibraryEditResources;
import org.eclipse.epf.library.edit.util.TngUtil;
import org.eclipse.epf.library.edit.validation.IValidator;

public class UniquenessValidator
implements IValidator {
    protected EObject object;
    private EStructuralFeature feature;
    private String featureName;
    private EStructuralFeature containingFeature;
    private IFilter childFilter;
    protected EObject container;

    public UniquenessValidator(EObject container, EStructuralFeature containingFeature, IFilter childFilter, EObject obj, EStructuralFeature feature) {
        this(container, containingFeature, childFilter, obj, feature, TngUtil.getFeatureText(feature).toLowerCase());
    }

    public UniquenessValidator(EObject container, EStructuralFeature containingFeature, IFilter childFilter, EObject obj, EStructuralFeature feature, String featureName) {
        this.container = container;
        this.object = obj;
        this.containingFeature = containingFeature;
        this.childFilter = childFilter;
        this.feature = feature;
        this.featureName = featureName;
    }

    public String isValid(String newText) {
        if (this.container == null) {
            return null;
        }
        if (StrUtil.isBlank((String)(newText = newText.trim()))) {
            return LibraryEditResources.formatString("LibraryEdit.emptyElementNameError.msg", this.featureName);
        }
        Object children = this.containingFeature == null ? this.container.eContents() : (Collection)this.container.eGet(this.containingFeature);
        Iterator iter = children.iterator();
        while (iter.hasNext()) {
            String name;
            Object child = iter.next();
            if (child == this.object || !this.childFilter.accept(child) || !(name = (String)((EObject)child).eGet(this.feature)).equalsIgnoreCase(newText)) continue;
            return LibraryEditResources.formatString("LibraryEdit.duplicateElementNameError.msg", newText);
        }
        return null;
    }

    public EObject getEObject() {
        return this.object;
    }
}

