/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.persistence;

import com.ibm.uma.CapabilityPattern;
import com.ibm.uma.ContentDescription;
import com.ibm.uma.ContentElement;
import com.ibm.uma.DeliveryProcess;
import com.ibm.uma.DescribableElement;
import com.ibm.uma.MethodElement;
import com.ibm.uma.MethodLibrary;
import com.ibm.uma.MethodPlugin;
import com.ibm.uma.MethodUnit;
import com.ibm.uma.Process;
import com.ibm.uma.ProcessComponent;
import com.ibm.uma.ProcessContribution;
import com.ibm.uma.UmaPackage;
import com.ibm.uma.util.IMethodLibraryPersister;
import com.ibm.uma.util.UmaUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.CommonPlugin;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.epf.persistence.FileManager;
import org.eclipse.epf.persistence.MultiFileIOException;
import org.eclipse.epf.persistence.MultiFileResourceSetImpl;
import org.eclipse.epf.persistence.MultiFileSaveUtil;
import org.eclipse.epf.persistence.MultiFileXMIResourceImpl;
import org.eclipse.epf.persistence.TxRecord;
import org.eclipse.epf.persistence.util.PersistenceResources;

public class MethodLibraryPersister
implements IMethodLibraryPersister {
    public static final MethodLibraryPersister INSTANCE = new MethodLibraryPersister();
    public static final String RESOURCE_FOLDER = "resources";
    private static final List folderInfos = new ArrayList();
    private static final IMethodLibraryPersister.FailSafeMethodLibraryPersister nonFailSafePersister;

    static {
        folderInfos.add(new FolderInfo(UmaPackage.eINSTANCE.getGuidance(), false));
        folderInfos.add(new FolderInfo(UmaPackage.eINSTANCE.getWorkProduct(), true));
        folderInfos.add(new FolderInfo(UmaPackage.eINSTANCE.getActivity(), true));
        nonFailSafePersister = new NonFailSafePersister();
    }

    public void save(MethodElement e) {
        MultiFileSaveUtil.save(e, null);
        MethodLibrary lib = UmaUtil.getMethodLibrary((EObject)e);
        if (lib != null && lib.eResource() != null) {
            MultiFileResourceSetImpl resourceSet = (MultiFileResourceSetImpl)lib.eResource().getResourceSet();
            if (lib.eResource().isModified()) {
                try {
                    resourceSet.save(lib.eResource(), null);
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                }
            }
        }
    }

    public static String getCorrectPath(ContentDescription content) {
        return MethodLibraryPersister.getCorrectPath((DescribableElement)content.eContainer(), content);
    }

    private static String getCorrectPath(DescribableElement e, ContentDescription content) {
        if (e == null) {
            return null;
        }
        MethodPlugin plugin = UmaUtil.getMethodPlugin((EObject)e);
        if (plugin == null) {
            return null;
        }
        File pluginDir = new File(plugin.eResource().getURI().toFileString()).getParentFile();
        String folderPath = MethodLibraryPersister.staticGetFolderPath(e.eClass());
        String dir = pluginDir.getAbsolutePath() + File.separator + folderPath + File.separator;
        return MethodLibraryPersister.getNextAvailableFileName(dir, e, content);
    }

    static String getNextAvailableFileName(String dir, ContentDescription content) {
        return MethodLibraryPersister.getNextAvailableFileName(dir, (DescribableElement)content.eContainer(), content);
    }

    private static String getNextAvailableFileName(String dir, DescribableElement e, ContentDescription content) {
        String currentPath = null;
        if (content.eResource() != null) {
            currentPath = content.eResource().getURI().toFileString();
        }
        String path = dir + e.getName() + ".xmi";
        if (currentPath != null && currentPath.equals(path) || !new File(path).exists()) {
            return path;
        }
        int i = 2;
        while (true) {
            path = dir + e.getName() + ' ' + i + ".xmi";
            if (currentPath != null && currentPath.equals(path) || !new File(path).exists()) {
                return path;
            }
            ++i;
        }
    }

    private static String staticGetFolderPath(EClass eClazz) {
        int size = folderInfos.size();
        FolderInfo info = null;
        int i = 0;
        while (i < size) {
            FolderInfo folderInfo = (FolderInfo)folderInfos.get(i);
            if (folderInfo.eClazz.isSuperTypeOf(eClazz)) {
                info = folderInfo;
            }
            ++i;
        }
        if (info != null) {
            if (info.eClazz == eClazz || info.shared) {
                return info.name;
            }
            return info.name + File.separatorChar + MethodLibraryPersister.lowerAndPluralize(eClazz.getName());
        }
        return MethodLibraryPersister.lowerAndPluralize(eClazz.getName());
    }

    public static String lowerAndPluralize(String name) {
        if ((name = name.toLowerCase()).endsWith("children")) {
            return name;
        }
        if (name.endsWith("child")) {
            return String.valueOf(name) + "ren";
        }
        if (name.endsWith("data")) {
            return name;
        }
        if (name.endsWith("datum")) {
            return String.valueOf(name.substring(0, name.length() - 2)) + "a";
        }
        if (name.endsWith("by")) {
            return String.valueOf(name) + "s";
        }
        if (name.endsWith("y")) {
            return String.valueOf(name.substring(0, name.length() - 1)) + "ies";
        }
        if (name.endsWith("ex")) {
            return String.valueOf(name.substring(0, name.length() - 2)) + "ices";
        }
        if (name.endsWith("x")) {
            return String.valueOf(name) + "es";
        }
        if (name.endsWith("us")) {
            return String.valueOf(name.substring(0, name.length() - 2)) + "i";
        }
        if (name.endsWith("ss")) {
            return String.valueOf(name) + "es";
        }
        if (name.endsWith("s")) {
            return name;
        }
        return String.valueOf(name) + "s";
    }

    public static String getResourcePath(MethodElement e) {
        String folderPath = MethodLibraryPersister.getElementPath(e);
        if (folderPath == null || folderPath.equals("")) {
            return RESOURCE_FOLDER;
        }
        if (folderPath.endsWith(File.separator)) {
            return folderPath + RESOURCE_FOLDER;
        }
        return folderPath + File.separator + RESOURCE_FOLDER;
    }

    public static String getElementPath(MethodElement e) {
        String relPluginPath;
        MethodPlugin plugin = UmaUtil.getMethodPlugin((EObject)e);
        if (plugin == null) {
            return "";
        }
        if (plugin.eResource() != null) {
            Resource libRes = UmaUtil.getMethodLibrary((EObject)plugin).eResource();
            if (libRes == plugin.eResource()) {
                relPluginPath = plugin.getName();
            } else {
                URI uri = plugin.eResource().getURI();
                URI relUri = uri.deresolve(libRes.getURI());
                relPluginPath = relUri.trimSegments(1).toFileString();
            }
        } else {
            relPluginPath = plugin.getName();
        }
        String folderPath = MethodLibraryPersister.staticGetFolderRelativePath(e);
        return folderPath.length() == 0 ? relPluginPath : relPluginPath + File.separatorChar + folderPath + File.separatorChar;
    }

    public static void main(String[] args) {
        EClass eCls = UmaPackage.eINSTANCE.getTemplate();
        System.out.println(eCls.getName());
    }

    public void adjustLocation(Resource resource) {
        HashSet modifiedResources = new HashSet();
        MultiFileSaveUtil.adjustLocation(resource, modifiedResources);
        MultiFileResourceSetImpl resourceSet = (MultiFileResourceSetImpl)resource.getResourceSet();
        Iterator iter = modifiedResources.iterator();
        while (iter.hasNext()) {
            try {
                resourceSet.save((Resource)iter.next(), null);
            }
            catch (Exception e) {
                CommonPlugin.INSTANCE.log((Object)e);
            }
        }
    }

    public void save(Resource resource) throws Exception {
        MultiFileResourceSetImpl resourceSet = (MultiFileResourceSetImpl)resource.getResourceSet();
        resourceSet.save(resource, null);
    }

    protected void deleteFiles(MethodElement e, String path, ResourceSet resourceSet) {
        if (new File(path).isDirectory()) {
            Iterator iter = resourceSet.getResources().iterator();
            while (iter.hasNext()) {
                Resource res = (Resource)iter.next();
                MethodElement me = MultiFileSaveUtil.getMethodElement(res);
                if (me == null || !UmaUtil.isContainedBy((EObject)me, (Object)e)) continue;
                res.unload();
                iter.remove();
            }
        }
        FileManager.getInstance().delete(path);
    }

    protected void delete(MethodElement e, Set modifiedResources) {
        String path;
        if (!UmaUtil.hasDirectResource((EObject)e)) {
            return;
        }
        MultiFileXMIResourceImpl resource = (MultiFileXMIResourceImpl)e.eResource();
        MultiFileResourceSetImpl resourceSet = (MultiFileResourceSetImpl)resource.getResourceSet();
        Iterator iter = resource.getContents().iterator();
        while (iter.hasNext()) {
            Object element = iter.next();
            if (!(element instanceof MethodElement) || element == e) continue;
            resourceSet.removeURIMappings((EObject)e, modifiedResources);
            resource.getContents().remove((Object)e);
            modifiedResources.add(resource);
            return;
        }
        try {
            resourceSet.cleanUp((Resource)resource, modifiedResources);
        }
        catch (Exception e1) {
            CommonPlugin.INSTANCE.log((Object)e1);
        }
        if (MultiFileSaveUtil.hasOwnFolder(e)) {
            path = new File(resource.getFinalURI().toFileString()).getParent();
            Iterator iter2 = resourceSet.getResources().iterator();
            while (iter2.hasNext()) {
                Resource res = (Resource)iter2.next();
                MethodElement me = MultiFileSaveUtil.getMethodElement(res);
                if (me == null || !UmaUtil.isContainedBy((EObject)me, (Object)e)) continue;
                res.unload();
                iter2.remove();
            }
        } else {
            path = resource.getFinalURI().toFileString();
        }
        this.deleteFiles(e, path, (ResourceSet)resourceSet);
    }

    private static void getObjectsWithDirectResources(EObject e, Collection objectsWithDirectResources) {
        if (UmaUtil.hasDirectResource((EObject)e)) {
            objectsWithDirectResources.add(e);
        } else {
            Iterator iter = e.eContents().iterator();
            while (iter.hasNext()) {
                MethodLibraryPersister.getObjectsWithDirectResources((EObject)iter.next(), objectsWithDirectResources);
            }
        }
    }

    public void delete(MethodElement e) {
        ArrayList elements = new ArrayList();
        MethodLibraryPersister.getObjectsWithDirectResources((EObject)e, elements);
        if (!elements.isEmpty()) {
            HashSet modifiedResources = new HashSet();
            Iterator iter = elements.iterator();
            while (iter.hasNext()) {
                this.delete((MethodElement)iter.next(), modifiedResources);
            }
            iter = modifiedResources.iterator();
            while (iter.hasNext()) {
                Resource resource = (Resource)iter.next();
                try {
                    this.save(resource);
                }
                catch (Exception ex) {
                    throw new WrappedException(ex);
                }
            }
        }
    }

    private static String staticGetFolderRelativePath(MethodElement e) {
        if (e instanceof MethodPlugin) {
            return "";
        }
        if (e instanceof ContentElement) {
            return MethodLibraryPersister.staticGetFolderPath(e.eClass());
        }
        MethodUnit unit = UmaUtil.getMethodUnit((MethodElement)e);
        if (unit instanceof ProcessComponent) {
            Process proc = ((ProcessComponent)unit).getProcess();
            if (proc instanceof CapabilityPattern) {
                return "capabilitypatterns";
            }
            if (proc instanceof DeliveryProcess) {
                return "deliveryprocesses";
            }
            if (proc instanceof ProcessContribution) {
                return "processcontributions";
            }
        } else if (unit instanceof ContentDescription) {
            return MethodLibraryPersister.staticGetFolderRelativePath((MethodElement)unit.eContainer());
        }
        return "";
    }

    public String getFolderRelativePath(MethodElement e) {
        return MethodLibraryPersister.staticGetFolderRelativePath(e);
    }

    FailSafePersister getFailSafePersister(Map options) {
        FailSafePersister persister = new FailSafePersister();
        persister.saveOptions.putAll(options);
        persister.saveOptions.put("TX_RECORD", persister.txRecord);
        return persister;
    }

    public IMethodLibraryPersister.FailSafeMethodLibraryPersister getFailSafePersister() {
        return new FailSafePersister();
    }

    private static class FolderInfo {
        EClass eClazz;
        boolean shared;
        private String name;

        public FolderInfo(EClass clazz, boolean shared) {
            this.eClazz = clazz;
            this.shared = shared;
            this.name = MethodLibraryPersister.lowerAndPluralize(clazz.getName());
        }
    }

    static class FailSafePersister
    extends MethodLibraryPersister
    implements IMethodLibraryPersister.FailSafeMethodLibraryPersister {
        private Map saveOptions = new HashMap(MultiFileResourceSetImpl.DEFAULT_SAVE_OPTIONS);
        private TxRecord txRecord = new TxRecord();
        private Map elementToInfoMapToDeleteFiles;

        public FailSafePersister() {
            this.saveOptions.put("TX_RECORD", this.txRecord);
            this.elementToInfoMapToDeleteFiles = new HashMap();
        }

        Map getSaveOptions() {
            return this.saveOptions;
        }

        void checkMove(Resource resource) {
            MultiFileXMIResourceImpl mfResource = (MultiFileXMIResourceImpl)resource;
            if (mfResource.txStarted()) {
                throw new MultiFileIOException(PersistenceResources.formatString("Persistence.moveResourceError.msg", resource));
            }
        }

        public void save(Resource resource) throws Exception {
            MultiFileSaveUtil.checkModify(resource);
            MultiFileResourceSetImpl resourceSet = (MultiFileResourceSetImpl)resource.getResourceSet();
            resourceSet.save(resource, this.saveOptions);
        }

        public void adjustLocation(Resource resource) {
            this.checkMove(resource);
            HashSet modifiedResources = new HashSet();
            if (MultiFileSaveUtil.prepareAdjustLocation((MultiFileXMIResourceImpl)resource, modifiedResources)) {
                this.txRecord.getResourcesToCommit().add(resource);
                Iterator iter = modifiedResources.iterator();
                while (iter.hasNext()) {
                    try {
                        this.save((Resource)iter.next());
                    }
                    catch (Exception e) {
                        CommonPlugin.INSTANCE.log((Object)e);
                        throw new MultiFileIOException(e.toString());
                    }
                }
            }
            this.commit();
        }

        public void adjustLocation(Collection resources) {
            if (resources == null || resources.isEmpty()) {
                return;
            }
            Iterator iter = resources.iterator();
            while (iter.hasNext()) {
                this.checkMove((Resource)iter.next());
            }
            HashSet modifiedResources = new HashSet();
            Iterator iter2 = resources.iterator();
            while (iter2.hasNext()) {
                MultiFileXMIResourceImpl resource = (MultiFileXMIResourceImpl)((Object)iter2.next());
                if (!MultiFileSaveUtil.prepareAdjustLocation(resource, modifiedResources)) continue;
                this.txRecord.getResourcesToCommit().add(resource);
            }
            iter2 = modifiedResources.iterator();
            while (iter2.hasNext()) {
                try {
                    this.save((Resource)iter2.next());
                }
                catch (Exception e) {
                    CommonPlugin.INSTANCE.log((Object)e);
                    throw new MultiFileIOException(e.toString());
                }
            }
            this.commit();
        }

        protected void deleteFiles(MethodElement e, String path, ResourceSet resourceSet) {
            this.elementToInfoMapToDeleteFiles.put(e, new Object[]{path, resourceSet});
        }

        private void superDeleteFiles(MethodElement e, String path, ResourceSet resourceSet) {
            super.deleteFiles(e, path, resourceSet);
        }

        public void commit() {
            Iterator<Object> iter = this.txRecord.getResourcesToCommit().iterator();
            while (iter.hasNext()) {
                ((MultiFileXMIResourceImpl)((Object)iter.next())).commit();
            }
            iter = this.txRecord.getResourcesToCommit().iterator();
            while (iter.hasNext()) {
                ((MultiFileXMIResourceImpl)((Object)iter.next())).txFinished(true);
            }
            iter = this.txRecord.getResourcesToCommit().iterator();
            while (iter.hasNext()) {
                ((MultiFileXMIResourceImpl)((Object)iter.next())).deleteBackup();
            }
            this.txRecord.clear();
            iter = this.elementToInfoMapToDeleteFiles.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry entry = (Map.Entry)iter.next();
                try {
                    Object[] info = (Object[])entry.getValue();
                    this.superDeleteFiles((MethodElement)entry.getKey(), (String)info[0], (ResourceSet)info[1]);
                }
                catch (Exception e) {
                    CommonPlugin.INSTANCE.log((Object)e);
                }
            }
            this.elementToInfoMapToDeleteFiles.clear();
        }

        public void rollback() {
            if (!this.txRecord.getResourcesToCommit().isEmpty()) {
                try {
                    MultiFileXMIResourceImpl resource;
                    ArrayList<MultiFileXMIResourceImpl> restoredResources = new ArrayList<MultiFileXMIResourceImpl>();
                    Iterator iter = this.txRecord.getResourcesToCommit().iterator();
                    while (iter.hasNext()) {
                        resource = (MultiFileXMIResourceImpl)((Object)iter.next());
                        if (!resource.restore()) continue;
                        restoredResources.add(resource);
                    }
                    iter = restoredResources.iterator();
                    while (iter.hasNext()) {
                        resource = (MultiFileXMIResourceImpl)((Object)iter.next());
                        resource.setModified(true);
                    }
                    iter = this.txRecord.getResourcesToCommit().iterator();
                    while (iter.hasNext()) {
                        resource = (MultiFileXMIResourceImpl)((Object)iter.next());
                        URI uri = resource.getURI();
                        if (uri.equals((Object)resource.getFinalURI())) continue;
                        try {
                            FileManager.getInstance().delete(uri.toFileString());
                        }
                        catch (Exception e) {
                            CommonPlugin.INSTANCE.log((Object)e);
                        }
                    }
                    iter = this.txRecord.getResourcesToCommit().iterator();
                    while (iter.hasNext()) {
                        ((MultiFileXMIResourceImpl)((Object)iter.next())).txFinished(false);
                    }
                }
                catch (RuntimeException e) {
                    CommonPlugin.INSTANCE.log((Object)e);
                    throw e;
                }
            }
            this.txRecord.clear();
        }

        public IMethodLibraryPersister.FailSafeMethodLibraryPersister getFailSafePersister() {
            return this;
        }

        public String getCurrentTxID() {
            return this.txRecord.getTxID();
        }
    }

    public static class NonFailSafePersister
    extends MethodLibraryPersister
    implements IMethodLibraryPersister.FailSafeMethodLibraryPersister {
        public void commit() {
        }

        public void rollback() {
        }

        public String getCurrentTxID() {
            return null;
        }

        public void adjustLocation(Collection resources) {
            Iterator iter = resources.iterator();
            while (iter.hasNext()) {
                this.adjustLocation((Resource)iter.next());
            }
        }
    }
}

