/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.persistence;

import com.ibm.uma.ContentDescription;
import com.ibm.uma.ContentElement;
import com.ibm.uma.MethodElement;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.Map;
import org.eclipse.emf.common.CommonPlugin;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.xmi.XMLHelper;
import org.eclipse.emf.ecore.xmi.XMLLoad;
import org.eclipse.emf.ecore.xmi.XMLSave;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceImpl;
import org.eclipse.epf.persistence.FileManager;
import org.eclipse.epf.persistence.MethodLibraryPersister;
import org.eclipse.epf.persistence.MultiFileIOException;
import org.eclipse.epf.persistence.MultiFileResourceSetImpl;
import org.eclipse.epf.persistence.MultiFileSaveUtil;
import org.eclipse.epf.persistence.MultiFileXMIHelperImpl;
import org.eclipse.epf.persistence.MultiFileXMILoadImpl;
import org.eclipse.epf.persistence.MultiFileXMISaveImpl;
import org.eclipse.epf.persistence.util.PersistenceResources;
import org.eclipse.epf.resourcemanager.ResourceDescriptor;
import org.eclipse.epf.resourcemanager.ResourceManager;
import org.eclipse.epf.uma.ecore.impl.MultiResourceEObject;

public class MultiFileXMIResourceImpl
extends XMIResourceImpl {
    private URI finalURI;
    private URI oldURI;
    private String backupFile;
    private String currentTxID;

    public MultiFileXMIResourceImpl(URI uri) {
        super(uri);
        this.setIntrinsicIDToEObjectMap(new HashMap());
    }

    protected XMLLoad createXMLLoad() {
        return new MultiFileXMILoadImpl(this.createXMLHelper());
    }

    protected XMLSave createXMLSave() {
        return new MultiFileXMISaveImpl(this.createXMLHelper());
    }

    protected XMLHelper createXMLHelper() {
        return new MultiFileXMIHelperImpl(this);
    }

    public String getID(EObject eObject) {
        String id = MultiFileSaveUtil.getGuid(eObject);
        if (id != null) {
            return id;
        }
        return super.getID(eObject);
    }

    public void setID(EObject eObject, String id) {
        Object oldID = id != null ? this.getEObjectToIDMap().put(eObject, id) : this.getEObjectToIDMap().remove(eObject);
        Map guidToMethodElementMap = ((MultiFileResourceSetImpl)this.getResourceSet()).getGuidToMethodElementMap();
        if (oldID != null) {
            this.getIDToEObjectMap().remove(oldID);
            if (eObject instanceof MethodElement) {
                guidToMethodElementMap.remove(oldID);
            }
        }
        if (id != null) {
            this.getIDToEObjectMap().put(id, eObject);
            if (eObject instanceof MethodElement) {
                guidToMethodElementMap.put(id, eObject);
                MethodElement e = (MethodElement)eObject;
                if (!e.getGuid().equals(id)) {
                    e.setGuid(id);
                }
            }
        }
    }

    protected boolean useUUIDs() {
        return true;
    }

    public String getURIFragment(EObject eObject) {
        try {
            String id = this.getID(eObject);
            if (id != null) {
                return id;
            }
            ArrayList<String> uriFragmentPath = new ArrayList<String>();
            EObject container = eObject.eContainer();
            while (container != null && container.eResource() == this) {
                uriFragmentPath.add(((InternalEObject)container).eURIFragmentSegment(eObject.eContainingFeature(), eObject));
                eObject = container;
                container = eObject.eContainer();
            }
            StringBuffer result = new StringBuffer("/");
            result.append(this.getURIFragmentRootSegment(eObject));
            ListIterator i = uriFragmentPath.listIterator(uriFragmentPath.size());
            while (i.hasPrevious()) {
                result.append('/');
                result.append((String)i.previous());
            }
            return result.toString();
        }
        catch (RuntimeException e) {
            System.err.println("Error getting URI fragment for " + eObject);
            throw e;
        }
    }

    protected void attachedHelper(EObject eObject) {
        String id;
        super.attachedHelper(eObject);
        if (this.useIDs() && (id = this.getID(eObject)) != null) {
            this.getEObjectToIDMap().put(eObject, id);
            ((MultiFileResourceSetImpl)this.getResourceSet()).getGuidToMethodElementMap().put(id, eObject);
        }
        if (this.isTrackingModification() && eObject.eResource() != this) {
            eObject.eAdapters().remove((Object)this.modificationTrackingAdapter);
        }
    }

    private void attachedAllWithIDs(EObject eObj) {
        this.attachedHelper(eObj);
        EList list = eObj.eContents();
        int size = list.size();
        int i = 0;
        while (i < size) {
            EObject o = (EObject)list.get(i);
            if (o.eResource() == this) {
                this.attachedAllWithIDs(o);
            }
            ++i;
        }
    }

    private void basicAttachedAll(EObject eObj) {
        eObj.eAdapters().add((Object)this.modificationTrackingAdapter);
        EList list = eObj.eContents();
        int size = list.size();
        int i = 0;
        while (i < size) {
            EObject o = (EObject)list.get(i);
            if (o.eResource() == this) {
                this.basicAttachedAll(o);
            }
            ++i;
        }
    }

    public void attachedAll(EObject eObj) {
        if (this.useIDs()) {
            this.attachedAllWithIDs(eObj);
        } else {
            this.basicAttachedAll(eObj);
        }
    }

    public void attached(EObject eObject) {
        this.attachedAll(eObject);
    }

    private void detachedAllWithIDs(EObject eObj) {
        this.detachedHelper(eObj);
        EList list = eObj.eContents();
        int size = list.size();
        int i = 0;
        while (i < size) {
            EObject o = (EObject)list.get(i);
            if (o.eResource() == this) {
                this.detachedAllWithIDs(o);
            }
            ++i;
        }
    }

    private void basicDetachedAll(EObject eObj) {
        eObj.eAdapters().remove((Object)this.modificationTrackingAdapter);
        EList list = eObj.eContents();
        int size = list.size();
        int i = 0;
        while (i < size) {
            EObject o = (EObject)list.get(i);
            if (o.eResource() == this) {
                this.basicDetachedAll(o);
            }
            ++i;
        }
    }

    protected EObject getEObjectByID(String id) {
        EObject eObject;
        Iterator iter = this.getContents().iterator();
        while (iter.hasNext()) {
            EObject element = (EObject)iter.next();
            String guid = MultiFileSaveUtil.getGuid(element);
            if (guid == null || !guid.equals(id)) continue;
            return element;
        }
        if (this.idToEObjectMap != null && (eObject = (EObject)this.idToEObjectMap.get(id)) != null) {
            return eObject;
        }
        return null;
    }

    protected void doUnload() {
        EcoreUtil.ContentTreeIterator allContents = new EcoreUtil.ContentTreeIterator(new ArrayList(this.getContents())){

            protected Iterator getEObjectChildren(EObject eObject) {
                ArrayList<EObject> childrenOfSameResource = new ArrayList<EObject>();
                Resource resource = eObject.eResource();
                Iterator iter = eObject.eContents().iterator();
                while (iter.hasNext()) {
                    EObject element = (EObject)iter.next();
                    if (resource == null || resource != element.eResource()) continue;
                    childrenOfSameResource.add(element);
                }
                return childrenOfSameResource.iterator();
            }
        };
        if (!this.getContents().isEmpty()) {
            this.getContents().clear();
        }
        this.getErrors().clear();
        this.getWarnings().clear();
        while (allContents.hasNext()) {
            this.unloaded((InternalEObject)allContents.next());
        }
        if (this.idToEObjectMap != null) {
            Iterator iter = this.idToEObjectMap.keySet().iterator();
            while (iter.hasNext()) {
                ((MultiFileResourceSetImpl)this.getResourceSet()).getGuidToMethodElementMap().remove(iter.next());
            }
            this.idToEObjectMap.clear();
        }
        if (this.eObjectToIDMap != null) {
            this.eObjectToIDMap.clear();
        }
        if (this.eObjectToExtensionMap != null) {
            this.eObjectToExtensionMap.clear();
        }
        if (this.intrinsicIDToEObjectMap != null) {
            this.intrinsicIDToEObjectMap.clear();
        }
    }

    protected void unloaded(InternalEObject internalEObject) {
        Map oppositeFeatureMap;
        if (internalEObject instanceof MultiResourceEObject && (oppositeFeatureMap = ((MultiResourceEObject)internalEObject).basicGetOppositeFeatureMap()) != null) {
            oppositeFeatureMap.clear();
        }
        super.unloaded(internalEObject);
    }

    public void detachedAll(EObject eObj) {
        if (this.useIDs()) {
            this.detachedAllWithIDs(eObj);
        } else {
            this.basicDetachedAll(eObj);
        }
    }

    public void detached(EObject eObject) {
        this.detachedAll(eObject);
    }

    public Adapter getModificationTrackingAdapter() {
        return this.modificationTrackingAdapter;
    }

    public void setModified(boolean isModified) {
        this.isModified();
        super.setModified(isModified);
    }

    public boolean eDeliver() {
        ResourceSet resourceSet = this.getResourceSet();
        if (resourceSet != null && !resourceSet.eDeliver()) {
            return false;
        }
        return super.eDeliver();
    }

    public void save(Map options) throws IOException {
        if (options == null) {
            options = MultiFileResourceSetImpl.DEFAULT_SAVE_OPTIONS;
        }
        super.save(options);
    }

    public URI getFinalURI() {
        if (this.finalURI != null) {
            return this.finalURI;
        }
        return this.getURI();
    }

    public void setFinalURI(URI uri) {
        this.finalURI = uri;
    }

    public void backUpURI() {
        this.oldURI = this.getURI();
    }

    public void setTempURI(String txID) {
        if (this.finalURI == null) {
            this.finalURI = this.oldURI = this.getURI();
            this.currentTxID = txID;
            String dir = new File(this.finalURI.toFileString()).getParent();
            MethodElement e = MultiFileSaveUtil.getMethodElement((Resource)this);
            URI tempURI = URI.createFileURI((String)(String.valueOf(dir) + File.separator + txID + "new" + e.getGuid()));
            this.setURI(tempURI);
            MultiFileResourceSetImpl resourceSet = (MultiFileResourceSetImpl)this.getResourceSet();
            resourceSet.getURIToTempURIMap().put(this.oldURI, tempURI);
        }
    }

    private void restoreURI() {
        if (this.oldURI != null) {
            this.setURI(this.oldURI);
        }
    }

    public boolean txStarted() {
        return this.moveStarted() || this.saveStarted();
    }

    public void txFinished(boolean successful) {
        if (successful) {
            this.setURI(this.finalURI);
            this.setModified(false);
        } else {
            boolean wasMove;
            this.restoreURI();
            boolean bl = wasMove = !this.oldURI.equals((Object)this.finalURI);
            if (wasMove) {
                MultiFileSaveUtil.updateURIMappings(this, null);
            }
        }
        if (this.oldURI != null) {
            MultiFileResourceSetImpl resourceSet = (MultiFileResourceSetImpl)this.getResourceSet();
            if (resourceSet != null) {
                resourceSet.getURIToTempURIMap().remove(this.oldURI);
            }
            this.oldURI = null;
        }
        this.currentTxID = null;
        this.finalURI = null;
    }

    public void deleteBackup() {
        if (this.backupFile != null) {
            try {
                FileManager.getInstance().delete(this.backupFile);
                this.backupFile = null;
            }
            catch (Throwable e) {
                CommonPlugin.INSTANCE.log((Object)e);
            }
        }
    }

    public boolean restore() {
        File src = null;
        File dest = null;
        boolean moved = false;
        if (this.backupFile != null) {
            src = new File(this.backupFile);
            dest = new File(this.getFinalURI().toFileString());
        } else {
            boolean bl = moved = this.oldURI != null && !this.oldURI.equals((Object)this.finalURI);
            if (moved) {
                File file = new File(this.getFinalURI().toFileString());
                dest = new File(this.oldURI.toFileString());
                boolean bl2 = moved = file.exists() && !dest.exists();
                if (moved) {
                    src = file;
                }
            }
        }
        if (src != null) {
            if (dest.exists()) {
                FileManager.getInstance().move(dest.getPath(), this.getURI().toFileString());
            }
            if (MultiFileSaveUtil.move((Resource)this, src, dest)) {
                if (moved) {
                    MultiFileSaveUtil.updateURIMappings(this, null);
                }
                return true;
            }
            throw new MultiFileIOException(PersistenceResources.formatString("Persistence.restoreResourceError.msg", (Object)this));
        }
        return false;
    }

    URI getOldURI() {
        return this.oldURI;
    }

    boolean moveStarted() {
        return this.oldURI != null && !this.oldURI.equals((Object)this.getFinalURI());
    }

    boolean saveStarted() {
        return this.currentTxID != null;
    }

    public void commit() {
        if (this.finalURI != null && !this.getContents().isEmpty()) {
            File currentFile;
            boolean wasMove;
            File finalFile = new File(this.finalURI.toFileString());
            boolean bl = wasMove = !this.oldURI.equals((Object)this.finalURI);
            if (wasMove) {
                MethodElement e = MultiFileSaveUtil.getMethodElement((Resource)this);
                if (e instanceof ContentElement && finalFile.exists()) {
                    this.finalURI = URI.createFileURI((String)MethodLibraryPersister.getNextAvailableFileName(finalFile.getParent(), (ContentDescription)e));
                    finalFile = new File(this.finalURI.toFileString());
                }
            } else {
                String backup = this.getBackupFilePath();
                if (new File(backup).exists()) {
                    FileManager.getInstance().delete(backup);
                }
                if (finalFile.exists()) {
                    if (FileManager.getInstance().move(finalFile.getPath(), backup, true)) {
                        this.backupFile = backup;
                    } else {
                        String msg = PersistenceResources.formatString("Persistence.renameError.msg", finalFile, backup);
                        throw new MultiFileIOException(msg);
                    }
                }
            }
            if (!MultiFileSaveUtil.move((Resource)this, currentFile = new File(wasMove ? this.oldURI.toFileString() : this.getURI().toFileString()), finalFile)) {
                String msg = PersistenceResources.formatString("Persistence.renameError.msg", currentFile, finalFile);
                throw new MultiFileIOException(msg);
            }
            if (wasMove) {
                ResourceDescriptor desc;
                Object iter;
                ResourceDescriptor resDesc = MultiFileSaveUtil.getResourceDescriptor((Resource)this);
                if (resDesc != null) {
                    resDesc.clearResolvedURI();
                } else {
                    String msg = "FATAL ERROR: no ResourceDescriptor found in parent resource for " + (Object)((Object)this);
                    CommonPlugin.INSTANCE.log((Object)msg);
                    System.err.println(msg);
                }
                HashMap<URI, ResourceDescriptor> oldURIToResourceDescriptorMap = null;
                ResourceManager resMgr = MultiFileSaveUtil.getResourceManager((Resource)this);
                if (resMgr != null) {
                    oldURIToResourceDescriptorMap = new HashMap<URI, ResourceDescriptor>();
                    iter = resMgr.eAllContents();
                    while (iter.hasNext()) {
                        Object obj = iter.next();
                        if (!(obj instanceof ResourceDescriptor)) continue;
                        desc = (ResourceDescriptor)obj;
                        oldURIToResourceDescriptorMap.put(desc.getResolvedURI(), desc);
                        desc.clearResolvedURI();
                    }
                }
                if (oldURIToResourceDescriptorMap != null) {
                    iter = this.getResourceSet().getResources().iterator();
                    while (iter.hasNext()) {
                        Resource res = (Resource)iter.next();
                        desc = (ResourceDescriptor)oldURIToResourceDescriptorMap.get(res.getURI());
                        if (desc == null) continue;
                        res.setURI(desc.getResolvedURI());
                    }
                }
            }
        }
    }

    public String getBackupFilePath() {
        String dir = new File(this.finalURI.toFileString()).getParent();
        String backupFile = String.valueOf(dir) + File.separator + this.currentTxID + "old" + MultiFileSaveUtil.getMethodElement((Resource)this).getGuid();
        return backupFile;
    }

    static void clearDetachedEObjectToIDMap() {
        DETACHED_EOBJECT_TO_ID_MAP.clear();
    }
}

