/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.resources;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.internal.resources.CharsetDeltaJob;
import org.eclipse.core.internal.resources.IManager;
import org.eclipse.core.internal.resources.ResourceException;
import org.eclipse.core.internal.resources.ResourceStatus;
import org.eclipse.core.internal.resources.Workspace;
import org.eclipse.core.internal.utils.Assert;
import org.eclipse.core.internal.utils.Messages;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.core.runtime.jobs.Job;
import org.osgi.framework.Bundle;
import org.osgi.service.prefs.BackingStoreException;

public class CharsetManager
implements IManager {
    public static final String ENCODING_PREF_NODE = "encoding";
    private static final String PROJECT_KEY = "<project>";
    private CharsetDeltaJob charsetListener;
    CharsetManagerJob job;
    private IResourceChangeListener listener;
    protected final Bundle systemBundle = Platform.getBundle((String)"org.eclipse.osgi");
    Workspace workspace;

    public CharsetManager(Workspace workspace) {
        this.workspace = workspace;
    }

    public String getCharsetFor(IPath resourcePath, boolean recurse) {
        Assert.isLegal(resourcePath.segmentCount() >= 1);
        IProject project = this.workspace.getRoot().getProject(resourcePath.segment(0));
        org.osgi.service.prefs.Preferences encodingSettings = this.getPreferences(project, false);
        if (encodingSettings == null) {
            return recurse ? ResourcesPlugin.getEncoding() : null;
        }
        return this.internalGetCharsetFor(resourcePath, encodingSettings, recurse);
    }

    String getKeyFor(IPath resourcePath) {
        return resourcePath.segmentCount() > 1 ? resourcePath.removeFirstSegments(1).toString() : PROJECT_KEY;
    }

    org.osgi.service.prefs.Preferences getPreferences(IProject project, boolean create) {
        if (create) {
            return new ProjectScope(project).getNode("org.eclipse.core.resources").node(ENCODING_PREF_NODE);
        }
        org.osgi.service.prefs.Preferences node = Platform.getPreferencesService().getRootNode().node("project");
        try {
            if (!node.nodeExists(project.getName())) {
                return null;
            }
            if (!(node = node.node(project.getName())).nodeExists("org.eclipse.core.resources")) {
                return null;
            }
            if (!(node = node.node("org.eclipse.core.resources")).nodeExists(ENCODING_PREF_NODE)) {
                return null;
            }
            return node.node(ENCODING_PREF_NODE);
        }
        catch (BackingStoreException e) {
            String message = Messages.resources_readingEncoding;
            ResourcesPlugin.getPlugin().getLog().log((IStatus)new ResourceStatus(383, project.getFullPath(), message, e));
            return null;
        }
    }

    /*
     * Unable to fully structure code
     */
    private String internalGetCharsetFor(IPath resourcePath, org.osgi.service.prefs.Preferences encodingSettings, boolean recurse) {
        charset = encodingSettings.get(this.getKeyFor(resourcePath), null);
        if (recurse) ** GOTO lbl6
        return charset;
lbl-1000:
        // 1 sources

        {
            resourcePath = resourcePath.removeLastSegments(1);
            charset = encodingSettings.get(this.getKeyFor(resourcePath), null);
lbl6:
            // 2 sources

            ** while (charset == null && resourcePath.segmentCount() > 1)
        }
lbl7:
        // 1 sources

        return charset == null ? ResourcesPlugin.getEncoding() : charset;
    }

    public void projectPreferencesChanged(IProject project) {
        this.charsetListener.charsetPreferencesChanged(project);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setCharsetFor(IPath resourcePath, String newCharset) throws CoreException {
        if (resourcePath.segmentCount() == 0) {
            Preferences resourcesPreferences = ResourcesPlugin.getPlugin().getPluginPreferences();
            if (newCharset != null) {
                resourcesPreferences.setValue(ENCODING_PREF_NODE, newCharset);
            } else {
                resourcesPreferences.setToDefault(ENCODING_PREF_NODE);
            }
            ResourcesPlugin.getPlugin().savePluginPreferences();
            return;
        }
        IProject project = this.workspace.getRoot().getProject(resourcePath.segment(0));
        org.osgi.service.prefs.Preferences encodingSettings = this.getPreferences(project, true);
        if (newCharset == null || newCharset.trim().length() == 0) {
            encodingSettings.remove(this.getKeyFor(resourcePath));
        } else {
            encodingSettings.put(this.getKeyFor(resourcePath), newCharset);
        }
        try {
            try {
                this.charsetListener.setDisabled(true);
                encodingSettings.flush();
            }
            catch (BackingStoreException e) {
                String message = Messages.resources_savingEncoding;
                throw new ResourceException(382, project.getFullPath(), message, e);
            }
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            this.charsetListener.setDisabled(false);
            throw throwable;
        }
        {
            Object var7_10 = null;
            this.charsetListener.setDisabled(false);
            return;
        }
    }

    public void shutdown(IProgressMonitor monitor) {
        this.workspace.removeResourceChangeListener(this.listener);
        if (this.charsetListener != null) {
            this.charsetListener.shutdown();
        }
    }

    public void startup(IProgressMonitor monitor) {
        this.job = new CharsetManagerJob();
        this.listener = new Listener();
        this.workspace.addResourceChangeListener(this.listener, 1);
        this.charsetListener = new CharsetDeltaJob(this.workspace);
        this.charsetListener.startup();
    }

    private class CharsetManagerJob
    extends Job {
        private static final int CHARSET_UPDATE_DELAY = 500;
        private List asyncChanges = new ArrayList();

        public CharsetManagerJob() {
            super(Messages.resources_charsetUpdating);
            this.setSystem(true);
            this.setPriority(10);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addChanges(Set newChanges) {
            if (newChanges.isEmpty()) {
                return;
            }
            List list = this.asyncChanges;
            synchronized (list) {
                this.asyncChanges.addAll(newChanges);
                this.asyncChanges.notify();
            }
            this.schedule(500L);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public IProject getNextChange() {
            List list = this.asyncChanges;
            synchronized (list) {
                return this.asyncChanges.isEmpty() ? null : (IProject)this.asyncChanges.remove(this.asyncChanges.size() - 1);
            }
        }

        /*
         * Exception decompiling
         */
        protected IStatus run(IProgressMonitor monitor) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 8[TRYBLOCK] [4 : 256->262)] java.lang.Throwable
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean shouldRun() {
            List list = this.asyncChanges;
            synchronized (list) {
                return !this.asyncChanges.isEmpty();
            }
        }
    }

    class Listener
    implements IResourceChangeListener {
        Listener() {
        }

        private void processEntryChanges(IResourceDelta projectDelta, Set projectsToSave) {
            String[] affectedResources;
            boolean resourceChanges = false;
            IProject currentProject = (IProject)projectDelta.getResource();
            org.osgi.service.prefs.Preferences projectPrefs = CharsetManager.this.getPreferences(currentProject, false);
            if (projectPrefs == null) {
                return;
            }
            try {
                affectedResources = projectPrefs.keys();
            }
            catch (BackingStoreException e) {
                String message = Messages.resources_readingEncoding;
                ResourcesPlugin.getPlugin().getLog().log((IStatus)new ResourceStatus(383, currentProject.getFullPath(), message, e));
                return;
            }
            int i = 0;
            while (i < affectedResources.length) {
                IResourceDelta memberDelta = projectDelta.findMember((IPath)new Path(affectedResources[i]));
                if (memberDelta != null && memberDelta.getKind() == 2) {
                    resourceChanges = true;
                    String currentValue = projectPrefs.get(affectedResources[i], null);
                    projectPrefs.remove(affectedResources[i]);
                    if ((memberDelta.getFlags() & 0x2000) != 0) {
                        IProject targetProject = CharsetManager.this.workspace.getRoot().getProject(memberDelta.getMovedToPath().segment(0));
                        org.osgi.service.prefs.Preferences targetPrefs = CharsetManager.this.getPreferences(targetProject, true);
                        targetPrefs.put(CharsetManager.this.getKeyFor(memberDelta.getMovedToPath()), currentValue);
                        if (targetProject != currentProject) {
                            projectsToSave.add(targetProject);
                        }
                    }
                }
                ++i;
            }
            if (resourceChanges) {
                projectsToSave.add(currentProject);
            }
        }

        public void resourceChanged(IResourceChangeEvent event) {
            IResourceDelta delta = event.getDelta();
            if (delta == null) {
                return;
            }
            IResourceDelta[] projectDeltas = delta.getAffectedChildren();
            HashSet projectsToSave = new HashSet();
            int i = 0;
            while (i < projectDeltas.length) {
                if (projectDeltas[i].getKind() == 4 && (projectDeltas[i].getFlags() & 0x4000) == 0) {
                    this.processEntryChanges(projectDeltas[i], projectsToSave);
                }
                ++i;
            }
            CharsetManager.this.job.addChanges(projectsToSave);
        }
    }
}

