/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.configuration;

import com.ibm.uma.MethodConfiguration;
import com.ibm.uma.MethodLibrary;
import com.ibm.uma.MethodPlugin;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.epf.library.configuration.ConfigurationClosure;
import org.eclipse.epf.library.events.ILibraryChangeListener;
import org.eclipse.epf.library.layout.ElementLayoutManager;
import org.eclipse.epf.library.services.DependencyManager;
import org.eclipse.epf.library.services.LibraryProcessor;

public class ConfigurationFactory {
    protected AdapterFactoryContentProvider afcp = null;
    private Map configMap = new HashMap();
    private LibraryProcessor libraryProc = null;
    private String currentConfigName = null;
    private Map layoutMgrMap = new HashMap();
    private DependencyManager depMgr = null;

    public ConfigurationFactory(LibraryProcessor libraryProc) {
        this.libraryProc = libraryProc;
        this.afcp = new AdapterFactoryContentProvider((AdapterFactory)libraryProc.getAdapterFactory());
        libraryProc.addListener(new ILibraryChangeListener(){

            public void libraryChanged(int option, Collection collection) {
                if (option == 4 || option == 1) {
                    ConfigurationFactory.this.clear();
                }
            }
        });
        this.clear();
    }

    public void clear() {
        Iterator it;
        this.currentConfigName = null;
        if (this.configMap.size() > 0) {
            it = this.configMap.values().iterator();
            while (it.hasNext()) {
                ((ConfigurationClosure)it.next()).dispose();
            }
        }
        this.configMap.clear();
        if (this.layoutMgrMap.size() > 0) {
            it = this.layoutMgrMap.values().iterator();
            while (it.hasNext()) {
                ((ElementLayoutManager)it.next()).clear();
            }
        }
        this.layoutMgrMap.clear();
        if (this.depMgr != null) {
            this.depMgr.clear();
            this.depMgr = null;
        }
    }

    public MethodLibrary getLibrary() {
        return this.libraryProc.getLibrary();
    }

    public URI getLibraryUri() {
        return this.libraryProc.getLibraryURI();
    }

    public AdapterFactory getAdapterFactory() {
        return this.libraryProc.getAdapterFactory();
    }

    public AdapterFactoryContentProvider getContentProvider() {
        return this.afcp;
    }

    public DependencyManager getDependencyManager() {
        if (this.depMgr == null) {
            this.depMgr = new DependencyManager(this.libraryProc);
        }
        return this.depMgr;
    }

    public List getMethodPlugins() {
        ArrayList<EObject> items = new ArrayList<EObject>();
        EList elements = this.libraryProc.getLibrary().eContents();
        if (elements != null) {
            Iterator it = elements.iterator();
            while (it.hasNext()) {
                EObject element = (EObject)it.next();
                if (!(element instanceof MethodPlugin)) continue;
                items.add(element);
            }
        }
        return items;
    }

    public void setCurrentConfiguration(String configName) {
        this.currentConfigName = configName;
    }

    public String getCurrentConfiguration() {
        return this.currentConfigName;
    }

    public ElementLayoutManager getLayoutManager() {
        return this.getLayoutManager(this.currentConfigName);
    }

    public ElementLayoutManager getLayoutManager(String configName) {
        ElementLayoutManager mgr = null;
        if (configName == null) {
            mgr = this.libraryProc.getLayoutManager();
        } else {
            mgr = (ElementLayoutManager)this.layoutMgrMap.get(configName);
            if (mgr == null) {
                MethodConfiguration config = this.libraryProc.getConfiguration(configName);
                mgr = new ElementLayoutManager(config);
                this.layoutMgrMap.put(configName, mgr);
            }
        }
        return mgr;
    }

    public ConfigurationClosure getClosure() {
        return this.getClosure(this.currentConfigName);
    }

    public ConfigurationClosure getClosure(String configName) {
        ConfigurationClosure config = null;
        if (configName != null && (config = (ConfigurationClosure)this.configMap.get(configName)) == null) {
            MethodConfiguration modelConfig = this.libraryProc.getConfiguration(configName);
            config = new ConfigurationClosure(this, modelConfig);
            this.configMap.put(configName, config);
        }
        return config;
    }

    public void makeClosure() {
        ConfigurationClosure c = this.getClosure(this.currentConfigName);
        if (c != null) {
            c.makeClosure();
        }
    }
}

