/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.configuration;

import com.ibm.uma.MethodConfiguration;
import com.ibm.uma.MethodElement;
import com.ibm.uma.MethodPackage;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.provider.ItemProviderAdapter;
import org.eclipse.epf.library.configuration.ConfigurationHelper;
import org.eclipse.epf.library.configuration.ElementRealizer;
import org.eclipse.epf.library.edit.IConfigurator;
import org.eclipse.epf.library.services.SafeUpdateController;
import org.eclipse.epf.library.util.LibraryUtil;
import org.eclipse.jface.viewers.Viewer;

public class ConfigurationFilter
extends AdapterImpl
implements IConfigurator {
    protected MethodConfiguration methodConfig;
    private Viewer viewer;

    public ConfigurationFilter(MethodConfiguration methodConfig, Viewer viewer) {
        this.methodConfig = methodConfig;
        this.viewer = viewer;
    }

    public boolean accept(Object obj) {
        if (this.methodConfig == null) {
            return true;
        }
        if ((obj = LibraryUtil.unwrap(obj)) instanceof MethodPackage) {
            return this.methodConfig.getMethodPackageSelection().contains(obj);
        }
        if (obj instanceof MethodElement) {
            return ConfigurationHelper.canShow((MethodElement)obj, this.methodConfig);
        }
        if (obj instanceof ItemProviderAdapter) {
            return true;
        }
        System.out.println("Object filtered: " + (obj == null ? null : obj.toString()));
        return false;
    }

    public Collection getChildren(Object obj, EStructuralFeature childFeature) {
        if (this.methodConfig == null) {
            return null;
        }
        if (childFeature != null && childFeature.isMany() && obj instanceof MethodElement) {
            ElementRealizer realizer = new ElementRealizer(this.methodConfig);
            realizer.setDiscardContributor(true);
            List value = ConfigurationHelper.calc0nFeatureValue((MethodElement)obj, childFeature, this.methodConfig, realizer);
            return value;
        }
        return null;
    }

    public void notifyChanged(final Notification msg) {
        if (this.viewer == null) {
            return;
        }
        SafeUpdateController.syncExec(new Runnable(){

            public void run() {
                switch (msg.getEventType()) {
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: {
                        ConfigurationFilter.this.viewer.refresh();
                    }
                }
            }
        });
    }

    public MethodConfiguration getMethodConfiguration() {
        return this.methodConfig;
    }

    public void setMethodConfiguration(MethodConfiguration config) {
        this.methodConfig = config;
    }
}

