/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.configuration;

import com.ibm.uma.Activity;
import com.ibm.uma.MethodConfiguration;
import com.ibm.uma.MethodElement;
import com.ibm.uma.RoleDescriptor;
import com.ibm.uma.Task;
import com.ibm.uma.TaskDescriptor;
import com.ibm.uma.VariabilityElement;
import com.ibm.uma.WorkProductDescriptor;
import org.eclipse.epf.library.configuration.ConfigurationHelper;
import org.eclipse.epf.library.util.LibraryUtil;

public class ElementRealizer {
    private MethodConfiguration config;
    private boolean discardContributor = false;
    private boolean resolveContributor = true;
    private boolean resolveReplacer = true;

    public ElementRealizer(MethodConfiguration config) {
        this(config, true, true);
    }

    public ElementRealizer(MethodConfiguration config, boolean resolveContributor, boolean resolveReplacer) {
        this.config = config;
        this.resolveContributor = resolveContributor;
        this.resolveReplacer = resolveReplacer;
    }

    public void setDiscardContributor(boolean discardContributor) {
        this.discardContributor = discardContributor;
    }

    public void setResolveContributor(boolean resolveContributor) {
        this.resolveContributor = resolveContributor;
    }

    public void setResolveReplacer(boolean resolveReplacer) {
        this.resolveReplacer = resolveReplacer;
    }

    public MethodElement realize(MethodElement element) {
        if (element instanceof Activity) {
            if (ConfigurationHelper.canShow(element, this.config)) {
                return element;
            }
            return null;
        }
        if (element == null || !ConfigurationHelper.inConfig(element, this.config)) {
            return null;
        }
        Task linkedElement = null;
        if (element instanceof TaskDescriptor) {
            linkedElement = ((TaskDescriptor)element).getTask();
        } else if (element instanceof WorkProductDescriptor) {
            linkedElement = ((WorkProductDescriptor)element).getWorkProduct();
        } else if (element instanceof RoleDescriptor) {
            linkedElement = ((RoleDescriptor)element).getRole();
        }
        if (linkedElement != null && !ConfigurationHelper.inConfig((MethodElement)linkedElement, this.config)) {
            return null;
        }
        if (this.config == null) {
            return element;
        }
        if (element instanceof VariabilityElement) {
            VariabilityElement e;
            VariabilityElement ve = (VariabilityElement)element;
            if (this.discardContributor && ConfigurationHelper.isContributor(ve)) {
                return null;
            }
            if (this.resolveContributor) {
                while (ConfigurationHelper.isContributor(ve)) {
                    e = ve.getVariabilityBasedOnElement();
                    if (ConfigurationHelper.inConfig((MethodElement)e, this.config)) {
                        ve = e;
                        continue;
                    }
                    System.out.println("Configuration closure error: Base element '" + LibraryUtil.getTypeName((MethodElement)ve) + "' not in configuration");
                    break;
                }
            }
            if (this.resolveReplacer) {
                e = ConfigurationHelper.getReplacer(ve, this.config);
                if (e != null) {
                    return e;
                }
            } else if (!ConfigurationHelper.inConfig((MethodElement)ve, this.config)) {
                return null;
            }
            if (ConfigurationHelper.canShow((MethodElement)ve, this.config)) {
                return ve;
            }
            return null;
        }
        if (ConfigurationHelper.canShow(element, this.config)) {
            return element;
        }
        return null;
    }
}

