/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.layout;

import com.ibm.uma.Activity;
import com.ibm.uma.MethodConfiguration;
import com.ibm.uma.MethodElement;
import com.ibm.uma.TaskDescriptor;
import com.ibm.uma.WorkBreakdownElement;
import java.io.File;
import org.eclipse.epf.library.configuration.ConfigurationHelper;
import org.eclipse.epf.library.edit.IFilter;
import org.eclipse.epf.library.edit.TngAdapterFactory;
import org.eclipse.epf.library.edit.util.ConfigurableComposedAdapterFactory;
import org.eclipse.epf.library.layout.IElementLayout;
import org.eclipse.epf.library.layout.LayoutResources;
import org.eclipse.epf.library.layout.ProcessAdapterFactoryFilter;
import org.eclipse.epf.library.layout.diagram.IActivityDiagramService;
import org.eclipse.epf.library.layout.elements.AbstractElementLayout;
import org.eclipse.epf.library.layout.elements.GeneralLayout;
import org.eclipse.epf.library.services.LibraryProcessor;
import org.eclipse.epf.library.util.ResourceHelper;

public class ElementLayoutManager {
    private static final String PACKAGE_NAME;
    private static final String default_config_path = "noconfig";
    private String publish_dir = null;
    private MethodConfiguration config = null;
    private IActivityDiagramService diagramService = null;
    ConfigurableComposedAdapterFactory wbsAdapterFactory = null;
    ConfigurableComposedAdapterFactory tbsAdapterFactory = null;
    ConfigurableComposedAdapterFactory wpbsAdapterFactory = null;
    ConfigurableComposedAdapterFactory cbsAdapterFactory = null;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.epf.library.layout.ElementLayoutManager");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        PACKAGE_NAME = clazz.getPackage().getName();
    }

    public ElementLayoutManager() {
        this(null, null);
    }

    public ElementLayoutManager(MethodConfiguration config) {
        this(config, null);
    }

    public ElementLayoutManager(MethodConfiguration config, String publishdir) {
        if (config != null) {
            this.config = config;
        }
        if (publishdir == null) {
            publishdir = LayoutResources.getDefaultPublishDir();
            if (!publishdir.endsWith(File.separator)) {
                publishdir = String.valueOf(publishdir) + File.separator;
            }
            publishdir = this.config == null ? String.valueOf(publishdir) + default_config_path : String.valueOf(publishdir) + this.config.getName();
        }
        this.setPublishDir(publishdir);
        this.wbsAdapterFactory = (ConfigurableComposedAdapterFactory)TngAdapterFactory.INSTANCE.createWBSComposedAdapterFactory();
        this.tbsAdapterFactory = (ConfigurableComposedAdapterFactory)TngAdapterFactory.INSTANCE.createTBSComposedAdapterFactory();
        this.wpbsAdapterFactory = (ConfigurableComposedAdapterFactory)TngAdapterFactory.INSTANCE.createWPBSComposedAdapterFactory();
        this.cbsAdapterFactory = (ConfigurableComposedAdapterFactory)TngAdapterFactory.INSTANCE.createProcessComposedAdapterFactory();
        ProcessAdapterFactoryFilter configurator = new ProcessAdapterFactoryFilter(this);
        this.wbsAdapterFactory.setFilter((IFilter)configurator);
        this.tbsAdapterFactory.setFilter((IFilter)configurator);
        this.wpbsAdapterFactory.setFilter((IFilter)configurator);
        this.cbsAdapterFactory.setFilter((IFilter)configurator);
    }

    public ConfigurableComposedAdapterFactory getWBSAdapterFactory() {
        return this.wbsAdapterFactory;
    }

    public ConfigurableComposedAdapterFactory getTBSAdapterFactory() {
        return this.tbsAdapterFactory;
    }

    public ConfigurableComposedAdapterFactory getWPBSAdapterFactory() {
        return this.wpbsAdapterFactory;
    }

    public ConfigurableComposedAdapterFactory getCBSAdapterFactory() {
        return this.cbsAdapterFactory;
    }

    public void setActivityDiagramService(IActivityDiagramService diagramService) {
        this.diagramService = diagramService;
    }

    public IActivityDiagramService getActivityDiagramService() {
        return this.diagramService;
    }

    private IElementLayout createLayout(MethodElement element) {
        String className;
        AbstractElementLayout layout = null;
        if (ConfigurationHelper.isDescriptionElement(element)) {
            className = "ContentDescription";
        } else if (element instanceof Activity) {
            className = "Activity";
        } else if (element instanceof WorkBreakdownElement && !(element instanceof TaskDescriptor)) {
            className = "WorkBreakdownElement";
        } else {
            Class<?>[] i = element.getClass().getInterfaces();
            className = i != null && i.length == 1 ? i[0].getName() : element.getClass().getName();
            int index = className.lastIndexOf(".");
            if (index >= 0) {
                className = className.substring(index + 1);
            }
        }
        className = String.valueOf(PACKAGE_NAME) + ".elements." + className + "Layout";
        try {
            Class<?> c = Class.forName(className);
            if (c != null) {
                layout = (AbstractElementLayout)c.newInstance();
            }
        }
        catch (Exception exception) {}
        if (layout == null) {
            layout = new GeneralLayout();
        }
        ((AbstractElementLayout)layout).init(this, element);
        return layout;
    }

    public IElementLayout getLayout(MethodElement element, boolean create) {
        IElementLayout layout = null;
        if (layout == null && create) {
            layout = this.createLayout(element);
        }
        return layout;
    }

    public IElementLayout getLayout(String url) {
        MethodElement element = ResourceHelper.getElementFromFileName(url);
        if (element != null) {
            return this.getLayout(element, true);
        }
        System.out.println("Can't find element for url '" + url + "'");
        return null;
    }

    public MethodConfiguration getConfiguration() {
        return this.config;
    }

    public void setPublishDir(String path) {
        this.publish_dir = String.valueOf(path) + File.separator;
        this.init_publishingSite();
    }

    public String getPublishDir() {
        return this.publish_dir;
    }

    private void init_publishingSite() {
        LayoutResources.copyLayoutFiles(this.publish_dir);
    }

    public void copyLibraryResources() {
        File libRoot = LibraryProcessor.getInstance().getLibraryRootPath();
        if (libRoot != null) {
            LayoutResources.copyDir(libRoot.getPath(), this.publish_dir);
        }
    }

    public void clear() {
        if (this.wbsAdapterFactory != null) {
            this.wbsAdapterFactory.dispose();
            this.wbsAdapterFactory = null;
        }
        if (this.tbsAdapterFactory != null) {
            this.tbsAdapterFactory.dispose();
            this.tbsAdapterFactory = null;
        }
        if (this.wpbsAdapterFactory != null) {
            this.wpbsAdapterFactory.dispose();
            this.wpbsAdapterFactory = null;
        }
        if (this.cbsAdapterFactory != null) {
            this.cbsAdapterFactory.dispose();
            this.cbsAdapterFactory = null;
        }
    }
}

