/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.layout.elements;

import com.ibm.uma.Activity;
import com.ibm.uma.BreakdownElement;
import com.ibm.uma.CompositeRole;
import com.ibm.uma.MethodConfiguration;
import com.ibm.uma.MethodElement;
import com.ibm.uma.Process;
import com.ibm.uma.Role;
import com.ibm.uma.RoleDescriptor;
import com.ibm.uma.Task;
import com.ibm.uma.TaskDescriptor;
import com.ibm.uma.TeamProfile;
import com.ibm.uma.UmaPackage;
import com.ibm.uma.WorkBreakdownElement;
import com.ibm.uma.WorkProductDescriptor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;
import org.eclipse.epf.library.configuration.ConfigurationHelper;
import org.eclipse.epf.library.edit.IFilter;
import org.eclipse.epf.library.edit.process.IBSItemProvider;
import org.eclipse.epf.library.edit.util.ConfigurableComposedAdapterFactory;
import org.eclipse.epf.library.edit.util.PredecessorList;
import org.eclipse.epf.library.edit.util.ProcessUtil;
import org.eclipse.epf.library.edit.util.Suppression;
import org.eclipse.epf.library.edit.util.TngUtil;
import org.eclipse.epf.library.layout.ElementLayoutManager;
import org.eclipse.epf.library.layout.IElementLayout;
import org.eclipse.epf.library.layout.LayoutInfo;
import org.eclipse.epf.library.layout.diagram.IActivityDiagramService;
import org.eclipse.epf.library.layout.diagram.MethodElementDiagram;
import org.eclipse.epf.library.layout.elements.AbstractElementLayout;
import org.eclipse.epf.library.layout.util.XmlElement;
import org.eclipse.epf.library.util.LibraryUtil;

public class ActivityLayout
extends AbstractElementLayout {
    private Process owningProcess = null;
    static /* synthetic */ Class class$0;

    public void setOwningProcess(Process proc) {
        this.owningProcess = proc;
    }

    public Process getOwningProcess() {
        if (this.owningProcess == null) {
            this.owningProcess = TngUtil.getOwningProcess((BreakdownElement)((Activity)this.element));
            this.prepareAdapterfactoryFor((ComposedAdapterFactory)this.getLayoutMgr().getCBSAdapterFactory(), this.owningProcess);
            this.prepareAdapterfactoryFor((ComposedAdapterFactory)this.getLayoutMgr().getTBSAdapterFactory(), this.owningProcess);
            this.prepareAdapterfactoryFor((ComposedAdapterFactory)this.getLayoutMgr().getWBSAdapterFactory(), this.owningProcess);
            this.prepareAdapterfactoryFor((ComposedAdapterFactory)this.getLayoutMgr().getWPBSAdapterFactory(), this.owningProcess);
        }
        return this.owningProcess;
    }

    private void prepareAdapterfactoryFor(ComposedAdapterFactory adapterFactory, Object obj) {
        if (obj == null || adapterFactory == null) {
            return;
        }
        ITreeItemContentProvider provider = null;
        if (obj instanceof ITreeItemContentProvider) {
            provider = (ITreeItemContentProvider)obj;
        } else {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.emf.edit.provider.ITreeItemContentProvider");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            provider = (ITreeItemContentProvider)adapterFactory.adapt(obj, (Object)clazz);
        }
        if (provider != null) {
            Collection items = provider.getChildren(obj);
            Iterator it = items.iterator();
            while (it.hasNext()) {
                Object rawitem = it.next();
                MethodElement item = (MethodElement)LibraryUtil.unwrap(rawitem);
                if (!(item instanceof Activity)) continue;
                this.prepareAdapterfactoryFor(adapterFactory, rawitem);
            }
        }
    }

    public void init(ElementLayoutManager layoutManager, MethodElement element) {
        super.__init(layoutManager, element);
        String file = String.valueOf(this.element.getName()) + this.element.getGuid();
        this.setLayoutInfo(new LayoutInfo("Description", "activity.xsl", String.valueOf(file) + "_desc" + ".html", true));
        this.setLayoutInfo(new LayoutInfo("WPBS", "activity_wpbs.xsl", String.valueOf(file) + "_wpbs" + ".html", false));
        this.setLayoutInfo(new LayoutInfo("TBS", "activity_tbs.xsl", String.valueOf(file) + "_tbs" + ".html", false));
        this.setLayoutInfo(new LayoutInfo("WBS", "activity_wbs.xsl", String.valueOf(file) + "_wbs" + ".html", false));
    }

    public XmlElement getXmlElement(boolean includeReferences) {
        XmlElement elementXml = super.getXmlElement();
        this.loadAttributes(elementXml);
        if (!includeReferences) {
            return elementXml;
        }
        XmlElement tabsXml = elementXml.newChild("tabs");
        Iterator it = this.layouts.iterator();
        while (it.hasNext()) {
            LayoutInfo info = (LayoutInfo)it.next();
            tabsXml.newChild("tab").setAttribute("name", info.name).setAttribute("url", String.valueOf(this.elementPath) + info.fileName);
        }
        Process proc = this.getOwningProcess();
        Suppression sup = new Suppression(proc);
        IActivityDiagramService diagramService = this.layoutManager.getActivityDiagramService();
        MethodElementDiagram diagram_workflow = null;
        MethodElementDiagram diagram_detail = null;
        MethodElementDiagram diagram_wp = null;
        if (diagramService != null) {
            IFilter filter = this.layoutManager.getWBSAdapterFactory().getFilter();
            diagram_workflow = diagramService.saveDiagram(this.element, "Activity", filter, sup);
            diagram_detail = diagramService.saveDiagram(this.element, "ActivityDetail", filter, sup);
            diagram_wp = diagramService.saveDiagram(this.element, "WPDependency", filter, sup);
        }
        XmlElement diagrams = elementXml.newChild("diagrams");
        if (diagram_workflow != null && diagram_workflow.getImageFileName() != null) {
            diagrams.newChild("diagram").setAttribute("name", "Activity").setValue(diagram_workflow.getHTML());
        }
        if (diagram_detail != null && diagram_detail.getImageFileName() != null) {
            diagrams.newChild("diagram").setAttribute("name", "ActivityDetail").setValue(diagram_detail.getHTML());
        }
        if (diagram_wp != null && diagram_detail.getImageFileName() != null) {
            diagrams.newChild("diagram").setAttribute("name", "WPDependency").setValue(diagram_wp.getHTML());
        }
        this.loadCopyright(elementXml);
        List properties = this.element.getInstanceProperties();
        if (properties != null) {
            int i = 0;
            while (i < properties.size()) {
                EClassifier type;
                EStructuralFeature feature = (EStructuralFeature)properties.get(i);
                if (feature != UmaPackage.eINSTANCE.getActivity_BreakdownElements() && (type = feature.getEType()) instanceof EClass) {
                    this.loadFeature(feature, elementXml, false);
                }
                ++i;
            }
        }
        XmlElement bs = elementXml.newChild("breakdown").setAttribute("name", "Work Breakdown Structure");
        ConfigurableComposedAdapterFactory adapterFactory = this.layoutManager.getCBSAdapterFactory();
        CompositeRoles crs = new CompositeRoles((ComposedAdapterFactory)adapterFactory, (Activity)this.element);
        ProcessUtil.updateIDs((AdapterFactory)adapterFactory, (Process)proc);
        ActivityLayoutSetting setting = new ActivityLayoutSetting((ComposedAdapterFactory)adapterFactory, crs, sup);
        this.iterate(this.element, bs, setting);
        bs = elementXml.newChild("breakdown").setAttribute("name", "Team Breakdown Structure");
        adapterFactory = this.layoutManager.getTBSAdapterFactory();
        crs = new CompositeRoles((ComposedAdapterFactory)adapterFactory, (Activity)this.element);
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.emf.edit.provider.ITreeItemContentProvider");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        IBSItemProvider provider = (IBSItemProvider)adapterFactory.adapt((Notifier)this.element, (Object)clazz);
        provider.setRolledUp(true);
        setting = new ActivityLayoutSetting((ComposedAdapterFactory)adapterFactory, crs, sup);
        setting.rollupRoles = true;
        this.iterate(this.element, bs, setting);
        bs = elementXml.newChild("breakdown").setAttribute("name", "Work Product Breakdown Structure");
        adapterFactory = this.layoutManager.getWPBSAdapterFactory();
        crs = new CompositeRoles((ComposedAdapterFactory)adapterFactory, (Activity)this.element);
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("org.eclipse.emf.edit.provider.ITreeItemContentProvider");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        provider = (IBSItemProvider)adapterFactory.adapt((Notifier)this.element, (Object)clazz2);
        provider.setRolledUp(true);
        setting = new ActivityLayoutSetting((ComposedAdapterFactory)adapterFactory, crs, sup);
        this.iterate(this.element, bs, setting);
        return elementXml;
    }

    private void iterate(Object parentObj, XmlElement parentXml, ActivityLayoutSetting setting) {
        ITreeItemContentProvider provider = null;
        if (parentObj instanceof ITreeItemContentProvider) {
            provider = (ITreeItemContentProvider)parentObj;
        } else {
            ComposedAdapterFactory composedAdapterFactory = setting.adapterFactory;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.emf.edit.provider.ITreeItemContentProvider");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            provider = (ITreeItemContentProvider)composedAdapterFactory.adapt(parentObj, (Object)clazz);
        }
        if (provider != null) {
            String displayName = ProcessUtil.getAttribute((Object)parentObj, (String)"presentation_name", (Object)provider);
            parentXml.setAttribute("DisplayName", displayName);
            ArrayList<MethodElement> uniqueList = new ArrayList<MethodElement>();
            Collection items = provider.getChildren(parentObj);
            Iterator it = items.iterator();
            while (it.hasNext()) {
                CompositeRole cr;
                Object rawitem = it.next();
                if (setting.sup.isSuppressed(rawitem)) continue;
                MethodElement item = (MethodElement)LibraryUtil.unwrap(rawitem);
                if (parentObj instanceof Activity && item instanceof RoleDescriptor && (cr = setting.crs.getCompositeRole((Activity)parentObj, (RoleDescriptor)item)) != null) {
                    item = cr;
                }
                if (uniqueList.contains(item)) continue;
                uniqueList.add(item);
                IElementLayout l = this.layoutManager.getLayout(item, true);
                if (l == null) continue;
                if (l instanceof ActivityLayout) {
                    ((ActivityLayout)l).setOwningProcess(this.getOwningProcess());
                }
                XmlElement child = l.getXmlElement(false);
                IBSItemProvider adapter = null;
                if (rawitem instanceof IBSItemProvider) {
                    adapter = (IBSItemProvider)rawitem;
                } else {
                    ComposedAdapterFactory composedAdapterFactory = setting.adapterFactory;
                    Class<?> clazz = class$0;
                    if (clazz == null) {
                        try {
                            clazz = Class.forName("org.eclipse.emf.edit.provider.ITreeItemContentProvider");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    adapter = (IBSItemProvider)composedAdapterFactory.adapt((Notifier)item, (Object)clazz);
                }
                if (item instanceof BreakdownElement) {
                    String index = this.getIndex(adapter);
                    String modelInfo = ProcessUtil.getAttribute((Object)item, (String)"model_info", (Object)adapter);
                    String team = ProcessUtil.getAttribute((Object)item, (String)"teams", (Object)adapter);
                    String isEventDriven = ProcessUtil.getAttribute((Object)item, (String)"is_event_driven", (Object)adapter);
                    String isOngoing = ProcessUtil.getAttribute((Object)item, (String)"is_ongoing", (Object)adapter);
                    String isOptional = ProcessUtil.getAttribute((Object)item, (String)"is_optional", (Object)adapter);
                    String isPlanned = ProcessUtil.getAttribute((Object)item, (String)"is_planned", (Object)adapter);
                    String isRepeatable = ProcessUtil.getAttribute((Object)item, (String)"is_repeatable", (Object)adapter);
                    String hasMultipleOccurrences = ProcessUtil.getAttribute((Object)item, (String)"has_multiple_occurrences", (Object)adapter);
                    child.setAttribute("Index", index).setAttribute("ModelInfo", modelInfo).setAttribute("Team", team);
                    child.newChild("attribute").setAttribute("name", "isEventDriven").setValue(isEventDriven);
                    child.newChild("attribute").setAttribute("name", "isOngoing").setValue(isOngoing);
                    child.newChild("attribute").setAttribute("name", "isOptional").setValue(isOptional);
                    child.newChild("attribute").setAttribute("name", "isPlanned").setValue(isPlanned);
                    child.newChild("attribute").setAttribute("name", "isRepeatable").setValue(isRepeatable);
                    child.newChild("attribute").setAttribute("name", "hasMultipleOccurrences").setValue(hasMultipleOccurrences);
                    displayName = ProcessUtil.getAttribute((Object)item, (String)"presentation_name", (Object)adapter);
                    child.setAttribute("DisplayName", displayName);
                }
                if (item instanceof WorkProductDescriptor) {
                    String entryState = ProcessUtil.getAttribute((Object)item, (String)"entry_state", (Object)adapter);
                    String exitState = ProcessUtil.getAttribute((Object)item, (String)"exit_state", (Object)adapter);
                    child.setAttribute("EntryState", entryState).setAttribute("ExitState", exitState);
                }
                if (item instanceof WorkBreakdownElement) {
                    String predecessors = this.getPredecessors(adapter, setting.sup);
                    child.setAttribute("Predecessors", predecessors);
                }
                if (item instanceof TaskDescriptor) {
                    XmlElement stepsXml = child.newChild("Steps");
                    TaskDescriptor td = (TaskDescriptor)item;
                    List selSteps = td.getSelectedSteps();
                    Task t = (Task)ConfigurationHelper.getCalculatedElement((MethodElement)td.getTask(), this.getLayoutMgr().getConfiguration());
                    if (t != null) {
                        List steps = ConfigurationHelper.calc0nFeatureValue((MethodElement)t, (EStructuralFeature)UmaPackage.eINSTANCE.getTask_Steps(), this.getLayoutMgr().getConfiguration());
                        int i = 0;
                        while (i < steps.size()) {
                            Object step = steps.get(i);
                            boolean selected = selSteps.contains(step);
                            stepsXml.newChild("Step").setAttribute("index", Integer.toString(i)).setAttribute("selected", selected ? "true" : "false");
                            ++i;
                        }
                    }
                }
                parentXml.addChild(child);
                if (item instanceof TeamProfile) {
                    this.buildTeamStructure((TeamProfile)item, child, setting);
                }
                if (setting.rollupRoles && item instanceof RoleDescriptor) {
                    this.buildRoleRollup((RoleDescriptor)item, child, setting);
                }
                this.iterate(rawitem, child, setting);
            }
        }
    }

    private void buildRoleRollup(RoleDescriptor roleItem, XmlElement parentXml, ActivityLayoutSetting setting) {
        MethodConfiguration config = this.getLayoutMgr().getConfiguration();
        EReference feature = UmaPackage.eINSTANCE.getRoleDescriptor_ResponsibleFor();
        List responsibleFor = ConfigurationHelper.calc0nFeatureValue((MethodElement)roleItem, (EStructuralFeature)feature, config);
        this.createRoleRollupNodes(parentXml, responsibleFor, TngUtil.getFeatureText((EStructuralFeature)feature));
        feature = UmaPackage.eINSTANCE.getRoleDescriptor_Modifies();
        List modifies = ConfigurationHelper.calc0nFeatureValue((MethodElement)roleItem, (EStructuralFeature)feature, config);
        this.createRoleRollupNodes(parentXml, modifies, TngUtil.getFeatureText((EStructuralFeature)feature));
        feature = UmaPackage.eINSTANCE.getRoleDescriptor_PerformsAsOwner();
        List primaryTasks = ConfigurationHelper.calc0nFeatureValue((MethodElement)roleItem, (EStructuralFeature)feature, config);
        this.createRoleRollupNodes(parentXml, primaryTasks, TngUtil.getFeatureText((EStructuralFeature)feature));
        feature = UmaPackage.eINSTANCE.getRoleDescriptor_PerformsAdditionally();
        List additionalTasks = ConfigurationHelper.calc0nFeatureValue((MethodElement)roleItem, (EStructuralFeature)feature, config);
        this.createRoleRollupNodes(parentXml, additionalTasks, TngUtil.getFeatureText((EStructuralFeature)feature));
    }

    private void createRoleRollupNodes(XmlElement parentXml, List items, String info) {
        Iterator it = items.iterator();
        while (it.hasNext()) {
            MethodElement e = (MethodElement)it.next();
            IElementLayout l = this.layoutManager.getLayout(e, true);
            XmlElement child = l.getXmlElement(false);
            child.setAttribute("ModelInfo", info);
            parentXml.addChild(child);
        }
    }

    private void buildTeamStructure(TeamProfile team, XmlElement parentXml, ActivityLayoutSetting setting) {
        ITreeItemContentProvider provider;
        ComposedAdapterFactory composedAdapterFactory = setting.adapterFactory;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.emf.edit.provider.ITreeItemContentProvider");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((provider = (ITreeItemContentProvider)composedAdapterFactory.adapt((Notifier)team, (Object)clazz)) != null) {
            Collection items = provider.getChildren((Object)team);
            Iterator it = items.iterator();
            while (it.hasNext()) {
                MethodElement item = (MethodElement)LibraryUtil.unwrap(it.next());
                IElementLayout l = this.layoutManager.getLayout(item, true);
                if (l == null) continue;
                XmlElement child = l.getXmlElement(false);
                parentXml.addChild(child);
                if (!(item instanceof TeamProfile)) continue;
                this.buildTeamStructure((TeamProfile)item, child, setting);
            }
        }
    }

    private String getIndex(IBSItemProvider adapter) {
        if (adapter != null) {
            int index = adapter.getId();
            if (index == 0) {
                return "";
            }
            return Integer.toString(index);
        }
        return "";
    }

    private String getPredecessors(IBSItemProvider adapter, Suppression sup) {
        PredecessorList list;
        if (adapter != null && (list = adapter.getPredecessors()) != null) {
            return list.toUnSuppressedString(sup);
        }
        return "";
    }

    public class CompositeRoles {
        Map itemMap = new HashMap();
        static /* synthetic */ Class class$0;

        public CompositeRoles(ComposedAdapterFactory adapterFactory, Activity act) {
            this.scan(adapterFactory, null, act);
        }

        private CompositeRoleInfo getCompositeRoleInfo(Activity parent, Activity act) {
            CompositeRoleInfo info = (CompositeRoleInfo)this.itemMap.get(act);
            if (info == null) {
                info = new CompositeRoleInfo(parent, act);
                this.itemMap.put(act, info);
            }
            return info;
        }

        private void scan(ComposedAdapterFactory adapterFactory, Activity parent, Activity act) {
            ITreeItemContentProvider provider;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.emf.edit.provider.ITreeItemContentProvider");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((provider = (ITreeItemContentProvider)adapterFactory.adapt((Notifier)act, (Object)clazz)) != null) {
                Collection items = provider.getChildren((Object)act);
                Iterator it = items.iterator();
                while (it.hasNext()) {
                    MethodElement item = (MethodElement)LibraryUtil.unwrap(it.next());
                    if (item instanceof CompositeRole) {
                        this.getCompositeRoleInfo(parent, act).addCompositeRole((CompositeRole)item);
                        continue;
                    }
                    if (!(item instanceof Activity)) continue;
                    this.scan(adapterFactory, act, (Activity)item);
                }
            }
        }

        private CompositeRole getCompositeRole(Activity activity, RoleDescriptor item) {
            if (activity == null) {
                return null;
            }
            CompositeRole desc = null;
            CompositeRoleInfo info = (CompositeRoleInfo)this.itemMap.get(activity);
            if (info != null) {
                desc = info.getCompositeRole(item);
                if (desc != null) {
                    return desc;
                }
                return this.getCompositeRole(info.getParentActivity(), item);
            }
            return null;
        }
    }

    public class CompositeRoleInfo {
        Activity parent;
        Activity owner;
        List items = new ArrayList();

        public CompositeRoleInfo(Activity parent, Activity owner) {
            this.parent = parent;
            this.owner = owner;
        }

        private void addCompositeRole(CompositeRole e) {
            if (!this.items.contains(e)) {
                this.items.add(e);
            }
        }

        private Activity getParentActivity() {
            return this.parent;
        }

        private CompositeRole getCompositeRole(RoleDescriptor item) {
            if (this.items.size() == 0) {
                return null;
            }
            Role r = item.getRole();
            Iterator it = this.items.iterator();
            while (it.hasNext()) {
                CompositeRole cr = (CompositeRole)it.next();
                if (!cr.getAggregatedRoles().contains(r)) continue;
                return cr;
            }
            return null;
        }
    }

    public class ActivityLayoutSetting {
        public ComposedAdapterFactory adapterFactory;
        public CompositeRoles crs;
        public Suppression sup;
        boolean rollupRoles = false;

        public ActivityLayoutSetting(ComposedAdapterFactory adapterFactory, CompositeRoles crs, Suppression sup) {
            this.adapterFactory = adapterFactory;
            this.crs = crs;
            this.sup = sup;
        }
    }
}

