/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.layout.elements;

import com.ibm.uma.MethodElement;
import java.util.Iterator;
import java.util.List;
import org.eclipse.epf.common.utils.StrUtil;
import org.eclipse.epf.library.LibraryPlugin;
import org.eclipse.epf.library.configuration.ConfigurationHelper;
import org.eclipse.epf.library.layout.ElementLayoutManager;
import org.eclipse.epf.library.layout.IElementLayout;
import org.eclipse.epf.library.layout.LayoutInfo;
import org.eclipse.epf.library.layout.util.XmlElement;
import org.eclipse.epf.library.util.ResourceHelper;

public class SummaryPageLayout
implements IElementLayout {
    private static final String LAYOUT_TYPE = "Summary";
    private static final String LAYOUT_XSL = "summary.xsl";
    ElementLayoutManager layoutManager;
    MethodElement element;
    List refList;
    String title;
    IElementLayout elementLayout;

    public SummaryPageLayout(ElementLayoutManager layoutManager, MethodElement element, String title, List refList) {
        this.layoutManager = layoutManager;
        this.element = element;
        this.refList = refList;
        this.title = title;
        this.elementLayout = layoutManager.getLayout(element, true);
    }

    public String getId() {
        return this.element.getGuid();
    }

    public String getType() {
        return LAYOUT_TYPE;
    }

    public String getName() {
        return this.title;
    }

    public String getDisplayName() {
        return this.title;
    }

    public String getUrl() {
        return String.valueOf(this.elementLayout.getFilePath()) + this.getFileName(".html");
    }

    public String getShapeiconUrl() {
        return null;
    }

    public String getNodeiconUrl() {
        return null;
    }

    public String getDiagramiconUrl() {
        return null;
    }

    public String getXslUrl() {
        return String.valueOf(LibraryPlugin.getDefault().getLayoutXslPath()) + LAYOUT_XSL;
    }

    public String getBackPath() {
        return this.elementLayout.getBackPath();
    }

    public String getFilePath() {
        return this.elementLayout.getFilePath();
    }

    public String getFilePath(IElementLayout relativeTo) {
        return this.elementLayout.getFilePath(relativeTo);
    }

    public String getFileName(String ext) {
        return String.valueOf(StrUtil.makeValidFileName((String)(String.valueOf(this.title) + "_"))) + this.elementLayout.getFileName(ext);
    }

    public MethodElement getElement() {
        return this.element;
    }

    public ElementLayoutManager getLayoutMgr() {
        return this.layoutManager;
    }

    public XmlElement getXmlElement(boolean includeReferences) {
        XmlElement elementXml = new XmlElement("Element").setAttribute("Type", this.getType()).setAttribute("Name", this.getName()).setAttribute("Url", this.getUrl()).setAttribute("BackPath", this.getBackPath()).setAttribute("ImageUrl", this.getShapeiconUrl()).setAttribute("DisplayName", this.getDisplayName());
        if (includeReferences) {
            XmlElement refXml = elementXml.newChild("referenceList").setAttribute("name", "");
            Iterator it = this.refList.iterator();
            while (it.hasNext()) {
                IElementLayout l;
                MethodElement me;
                Object e = it.next();
                if (!(e instanceof MethodElement) || (e = ConfigurationHelper.getCalculatedElement(me = (MethodElement)e, this.layoutManager.getConfiguration())) == null || (l = this.layoutManager.getLayout(me, true)) == null) continue;
                refXml.addChild(l.getXmlElement(false));
            }
        }
        return elementXml;
    }

    public List getLayouts() {
        return null;
    }

    public String getFileName(LayoutInfo info, String ext) {
        return ResourceHelper.getFileName(this.element, null, info.name, ext);
    }

    public void setContentTarget(MethodElement targetElement) {
    }

    public void setElementOwner(MethodElement owner) {
    }
}

