/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.layout.elements;

import com.ibm.uma.MethodElement;
import com.ibm.uma.Role;
import com.ibm.uma.Task;
import com.ibm.uma.util.AssociationHelper;
import java.util.List;
import org.eclipse.epf.library.configuration.ConfigurationHelper;
import org.eclipse.epf.library.layout.ElementLayoutManager;
import org.eclipse.epf.library.layout.elements.AbstractElementLayout;
import org.eclipse.epf.library.layout.util.XmlElement;

public class TaskLayout
extends AbstractElementLayout {
    public void init(ElementLayoutManager layoutManager, MethodElement element) {
        super.__init(layoutManager, element);
    }

    public XmlElement getXmlElement(boolean includeReferences) {
        XmlElement elementXml = super.getXmlElement(includeReferences);
        if (includeReferences) {
            MethodElement role;
            Task task = (Task)this.element;
            Role performingRole = task.getPerformedBy();
            if (performingRole != null && (role = ConfigurationHelper.getCalculatedElement((MethodElement)performingRole, this.layoutManager.getConfiguration())) != null) {
                String roleName = ((Role)role).getPresentationName();
                if (roleName == null || roleName.length() == 0) {
                    roleName = role.getName();
                }
                elementXml.setAttribute("performingRoleName", roleName);
                this.addReference(elementXml, "performingRole", role);
            }
            MethodElement discipline = ConfigurationHelper.calc01FeatureValue(this.element, AssociationHelper.Task_Discipline, this.layoutManager.getConfiguration());
            this.addReference(elementXml, "discipline", discipline);
            List usercategories = ConfigurationHelper.calc0nFeatureValue(this.element, AssociationHelper.DescribableElement_CustomCategories, this.layoutManager.getConfiguration());
            this.processChild(elementXml.newChild("referenceList").setAttribute("name", "customCategories"), usercategories, false);
        }
        return elementXml;
    }
}

