/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.util;

import com.ibm.uma.ContentElement;
import com.ibm.uma.Domain;
import com.ibm.uma.MethodConfiguration;
import com.ibm.uma.MethodElement;
import com.ibm.uma.MethodPlugin;
import com.ibm.uma.ProcessComponent;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.logging.FileHandler;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.emf.edit.provider.DelegatingWrapperItemProvider;
import org.eclipse.emf.edit.provider.ItemProviderAdapter;
import org.eclipse.epf.library.edit.TransientGroupItemProvider;
import org.eclipse.epf.library.edit.navigator.ConfigurationsItemProvider;
import org.eclipse.epf.library.services.LibraryProcessor;
import org.eclipse.epf.persistence.MultiFileSaveUtil;
import org.eclipse.epf.resourcemanager.ResourceDescriptor;
import org.eclipse.epf.resourcemanager.ResourceManager;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.xml.sax.SAXException;

public class ImportExportUtil {
    public static final String NEW_LINE = System.getProperty("line.separator", "\n");

    public static Logger getLogger(String classname, String filename) {
        Logger logger = Logger.getLogger(classname);
        try {
            new File(filename).getParentFile().mkdirs();
            FileHandler fh = new FileHandler(filename, false);
            fh.setFormatter(new SimpleFormatter(){

                public String format(LogRecord rec) {
                    StringBuffer buf = new StringBuffer(1000);
                    buf.append(new Date());
                    buf.append(' ');
                    buf.append(this.formatMessage(rec));
                    buf.append('\n');
                    return buf.toString();
                }
            });
            fh.setLevel(Level.ALL);
            logger.addHandler(fh);
            logger.setUseParentHandlers(false);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return logger;
    }

    public static void closeLog(Logger logger) {
        Handler[] handlers = logger.getHandlers();
        int i = 0;
        while (i < handlers.length) {
            handlers[i].close();
            ++i;
        }
    }

    public static List fileList(File f, String extension) {
        extension = extension.toUpperCase();
        ArrayList<File> returnList = new ArrayList<File>();
        try {
            if (f.isDirectory()) {
                String[] flist = f.list();
                int i = 0;
                while (i < flist.length) {
                    File fc = new File(f.getPath(), flist[i]);
                    returnList.addAll(ImportExportUtil.fileList(fc, extension));
                    ++i;
                }
            } else if (extension != null) {
                String name = f.getName().toUpperCase();
                if (name.lastIndexOf(".") != -1 && name.substring(name.lastIndexOf(".") + 1).startsWith(extension)) {
                    returnList.add(f);
                }
            } else {
                returnList.add(f);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return returnList;
    }

    public static List fileListExcludeExt(File f, String extension) {
        ArrayList<File> returnList = new ArrayList<File>();
        try {
            if (f.isDirectory()) {
                String[] flist = f.list();
                int i = 0;
                while (i < flist.length) {
                    File fc = new File(f.getPath(), flist[i]);
                    returnList.addAll(ImportExportUtil.fileListExcludeExt(fc, extension));
                    ++i;
                }
            } else if (extension != null) {
                String name = f.getName();
                if (name.lastIndexOf(".") != -1 && !name.substring(name.lastIndexOf(".") + 1).startsWith(extension)) {
                    returnList.add(f);
                }
            } else {
                returnList.add(f);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return returnList;
    }

    private static void addGuidsOfMethodElement(MethodElement element, List list, List children) {
        list.add(element.getGuid());
        Iterator iter = element.eAdapters().iterator();
        while (iter.hasNext()) {
            Object adapter = iter.next();
            if (!(adapter instanceof ItemProviderAdapter)) continue;
            children.addAll(((ItemProviderAdapter)adapter).getChildren((Object)element));
            break;
        }
        if (element instanceof Domain) {
            children.addAll(((Domain)element).getWorkProducts());
        } else if (element instanceof MethodConfiguration) {
            children.addAll(((MethodConfiguration)element).getMethodPackageSelection());
        }
        if (element instanceof ContentElement) {
            children.addAll(((ContentElement)element).getAssets());
            children.addAll(((ContentElement)element).getChecklists());
            children.addAll(((ContentElement)element).getConceptsAndPapers());
            children.addAll(((ContentElement)element).getExamples());
            children.addAll(((ContentElement)element).getGuidelines());
            children.addAll(((ContentElement)element).getSupportingMaterials());
        }
    }

    private static Collection getMethodElementChildren(Object o) {
        ArrayList list = new ArrayList();
        ArrayList children = new ArrayList();
        if (o == null) {
            return list;
        }
        if (o instanceof MethodElement) {
            ImportExportUtil.addGuidsOfMethodElement((MethodElement)o, list, children);
        } else if (o instanceof TransientGroupItemProvider) {
            children.addAll(((TransientGroupItemProvider)o).getChildren(o));
        } else if (o instanceof ItemProviderAdapter) {
            children.addAll(((ItemProviderAdapter)o).getChildren(o));
        } else if (o instanceof DelegatingWrapperItemProvider) {
            Object e = ((DelegatingWrapperItemProvider)o).getEditableValue(o);
            if (e instanceof MethodElement) {
                ImportExportUtil.addGuidsOfMethodElement((MethodElement)e, list, children);
            }
            children.addAll(((DelegatingWrapperItemProvider)o).getChildren(o));
        } else if (o instanceof ConfigurationsItemProvider) {
            children.addAll(((ConfigurationsItemProvider)o).getChildren(o));
        }
        if (children != null && children.size() > 0) {
            Iterator iterator = children.iterator();
            while (iterator.hasNext()) {
                Object obj = iterator.next();
                list.addAll(ImportExportUtil.getMethodElementChildren(obj));
            }
        }
        return list;
    }

    public static Collection getSelectedElements(IStructuredSelection selection) {
        ArrayList<String> exportList = new ArrayList<String>();
        if (selection != null && selection.size() > 0) {
            Iterator iter = selection.iterator();
            while (iter.hasNext()) {
                Object o = iter.next();
                if (o instanceof MethodPlugin) {
                    MethodPlugin e = (MethodPlugin)o;
                    exportList.add(e.getGuid());
                    continue;
                }
                exportList.addAll(ImportExportUtil.getMethodElementChildren(o));
            }
        } else {
            List pluginList = LibraryProcessor.getInstance().getMethodModels();
            Iterator iter = pluginList.iterator();
            while (iter.hasNext()) {
                MethodPlugin plugin = (MethodPlugin)iter.next();
                exportList.add(plugin.getGuid());
            }
        }
        return exportList;
    }

    public static String escapeHTML(String str) {
        StringBuffer sb = new StringBuffer();
        int len = str == null ? 0 : str.length();
        int i = 0;
        while (i < len) {
            char ch = str.charAt(i);
            switch (ch) {
                case '&': {
                    sb.append("&amp;");
                    break;
                }
                default: {
                    sb.append(ch);
                }
            }
            ++i;
        }
        return sb.toString();
    }

    public static String unescapeHTML(String str) {
        if (str == null) {
            return "";
        }
        str = str.replaceAll("&amp;", "&");
        return str;
    }

    public static String findPresUri(ResourceManager resMgr, String guid) throws RuntimeException {
        String presUri = null;
        ResourceDescriptor resDesc = MultiFileSaveUtil.findResourceDescriptor((ResourceManager)resMgr, (String)guid);
        if (resDesc != null) {
            presUri = resDesc.getResolvedURI().toFileString();
        } else {
            MethodElement e = LibraryProcessor.getInstance().getElement(guid);
            if (e != null) {
                presUri = e.eResource().getURI().toFileString();
            }
        }
        return presUri;
    }

    /*
     * Exception decompiling
     */
    public static void replace(ProcessComponent procComp, String dir) throws IOException, ParserConfigurationException, FactoryConfigurationError, SAXException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 1[TRYBLOCK] [1 : 679->683)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

