/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.util;

import com.ibm.uma.MethodLibrary;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.epf.library.LibraryPlugin;
import org.eclipse.epf.library.LibraryResources;
import org.eclipse.epf.library.edit.util.TngUtil;
import org.eclipse.swt.widgets.Shell;

public class ResourceUtil {
    private static String methodLibraryNature = "org.eclipse.epf.library.MethodLibraryNature";
    private static String[] methodLibraryNatures = new String[]{methodLibraryNature};
    private static boolean debug = LibraryPlugin.getDefault().isDebugging();

    public static final void open(MethodLibrary lib, IProgressMonitor monitor) throws CoreException, IOException {
        ResourceUtil.open(ResourceUtil.getLibraryDirectory(lib), monitor);
    }

    public static final void open(String libDir, IProgressMonitor monitor) throws CoreException, IOException {
        IProjectDescription description;
        Path path;
        block21: {
            path = new Path(String.valueOf(libDir) + File.separator + ".project");
            description = null;
            try {
                description = ResourcesPlugin.getWorkspace().loadProjectDescription((IPath)path);
            }
            catch (CoreException coreException) {
                if (!debug) break block21;
                System.out.println("### - exception in loadProjectDescription");
            }
        }
        IProject project = null;
        try {
            if (description == null) {
                if (debug) {
                    System.out.println("### - creating new method library project");
                }
                project = ResourceUtil.createValidProjectFromPath(libDir, monitor);
            } else {
                if (debug) {
                    System.out.println("### - opening existing method library project " + description.getName());
                }
                if (!(project = ResourcesPlugin.getWorkspace().getRoot().getProject(description.getName())).exists()) {
                    try {
                        if (debug) {
                            System.out.println("### - creating existing .project " + description.getName() + " in workspace");
                        }
                        project = ResourceUtil.createProject(libDir, project.getName(), monitor);
                    }
                    catch (CoreException coreException) {
                        if (debug) {
                            System.out.println("### - creating existing .project failed - deleting workspace-project in " + libDir + " and creating workspace-project " + project.getName());
                        }
                        ResourceUtil.deleteProject(libDir, monitor);
                        project = ResourceUtil.createProject(libDir, project.getName(), monitor);
                    }
                } else {
                    if (debug) {
                        System.out.println("### - project " + project.getName() + " exists in workspace");
                    }
                    if (new File(libDir).compareTo(project.getLocation().toFile()) != 0) {
                        File projectFile;
                        if (debug) {
                            System.out.println("### - project " + project.getName() + " exists in workspace, but location differs - create a new project");
                        }
                        if (!(projectFile = path.toFile()).canWrite()) {
                            throw new IOException("###" + projectFile.getAbsolutePath());
                        }
                        projectFile.delete();
                        project = ResourceUtil.createValidProjectFromPath(libDir, monitor);
                    }
                }
            }
            if (project == null) {
                throw new IOException(LibraryResources.getString("Library.ResourceUtil.Invalid_library_path"));
            }
            project.open(128, monitor);
            description = project.getDescription();
            String[] existingNatures = description.getNatureIds();
            if (!Arrays.asList(existingNatures).contains(methodLibraryNature)) {
                if (debug) {
                    System.out.println("### - adding methodlibrarynature to " + description.getName());
                }
                description.setNatureIds(methodLibraryNatures);
                project.setDescription(description, 3, monitor);
            }
        }
        catch (CoreException ex) {
            LibraryPlugin.getDefault().getLogger().logError((Throwable)ex);
            throw ex;
        }
    }

    public static final void close(MethodLibrary lib, IProgressMonitor monitor) throws CoreException {
        IProject project = ResourceUtil.findProject(lib);
        if (project != null && project.isOpen()) {
            if (debug) {
                System.out.println("### - closing project " + project.getName());
            }
            project.close(monitor);
        } else if (debug) {
            System.out.println("### - ERROR closing project for library in \"" + ResourceUtil.getLibraryDirectory(lib) + "\": project could not be found.");
        }
    }

    public static IProject findProject(MethodLibrary lib) {
        return ResourceUtil.findProject(ResourceUtil.getLibraryDirectory(lib));
    }

    public static IProject findProject(String dir) {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IProject[] projects = workspace.getRoot().getProjects();
        try {
            int i = 0;
            while (i < projects.length) {
                IProject project = projects[i];
                if (new File(dir).compareTo(project.getLocation().toFile()) == 0) {
                    if (debug) {
                        System.out.println("### - found project " + project.getName() + " with location " + dir);
                    }
                    return project;
                }
                ++i;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            LibraryPlugin.getDefault().getLogger().logError((Throwable)ex);
        }
        return null;
    }

    public static final boolean deleteProject(MethodLibrary lib, IProgressMonitor monitor) throws CoreException {
        return ResourceUtil.deleteProject(ResourceUtil.getLibraryDirectory(lib), monitor);
    }

    private static boolean deleteProject(String path, IProgressMonitor monitor) throws CoreException {
        IProject project = ResourceUtil.findProject(path);
        try {
            if (project != null) {
                if (debug) {
                    System.out.println("### - deleting project " + project.getName());
                }
                if (monitor == null) {
                    monitor = new NullProgressMonitor();
                }
                project.delete(9, monitor);
            }
        }
        catch (CoreException ex) {
            ex.printStackTrace();
            LibraryPlugin.getDefault().getLogger().logError((Throwable)ex);
            return false;
        }
        return true;
    }

    public static IProject createProject(MethodLibrary lib, IProgressMonitor monitor) {
        return ResourceUtil.createValidProjectFromPath(ResourceUtil.getLibraryDirectory(lib), monitor);
    }

    public static IProject createValidProjectFromPath(String path, IProgressMonitor monitor) {
        IProject project = ResourceUtil.findProject(path);
        try {
            if (project != null) {
                project.delete(9, monitor);
            }
        }
        catch (CoreException ex) {
            LibraryPlugin.getDefault().getLogger().logError((Throwable)ex);
            return null;
        }
        String libName = new File(path).getName();
        String libDir = new File(path).getAbsolutePath();
        String projectName = libName;
        int i = 2;
        while (i < 100) {
            try {
                project = ResourceUtil.createProject(libDir, projectName, monitor);
                if (debug) {
                    System.out.println("### - creating new method library project " + projectName);
                }
                return project;
            }
            catch (CoreException coreException) {
                projectName = libName + ' ' + i++;
            }
        }
        return null;
    }

    private static final IProject createProject(String dir, String projectName, IProgressMonitor monitor) throws CoreException {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IProject newProjectHandle = workspace.getRoot().getProject(projectName);
        IProjectDescription description = workspace.newProjectDescription(newProjectHandle.getName());
        description.setNatureIds(methodLibraryNatures);
        Path path = new Path(dir);
        description.setLocation((IPath)path);
        newProjectHandle.create(description, monitor);
        return newProjectHandle;
    }

    public static void closeAllMethodLibraryProjects(IProgressMonitor monitor) {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IProject[] projects = workspace.getRoot().getProjects();
        try {
            int i = 0;
            while (i < projects.length) {
                IProject project = projects[i];
                if (project.isOpen() && project.getNature(methodLibraryNature) != null) {
                    if (debug) {
                        System.out.println("### - closing method library project " + project.getName());
                    }
                    project.close(monitor);
                }
                ++i;
            }
        }
        catch (CoreException ex) {
            ex.printStackTrace();
            LibraryPlugin.getDefault().getLogger().logError((Throwable)ex);
        }
    }

    public static String getLibraryDirectory(MethodLibrary lib) {
        return new File(lib.eResource().getURI().toFileString()).getParent();
    }

    public static IStatus checkEdit(EObject eObj, Shell shell) {
        return TngUtil.checkEdit((EObject)eObj, (Object)shell);
    }
}

