/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.publishing.wizards;

import com.ibm.uma.MethodConfiguration;
import org.eclipse.epf.library.LibraryPlugin;
import org.eclipse.epf.library.edit.ui.UserInteractionHelper;
import org.eclipse.epf.library.services.LibraryProcessor;
import org.eclipse.epf.publishing.services.AbstractViewBuilder;
import org.eclipse.epf.publishing.services.ConfigurationViewBuilder;
import org.eclipse.epf.publishing.services.PublishOptions;
import org.eclipse.epf.publishing.ui.PublishingUIResources;
import org.eclipse.epf.publishing.wizards.PublishConfigurationWizard;
import org.eclipse.epf.publishing.wizards.PublishProgressMonitorDialog;
import org.eclipse.epf.publishing.wizards.PublishingOperation;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;
import org.eclipse.ui.PlatformUI;

public class Publish
implements IWorkbenchWindowActionDelegate {
    private IStructuredSelection selection;
    private PublishOptions publishDataModel;

    public void init(IWorkbenchWindow window) {
    }

    public void run(IAction action) {
        this.publishDataModel = new PublishOptions();
        IPreferenceStore store = LibraryPlugin.getDefault().getPreferenceStore();
        String lastPubPath = store.getString("org.eclipse.epf.library.pref.last_publish_folder");
        if (lastPubPath != null && lastPubPath.length() > 0) {
            this.publishDataModel.setLastPublicationPath(lastPubPath);
        }
        PublishConfigurationWizard wizard = new PublishConfigurationWizard(this.publishDataModel);
        wizard.init(PlatformUI.getWorkbench(), this.selection);
        WizardDialog dialog = new WizardDialog(Display.getCurrent().getActiveShell(), (IWizard)wizard);
        dialog.create();
        dialog.open();
        if (!this.publishDataModel.isFinishPressed()) {
            return;
        }
        String publishDestFolder = this.publishDataModel.getPublicationPath();
        store.setValue("org.eclipse.epf.library.pref.last_publish_folder", publishDestFolder);
        LibraryPlugin.getDefault().savePluginPreferences();
        ConfigurationViewBuilder viewBuilder = null;
        try {
            LibraryProcessor lp = LibraryProcessor.getInstance();
            String selecedConfigName = this.publishDataModel.getSelectedConfig();
            MethodConfiguration config = lp.getConfiguration(selecedConfigName);
            viewBuilder = ConfigurationViewBuilder.getViewBuilder((String)publishDestFolder, (MethodConfiguration)config, (PublishOptions)this.publishDataModel);
            PublishingOperation operation = new PublishingOperation((AbstractViewBuilder)viewBuilder);
            PublishProgressMonitorDialog dlg = new PublishProgressMonitorDialog(Display.getCurrent().getActiveShell(), (AbstractViewBuilder)viewBuilder);
            UserInteractionHelper.runWithProgress((IRunnableWithProgress)operation, (ProgressMonitorDialog)dlg, (boolean)true, (String)PublishingUIResources.getString("PublishingUI.publishConfigWizard.title"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (viewBuilder != null) {
            viewBuilder.dispose();
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
    }

    public void dispose() {
    }
}

