//------------------------------------------------------------------------------
// Copyright (c) 2005, 2006 IBM Corporation and others.
// All rights reserved. This program and the accompanying materials
// are made available under the terms of the Eclipse Public License v1.0
// which accompanies this distribution, and is available at
// http://www.eclipse.org/legal/epl-v10.html
// 
// Contributors:
// IBM Corporation - initial implementation
//------------------------------------------------------------------------------

var tree_node_class  = "treeNode";
var collapseSectionsByDefault = false;
var expandImage;
var collapseImage;
var shimImage;


// Creates the collapsible tree table
// the expected format of the html source are as follows:
// each <TR tag has a uinque id and a parentId.
/*
<head>
<META http-equiv="Content-Type" content="text/html; charset=utf-8">
<link type="text/css" href="./css/default.css" rel="StyleSheet">
<script src="./treetable.js" type="text/javascript" language="JavaScript"></script>
</head>
<body onload="createTree('td', 'treeNode', './images/');" >
<table border="1">
<tr id="1" parentId="0">
<td class="treeNode">col 1-1</td><td>col 1-2</td>
</tr>

<tr id="2" parentId="1">
<td class="treeNode">col 1-1</td><td>col 2-2</td>
</tr>

<tr id="3" parentId="1">
<td class="treeNode">col 1-1</td><td>col 2-2</td>
</tr>

<tr id="4" parentId="0">
<td class="treeNode">col 2-1</td><td>col 2-2</td>
</tr>
</table>
</body>
*/

function createTree(tagName, classSelector, imgPath) {

	tree_node_class = classSelector;
	
	expandImage = imgPath + 'expand.gif';	
	collapseImage = imgPath + 'collapse.gif';
	//expandAllImage = imgPath + 'expand_all.gif';	
	//collapseAllImage = imgPath + 'collapse_all.gif';
	//backToTopImage = imgPath + 'back_to_top.gif';
	shimImage = imgPath + 'shim.gif';
	
	if (document.getElementsByTagName) {
		
		//alert("start");
		
		// save map of parentId to parent TR to improve performance
		var createdNodes = new Array();

		var elements = document.getElementsByTagName(tagName);
		//var sectionElements = new Array(elements.length);
		//var totalLinks = 0;
		for (var i = 0; i < elements.length; i++) {
			var element = elements[i];
			if (element.className == classSelector ) 
			{
				var indentSize = 0;
				var trElement= getTR(element);	
				if ( trElement.parentId != "")
				{
				
					// cache it to be faster
					//parentTR = document.getElementById(trElement.parentId);
					parentTR = createdNodes[trElement.parentId];
					if ( parentTR != null && parentTR != undefined )
					{
						indentSize = parentTR.indentSize + 1;
					}
				}
				
				trElement.indentSize = indentSize;
				trElement.expanded = true;
				
				//alert(trElement.id);
				createTreeNode(element, indentSize);
				
				//save the created ones so we can referecne it
				createdNodes[trElement.id] = trElement;
				
			}
		}
		
		//alert("end");
		
	}
}

function getTR(element)
{
	// the heml structure is
	// <tr id="2" parentId="1">
	// <td class="treeNode">col 1-1</td><td>col 2-2</td>
	// </tr>
	var e = element;
	while ( e != null && e.tagName != "TR" || e.className != tree_node_class)
	{	
		e = e.parentNode;
		//alert(e.tagName);
	}
	
	return e;
}


// Creates a collapsible section.
function createTreeNode(element, indentSize) {
	

	if (document.createElement) {
	
		//var indent = indentSize*5 + 17;
		
		// Add a expand/collapse link to the tree node heading.
		var span = document.createElement('span');		
		var link = document.createElement('a');


		link.href = '#';
		var image = document.createElement('img');
		if ( hasChildren(element) )
		{
			if (collapseSectionsByDefault) {
				image.src = expandImage;
			}
			else {
				image.src = collapseImage;
			}
		}
		else
		{
			image.src = shimImage;
		}
		
		image.width = '17';
		image.height = '15';
		image.border = '0';
		image.align = 'absmiddle';
		link.appendChild(image);
		link.onclick = expandCollapseTreeNode;
		
		var space = String.fromCharCode(160);
		var space4 = space+space+space+space;
		var spaces = "";
		for ( var i = 0; i < indentSize; i++)
		{
			spaces += space4;			
		}
		
		span.appendChild(document.createTextNode(spaces));			
		span.appendChild(link);
				
		element.insertBefore(span, element.firstChild);
		element.appendChild(document.createTextNode(String.fromCharCode(160)));
		element.appendChild(document.createTextNode(String.fromCharCode(160)));		   		
	}
}



// Expands or collapses a section based on the received event.
function expandCollapseTreeNode(evt) {

	var trElement = getTR(this);

	//alert("expended=" + trElement.expanded);
	if (trElement.expanded) {
		hideChildren(trElement);
		this.firstChild.src = expandImage;
	}
	else {
		showHideChildren(trElement, true);
		this.firstChild.src = collapseImage;
	}
	
	trElement.expanded = !trElement.expanded;
	
	if (evt && evt.preventDefault) {
		evt.preventDefault();
	}
	return false;
}




function hideChildren(parent)
{	
	// make sure it's the TR element
	parent = getTR(parent);
	//var parentId = parent.id;
	var indentSize = parent.indentSize;
	var nextTR = parent;
	while ( (nextTR=nextTR.nextSibling) != null && nextTR.indentSize > indentSize )
	{		
		nextTR.style.display = 'none';		
	}
		
}


function showHideChildren(parent, show)
{	
	// make sure it's the TR element
	parent = getTR(parent);
	//var indentSize = parent.indentSize;
	var nextTR = parent.nextSibling;
	while ( nextTR != null && nextTR.parentId == parent.id )
	{
		if (show)
		{
			nextTR.style.display = '';
		}
		else
		{
			
			nextTR.style.display = 'none';
		}
		
		nextTR = showHideChildren(nextTR, show&&nextTR.expanded);
	}
	
	return nextTR;
	
}


function hasChildren(parent)
{
	// make sure it's the TR element
	parent = getTR(parent);
	var nextTR = parent.nextSibling;
	if ( nextTR != null && nextTR.parentId == parent.id )
	{
		return true;
	}
	
	return false;

}

