<?xml version="1.0" encoding="UTF-8"?>
<!-- 
    Copyright (c) 2005, 2006 IBM Corporation and others.
    All rights reserved. This program and the accompanying materials
    are made available under the terms of the Eclipse Public License v1.0
    which accompanies this distribution, and is available at
    http://www.eclipse.org/legal/epl-v10.html
    Contributors:
    IBM Corporation - initial implementation
-->

<xsl:stylesheet version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
	xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance">
	
	<xsl:include href="helper.xsl"/>
			
	<xsl:template match="/Element">
		<xsl:variable name="elementType" select="@Type"/>
		<xsl:variable name="elementTypeName" select="@TypeName"/>
		<xsl:variable name="elementName" select="breakdown[@name='Work Breakdown Structure']"/>
		<xsl:variable name="backPath" select="@BackPath"/>
		<xsl:variable name="imagePath" select="concat($backPath, 'images/')"/>
	    <xsl:variable name="shapeImage" select="concat($backPath,@ShapeiconUrl)"/>
		<xsl:variable name="presentation" select="reference[@name='presentation']"/>
		<xsl:variable name="contentDescription" select="$presentation/Element"/>
		<xsl:variable name="copyright" select="copyright"/>
		<xsl:variable name="showTreeBrowser" select="@showTreeBrowser"/>
		<xsl:variable name="responsibleRole" select="reference[@name='responsibleRole']/Element[@Type='Role']"/>
		<html>
			<head>
				<title><xsl:value-of select="$elementType"/>: <xsl:value-of select="$elementName/@DisplayName"/></title>
				<meta http-equiv="Content-Type" content="text/html; charset=utf-8"/>
				<meta name="element_type"> 
					<xsl:call-template name="mapping">
						<xsl:with-param name="elementType" select="$elementType"/>
					</xsl:call-template>
				</meta>
				<!-- <meta name="element_type" content="{$elementType}"/> -->
				<meta name="filetype" content="description"/>
				<meta name="role">
					<xsl:attribute name="content"><xsl:value-of select="$responsibleRole/@DisplayName"/></xsl:attribute>
				</meta>
				<link rel="StyleSheet" href="{$backPath}css/default.css" type="text/css"/>
				<script language="JavaScript" type="text/javascript" src="{$backPath}scripts/contentpage.js"/>
				<script language="JavaScript" type="text/javascript" src="{$backPath}scripts/treetable.js"/>
				<script language="JavaScript" type="text/javascript">
					backPath = '<xsl:value-of select="$backPath"/>';
					imgPath = '<xsl:value-of select="$imagePath"/>';
				</script>
			</head>
			<body onload="createSectionLinks('div', 'sectionHeading', '{$imagePath}');createTree('div', 'treeNode', '{$imagePath}');">
				<table border="0" cellpadding="0" cellspacing="0" width="100%">
					<tr>
						<td valign="top">
							<xsl:call-template name="overview">
								<xsl:with-param name="elementType" select="$elementType"/>
								<xsl:with-param name="elementTypeName" select="$elementTypeName"/>
								<xsl:with-param name="elementName" select="$elementName/@DisplayName"/>
								<xsl:with-param name="elementIcon" select="$shapeImage"/>
								<xsl:with-param name="backPath" select="$backPath"/>
								<xsl:with-param name="showTreeBrowser" select="$showTreeBrowser"/>
							</xsl:call-template>
							<xsl:call-template name="activityTabs"/>
							<xsl:call-template name="workflowSection"/>
							<xsl:call-template name="tbsSection"/>
							<xsl:call-template name="copyright">
								<xsl:with-param name="copyright" select="$copyright"/>
							</xsl:call-template>
						</td>						
					</tr>
				</table>
			</body>
		</html>
	</xsl:template>
	
	<xsl:template name="activityTabs">
		<xsl:variable name="imagePath" select="concat(/Element/@BackPath, 'images/')"/>
		<table width="100%" border="0" cellspacing="0" cellpadding="0">
			<tr valign="middle">
				<td class="tab">
					<img src="{$imagePath}shim.gif" width="10" height="17" alt=""/>
				</td>
				<td class="tab">
					<a class="tab">
						<xsl:attribute name="href"><xsl:value-of select="concat(/Element/@BackPath, tabs/tab[@name='Description']/@url)"/></xsl:attribute>
						<xsl:value-of select="$descriptionText"/>
					</a>
				</td>
				<td width="21">
					<img src="{$imagePath}tab_middle-i_i.gif" width="21" height="17" align="absmiddle" alt=""/>
				</td>
				<td class="tab">
					<a class="tab">
						<xsl:attribute name="href"><xsl:value-of select="concat(/Element/@BackPath, tabs/tab[@name='WBS']/@url)"/></xsl:attribute>
						<span style="white-space:nowrap;"><xsl:value-of select="$wbsText"/></span>
					</a>
				</td>
				<td width="1">
					<img src="{$imagePath}tab_middle-i_a.gif" width="21" height="17" align="absmiddle" alt=""/>
				</td>
				<td class="activeTab">
					<span style="white-space:nowrap;"><xsl:value-of select="$tbsText"/></span>
				</td>
				<td width="21">
					<img src="{$imagePath}tab_middle-a_i.gif" width="21" height="17" align="absmiddle" alt=""/>
				</td>
				<td class="tab">
					<a class="tab">
						<xsl:attribute name="href"><xsl:value-of select="concat(/Element/@BackPath, tabs/tab[@name='WPBS']/@url)"/></xsl:attribute>
						<span style="white-space:nowrap;"><xsl:value-of select="$wpbsText"/></span>
					</a>
				</td>
				<td width="21">
					<img src="{$imagePath}tab_end-i.gif" width="21" height="17" alt=""/>
				</td>
				<td width="50%">
					<img src="{$imagePath}shim.gif" width="10" height="17" alt=""/>
				</td>
			</tr>
			<tr>
				<td colspan="4">
					<img src="{$imagePath}shim.gif" alt="" height="2"/>
				</td>
				<td>
					<img src="{$imagePath}tab_space_middle.gif" width="21" height="2" alt=""/>
				</td>
				<td class="activeTab">
					<img src="{$imagePath}shim.gif" width="10" height="2" alt=""/>
				</td>
				<td>
					<img src="{$imagePath}tab_space.gif" width="21" height="2" alt=""/>
				</td>
				<td colspan="3">
					<img src="{$imagePath}shim.gif" height="2" alt=""/>
				</td>
			</tr>
			<tr>
				<td colspan="10" class="activeTab">
					<img src="{$imagePath}shim.gif" height="5" alt=""/>
				</td>
			</tr>
		</table>
	</xsl:template>	
	
	<xsl:template name="workflowSection">
		<xsl:if test="count(breakdown[@name='Team Breakdown Structure']/Element[@Type='TeamProfile']) > 0">
		<div class="sectionHeading"><xsl:value-of select="$teamStructureText"/></div>
		<div class="sectionContent">
			<!--
			<p align="center">
				<xsl:value-of disable-output-escaping="yes" select="diagrams/diagram[@name='ActivityDetail']"/>
				temporary solution, show the team structure instead
			</p>
			-->
			
				<p align="left">
					<xsl:for-each select="breakdown[@name='Team Breakdown Structure']/Element[@Type='TeamProfile']">
						<xsl:call-template name="teamStructure">
							<xsl:with-param name="element" select="."/>
						</xsl:call-template>
					</xsl:for-each>
				</p>			
		</div>
		</xsl:if>
	</xsl:template>
	
	<xsl:template name="teamStructure">
		<xsl:param name="element"/>		
		<a>
			<xsl:attribute name="href"><xsl:value-of select="concat(/Element/@BackPath, $element/@Url)"/></xsl:attribute>
			<xsl:value-of select="$element/@DisplayName"/>
		</a>

		<xsl:if test="count($element/Element) > 0">
			<ul>
				<xsl:for-each select="$element/Element">
				<li>
					<xsl:call-template name="teamStructure">
						<xsl:with-param name="element" select="."/>
					</xsl:call-template>
				</li>
				</xsl:for-each>
			</ul>
		</xsl:if>
	</xsl:template>
	
	<xsl:template name="tbsSection">
		<xsl:variable name="imagePath" select="concat(/Element/@BackPath, 'images/')"/>

					<div class="sectionHeading"><xsl:value-of select="$teamProfileBreakdownText"/></div>
		<div class="sectionContent">

			<table class="breakdownTable" width="100%" border="0" cellpadding="0" cellspacing="1" bordercolor="#999999">
				<tr valign="top">
					<th><xsl:value-of select="$prefixText"/></th>
					<th><xsl:value-of select="$breakdownElementText"/></th>
					<th><xsl:value-of select="$modelInfoText"/></th>
					<th><xsl:value-of select="$typeText"/></th>					
				</tr>
				<xsl:for-each select="breakdown[@name='Team Breakdown Structure']/Element">
					<xsl:call-template name="wbsItem">
						<xsl:with-param name="element" select="."/>
						<xsl:with-param name="indent" select=" '' "/>
						<xsl:with-param name="parentNodeId" select=" '' "/>
					</xsl:call-template>
				</xsl:for-each>
			</table>
		</div>
	</xsl:template>
	
	<xsl:template name="wbsItem">
		<xsl:param name="element"/>
		<xsl:param name="parentNodeId"/>
		<xsl:param name="indent"/>
		<xsl:variable name="imagePath" select="concat(/Element/@BackPath, 'images/')"/>
		<tr class="treeNode">
			<xsl:attribute name="id"><xsl:value-of select="$element/@nodeId"/></xsl:attribute>
			<xsl:attribute name="parentId"><xsl:value-of select="$parentNodeId"/></xsl:attribute>
					
			<td bgcolor="#cccccc">
				<xsl:value-of select="$element/attribute[@name='prefix']"/>&#160;</td>
			<td>
				<table class="defaultTable" border="0" cellspacing="0" cellpadding="0" bgcolor="#000000"><tr>
			<td> <div class="treeNode"></div>
			<!--
			<xsl:value-of select="$indent"/>
			-->
			</td>
			<td width="100%">
				<a>
					<xsl:attribute name="href"><xsl:value-of select="concat(/Element/@BackPath, $element/@Url)"/></xsl:attribute>
					<xsl:value-of select="$element/@DisplayName"/>
				</a>
			</td>			
			</tr>
			</table>			
			</td>
			<td bgcolor="#cccccc"><xsl:value-of select="$element/@ModelInfo"/>&#160;</td>
			<td><xsl:value-of select="$element/@Type"/></td>			
		</tr>
		<xsl:if test="count($element/Element) > 0">
			<xsl:for-each select="$element/Element">
				<xsl:call-template name="wbsItem">
					<xsl:with-param name="element" select="."/>
					<xsl:with-param name="indent" select="concat('&#160;&#160;&#160;&#160;', $indent)"/>
					<xsl:with-param name="parentNodeId" select="$element/@nodeId"/>
				</xsl:call-template>
			</xsl:for-each>
		</xsl:if>
	</xsl:template>
	
</xsl:stylesheet>
