<?xml version="1.0" encoding="UTF-8"?>
<!-- 
    Copyright (c) 2005, 2006 IBM Corporation and others.
    All rights reserved. This program and the accompanying materials
    are made available under the terms of the Eclipse Public License v1.0
    which accompanies this distribution, and is available at
    http://www.eclipse.org/legal/epl-v10.html
    Contributors:
    IBM Corporation - initial implementation
-->

<xsl:stylesheet version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
	xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance">
	
	<xsl:include href="helper.xsl"/>
	
	<xsl:template match="/Element">
		<xsl:variable name="elementType" select="@Type"/>
		<xsl:variable name="elementTypeName" select="@TypeName"/>		
		<xsl:variable name="elementName" select="breakdown[@name='Work Breakdown Structure']"/>
		<xsl:variable name="backPath" select="@BackPath"/>
		<xsl:variable name="imagePath" select="concat($backPath, 'images/')"/>
		<xsl:variable name="shapeImage" select="concat($backPath,@ShapeiconUrl)"/>
		<xsl:variable name="presentation" select="reference[@name='presentation']"/>
		<xsl:variable name="contentDescription" select="$presentation/Element"/>
		<xsl:variable name="copyright" select="copyright"/>
		<xsl:variable name="showTreeBrowser" select="@showTreeBrowser"/>
		<xsl:variable name="responsibleRole" select="reference[@name='responsibleRole']/Element[@Type='Role']"/>
		<html>
			<head>
				<title><xsl:value-of select="$elementType"/>: <xsl:value-of select="$elementName/@DisplayName"/></title>
				<meta http-equiv="Content-Type" content="text/html; charset=utf-8"/>
				<meta name="element_type"> 
					<xsl:call-template name="mapping">
						<xsl:with-param name="elementType" select="$elementType"/>
					</xsl:call-template>
				</meta>
				<!-- <meta name="element_type" content="{$elementType}"/> -->
				<meta name="filetype" content="description"/>
				<meta name="role">
					<xsl:attribute name="content"><xsl:value-of select="$responsibleRole/@DisplayName"/></xsl:attribute>
				</meta>
				<link rel="StyleSheet" href="{$backPath}css/default.css" type="text/css"/>
				<script language="JavaScript" type="text/javascript" src="{$backPath}scripts/contentpage.js"/>
				<script language="JavaScript" type="text/javascript" src="{$backPath}scripts/treetable.js"/>
				<script language="JavaScript" type="text/javascript">
					backPath = '<xsl:value-of select="$backPath"/>';
					imgPath = '<xsl:value-of select="$imagePath"/>';
				</script>
			</head>
			<body onload="createSectionLinks('div', 'sectionHeading', '{$imagePath}'); createTree('div', 'treeNode', '{$imagePath}');">
				<table border="0" cellpadding="0" cellspacing="0" width="100%">
					<tr>
						<td valign="top">
							<xsl:call-template name="overview">
								<xsl:with-param name="elementType" select="$elementType"/>
								<xsl:with-param name="elementTypeName" select="$elementTypeName"/>
								<xsl:with-param name="elementName" select="$elementName/@DisplayName"/>
								<xsl:with-param name="elementIcon" select="$shapeImage"/>
								<xsl:with-param name="backPath" select="$backPath"/>
								<xsl:with-param name="showTreeBrowser" select="$showTreeBrowser"/>
							</xsl:call-template>
							<xsl:call-template name="activityTabs"/>				
							<xsl:call-template name="workflowSection"/>
							<xsl:call-template name="wbsSection"/>
							<xsl:call-template name="copyright">
								<xsl:with-param name="copyright" select="$copyright"/>
							</xsl:call-template>
						</td>						
					</tr>
				</table>
			</body>
		</html>
	</xsl:template>
	
	<xsl:template name="activityTabs">
		<xsl:variable name="imagePath" select="concat(/Element/@BackPath, 'images/')"/>
		<table width="100%" border="0" cellspacing="0" cellpadding="0">
			<tr valign="middle">
				<td width="10" class="tab">
					<img src="{$imagePath}shim.gif" width="10" height="17" alt=""/>
				</td>
				<td class="tab">
					<a class="tab">
						<xsl:attribute name="href"><xsl:value-of select="concat(/Element/@BackPath, tabs/tab[@name='Description']/@url)"/></xsl:attribute>
						<xsl:value-of select="$descriptionText"/>
					</a>
				</td>
				<td width="21">
					<img src="{$imagePath}tab_middle-i_a.gif" width="21" height="17" align="absmiddle" alt=""/>
				</td>
				<td class="activeTab">
					<span style="white-space:nowrap;"><xsl:value-of select="$wbsText"/></span>
				</td>
				<td width="1">
					<img src="{$imagePath}tab_middle-a_i.gif" width="21" height="17" align="absmiddle" alt=""/>
				</td>				
				<td class="tab">
					<a class="tab">
						<xsl:attribute name="href"><xsl:value-of select="concat(/Element/@BackPath, tabs/tab[@name='TBS']/@url)"/></xsl:attribute>
						<span style="white-space:nowrap;"><xsl:value-of select="$tbsText"/></span>
					</a>
				</td>
				<td width="21">
					<img src="{$imagePath}tab_middle-i_i.gif" width="21" height="17" align="absmiddle" alt=""/>
				</td>
				<td class="tab">
					<a class="tab">
						<xsl:attribute name="href"><xsl:value-of select="concat(/Element/@BackPath, tabs/tab[@name='WPBS']/@url)"/></xsl:attribute>
						<span style="white-space:nowrap;"><xsl:value-of select="$wpbsText"/></span>
					</a>
				</td>
				<td width="21">
					<img src="{$imagePath}tab_end-i.gif" width="21" height="17" alt=""/>
				</td>
				<td width="50%">
					<img src="{$imagePath}shim.gif" width="10" height="17" alt=""/>
				</td>
			</tr>
			<tr>
				<td colspan="2">
					<img src="{$imagePath}shim.gif" height="2" alt=""/>
				</td>
				<td>
					<img src="{$imagePath}tab_space_middle.gif" width="21" height="2" alt=""/>
				</td>
				<td class="activeTab">
					<img src="{$imagePath}shim.gif" width="10" height="2" alt=""/>
				</td>
				<td>
					<img src="{$imagePath}tab_space.gif" width="21" height="2" alt=""/>
				</td>				
				<td colspan="5">
					<img src="{$imagePath}shim.gif" height="2" alt=""/>
				</td>
			</tr>
			<tr>
				<td colspan="10" class="activeTab">
					<img src="{$imagePath}shim.gif" height="5" alt=""/>
				</td>
			</tr>
		</table>
	</xsl:template>
	
	<xsl:template name="workflowSection">
		<xsl:if test="diagrams/diagram[@name='Activity'] or diagrams/diagram[@name='ActivityDetail']">
			<div class="sectionHeading"><xsl:value-of select="$workflowText"/></div>
			<div class="sectionContent">
				<table class="sectionTable" border="0" cellspacing="0" cellpadding="0">
					<tr>
						<td class="sectionTableCell" colspan="2" align="center">	
							<xsl:value-of disable-output-escaping="yes" select="diagrams/diagram[@name='Activity']"/>
						</td>
					</tr>
					<tr>
						<td class="sectionTableCell" colspan="2" align="center">	
							<xsl:value-of disable-output-escaping="yes" select="diagrams/diagram[@name='ActivityDetail']"/>
						</td>
					</tr>					
				</table>
			</div>
		</xsl:if>
	</xsl:template>
	
	<xsl:template name="wbsSection">
		<xsl:variable name="imagePath" select="concat(/Element/@BackPath, 'images/')"/>

					<div class="sectionHeading"><xsl:value-of select="$workBreakdownText"/></div>
		<div class="sectionContent">

			<table class="breakdownTable" width="100%" border="0" cellpadding="0" cellspacing="1" bordercolor="#999999">
				<tr valign="top">
					<th><xsl:value-of select="$indexText"/></th>
					<th><xsl:value-of select="$prefixText"/></th>
					<th><xsl:value-of select="$breakdownElementText"/></th>
					<th><xsl:value-of select="$stepsText"/></th>
					<th><xsl:value-of select="$predecessorsText"/></th>
					<th><xsl:value-of select="$modelInfoText"/></th>
					<th><xsl:value-of select="$repeatableText"/></th>
					<th><xsl:value-of select="$multipleOccurrencesText"/></th>
					<th><xsl:value-of select="$optionalText"/></th>
					<th><xsl:value-of select="$plannedText"/></th>
					<th><xsl:value-of select="$typeText"/></th>
				</tr>
				<xsl:for-each select="breakdown[@name='Work Breakdown Structure']/Element">
					<xsl:call-template name="wbsItem">
						<xsl:with-param name="element" select="."/>
						<xsl:with-param name="indent" select=" '' "/>
						<xsl:with-param name="parentNodeId" select=" '' "/>
					</xsl:call-template>
				</xsl:for-each>
			</table>
		</div>
	</xsl:template>		
	
	<xsl:template name="wbsItem">
		<xsl:param name="element"/>
		<xsl:param name="parentNodeId"/>
		<xsl:param name="indent"/>
		<xsl:variable name="imagePath" select="concat(/Element/@BackPath, 'images/')"/>			
		<tr class="treeNode">
			<xsl:attribute name="id"><xsl:value-of select="$element/@nodeId"/></xsl:attribute>
			<xsl:attribute name="parentId"><xsl:value-of select="$parentNodeId"/></xsl:attribute>

			<td><xsl:value-of select="$element/@Index"/></td>
			<td bgcolor="#cccccc"><xsl:value-of select="$element/attribute[@name='prefix']"/>&#160;</td>
			<td>

			<table class="defaultTable" border="0" cellspacing="0" cellpadding="0" bgcolor="#000000">
				<tr>
					<td><div class="treeNode"></div>
					<!--
						<xsl:value-of select="$indent"/>
					-->
					</td>
					<td width="100%">
						<a>
							<xsl:attribute name="href"><xsl:value-of select="concat(/Element/@BackPath, $element/@Url)"/></xsl:attribute>
							<xsl:value-of select="$element/@DisplayName"/>
						</a>
					</td>
				</tr>
			</table>
		
			</td>
			<td bgcolor="#cccccc">
				<xsl:for-each select="$element/Steps/Step">
					<img width="10" height="9" alt="">
						<xsl:attribute name="src"><xsl:choose><xsl:when test="@selected='true'"><xsl:value-of select="$imagePath"/>circle_close.gif</xsl:when><xsl:otherwise><xsl:value-of select="$imagePath"/>circle_open.gif</xsl:otherwise></xsl:choose></xsl:attribute>
					</img>					
					<xsl:if test="position() mod 5 = 0">
						<br/>
					</xsl:if>
				</xsl:for-each>
				&#160;
			</td>
			<td><xsl:value-of select="$element/@Predecessors"/>&#160;</td>
			<td bgcolor="#cccccc"><xsl:value-of select="$element/@ModelInfo"/>&#160;</td>
			<td align="center">
				<label for="cbox1"/>
				<input type="checkbox" name="repeatable">
				<xsl:attribute name="readonly">true</xsl:attribute>
 				<xsl:if test="$element/attribute[@name='isRepeatable'] = 'true'">
  					<xsl:attribute name="checked">checked</xsl:attribute>
 				</xsl:if>
 				<xsl:attribute name="id">cbox1</xsl:attribute>
 				<xsl:attribute name="value">cbox1</xsl:attribute>
 				<xsl:attribute name="onclick">
 				<xsl:choose>
 					<xsl:when test="$element/attribute[@name='isRepeatable'] = 'true'">
 						this.checked=true;
 					</xsl:when>
 					<xsl:otherwise>
 						this.checked=false;
 					</xsl:otherwise>
 				</xsl:choose>
 				</xsl:attribute>
				</input>				
			</td>
			<td bgcolor="#cccccc" align="center">
				<label for="cbox2"/>
				<input type="checkbox" name="multipleOccurrences">
				<xsl:attribute name="readonly">true</xsl:attribute>
 				<xsl:if test="$element/attribute[@name='hasMultipleOccurrences'] = 'true'">
  					<xsl:attribute name="checked">checked</xsl:attribute>
 				</xsl:if>
 				<xsl:attribute name="id">cbox2</xsl:attribute>
 				<xsl:attribute name="value">cbox2</xsl:attribute>
 				<xsl:attribute name="onclick">
 				<xsl:choose>
 					<xsl:when test="$element/attribute[@name='hasMultipleOccurrences'] = 'true'">
 						this.checked=true;
 					</xsl:when>
 					<xsl:otherwise>
 						this.checked=false;
 					</xsl:otherwise>
 				</xsl:choose>
 				</xsl:attribute>
				</input>				
			</td>
			<td align="center">
				<label for="cbox3"/>
				<input type="checkbox" name="optional">
				<xsl:attribute name="readonly">true</xsl:attribute>
 				<xsl:if test="$element/attribute[@name='isOptional'] = 'true'">
  					<xsl:attribute name="checked">checked</xsl:attribute>
 				</xsl:if>
 				<xsl:attribute name="id">cbox3</xsl:attribute>
 				<xsl:attribute name="value">cbox3</xsl:attribute>
 				<xsl:attribute name="onclick">
 				<xsl:choose>
 					<xsl:when test="$element/attribute[@name='isOptional'] = 'true'">
 						this.checked=true;
 					</xsl:when>
 					<xsl:otherwise>
 						this.checked=false;
 					</xsl:otherwise>
 				</xsl:choose>
 				</xsl:attribute>
				</input>
			</td>
			<td bgcolor="#cccccc" align="center">
				<label for="cbox2"/>
				<input type="checkbox" name="planned">
				<xsl:attribute name="readonly">true</xsl:attribute>
 				<xsl:if test="$element/attribute[@name='isPlanned'] = 'true'">
  					<xsl:attribute name="checked">checked</xsl:attribute>
 				</xsl:if>
 				<xsl:attribute name="id">cbox2</xsl:attribute>
 				<xsl:attribute name="value">cbox2</xsl:attribute>
 				<xsl:attribute name="onclick">
 				<xsl:choose>
 					<xsl:when test="$element/attribute[@name='isPlanned'] = 'true'">
 						this.checked=true;
 					</xsl:when>
 					<xsl:otherwise>
 						this.checked=false;
 					</xsl:otherwise>
 				</xsl:choose>
 				</xsl:attribute>
				</input>				
			</td>
			<td><xsl:value-of select="$element/@Type"/></td>
		</tr>
		<xsl:if test="count($element/Element) > 0">
			<xsl:for-each select="$element/Element">
				<xsl:call-template name="wbsItem">
					<xsl:with-param name="element" select="."/>
					<xsl:with-param name="indent" select="concat('&#160;&#160;&#160;&#160;', $indent)"/>
					<xsl:with-param name="parentNodeId" select="$element/@nodeId"/>
				</xsl:call-template>
			</xsl:for-each>
		</xsl:if>
	</xsl:template>
	
</xsl:stylesheet>
