<?xml version="1.0" encoding="UTF-8"?>
<!-- 
    Copyright (c) 2005, 2006 IBM Corporation and others.
    All rights reserved. This program and the accompanying materials
    are made available under the terms of the Eclipse Public License v1.0
    which accompanies this distribution, and is available at
    http://www.eclipse.org/legal/epl-v10.html
    Contributors:
    IBM Corporation - initial implementation
-->

<xsl:stylesheet version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
	xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance">
	
    <xsl:include href="helper.xsl"/>
    
	
	<xsl:template match="/Element">
		<xsl:variable name="Name" select="@Name"/>
		<xsl:variable name="elementType" select="@Type"/>
		<xsl:variable name="elementTypeName" select="@TypeName"/>
		<xsl:variable name="elementName" select="@DisplayName"/>
		<xsl:variable name="backPath" select="@BackPath"/>
		<xsl:variable name="shapeImage" select="concat($backPath,@ShapeiconUrl)"/>
		<xsl:variable name="imagePath" select="concat($backPath, 'images/')"/>	
		<xsl:variable name="presentationName_temp" select="reference[@name='presentation']/Element/attribute[@name='presentationName']" />
    	<xsl:variable name="presentationName">
			<xsl:choose>
				<xsl:when test="$presentationName_temp != '' "><xsl:value-of select="$presentationName_temp"/></xsl:when>
				<xsl:otherwise><xsl:value-of select="$Name"/></xsl:otherwise>				
			</xsl:choose>
    	</xsl:variable>
	    <xsl:variable name="presentation" select="reference[@name='presentation']"/>
		<xsl:variable name="description" select="$presentation/Element"/>
		<xsl:variable name="copyright" select="copyright"/>
	    <xsl:variable name="showTreeBrowser" select="@showTreeBrowser"/>
		<xsl:variable name="briefDescription" select="attribute[@name='briefDescription']"/>	    
		<html>
			<head>
				<xsl:choose>
					<xsl:when test="$elementType = 'CustomCategory'">				
						<title><xsl:value-of select="$elementName"/></title>
					</xsl:when>				
					<xsl:otherwise>
						<title><xsl:value-of select="$elementType"/>: <xsl:value-of select="$elementName"/></title>
					</xsl:otherwise>
				</xsl:choose>
				<meta http-equiv="Content-Type" content="text/html; charset=utf-8"/>
				<meta name="element_type"> 
					<xsl:call-template name="mapping">
						<xsl:with-param name="elementType" select="$elementType"/>
					</xsl:call-template>
				</meta>
				<!-- <meta name="element_type" content="{$elementType}"/> -->
				<meta name="filetype" content="description"/>
				<link rel="StyleSheet" href="{$backPath}css/default.css" type="text/css"/>
				<script language="JavaScript" type="text/javascript" src="{$backPath}scripts/contentpage.js"></script>
				<script  language="JavaScript" type="text/javascript" >
					backPath = '<xsl:value-of select="$backPath"/>';
				</script>
			</head>
			<body onload="createSectionLinks('div', 'sectionHeading', '{$imagePath}');">
				<table border="0" cellpadding="0" cellspacing="0" width="100%">
					<tr>
						<td valign="top">
							<a name="Top"/>
							<xsl:call-template name="overview">
								<xsl:with-param name="elementType" select="$elementType"/>
								<xsl:with-param name="elementTypeName" select="$elementTypeName"/>
								<xsl:with-param name="elementName" select="$elementName"/>
								<xsl:with-param name="elementIcon" select="$shapeImage"/>
								<xsl:with-param name="backPath" select="$backPath"/>
								<xsl:with-param name="showTreeBrowser" select="$showTreeBrowser"/>
							</xsl:call-template>
							<xsl:call-template name="relationshipsSection">
								<xsl:with-param name="elementType" select="$elementType"/>
							</xsl:call-template>
							<xsl:call-template name="mainDescriptionSection">
								<xsl:with-param name="description" select="$description"/>
							</xsl:call-template>
							<xsl:if test="$elementType != 'CustomCategory'">
								<xsl:call-template name="illustrationsSection"/>
							</xsl:if>
							<xsl:call-template name="keyConsiderationsSection">
								<xsl:with-param name="description" select="$description"/>
							</xsl:call-template>
							<xsl:call-template name="moreInfoSection">
								<xsl:with-param name="elementType" select="$elementType"/>
								<xsl:with-param name="briefDescription" select="$briefDescription"/>
							</xsl:call-template>
							<xsl:call-template name="copyright">
								<xsl:with-param name="copyright" select="$copyright"/>
							</xsl:call-template>
						</td>						
					</tr>
				</table>
			</body>
		</html>
    </xsl:template>
    
	<xsl:template name="moreInfoSection">
		<xsl:param name="elementType"/>
		<xsl:param name="briefDescription"/>
		<xsl:variable name="checklists" select="referenceList/Element[@Type='Checklist']"/>
		<xsl:variable name="concepts" select="referenceList/Element[@Type='Concept']"/>
		<xsl:variable name="guidelines" select="referenceList/Element[@Type='Guideline']"/>
		<xsl:variable name="supportingMaterials" select="referenceList/Element[@Type='SupportingMaterial']"/>
		<xsl:variable name="whitePapers" select="referenceList/Element[@Type='Whitepaper']"/>
		<xsl:variable name="conceptsAndPapers" select="referenceList/Element[@Type='conceptsAndPapers']"/>
		
		<xsl:choose>
			<xsl:when test="$elementType = 'CustomCategory'">
			<!--
				<xsl:if test="count($checklists) + count($conceptsAndPapers) + count($guidelines) > 0">
					<div class="sectionHeading"><xsl:value-of select="$moreInfoText"/></div>
					<div class="sectionContent">
						<table class="sectionTable" border="0" cellspacing="0" cellpadding="0">
							<xsl:call-template name="addChecklists">
								<xsl:with-param name="checklists" select="$checklists"/>
							</xsl:call-template>
							<xsl:call-template name="addConcepts">
								<xsl:with-param name="concepts" select="$conceptsAndPapers"/>
							</xsl:call-template>
							<xsl:call-template name="addGuidelines">
								<xsl:with-param name="guidelines" select="$guidelines"/>
							</xsl:call-template>							
						</table>
					</div>
				</xsl:if>
			-->
			</xsl:when>
			<xsl:otherwise>
				<xsl:if test="count($checklists) + count($concepts) + count($guidelines) + count($supportingMaterials) + count($whitePapers) > 0">
					<div class="sectionHeading"><xsl:value-of select="$moreInfoText"/></div>
					<div class="sectionContent">
						<table class="sectionTable" border="0" cellspacing="0" cellpadding="0">
							<xsl:call-template name="addChecklists">
								<xsl:with-param name="checklists" select="$checklists"/>
							</xsl:call-template>
							<xsl:call-template name="addConcepts">
								<xsl:with-param name="concepts" select="$concepts"/>
							</xsl:call-template>
							<xsl:call-template name="addGuidelines">
								<xsl:with-param name="guidelines" select="$guidelines"/>
							</xsl:call-template>
							<xsl:call-template name="addSupportingMaterials">
								<xsl:with-param name="supportingMaterials" select="$supportingMaterials"/>
							</xsl:call-template>
							<xsl:call-template name="addWhitePapers">
								<xsl:with-param name="whitePapers" select="$whitePapers"/>
							</xsl:call-template>
						</table>
					</div>
				</xsl:if>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	
    <xsl:template name="relationshipsSection">
		<xsl:param name="elementType"/>
		<xsl:if test="$elementType = 'Discipline'">
			<xsl:call-template name="showDisciple"/>
		</xsl:if>
		<xsl:if test="$elementType = 'DisciplineGrouping'">
			<xsl:call-template name="showDiscipleGrouping"/>
		</xsl:if>
		<xsl:if test="$elementType = 'Domain'">
			<xsl:call-template name="showDomain"/>
		</xsl:if>
		<xsl:if test="$elementType = 'WorkProductType'">
			<xsl:call-template name="showWorkProductType"/>
		</xsl:if>		
		<xsl:if test="$elementType = 'RoleSetGrouping'">
			<xsl:call-template name="showRoleSetGrouping"/>
		</xsl:if>
		<xsl:if test="$elementType = 'RoleSet'">
			<xsl:call-template name="showRoleSet"/>
		</xsl:if>
		<xsl:if test="$elementType = 'Tool'">
			<xsl:call-template name="showTool"/>
		</xsl:if>
		<xsl:if test="$elementType = 'CustomCategory'">
			<xsl:call-template name="showCustomCategory"/>
		</xsl:if>		
    </xsl:template>
	
    <xsl:template name="showDisciple">
		<xsl:variable name="referenceWorkflows" select="referenceList[@name='referenceWorkflows']/Element"/>
		<xsl:variable name="tasks" select="referenceList[@name='tasks']/Element"/>	
				
		<xsl:if test="count($referenceWorkflows) + count($tasks) > 0">
			<div class="sectionHeading"><xsl:value-of select="$relationshipsText"/></div>
			<div class="sectionContent">
				<table class="sectionTable" border="0" cellspacing="0" cellpadding="0">
					<xsl:if test="count($referenceWorkflows) > 0">
						<tr valign="top">
							<th class="sectionTableHeading" scope="row"><xsl:value-of select="$referenceWorkflowsText"/></th>
							<td class="sectionTableCell">
								<ul>
									<xsl:for-each select="$referenceWorkflows">
										<li>
											<a>
												<xsl:attribute name="href"><xsl:value-of select="/Element/@BackPath"/><xsl:value-of select="@Url"/></xsl:attribute>
												<xsl:value-of select="@DisplayName"/>
											</a>
										</li>
									</xsl:for-each>
								</ul>
							</td>
						</tr>
					</xsl:if>
					<xsl:if test="count($tasks) > 0">
						<tr valign="top">
							<th class="sectionTableHeading" scope="row"><xsl:value-of select="$tasksText"/></th>
							<td class="sectionTableCell">
								<ul>
									<xsl:for-each select="$tasks">
										<xsl:sort data-type="text" select="@DisplayName" order="ascending" />
										<li>
											<a>
												<xsl:attribute name="href"><xsl:value-of select="/Element/@BackPath"/><xsl:value-of select="@Url"/></xsl:attribute>
												<xsl:value-of select="@DisplayName"/>
											</a>
										</li>
									</xsl:for-each>
								</ul>
							</td>
						</tr>
					</xsl:if>										
				</table>
			</div>
		</xsl:if>
    </xsl:template>
    
    <xsl:template name="showDiscipleGrouping">
		<xsl:variable name="disciplines" select="referenceList[@name='disciplines']/Element"/>
		
		<xsl:if test="count($disciplines) > 0">
			<div class="sectionHeading"><xsl:value-of select="$relationshipsText"/></div>
			<div class="sectionContent">
				<table class="sectionTable" border="0" cellspacing="0" cellpadding="0">
					<xsl:if test="count($disciplines) > 0">
						<tr valign="top">
							<th class="sectionTableHeading" scope="row"><xsl:value-of select="$disciplinesText"/></th>
							<td class="sectionTableCell">
								<ul>
									<xsl:for-each select="$disciplines">
										<li>
											<a>
												<xsl:attribute name="href"><xsl:value-of select="/Element/@BackPath"/><xsl:value-of select="@Url"/></xsl:attribute>
												<xsl:value-of select="@DisplayName"/>
											</a>
										</li>
									</xsl:for-each>
								</ul>
							</td>
						</tr>
					</xsl:if>
				</table>
			</div>
		</xsl:if>
    </xsl:template>
    
    <xsl:template name="showDomain">
		<xsl:variable name="subdomains" select="referenceList[@name='subdomains']/Element"/>
		<xsl:variable name="workProducts" select="referenceList[@name='workProducts']/Element"/>
						
		<xsl:if test="count($subdomains) + count($workProducts) > 0">
			<div class="sectionHeading"><xsl:value-of select="$relationshipsText"/></div>
			<div class="sectionContent">
				<table class="sectionTable" border="0" cellspacing="0" cellpadding="0">
					<xsl:if test="count($subdomains) > 0">
						<tr valign="top">
							<th class="sectionTableHeading" scope="row"><xsl:value-of select="$subdomainsText"/></th>
							<td class="sectionTableCell">
								<ul>
									<xsl:for-each select="$subdomains">
										<li>
											<a>
												<xsl:attribute name="href"><xsl:value-of select="/Element/@BackPath"/><xsl:value-of select="@Url"/></xsl:attribute>
												<xsl:value-of select="@DisplayName"/>
											</a>
										</li>
									</xsl:for-each>
								</ul>
							</td>
						</tr>
					</xsl:if>
					<xsl:if test="count($workProducts) > 0">
						<tr valign="top">
							<th class="sectionTableHeading" scope="row"><xsl:value-of select="$workProductsText"/></th>
							<td class="sectionTableCell">
								<ul>
									<xsl:for-each select="$workProducts">
									<xsl:sort data-type="text" select="@DisplayName" order="ascending" />
										<li>
											<a>
												<xsl:attribute name="href"><xsl:value-of select="/Element/@BackPath"/><xsl:value-of select="@Url"/></xsl:attribute>
												<xsl:value-of select="@DisplayName"/>
											</a>
										</li>
									</xsl:for-each>
								</ul>
							</td>
						</tr>
					</xsl:if>														
				</table>
			</div>
		</xsl:if>
    </xsl:template>
    
    <xsl:template name="showWorkProductType">
		<xsl:variable name="workProducts" select="referenceList[@name='workProducts']/Element"/>
						
		<xsl:if test="count($workProducts) > 0">
			<div class="sectionHeading"><xsl:value-of select="$relationshipsText"/></div>
			<div class="sectionContent">
				<table class="sectionTable" border="0" cellspacing="0" cellpadding="0">
					<xsl:if test="count($workProducts) > 0">
						<tr valign="top">
							<th class="sectionTableHeading" scope="row"><xsl:value-of select="$workProductsText"/></th>
							<td class="sectionTableCell">
								<ul>
									<xsl:for-each select="$workProducts">
										<li>
											<a>
												<xsl:attribute name="href"><xsl:value-of select="/Element/@BackPath"/><xsl:value-of select="@Url"/></xsl:attribute>
												<xsl:value-of select="@DisplayName"/>
											</a>
										</li>
									</xsl:for-each>
								</ul>
							</td>
						</tr>
					</xsl:if>														
				</table>
			</div>
		</xsl:if>
    </xsl:template>
        
    <xsl:template name="showRoleSetGrouping">
		<xsl:variable name="roleSets" select="referenceList[@name='roleSets']/Element"/>
		
		<xsl:if test="count($roleSets) > 0">
			<div class="sectionHeading"><xsl:value-of select="$relationshipsText"/></div>
			<div class="sectionContent">
				<table class="sectionTable" border="0" cellspacing="0" cellpadding="0">
					<xsl:if test="count($roleSets) > 0">
						<tr valign="top">
							<th class="sectionTableHeading" scope="row"><xsl:value-of select="$roleSetsText"/></th>
							<td class="sectionTableCell">
								<ul>
									<xsl:for-each select="$roleSets">
										<li>
											<a>
												<xsl:attribute name="href"><xsl:value-of select="/Element/@BackPath"/><xsl:value-of select="@Url"/></xsl:attribute>
												<xsl:value-of select="@DisplayName"/>
											</a>
										</li>
									</xsl:for-each>
								</ul>
							</td>
						</tr>
					</xsl:if>
				</table>
			</div>
		</xsl:if>
    </xsl:template>
    
    <xsl:template name="showRoleSet">
		<xsl:variable name="roles" select="referenceList[@name='roles']/Element"/>
		
		<xsl:if test="count($roles) > 0">
			<div class="sectionHeading"><xsl:value-of select="$relationshipsText"/></div>
			<div class="sectionContent">
				<table class="sectionTable" border="0" cellspacing="0" cellpadding="0">
					<xsl:if test="count($roles) > 0">
						<tr valign="top">
							<th class="sectionTableHeading" scope="row"><xsl:value-of select="$rolesText"/></th>
							<td class="sectionTableCell">
								<ul>
									<xsl:for-each select="$roles">
										<li>
											<a>
												<xsl:attribute name="href"><xsl:value-of select="/Element/@BackPath"/><xsl:value-of select="@Url"/></xsl:attribute>
												<xsl:value-of select="@DisplayName"/>
											</a>
										</li>
									</xsl:for-each>
								</ul>
							</td>
						</tr>
					</xsl:if>
				</table>
			</div>
		</xsl:if>
    </xsl:template>
    
    <xsl:template name="showTool">
		<xsl:variable name="toolMentors" select="referenceList[@name='toolMentors']/Element"/>
		
		<xsl:if test="count($toolMentors) > 0">
			<div class="sectionHeading"><xsl:value-of select="$relationshipsText"/></div>
			<div class="sectionContent">
				<table class="sectionTable" border="0" cellspacing="0" cellpadding="0">
					<xsl:if test="count($toolMentors) > 0">
						<tr valign="top">
							<th class="sectionTableHeading" scope="row"><xsl:value-of select="$toolMentorsText"/></th>
							<td class="sectionTableCell">
								<ul>
									<xsl:for-each select="$toolMentors">
										<li>
											<a>
												<xsl:attribute name="href"><xsl:value-of select="/Element/@BackPath"/><xsl:value-of select="@Url"/></xsl:attribute>
												<xsl:value-of select="@DisplayName"/>
											</a>
										</li>
									</xsl:for-each>
								</ul>
							</td>
						</tr>
					</xsl:if>
				</table>
			</div>
		</xsl:if>
    </xsl:template>
    
    <xsl:template name="showCustomCategory">
		<xsl:variable name="categorizedElements" select="referenceList[@name='categorizedElements']/Element"/>
		
		<xsl:if test="count($categorizedElements) > 0">
			<div class="sectionHeading"><xsl:value-of select="$relationshipsText"/></div>
			<div class="sectionContent">
				<table class="sectionTable" border="0" cellspacing="0" cellpadding="0">					
					<!-- <xsl:if test="count($categorizedElements[@Type!='CustomCategory']) > 0"> -->
						<tr valign="top">
							<th class="sectionTableHeading" scope="row"><xsl:value-of select="$contentsText"/></th>
							<td class="sectionTableCell">
								<ul>
									<xsl:for-each select="$categorizedElements[@Type!='CustomCategory']">
										<li>
											<a>
												<xsl:attribute name="href"><xsl:value-of select="/Element/@BackPath"/><xsl:value-of select="@Url"/></xsl:attribute>
												<xsl:value-of select="@DisplayName"/>
											</a>
										</li>										
									</xsl:for-each>
									<xsl:for-each select="$categorizedElements[@Type='CustomCategory']">
										<li>
											<a>
												<xsl:attribute name="href"><xsl:value-of select="/Element/@BackPath"/><xsl:value-of select="@Url"/></xsl:attribute>
												<xsl:value-of select="@DisplayName"/>
											</a>
										</li>
									</xsl:for-each>
								</ul>
							</td>
						</tr>
					<!-- </xsl:if> -->
				</table>
			</div>
		</xsl:if>
    </xsl:template>
    
</xsl:stylesheet>
