<?xml version="1.0" encoding="UTF-8"?>
<!-- 
    Copyright (c) 2005, 2006 IBM Corporation and others.
    All rights reserved. This program and the accompanying materials
    are made available under the terms of the Eclipse Public License v1.0
    which accompanies this distribution, and is available at
    http://www.eclipse.org/legal/epl-v10.html
    Contributors:
    IBM Corporation - initial implementation
-->

<xsl:stylesheet version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
	xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance">
	
	<xsl:include href="helper.xsl"/>

	<xsl:param name="pageNotInstalledText"/>
	<xsl:param name="elementDoesNotExistText"/>
	<xsl:param name="isNotValidText"/>
	<xsl:param name="elementMightBeDeletedText"/>
	<xsl:param name="pleaseFixLinkText"/>
	<xsl:param name="infoAboutMissingElementText"/>
	<xsl:param name="elementNameText"/>
	<xsl:param name="guidText"/>
	<xsl:param name="missingElementText"/>
	<xsl:param name="notAvailableText"/>
	<xsl:param name="elementTypeText"/>
	<xsl:param name="pluginNameText"/>

	<xsl:template match="/Element">
		<xsl:variable name="copyright" select="copyright"/>
		<xsl:variable name="showTreeBrowser" select="@showTreeBrowser"/>		
		<html>	
			<head>
				<title><xsl:value-of select="$pageNotInstalledText"/></title>
				<meta http-equiv="Content-Type" content="text/html; charset=utf-8"/>
			</head>		
			<body>
			<xsl:choose>
				<xsl:when test="@invalidLink">
					<b><h3><xsl:value-of select="$elementDoesNotExistText"/></h3></b>
					<p/>
					<xsl:value-of select="$isNotValidText"/>
					<br/>	
					<xsl:value-of select="$elementMightBeDeletedText"/>
					<p/>
					<xsl:value-of select="$pleaseFixLinkText"/>										
				</xsl:when>
			<xsl:otherwise>
				<b><h3><xsl:value-of select="$missingElementText"/></h3></b>
				<p/>
				<xsl:value-of select="$notAvailableText"/>								
			</xsl:otherwise>
			</xsl:choose>
			</body>
		</html>
	</xsl:template>
</xsl:stylesheet>
