<?xml version="1.0" encoding="UTF-8"?>
<!-- 
    Copyright (c) 2005, 2006 IBM Corporation and others.
    All rights reserved. This program and the accompanying materials
    are made available under the terms of the Eclipse Public License v1.0
    which accompanies this distribution, and is available at
    http://www.eclipse.org/legal/epl-v10.html
    Contributors:
    IBM Corporation - initial implementation
-->

<xsl:stylesheet version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
	xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance">
	
	<xsl:include href="helper.xsl"/>
	
	
	<xsl:template match="/Element">
		<xsl:variable name="elementType" select="@Type"/>
		<xsl:variable name="elementTypeName" select="@TypeName"/>
		<xsl:variable name="elementName" select="@DisplayName"/>
		<xsl:variable name="backPath" select="@BackPath"/>
		<xsl:variable name="imagePath" select="concat($backPath, 'images/')"/>		
	    <xsl:variable name="shapeImage" select="concat($backPath,@ShapeiconUrl)"/>
		<xsl:variable name="presentation" select="reference[@name='presentation']"/>
		<xsl:variable name="contentDescription" select="$presentation/Element"/>
		<xsl:variable name="copyright" select="copyright"/>
		<xsl:variable name="showTreeBrowser" select="@showTreeBrowser"/>
		<xsl:variable name="responsibleRole" select="reference[@name='responsibleRole']/Element[@Type='Role']"/>
		
    	<html>
			<head>
				<title><xsl:value-of select="$elementType"/>: <xsl:value-of select="$elementName"/></title>
				<meta http-equiv="Content-Type" content="text/html; charset=utf-8"/>
				<meta name="element_type" content="{$elementType}"/>
				<meta name="filetype" content="description"/>
				<meta name="role">
				<xsl:attribute name="content"><xsl:value-of select="$responsibleRole/@DisplayName"/></xsl:attribute>
				</meta>
				<link rel="StyleSheet" href="{$backPath}css/default.css" type="text/css"/>
				<script language="JavaScript" type="text/javascript" src="{$backPath}scripts/contentpage.js"></script>
				<script  language="JavaScript" type="text/javascript" >
					backPath = '<xsl:value-of select="$backPath"/>';
				</script>
			</head>
			<body onload="createSectionLinks('div', 'sectionHeading', '{$imagePath}');">
				<table border="0" cellpadding="0" cellspacing="0" width="100%">
					<tr>
						<td valign="top">
							<a name="Top"/>
							<xsl:call-template name="overview">
								<xsl:with-param name="elementType" select="$elementType"/>
								<xsl:with-param name="elementTypeName" select="$elementTypeName"/>
								<xsl:with-param name="elementName" select="$elementName"/>
								<xsl:with-param name="elementIcon" select="$shapeImage"/>
								<xsl:with-param name="backPath" select="$backPath"/>
								<xsl:with-param name="showTreeBrowser" select="$showTreeBrowser"/>
							</xsl:call-template>
							<xsl:call-template name="relationshipsSection2"/>
							<xsl:call-template name="descriptionSection">
								<xsl:with-param name="description" select="$contentDescription"/>
							</xsl:call-template>
							<xsl:call-template name="copyright">
								<xsl:with-param name="copyright" select="$copyright"/>
							</xsl:call-template>
						</td>						
					</tr>
				</table>
			</body>
		</html>
	</xsl:template>
	
	<xsl:template name="relationshipsSection2">
		<xsl:variable name="subPractices" select="referenceList[@name='subPractices']/Element"/>	
		<xsl:variable name="contentReferences" select="referenceList[@name='contentReferences']/Element"/>
			<div class="sectionHeading"><xsl:value-of select="$relationshipsText"/></div>
			<div class="sectionContent">
				<table class="sectionTable" border="0" cellspacing="0" cellpadding="0">
					<xsl:if test="count($subPractices) > 0">
						<tr valign="top">
							<th class="sectionTableHeading" scope="row"><xsl:value-of select="$subPracticesText"/></th>
							<td class="sectionTableCell">
								<ul>
									<xsl:for-each select="$subPractices">
										<li>
											<a>
												<xsl:attribute name="href"><xsl:value-of select="/Element/@BackPath"/><xsl:value-of select="@Url"/></xsl:attribute>
												<xsl:value-of select="@DisplayName"/>
											</a>
										</li>
									</xsl:for-each>
								</ul>
							</td>
						</tr>
					</xsl:if>
					<xsl:if test="count($contentReferences) > 0">
						<tr valign="top">
							<th class="sectionTableHeading" scope="row"><xsl:value-of select="$contentReferencesText"/></th>
							<td class="sectionTableCell">
								<ul>
									<xsl:for-each select="$contentReferences">
										<li>
											<a>
												<xsl:attribute name="href"><xsl:value-of select="/Element/@BackPath"/><xsl:value-of select="@Url"/></xsl:attribute>
												<xsl:value-of select="@DisplayName"/>
											</a>
										</li>
									</xsl:for-each>
								</ul>
							</td>
						</tr>
					</xsl:if>					
				</table>
			</div>		
    </xsl:template>
    
	<xsl:template name="descriptionSection">
		<xsl:param name="description"/>
		<xsl:variable name="mainDescription" select="$description/attribute[@name='mainDescription']"/>
		<xsl:variable name="problem" select="$description/attribute[@name='problem']"/>
		<xsl:variable name="background" select="$description/attribute[@name='background']"/>
		<xsl:variable name="goals" select="$description/attribute[@name='goals']"/>
		<xsl:variable name="application" select="$description/attribute[@name='application']"/>
		<xsl:variable name="levelsOfAdoption" select="$description/attribute[@name='levelsOfAdoption']"/>
		<xsl:variable name="additionalInfo" select="$description/attribute[@name='additionalInfo']"/>
		
		<xsl:if test="$mainDescription != '' or $problem != '' or $background != '' or $goals != '' or $application != '' or $levelsOfAdoption != '' or $additionalInfo != ''">
			<div class="sectionHeading"><xsl:value-of select="$descriptionText"/></div>
			<div class="sectionContent">			
				<table class="sectionTable" border="0" cellspacing="0" cellpadding="0">
					<xsl:if test="$mainDescription != ''">
						<tr valign="top">
							<th class="sectionTableHeading" scope="row"><xsl:value-of select="$mainDescriptionText"/></th>
							<td class="sectionTableCell">
								<xsl:value-of disable-output-escaping="yes" select="$mainDescription"/>
							</td>
						</tr>
					</xsl:if>
					<xsl:if test="$problem != ''">
						<tr valign="top">
							<th class="sectionTableHeading" scope="row"><xsl:value-of select="$problemText"/></th>
							<td class="sectionTableCell">
								<xsl:value-of disable-output-escaping="yes" select="$problem"/>
							</td>
						</tr>
					</xsl:if>
					<xsl:if test="$background != ''">
						<tr valign="top">
							<th class="sectionTableHeading" scope="row"><xsl:value-of select="$backgroundText"/></th>
							<td class="sectionTableCell">
								<xsl:value-of disable-output-escaping="yes" select="$background"/>
							</td>
						</tr>
					</xsl:if>
					<xsl:if test="$goals != ''">
						<tr valign="top">
							<th class="sectionTableHeading" scope="row"><xsl:value-of select="$goalsText"/></th>
							<td class="sectionTableCell">
								<xsl:value-of disable-output-escaping="yes" select="$goals"/>
							</td>
						</tr>
					</xsl:if>
					<xsl:if test="$application != ''">
						<tr valign="top">
							<th class="sectionTableHeading" scope="row"><xsl:value-of select="$applicationText"/></th>
							<td class="sectionTableCell">
								<xsl:value-of disable-output-escaping="yes" select="$application"/>
							</td>
						</tr>
					</xsl:if>
					<xsl:if test="$levelsOfAdoption != ''">
						<tr valign="top">
							<th class="sectionTableHeading" scope="row"><xsl:value-of select="$levelsOfAdoptionText"/></th>
							<td class="sectionTableCell">
								<xsl:value-of disable-output-escaping="yes" select="$levelsOfAdoption"/>
							</td>
						</tr>
					</xsl:if>
					<xsl:if test="$additionalInfo != ''">
						<tr valign="top">
							<th class="sectionTableHeading" scope="row"><xsl:value-of select="$additionalInfoText"/></th>
							<td class="sectionTableCell">
								<xsl:value-of disable-output-escaping="yes" select="$additionalInfo"/>
							</td>
						</tr>
					</xsl:if>
				</table>
			</div>
		</xsl:if>
	</xsl:template>    
	
</xsl:stylesheet>
