<?xml version="1.0" encoding="UTF-8"?>
<!-- 
    Copyright (c) 2005, 2006 IBM Corporation and others.
    All rights reserved. This program and the accompanying materials
    are made available under the terms of the Eclipse Public License v1.0
    which accompanies this distribution, and is available at
    http://www.eclipse.org/legal/epl-v10.html
    Contributors:
    IBM Corporation - initial implementation
-->

<xsl:stylesheet version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
	xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance">

	<xsl:include href="helper.xsl"/>
	
			
	<xsl:template match="/Element">
		<xsl:variable name="elementType" select="@Type"/>
		<xsl:variable name="elementTypeName" select="@TypeName"/>
		<xsl:variable name="elementName" select="@DisplayName"/>
		<xsl:variable name="backPath" select="@BackPath"/>
		<xsl:variable name="imagePath" select="concat($backPath, 'images/')"/>
	    <xsl:variable name="shapeImage" select="concat($backPath,@ShapeiconUrl)"/>
		<xsl:variable name="presentation" select="reference[@name='presentation']"/>
		<xsl:variable name="contentDescription" select="$presentation/Element[@Type='BreakdownElementDescription']"/>
		<xsl:variable name="breakdownElementDescription" select="$presentation/Element[@Type='BreakdownElementDescription']"/>
		<xsl:variable name="descriptorDescription" select="$presentation/Element[@Type='DescriptorDescription']"/>		
		<xsl:variable name="copyright" select="copyright"/>
		<xsl:variable name="showTreeBrowser" select="@showTreeBrowser"/>
		
		<html>	
			<head>
				<title><xsl:value-of select="$elementType"/>: <xsl:value-of select="$elementName"/></title>
				<meta http-equiv="Content-Type" content="text/html; charset=utf-8"/>
				<meta name="element_type" content="{$elementType}"/>
				<meta name="filetype" content="description"/>
				<link rel="StyleSheet" href="{$backPath}css/default.css" type="text/css"/>
				<script language="JavaScript" type="text/javascript" src="{$backPath}scripts/contentpage.js"></script>
				<script language="JavaScript" type="text/javascript">
					backPath = '<xsl:value-of select="$backPath"/>';
				</script>
			</head>
			<body onload="createSectionLinks('div', 'sectionHeading', '{$imagePath}');">
				<table border="0" cellpadding="0" cellspacing="0" width="100%">
					<tr>
						<td valign="top">	
							<a name="Top"/>
							<xsl:call-template name="overview">
								<xsl:with-param name="elementType" select="$elementType"/>
								<xsl:with-param name="elementTypeName" select="$elementTypeName"/>
								<xsl:with-param name="elementName" select="$elementName"/>
								<xsl:with-param name="elementIcon" select="$shapeImage"/>
								<xsl:with-param name="backPath" select="$backPath"/>
								<xsl:with-param name="showTreeBrowser" select="$showTreeBrowser"/>
							</xsl:call-template>							
							<xsl:call-template name="relationshipsSection"/>
							<xsl:call-template name="mainDescriptionSection">
								<xsl:with-param name="description" select="$breakdownElementDescription"/>
							</xsl:call-template>
							<xsl:call-template name="propertiesSection">
								<xsl:with-param name="contentDescription" select="$contentDescription"/>
							</xsl:call-template>
							<xsl:call-template name="usageSection">
								<xsl:with-param name="contentDescription" select="$breakdownElementDescription"/>
							</xsl:call-template>							
							<xsl:call-template name="keyConsiderationsSection">
								<xsl:with-param name="description" select="$breakdownElementDescription"/>
							</xsl:call-template>							
							<xsl:call-template name="copyright">
								<xsl:with-param name="copyright" select="$copyright"/>
							</xsl:call-template>
						</td>						
					</tr>
				</table>
			</body>
		</html>
	</xsl:template>
	
	<xsl:template name="propertiesSection">
		<xsl:param name="contentDescription"/>
		<div class="sectionHeading"><xsl:value-of select="$propertiesText"/></div>
		<div class="sectionContent">
			<table class="sectionTable" border="0" cellspacing="0" cellpadding="0">
			    <xsl:call-template name="property">
					<xsl:with-param name="fieldLabel" select="$multipleOccurrencesText"/>
					<xsl:with-param name="fieldText" select="attribute[@name='hasMultipleOccurrences']"/>
				</xsl:call-template>
				<xsl:if test="attribute[@name='isOptional']">
					<xsl:call-template name="property">
						<xsl:with-param name="fieldLabel" select="$optionalText"/>
						<xsl:with-param name="fieldText" select="attribute[@name='isOptional']"/>
					</xsl:call-template>
				</xsl:if>
				<xsl:if test="attribute[@name='isPlanned']">
					<xsl:call-template name="property">
						<xsl:with-param name="fieldLabel" select="$plannedText"/>
						<xsl:with-param name="fieldText" select="attribute[@name='isPlanned']"/>
					</xsl:call-template>
				</xsl:if>
			</table>
		</div>
	</xsl:template>
	
	<xsl:template name="relationshipsSection">
		<xsl:variable name="subTeams" select="referenceList[@name='subTeam']/Element"/>		
		<xsl:variable name="teamRoles" select="referenceList[@name='teamRoles']/Element"/>
			
		<xsl:if test="count($subTeams) + count($teamRoles) > 0">
			<div class="sectionHeading"><xsl:value-of select="$relationshipsText"/></div>
			<div class="sectionContent">
				<table class="sectionTable" border="0" cellspacing="0" cellpadding="0">
					<xsl:if test="count($subTeams) > 0">
						<tr valign="top">
							<th class="sectionTableHeading" scope="row"><xsl:value-of select="$subTeamsText"/></th>
							<td class="sectionTableCell" colspan="3">
								<xsl:for-each select="$subTeams">
									<li>
										<a>
											<xsl:attribute name="href"><xsl:value-of select="/Element/@BackPath"/><xsl:value-of select="@Url"/></xsl:attribute>
											<xsl:value-of select="@DisplayName"/>
										</a>
									</li>
								</xsl:for-each>
							</td>
						</tr>
					</xsl:if>
					<xsl:if test="count($teamRoles) > 0">
						<tr valign="top">
							<th class="sectionTableHeading" scope="row"><xsl:value-of select="$teamRolesText"/></th>
							<td class="sectionTableCell" colspan="3">
								<xsl:for-each select="$teamRoles">
									<li>
										<a>
											<xsl:attribute name="href"><xsl:value-of select="/Element/@BackPath"/><xsl:value-of select="@Url"/></xsl:attribute>
											<xsl:value-of select="@DisplayName"/>
										</a>
									</li>
								</xsl:for-each>
							</td>
						</tr>
					</xsl:if>
				</table>
			</div>
		</xsl:if>
	</xsl:template>
	
	<xsl:template name="usageSection">
		<xsl:param name="contentDescription"/>
		<xsl:if test="$contentDescription/attribute[@name='usageGuidance'] != ''">
			<div class="sectionHeading"><xsl:value-of select="$usageText"/></div>
			<div class="sectionContent">
				<table class="sectionTable" border="0" cellspacing="0" cellpadding="0">
					<xsl:call-template name="property">
						<xsl:with-param name="fieldLabel" select="'Usage Guidance'"/>
						<xsl:with-param name="fieldText" select="$contentDescription/attribute[@name='usageGuidance']"/>
					</xsl:call-template>
				</table>
			</div>
		</xsl:if>
	</xsl:template>
	
</xsl:stylesheet>
