<?xml version="1.0" encoding="UTF-8"?>
<!-- 
    Copyright (c) 2005, 2006 IBM Corporation and others.
    All rights reserved. This program and the accompanying materials
    are made available under the terms of the Eclipse Public License v1.0
    which accompanies this distribution, and is available at
    http://www.eclipse.org/legal/epl-v10.html
    Contributors:
    IBM Corporation - initial implementation
-->

<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format">

<xsl:template match="Bookmarks">
<html>
<head>
<style type="text/css">

body {
	background-color: #FFFFFF;
	font-family: arial, helvetica, sans-serif;
	font-size: 10px;
	margin-left: 0px;
	margin-right: 0px;
	margin-top: 0px;
	margin-bottom: 0px;
	text-decoration: none;
}

span.tab {
  cursor : pointer;
  cursor : hand;
  font-size: 10pt;  
}

table.tab {
	background:#c8d7e3;
	}

td.tab {
	background:#c8d7e3;
	border-top:0px solid #99afc4;
	border-bottom:0px solid #99afc4;
	border-right : 1px solid #ffffff;
  	border-left : 2px solid #ffffff;
	white-space:nowrap;
	}

span.tabSeperator{
	background:#ffffff;
	width: 2px;
	white-space:nowrap;
	}

td.menu {
	background:#006699;

}

span.menu {
	cursor : hand;
	font-size: 8pt;
	color: #ffffff;
}

</style>
<script type="text/javascript" src="bookmarkviews.js">
</script>
<script>
function checkKey(el) {
	if (event.keyCode==13)
	{
		el.click();
	}
}
</script>
</head>

<body marginheight="0" marginwidth="0" onload="init();">
<table width="100%" height="100%" border="0">
<tr valign="top">
<td width="100%">

<table class="tab" cellspacing="0px" cellpadding="0px" border="0" width="100%">
<!-- add the tab menus -->
<tr>
<td class="menu" width="100%">
<span class="menu" tabindex="1" onclick="whereAmI();" onkeypress="checkKey(this);"><img alt="" src="images/ni_where.gif"/>Where am I&#160;</span>
<span class="tabSeperator"></span>
<span class="menu" tabindex="1" onclick="togViews();" onkeypress="checkKey(this);"><img alt="" src="images/action_unhide.gif"/>Tree Sets&#160;</span>
</td>
</tr>

<!-- load the tabs -->
	<tr>
	<td width="100%">
<xsl:variable name="size"><xsl:value-of select="count(Bookmark)"/></xsl:variable>
<xsl:for-each select="Bookmark">
	<xsl:variable name="pos"><xsl:value-of select="position()-1"/></xsl:variable>
	<xsl:variable name="name"><xsl:value-of select="@tabName"/></xsl:variable>
	<xsl:variable name="url"><xsl:value-of select="@url"/></xsl:variable>
	<xsl:variable name="default"><xsl:value-of select="@default"/></xsl:variable>
<span class="tab" id="tab{$pos}" tabindex="1"  onkeypress="checkKey(this);" onclick="displayTree(this);">
	<xsl:attribute name="url"><xsl:value-of select="$url"/></xsl:attribute>
	<xsl:attribute name="isDefaultView"><xsl:value-of select="$default"/></xsl:attribute>
&#160;<xsl:value-of select="$name"/>&#160;
<span class="tabSeperator"></span>
</span>

<!--
<xsl:if test="$pos &lt; $size-1 ">
	<span class="tabSeperator"></span>
</xsl:if>
-->
</xsl:for-each>
<!--
	<span class="tab" id="tab0" onclick="displayTree(this, 'Overview.html')">&#160;Tab0</span>
	<span class="tabSeperator"></span>
	<span class="tab" id="tab1" onclick="displayTree(this, 'http://www.google.com')">&#160;Tab1</span>
	<span class="tabSeperator"></span>
	<span class="tab" id="tab2" onclick="displayTree(this, 'http://www.ibm.com')">&#160;Tab2</span>
	<span class="tabSeperator"></span>
	<span class="tab" id="tab3" onclick="displayTree(this, 'about:blank')">&#160;Tab3</span>
-->
	</td>
	</tr>
</table>
</td>
</tr>
<tr valign="top" height="100%">
<td width="100%">
<table width="100%" height="100%" border="1" valign="top">
<tr>
	<td width="100%">
	<iframe name="ory_toc" title="" style="visibility:visible" tabindex="1" frameborder="no" width="100%" height="100%" scrolling="yes">
    </iframe>
	</td>
	</tr>
</table>
</td>
<!--
<td height="100%">
	<iframe name="ory_doc" title="" style="visibility:visible" tabindex="-1" frameborder="no" width="100%" height="100%" scrolling="yes">
    </iframe>
</td>
-->

</tr>
</table>

</body>
</html>


</xsl:template>
</xsl:stylesheet>
