/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.publishing.services;

import com.ibm.uma.MethodConfiguration;
import java.io.File;
import java.net.URL;
import java.text.MessageFormat;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.epf.common.utils.FileUtil;
import org.eclipse.epf.common.utils.StrUtil;
import org.eclipse.epf.library.layout.LayoutResources;
import org.eclipse.epf.library.layout.util.XmlElement;
import org.eclipse.epf.publishing.PublishingPlugin;
import org.eclipse.epf.publishing.PublishingResources;
import org.eclipse.epf.publishing.layout.Bookmark;
import org.eclipse.epf.publishing.layout.BookmarkList;
import org.eclipse.epf.publishing.services.AbstractViewBuilder;
import org.eclipse.epf.publishing.services.GlossaryBuilder;
import org.eclipse.epf.publishing.services.PublishOptions;
import org.eclipse.epf.publishing.services.PublishingContentValidator;
import org.eclipse.epf.publishing.services.PublishingServiceException;
import org.eclipse.epf.publishing.services.index.DefinitionObject;
import org.eclipse.epf.publishing.services.index.KeyWordIndexHelper;
import org.eclipse.epf.publishing.services.search.IndexManager;
import org.eclipse.epf.publishing.util.PublishingUtil;

public class PublishManager {
    private static final String DOC_ROOT = "docroot/";
    public static final String LIBRARY_DIRECTORY = "applet";
    public static final String NO_APPLET_DIRECTORY = "noapplet";
    public static final String APPLET_SEARCH = "applet_search";
    public static final String BOOKMARK_SUFFIX_XML = ".xml";
    public static final String BOOKMARK_SUFFIX_HTML = ".html";
    public static final String SPACE_REPLACEMENT = "_";
    public static final String SPACE_STRING = " ";
    public static final String PUBLISHED_BOOKMARKS_CFG_NAME = "PublishedBookmarks.xml";
    public static final String PUBLISHED_BOOKMARKS_DELIMITER = "*";
    private static final String BOOKMARK_XSL_FILE = "xsl/bookmark.xsl";
    private static final String BOOKMARKS_XSL_FILE = "xsl/PublishedBookmarks.xsl";
    private static final String INDEX_XSL_FILE = "xsl/index.xsl";
    private static final String TOPNAV_XSL_FILE = "xsl/topnav.xsl";
    private static final String KEYWORD_DEF_FILE = "keywordindexdef.txt";
    private static final String PUBLISHING_REPORT_XSL_FILE = "xsl/PublishingReport.xsl";
    private static final String PUBLISHING_REPORT_HTML_FILE = "PublishingReport.html";
    AbstractViewBuilder viewBuilder;
    private boolean debug = false;
    private boolean sucess = false;

    public PublishManager(AbstractViewBuilder viewBuilder) {
        this.viewBuilder = viewBuilder;
        this.debug = PublishingPlugin.getDefault().isDebugging();
    }

    public void publish(IProgressMonitor monitor) throws PublishingServiceException {
        try {
            String title;
            if (monitor.isCanceled()) {
                return;
            }
            long startTime = 0L;
            if (this.debug) {
                startTime = System.currentTimeMillis();
            }
            String publishDir = this.viewBuilder.getHtmlBuilder().getPublishDir();
            PublishOptions options = this.viewBuilder.getOptions();
            this.fixOptions(options);
            MethodConfiguration config = this.viewBuilder.getHtmlBuilder().getLayoutManager().getConfiguration();
            monitor.subTask(PublishingResources.getString("Publishing.initializingDirTask.name"));
            File f = new File(this.viewBuilder.getHtmlBuilder().getPublishDir());
            if (!f.exists()) {
                f.mkdirs();
            }
            monitor.subTask(PublishingResources.getString("Publishing.copyingFilesTask.name"));
            this.copyDocRootFiles();
            this.viewBuilder.getHtmlBuilder().enableContentScan(true);
            this.viewBuilder.getHtmlBuilder().enableTreeBrowser(true);
            monitor.subTask(PublishingResources.getString("Publishing.generatingBookmarksTask.name"));
            this.generateBookmarks(monitor);
            String string = title = options == null ? "" : options.getTitle();
            if (monitor.isCanceled()) {
                return;
            }
            if (options == null || options.isGenerateGlossary()) {
                monitor.subTask(PublishingResources.getString("Publishing.generatingGlossaryTask.name"));
                new GlossaryBuilder().execute(config, publishDir, title, monitor);
            }
            if (monitor.isCanceled()) {
                return;
            }
            if (options == null || options.isGenerateIndex()) {
                monitor.subTask(PublishingResources.getString("Publishing.generatingBookmarkIndexTask.name"));
                this.generateBookmarkIndex(publishDir, title, monitor);
            }
            if (monitor.isCanceled()) {
                return;
            }
            if ((options == null || options.generateSearchDB) && PublishManager.getAppletSearchPath() != null) {
                monitor.subTask(PublishingResources.getString("Publishing.generatingSearchIndexTask.name"));
                IndexManager.createIndex(publishDir, monitor);
            }
            if (monitor.isCanceled()) {
                return;
            }
            this.getPublishingReport();
            if (monitor.isCanceled()) {
                return;
            }
            this.sucess = true;
            if (this.debug) {
                long duration = (System.currentTimeMillis() - startTime) / 1000L;
                System.out.println(MessageFormat.format("Time taken to publish configuration ''{0}'': {1} secs", config.getName(), "" + duration));
            }
        }
        catch (Exception e) {
            throw new PublishingServiceException(e);
        }
    }

    private void generateBookmarks(IProgressMonitor monitor) {
        BookmarkList list = new BookmarkList();
        List bookmarks = this.viewBuilder.buildViews(monitor);
        Bookmark defaultView = this.viewBuilder.getDefaultView();
        if (monitor.isCanceled()) {
            return;
        }
        if (defaultView == null && bookmarks.size() > 0) {
            defaultView = (Bookmark)bookmarks.get(0);
        }
        Iterator it = bookmarks.iterator();
        while (it.hasNext()) {
            Bookmark b = (Bookmark)it.next();
            String fileName = this.writeBookmark(b);
            list.addBookmark(b.getPresentationName(), fileName, defaultView == b);
        }
        this.writePublishedBookmarks(list);
    }

    public String getPublishedUrl() {
        String url;
        File f;
        if (this.sucess && (f = new File(url = this.getIndexFilePath())).exists()) {
            return url;
        }
        return null;
    }

    public void copyDocRootFiles() {
        try {
            URL plugin_url = PublishingPlugin.getDefault().getInstallURL();
            URL url = new URL(plugin_url, DOC_ROOT);
            String fromPath = Platform.resolve((URL)url).getPath();
            String includes = "*.*, process/**, images/**, index/**, scripts/**, stylesheets/**, applet/images/**, applet/help.htm, ext_help/";
            String excludes = "applet_search/**";
            PublishOptions options = this.viewBuilder.getOptions();
            if (options == null || options.useApplet || options.generateSearchDB) {
                includes = String.valueOf(includes) + ", applet/**";
            }
            if (options != null && !options.useApplet) {
                includes = String.valueOf(includes) + ", noapplet/**";
            }
            String publishDir = this.viewBuilder.getHtmlBuilder().getPublishDir();
            LayoutResources.copyDir((String)fromPath, (String)publishDir, (String)includes, (String)excludes);
            if ((options == null || options.generateSearchDB) && (fromPath = PublishManager.getAppletSearchPath()) != null) {
                includes = "*.*, **/";
                LayoutResources.copyDir((String)fromPath, (String)(String.valueOf(publishDir) + LIBRARY_DIRECTORY), (String)includes, null);
            }
            if (options.bannerImage != null && options.bannerImage.length() > 0) {
                FileUtil.copyFile((String)options.bannerImage, (String)(String.valueOf(publishDir) + "images"));
                options.bannerImage = FileUtil.getFileName((String)options.bannerImage);
            } else {
                options.bannerImage = "banner.gif";
            }
            if (options.aboutHTML != null && options.aboutHTML.length() > 0) {
                FileUtil.copyFile((String)options.aboutHTML, (String)(String.valueOf(publishDir) + "about.htm"));
            }
            this.copyLocalizedFiles(new File(publishDir));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void fixOptions(PublishOptions options) {
        if (PublishManager.getAppletSearchPath() == null) {
            options.generateSearchDB = false;
        }
        if (PublishManager.getAppletPath() == null) {
            options.useApplet = false;
        }
    }

    public static String getAppletPath() {
        return PublishManager.getPath(LIBRARY_DIRECTORY);
    }

    public static String getAppletSearchPath() {
        return PublishManager.getPath(APPLET_SEARCH);
    }

    private static String getPath(String folder) {
        try {
            URL plugin_url = PublishingPlugin.getDefault().getInstallURL();
            URL url = new URL(plugin_url, "docroot/applet_search");
            return Platform.resolve((URL)url).getPath();
        }
        catch (Exception exception) {
            return null;
        }
    }

    private void copyLocalizedFiles(File toDir) {
        try {
            PublishingPlugin.getDefault().copyLocalizedFiles("docroot/scripts/", new File(toDir, "scripts/"), true, false);
            PublishingPlugin.getDefault().copyLocalizedFiles("docroot/images/", new File(toDir, "images/"), true, false);
            PublishingPlugin.getDefault().copyLocalizedFiles(DOC_ROOT, new File(toDir, "/"), false, false);
            PublishOptions options = this.viewBuilder.getOptions();
            if (options == null || options.useApplet || options.generateSearchDB) {
                PublishingPlugin.getDefault().copyLocalizedFiles("docroot/applet/", new File(toDir, "applet/"), false, false);
                PublishingPlugin.getDefault().copyLocalizedFiles("docroot/applet_search/", new File(toDir, "applet/"), false, false);
                PublishingPlugin.getDefault().copyLocalizedFiles("docroot/ext_help/", new File(toDir, "ext_help/"), false, false);
                PublishingPlugin.getDefault().copyLocalizedFiles("docroot/applet/localization/", new File(toDir, "applet/localization/"), true, true);
            }
            if (options != null && !options.useApplet) {
                PublishingPlugin.getDefault().copyLocalizedFiles("docroot/noapplet/", new File(toDir, "noapplet/"), false, false);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private String makeBookmarkFileName(String bookmarkName) {
        return String.valueOf(bookmarkName.replace(SPACE_STRING.charAt(0), SPACE_REPLACEMENT.charAt(0))) + BOOKMARK_SUFFIX_XML;
    }

    private String getBookmarkPath() {
        String savePath = String.valueOf(this.viewBuilder.getHtmlBuilder().getPublishDir()) + LIBRARY_DIRECTORY + File.separator;
        File xf = new File(savePath);
        if (!xf.exists()) {
            xf.mkdirs();
        }
        return savePath;
    }

    private String writeBookmark(Bookmark b) {
        PublishOptions options = this.viewBuilder.getOptions();
        String bookmarkFileName = this.makeBookmarkFileName(StrUtil.makeValidFileName((String)b.getPresentationName()));
        XmlElement xml = b.getXmlElement();
        if (options == null || options.useApplet) {
            String savePath = String.valueOf(this.getBookmarkPath()) + bookmarkFileName;
            xml.saveTo(savePath);
        } else {
            String buffer = PublishingUtil.getHtml(xml, BOOKMARK_XSL_FILE);
            if (buffer != null) {
                String htmlPath = this.getBookmarkHtmlPath(bookmarkFileName);
                FileUtil.writeUTF8File((String)htmlPath, (String)buffer.toString());
            }
        }
        return bookmarkFileName;
    }

    private void writePublishedBookmarks(BookmarkList list) {
        String htmlPath;
        boolean showIndex;
        XmlElement xml = list.getXmlElement();
        PublishOptions options = this.viewBuilder.getOptions();
        boolean useApplet = options == null || options.useApplet;
        boolean allowAppletSearch = options == null || options.generateSearchDB;
        boolean showGlossary = options == null || options.generateGlossary;
        boolean bl = showIndex = options == null || options.generateIndex;
        if (useApplet) {
            String savePath = String.valueOf(this.getBookmarkPath()) + PUBLISHED_BOOKMARKS_CFG_NAME;
            xml.saveTo(savePath);
        } else {
            String buffer = PublishingUtil.getHtml(xml, BOOKMARKS_XSL_FILE);
            if (buffer != null) {
                String htmlPath2 = this.getBookmarkHtmlPath(PUBLISHED_BOOKMARKS_CFG_NAME);
                FileUtil.writeUTF8File((String)htmlPath2, (String)buffer.toString());
            }
        }
        XmlElement optionXml = new XmlElement("PublishingOption").setAttribute("title", options == null ? "" : options.title).setAttribute("bannerImage", options == null ? "" : options.bannerImage).setAttribute("feedbackUrl", options == null ? "" : options.feedbackURL).setAttribute("useApplet", useApplet ? "true" : "false").setAttribute("allowAppletSearch", allowAppletSearch ? "true" : "false").setAttribute("showGlossary", showGlossary ? "true" : "false").setAttribute("showIndex", showIndex ? "true" : "false");
        String buffer = PublishingUtil.getHtml(optionXml, INDEX_XSL_FILE);
        if (buffer != null) {
            htmlPath = this.getIndexFilePath();
            FileUtil.writeUTF8File((String)htmlPath, (String)buffer.toString());
        }
        if ((buffer = PublishingUtil.getHtml(optionXml, TOPNAV_XSL_FILE)) != null) {
            htmlPath = String.valueOf(this.viewBuilder.getHtmlBuilder().getPublishDir()) + "topnav.htm";
            FileUtil.writeUTF8File((String)htmlPath, (String)buffer.toString());
        }
    }

    public String getIndexFilePath() {
        return String.valueOf(this.viewBuilder.getHtmlBuilder().getPublishDir()) + "index.htm";
    }

    private String getBookmarkHtmlPath(String boomkarkFile) {
        int indx = boomkarkFile.lastIndexOf(BOOKMARK_SUFFIX_XML);
        return String.valueOf(this.viewBuilder.getHtmlBuilder().getPublishDir()) + NO_APPLET_DIRECTORY + File.separatorChar + boomkarkFile.substring(0, indx) + BOOKMARK_SUFFIX_HTML;
    }

    private void generateBookmarkIndex(String publishDir, String title, IProgressMonitor monitor) {
        try {
            String helpFile;
            String charSet;
            URL url = new URL(PublishingPlugin.getDefault().getInstallURL(), KEYWORD_DEF_FILE);
            if (url == null) {
                System.out.println("Unable to get index definition file ");
                return;
            }
            String deffile = Platform.resolve((URL)url).getPath();
            KeyWordIndexHelper indexHelper = new KeyWordIndexHelper(deffile, charSet = "utf-8", helpFile = null);
            DefinitionObject defObj = indexHelper.loadDefinition(publishDir);
            if (defObj != null) {
                defObj.setwwwRoot(publishDir);
                defObj.setIndexTitle(String.valueOf(PublishingResources.getString("Publishing.indexLabel.text")) + " - " + title);
            }
            indexHelper.execute(monitor);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public String getPublishingReport() {
        String publishDir = this.viewBuilder.getHtmlBuilder().getPublishDir();
        String file_pathname = "logs" + File.separator + PUBLISHING_REPORT_HTML_FILE;
        File f = new File(publishDir, file_pathname);
        String report_file = f.getAbsolutePath();
        if (!f.exists()) {
            File errorLog = new File(publishDir, "logs" + File.separator + "error.log");
            File warningLog = new File(publishDir, "logs" + File.separator + "warning.log");
            File infoLog = new File(publishDir, "logs" + File.separator + "info.log");
            XmlElement reportXml = new XmlElement("PublishingReport");
            reportXml.newChild("pubDir").setAttribute("path", publishDir);
            reportXml.newChild("errorLog").setAttribute("name", "error.log").setAttribute("path", "./" + errorLog.getName());
            reportXml.newChild("warningLog").setAttribute("name", "warning.log").setAttribute("path", "./" + warningLog.getName());
            reportXml.newChild("infoLog").setAttribute("name", "info.log").setAttribute("path", "./" + infoLog.getName());
            PublishingContentValidator validator = (PublishingContentValidator)this.viewBuilder.getHtmlBuilder().getValidator();
            reportXml.addChild(validator.getReport());
            String buffer = PublishingUtil.getHtml(reportXml, PUBLISHING_REPORT_XSL_FILE);
            if (buffer != null) {
                FileUtil.writeUTF8File((String)report_file, (String)buffer.toString());
            }
        }
        return report_file;
    }
}

