/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.persistence;

import com.ibm.uma.util.IFileManager;
import java.io.File;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.core.internal.resources.ResourceException;
import org.eclipse.core.internal.resources.ResourceStatus;
import org.eclipse.core.internal.utils.Messages;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResourceStatus;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.CommonPlugin;
import org.eclipse.epf.persistence.MultiFileIOException;
import org.eclipse.epf.persistence.util.PersistenceResources;

public class FileManager
implements IFileManager {
    private static final String PLUGIN_ID;
    private static FileManager instance;
    private boolean validateEditInitialized = false;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.epf.persistence.FileManager");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        PLUGIN_ID = clazz.getPackage().getName();
        instance = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final FileManager getInstance() {
        if (instance != null) return instance;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.epf.persistence.FileManager");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Class<?> clazz2 = clazz;
        synchronized (clazz) {
            if (instance != null) return instance;
            instance = new FileManager();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    private FileManager() {
    }

    private static boolean refresh(String oldPath) throws CoreException {
        IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        Path path = new Path(oldPath);
        Object resource = new File(oldPath).isFile() ? workspaceRoot.getFileForLocation((IPath)path) : workspaceRoot.getContainerForLocation((IPath)path);
        if (!resource.exists()) {
            ArrayList<IContainer> foldersToRefresh = new ArrayList<IContainer>();
            IContainer container = resource.getParent();
            while (!container.exists()) {
                foldersToRefresh.add(0, container);
                container = container.getParent();
            }
            if (container.exists()) {
                container.refreshLocal(1, null);
            }
            if (!foldersToRefresh.isEmpty()) {
                Iterator iter = foldersToRefresh.iterator();
                while (iter.hasNext()) {
                    IFolder folder = (IFolder)iter.next();
                    if (folder.exists()) {
                        folder.refreshLocal(1, null);
                        continue;
                    }
                    return false;
                }
            }
        }
        resource.refreshLocal(1, null);
        return true;
    }

    public boolean move(String oldPath, String newPath) {
        return this.move(oldPath, newPath, false);
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public boolean move(String oldPath, String newPath, boolean forceRemoveSource) {
        block14: {
            try {
                block15: {
                    FileManager.refresh(oldPath);
                    resource /* !! */  = null;
                    workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
                    destPath = new Path(newPath);
                    resource /* !! */  = new File(oldPath).isFile() != false ? workspaceRoot.getFileForLocation((IPath)destPath) : workspaceRoot.getContainerForLocation((IPath)destPath);
                    if (resource /* !! */ .exists()) {
                        throw new MultiFileIOException(PersistenceResources.formatString("Persistence.moveError.msg", oldPath, newPath));
                    }
                    foldersToCreate = new ArrayList<IContainer>();
                    container = resource /* !! */ .getParent();
                    while (!container.exists()) {
                        foldersToCreate.add(0, container);
                        container = container.getParent();
                    }
                    if (!foldersToCreate.isEmpty()) {
                        container.refreshLocal(1, null);
                        iter = foldersToCreate.iterator();
                        while (iter.hasNext()) {
                            folder = (IFolder)iter.next();
                            if (!folder.exists()) {
                                folder.create(true, false, null);
                                continue;
                            }
                            folder.refreshLocal(1, null);
                        }
                    }
                    destPath = resource /* !! */ .getFullPath();
                    path = new Path(oldPath);
                    file = workspaceRoot.getFileForLocation((IPath)path);
                    resource /* !! */  = file != null && file.exists() != false ? file : workspaceRoot.getContainerForLocation((IPath)path);
                    if (resource /* !! */  == null) break block14;
                    try {
                        resource /* !! */ .move((IPath)destPath, true, null);
                        break block15;
                    }
                    catch (ResourceException e) {
                        if (forceRemoveSource) {
                            throw e;
                        }
                        failed = false;
                        statuses = e.getStatus().getChildren();
                        i = 0;
                        ** while (i < statuses.length)
                    }
lbl-1000:
                    // 1 sources

                    {
                        status = statuses[i];
                        if (status.getCode() == 273 && status.getMessage() == Messages.localstore_deleteProblemDuringMove) {
                            msg = MessageFormat.format("Warning while moving ''{0}'' to ''{1}'': {2}", new Object[]{oldPath, newPath, status.getMessage()});
                            CommonPlugin.INSTANCE.log((Object)msg);
                        } else {
                            failed = true;
                        }
                        ++i;
                        continue;
                    }
lbl49:
                    // 1 sources

                    if (failed || !new File(newPath).exists()) {
                        return false;
                    }
                }
                return true;
            }
            catch (CoreException e) {
                CommonPlugin.INSTANCE.log((Object)e);
            }
        }
        return false;
    }

    public boolean rename(File oldFile, File newFile) {
        return this.move(oldFile.getAbsolutePath(), newFile.getAbsolutePath());
    }

    public boolean delete(String path) {
        IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        try {
            workspaceRoot.refreshLocal(2, null);
        }
        catch (CoreException e1) {
            e1.printStackTrace();
        }
        Path loc = new Path(path);
        Object resource = null;
        IFile file = workspaceRoot.getFileForLocation((IPath)loc);
        resource = file.exists() ? file : file.getProject().getFolder(file.getProjectRelativePath());
        if (resource != null) {
            try {
                resource.delete(true, null);
                return true;
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        }
        return false;
    }

    private static boolean fromCC(IStatus status) {
        String pluginId = status.getPlugin();
        return pluginId != null && pluginId.toLowerCase().indexOf("clearcase") != -1;
    }

    public IStatus checkModify(String[] paths, Object context) {
        IStatus status = null;
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IFile[] files = new IFile[paths.length];
        ArrayList<String> notFoundFiles = new ArrayList<String>();
        int i = 0;
        while (i < paths.length) {
            String path = paths[i];
            try {
                FileManager.refresh(path);
            }
            catch (CoreException e) {
                CommonPlugin.INSTANCE.log((Object)e);
            }
            IFile file = workspace.getRoot().getFileForLocation((IPath)new Path(path));
            if (file == null) {
                notFoundFiles.add(path);
            } else {
                files[i] = file;
            }
            ++i;
        }
        if (!notFoundFiles.isEmpty()) {
            return new Status(2, PLUGIN_ID, 2, PersistenceResources.formatString("Persistence.fileNotFoundError.msg", notFoundFiles), null);
        }
        if (!this.validateEditInitialized) {
            status = workspace.validateEdit(files, context);
            this.validateEditInitialized = true;
        }
        if (!(status = workspace.validateEdit(files, context)).isOK() && FileManager.fromCC(status)) {
            String msg = PersistenceResources.getString("Persistence.modifyFilesError.msg");
            MultiStatus multiStatus = new MultiStatus(PLUGIN_ID, status.getCode(), msg, null);
            multiStatus.add(status);
            return multiStatus;
        }
        if (status instanceof MultiStatus) {
            MultiStatus ms = (MultiStatus)status;
            int i2 = 0;
            while (i2 < ms.getChildren().length) {
                IStatus childStatus = ms.getChildren()[i2];
                if (childStatus instanceof IResourceStatus && childStatus.getCode() == 279) {
                    IResourceStatus resourceStatus = (IResourceStatus)childStatus;
                    IPath path = resourceStatus.getPath();
                    IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile(path);
                    String localPath = file.getLocation().toOSString();
                    String msg = MessageFormat.format(PersistenceResources.getString("Persistence.FileManager.fileReadOnly"), localPath);
                    ms.getChildren()[i2] = new ResourceStatus(childStatus.getSeverity(), childStatus.getCode(), resourceStatus.getPath(), msg, childStatus.getException());
                }
                ++i2;
            }
        }
        return status;
    }

    public IStatus checkModify(String path, Object context) {
        return this.checkModify(new String[]{path}, context);
    }
}

