/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.ide.dialogs;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardContainer;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.ICapabilityUninstallWizard;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.ide.IDEWorkbenchMessages;
import org.eclipse.ui.internal.ide.IDEWorkbenchPlugin;
import org.eclipse.ui.internal.ide.dialogs.ProjectCapabilityPropertyPage;
import org.eclipse.ui.internal.ide.dialogs.ProjectCapabilitySimpleAddWizard;
import org.eclipse.ui.internal.ide.dialogs.RemoveCapabilityWizard;
import org.eclipse.ui.internal.ide.registry.Capability;
import org.eclipse.ui.internal.ide.registry.CapabilityRegistry;
import org.eclipse.ui.internal.progress.ProgressMonitorJobsDialog;
import org.eclipse.ui.model.WorkbenchContentProvider;

public class ProjectCapabilityEditingPropertyPage
extends ProjectCapabilityPropertyPage {
    private static final int SIZING_WIZARD_WIDTH = 500;
    private static final int SIZING_WIZARD_HEIGHT = 500;
    private TableViewer table;
    private Button addButton;
    private Button removeButton;
    private ArrayList disabledCaps = new ArrayList();
    private Capability selectedCap;
    private CapabilityRegistry reg;

    protected Control createContents(Composite parent) {
        Font font = parent.getFont();
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.getControl(), "org.eclipse.ui.ide.project_capability_property_page_context");
        this.noDefaultAndApplyButton();
        this.reg = IDEWorkbenchPlugin.getDefault().getCapabilityRegistry();
        Composite topComposite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        topComposite.setLayout((Layout)layout);
        topComposite.setLayoutData((Object)new GridData(1808));
        String instructions = this.reg.hasCapabilities() ? IDEWorkbenchMessages.ProjectCapabilityPropertyPage_chooseCapabilities : IDEWorkbenchMessages.ProjectCapabilityPropertyPage_noCapabilities;
        Label label = new Label(topComposite, 16384);
        label.setFont(font);
        label.setText(instructions);
        Capability[] caps = this.reg.getProjectDisabledCapabilities(this.getProject());
        this.disabledCaps.addAll(Arrays.asList(caps));
        Composite mainComposite = new Composite(topComposite, 0);
        layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        mainComposite.setLayout((Layout)layout);
        mainComposite.setLayoutData((Object)new GridData(1808));
        Composite capComposite = new Composite(mainComposite, 0);
        layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        capComposite.setLayout((Layout)layout);
        capComposite.setLayoutData((Object)new GridData(1808));
        label = new Label(capComposite, 16384);
        label.setFont(font);
        label.setText(IDEWorkbenchMessages.ProjectCapabilitySelectionGroup_capabilities);
        this.table = new TableViewer(capComposite, 2820);
        this.table.getTable().setLayoutData((Object)new GridData(1808));
        this.table.getTable().setFont(font);
        this.table.setLabelProvider((IBaseLabelProvider)new CapabilityLabelProvider());
        this.table.setContentProvider(this.getContentProvider());
        this.table.setInput((Object)this.getProject());
        Composite buttonComposite = new Composite(mainComposite, 0);
        layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        buttonComposite.setLayout((Layout)layout);
        buttonComposite.setLayoutData((Object)new GridData(1040));
        label = new Label(buttonComposite, 16384);
        label.setFont(font);
        label.setText("");
        this.addButton = new Button(buttonComposite, 8);
        this.addButton.setText(IDEWorkbenchMessages.ProjectCapabilityEditingPropertyPage_add);
        this.addButton.setEnabled(true);
        this.addButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ProjectCapabilityEditingPropertyPage.this.addCapability();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        GridData data = new GridData();
        data.horizontalAlignment = 4;
        int widthHint = this.convertHorizontalDLUsToPixels(61);
        data.widthHint = Math.max(widthHint, this.addButton.computeSize((int)-1, (int)-1, (boolean)true).x);
        this.addButton.setLayoutData((Object)data);
        this.addButton.setFont(font);
        this.removeButton = new Button(buttonComposite, 8);
        this.removeButton.setText(IDEWorkbenchMessages.ProjectCapabilityEditingPropertyPage_remove);
        this.removeButton.setEnabled(false);
        this.removeButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ProjectCapabilityEditingPropertyPage.this.removeCapability(ProjectCapabilityEditingPropertyPage.this.selectedCap);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        data = new GridData();
        data.horizontalAlignment = 4;
        widthHint = this.convertHorizontalDLUsToPixels(61);
        data.widthHint = Math.max(widthHint, this.removeButton.computeSize((int)-1, (int)-1, (boolean)true).x);
        this.removeButton.setLayoutData((Object)data);
        this.removeButton.setFont(font);
        this.table.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ProjectCapabilityEditingPropertyPage.this.selectedCap = null;
                IStructuredSelection sel = (IStructuredSelection)event.getSelection();
                if (sel != null) {
                    ProjectCapabilityEditingPropertyPage.this.selectedCap = (Capability)((Object)sel.getFirstElement());
                }
                ProjectCapabilityEditingPropertyPage.this.removeButton.setEnabled(ProjectCapabilityEditingPropertyPage.this.selectedCap != null);
            }
        });
        return topComposite;
    }

    private IContentProvider getContentProvider() {
        return new WorkbenchContentProvider(){

            public Object[] getChildren(Object parentElement) {
                if (parentElement instanceof IProject) {
                    return ProjectCapabilityEditingPropertyPage.this.reg.getProjectCapabilities((IProject)parentElement);
                }
                return null;
            }
        };
    }

    private boolean isDisabledCapability(Capability cap) {
        return this.disabledCaps.contains((Object)cap);
    }

    private void addCapability() {
        ProjectCapabilitySimpleAddWizard wizard = new ProjectCapabilitySimpleAddWizard(PlatformUI.getWorkbench(), (IStructuredSelection)StructuredSelection.EMPTY, this.getProject());
        WizardDialog dialog = new WizardDialog(this.getShell(), (IWizard)wizard);
        dialog.create();
        dialog.getShell().setSize(Math.max(500, dialog.getShell().getSize().x), 500);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)dialog.getShell(), "org.eclipse.ui.ide.update_capability_wizard_context");
        dialog.open();
        this.table.refresh();
    }

    private void removeCapability(Capability cap) {
        ArrayList<Capability> results = new ArrayList<Capability>();
        results.addAll(Arrays.asList(this.reg.getProjectCapabilities(this.getProject())));
        results.remove((Object)cap);
        Capability[] caps = new Capability[results.size()];
        results.toArray(caps);
        int i = 0;
        while (i < caps.length) {
            List<String> prereqs = Arrays.asList(this.reg.getPrerequisiteIds(caps[i]));
            if (prereqs.contains(cap.getId())) {
                MessageDialog.openWarning((Shell)this.getShell(), (String)IDEWorkbenchMessages.ProjectCapabilityPropertyPage_errorTitle, (String)NLS.bind((String)IDEWorkbenchMessages.ProjectCapabilityPropertyPage_capabilityRequired, (Object)caps[i].getName()));
                return;
            }
            ++i;
        }
        IStatus status = this.reg.validateCapabilities(caps);
        if (!status.isOK()) {
            ErrorDialog.openError((Shell)this.getShell(), (String)IDEWorkbenchMessages.ProjectCapabilityPropertyPage_errorTitle, (String)IDEWorkbenchMessages.ProjectCapabilityPropertyPage_invalidSelection, (IStatus)status);
            return;
        }
        String[] natureIds = new String[]{cap.getNatureId()};
        ICapabilityUninstallWizard wizard = cap.getUninstallWizard();
        if (wizard == null) {
            wizard = new RemoveCapabilityWizard();
        }
        if (wizard != null) {
            wizard.init(PlatformUI.getWorkbench(), (IStructuredSelection)StructuredSelection.EMPTY, this.getProject(), natureIds);
            wizard.addPages();
        }
        if (wizard.getStartingPage() == null) {
            wizard.setContainer(new StubContainer());
            wizard.performFinish();
            wizard.setContainer(null);
        } else {
            wizard = cap.getUninstallWizard();
            if (wizard == null) {
                wizard = new RemoveCapabilityWizard();
            }
            if (wizard != null) {
                wizard.init(PlatformUI.getWorkbench(), (IStructuredSelection)StructuredSelection.EMPTY, this.getProject(), natureIds);
            }
            WizardDialog dialog = new WizardDialog(this.getShell(), (IWizard)wizard);
            dialog.create();
            dialog.getShell().setSize(Math.max(500, dialog.getShell().getSize().x), 500);
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)dialog.getShell(), "org.eclipse.ui.ide.update_capability_wizard_context");
            dialog.open();
        }
        this.table.refresh();
    }

    public boolean performOk() {
        return true;
    }

    class CapabilityLabelProvider
    extends LabelProvider {
        private Map imageTable;

        CapabilityLabelProvider() {
        }

        public void dispose() {
            if (this.imageTable != null) {
                Iterator it = this.imageTable.values().iterator();
                while (it.hasNext()) {
                    ((Image)it.next()).dispose();
                }
                this.imageTable = null;
            }
        }

        public Image getImage(Object element) {
            Image image;
            ImageDescriptor descriptor = ((Capability)((Object)element)).getIconDescriptor();
            if (descriptor == null) {
                return null;
            }
            if (this.imageTable == null) {
                this.imageTable = new Hashtable(40);
            }
            if ((image = (Image)this.imageTable.get(descriptor)) == null) {
                image = descriptor.createImage();
                this.imageTable.put(descriptor, image);
            }
            return image;
        }

        public String getText(Object element) {
            Capability cap = (Capability)((Object)element);
            String text = cap.getName();
            if (ProjectCapabilityEditingPropertyPage.this.isDisabledCapability(cap)) {
                text = NLS.bind((String)IDEWorkbenchMessages.ProjectCapabilitySelectionGroup_disabledLabel, (Object)text);
            }
            return text;
        }
    }

    class StubContainer
    implements IWizardContainer {
        StubContainer() {
        }

        public IWizardPage getCurrentPage() {
            return null;
        }

        public Shell getShell() {
            return ProjectCapabilityEditingPropertyPage.this.getShell();
        }

        public void showPage(IWizardPage page) {
        }

        public void updateButtons() {
        }

        public void updateMessage() {
        }

        public void updateTitleBar() {
        }

        public void updateWindowTitle() {
        }

        public void run(boolean fork, boolean cancelable, IRunnableWithProgress runnable) throws InvocationTargetException, InterruptedException {
            new ProgressMonitorJobsDialog(this.getShell()).run(fork, cancelable, runnable);
        }
    }
}

