/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.graphics;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.internal.cairo.Cairo;

public class Pattern
extends Resource {
    public int handle;

    public Pattern(Device device, Image image) {
        if (device == null) {
            device = Device.getDevice();
        }
        if (device == null) {
            SWT.error(4);
        }
        if (image == null) {
            SWT.error(4);
        }
        if (image.isDisposed()) {
            SWT.error(5);
        }
        this.device = device;
        device.checkCairo();
        image.createSurface();
        this.handle = Cairo.cairo_pattern_create_for_surface(image.surface);
        if (this.handle == 0) {
            SWT.error(2);
        }
        Cairo.cairo_pattern_set_extend(this.handle, 1);
        if (device.tracking) {
            device.new_Object(this);
        }
    }

    public Pattern(Device device, float x1, float y1, float x2, float y2, Color color1, Color color2) {
        if (device == null) {
            device = Device.getDevice();
        }
        if (device == null) {
            SWT.error(4);
        }
        if (color1 == null) {
            SWT.error(4);
        }
        if (color1.isDisposed()) {
            SWT.error(5);
        }
        if (color2 == null) {
            SWT.error(4);
        }
        if (color2.isDisposed()) {
            SWT.error(5);
        }
        this.device = device;
        device.checkCairo();
        this.handle = Cairo.cairo_pattern_create_linear(x1, y1, x2, y2);
        if (this.handle == 0) {
            SWT.error(2);
        }
        GC.setCairoPatternColor(this.handle, 0, color1);
        GC.setCairoPatternColor(this.handle, 1, color2);
        Cairo.cairo_pattern_set_extend(this.handle, 1);
        if (device.tracking) {
            device.new_Object(this);
        }
    }

    public void dispose() {
        if (this.handle == 0) {
            return;
        }
        if (this.device.isDisposed()) {
            return;
        }
        Cairo.cairo_pattern_destroy(this.handle);
        this.handle = 0;
        if (this.device.tracking) {
            this.device.dispose_Object(this);
        }
        this.device = null;
    }

    public boolean isDisposed() {
        return this.handle == 0;
    }

    public String toString() {
        if (this.isDisposed()) {
            return "Pattern {*DISPOSED*}";
        }
        return "Pattern {" + this.handle + "}";
    }
}

