/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.internal.search;

import java.io.IOException;
import java.util.ArrayList;
import org.apache.lucene.document.Document;
import org.apache.lucene.search.Hits;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.help.IToc;
import org.eclipse.help.ITopic;
import org.eclipse.help.internal.HelpPlugin;
import org.eclipse.help.internal.model.ITocElement;
import org.eclipse.help.internal.search.ISearchHitCollector;
import org.eclipse.help.internal.search.SearchHit;
import org.eclipse.help.internal.util.URLCoder;
import org.eclipse.help.internal.workingset.AdaptableHelpResource;
import org.eclipse.help.internal.workingset.AdaptableToc;
import org.eclipse.help.internal.workingset.WorkingSet;

public class SearchResults
implements ISearchHitCollector {
    private ArrayList scopes;
    private int maxHits;
    private String locale;
    protected SearchHit[] searchHits = new SearchHit[0];
    static /* synthetic */ Class class$0;

    public SearchResults(WorkingSet[] workingSets, int maxHits, String locale) {
        this.maxHits = maxHits;
        this.locale = locale;
        this.scopes = this.getScopes(workingSets);
    }

    public void addHits(Hits hits, String highlightTerms) {
        String urlEncodedWords = URLCoder.encode((String)highlightTerms);
        ArrayList<SearchHit> searchHitList = new ArrayList<SearchHit>();
        float scoreScale = 1.0f;
        boolean scoreScaleSet = false;
        int h = 0;
        int j = 0;
        while (h < hits.length() && j < this.maxHits && h < 500) {
            block18: {
                ITopic t;
                AdaptableHelpResource scope;
                IToc toc;
                String href;
                float score;
                Document doc;
                block20: {
                    block19: {
                        try {
                            doc = hits.doc(h);
                            score = hits.score(h);
                        }
                        catch (IOException iOException) {
                            break block18;
                        }
                        href = doc.get("name");
                        toc = null;
                        scope = null;
                        if (this.scopes != null) break block19;
                        toc = this.getTocForTopic(href, this.locale);
                        break block20;
                    }
                    scope = this.getScopeForTopic(href);
                    if (scope == null) break block18;
                    if (scope instanceof AdaptableToc) {
                        Class<?> clazz = class$0;
                        if (clazz == null) {
                            try {
                                clazz = Class.forName("org.eclipse.help.IToc");
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                            }
                        }
                        toc = (IToc)scope.getAdapter(clazz);
                    } else {
                        IAdaptable iAdaptable = scope.getParent();
                        Class<?> clazz = class$0;
                        if (clazz == null) {
                            try {
                                clazz = Class.forName("org.eclipse.help.IToc");
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                            }
                        }
                        toc = (IToc)iAdaptable.getAdapter((Class)clazz);
                    }
                }
                if (!scoreScaleSet) {
                    if (score > 0.0f) {
                        scoreScale = 0.99f / score;
                        score = 1.0f;
                    }
                    scoreScaleSet = true;
                } else {
                    score = score * scoreScale + 0.01f;
                }
                String label = doc.get("raw_title");
                if ("".equals(label) && toc != null && (t = scope != null ? scope.getTopic(href) : toc.getTopic(href)) != null) {
                    label = t.getLabel();
                }
                if (label == null || "".equals(label)) {
                    label = href;
                }
                String summary = doc.get("summary");
                ++j;
                href = String.valueOf(href) + "?resultof=" + urlEncodedWords;
                searchHitList.add(new SearchHit(href, label, summary, score, toc));
            }
            ++h;
        }
        this.searchHits = searchHitList.toArray(new SearchHit[searchHitList.size()]);
    }

    private AdaptableHelpResource getScopeForTopic(String href) {
        int i = 0;
        while (i < this.scopes.size()) {
            AdaptableHelpResource scope = (AdaptableHelpResource)this.scopes.get(i);
            if (scope.getTopic(href) != null) {
                return scope;
            }
            ++i;
        }
        return null;
    }

    private IToc getTocForTopic(String href, String locale) {
        ITocElement[] tocs = HelpPlugin.getTocManager().getTocs(locale);
        int i = 0;
        while (i < tocs.length) {
            ITopic topic = tocs[i].getTopic(href);
            if (topic != null) {
                return tocs[i];
            }
            ++i;
        }
        return null;
    }

    public SearchHit[] getSearchHits() {
        return this.searchHits;
    }

    private ArrayList getScopes(WorkingSet[] wSets) {
        if (wSets == null) {
            return null;
        }
        this.scopes = new ArrayList(wSets.length);
        int w = 0;
        while (w < wSets.length) {
            AdaptableHelpResource[] elements = wSets[w].getElements();
            int i = 0;
            while (i < elements.length) {
                this.scopes.add(elements[i]);
                ++i;
            }
            ++w;
        }
        return this.scopes;
    }
}

