/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.export.services;

import java.io.File;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.epf.common.utils.XMLUtil;
import org.eclipse.epf.export.services.ConfigurationSpec;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class LibraryDocument {
    public static final String TAG_methodPlugins = "methodPlugins";
    public static final String TAG_predefinedConfigurations = "predefinedConfigurations";
    public static final String TAG_resourceDescriptors = "resourceDescriptors";
    public static final String TAG_resourceSubManagers = "subManagers";
    public static final String ATTR_href = "href";
    public static final String ATTR_id = "id";
    public static final String ATTR_uri = "uri";
    public static final String ATTR_guid = "guid";
    public static final String exportFile = "export.xmi";
    public static final String libraryFile = "library.xmi";
    protected File libFile;
    protected Document document;
    protected Element libTag = null;
    protected Element resTag = null;

    public LibraryDocument(File libFile) throws Exception {
        this.libFile = libFile;
        this.init();
    }

    private void init() throws Exception {
        this.document = XMLUtil.loadXml((File)this.libFile);
        Element root = this.document.getDocumentElement();
        NodeList nodes = root.getElementsByTagName("com.ibm.uma:MethodLibrary");
        if (nodes != null && nodes.getLength() > 0) {
            this.libTag = (Element)nodes.item(0);
        }
        if ((nodes = root.getElementsByTagName("com.ibm.uma.resourcemanager:ResourceManager")) != null && nodes.getLength() > 0) {
            this.resTag = (Element)nodes.item(0);
        }
    }

    public Document getDocument() {
        return this.document;
    }

    public File getFile() {
        return this.libFile;
    }

    public Element getLibTag() {
        return this.libTag;
    }

    public String getLibraryName() {
        return this.libTag.getAttribute("name");
    }

    public String getLibraryGuid() {
        return this.libTag.getAttribute(ATTR_guid);
    }

    public Element getResourceTag() {
        return this.resTag;
    }

    public void removePlugin(Element node) {
        this.libTag.removeChild(node);
    }

    public void removeConfiguration(Element node) {
        this.libTag.removeChild(node);
    }

    public void removeResourceDescriptor(Element node) {
        this.resTag.removeChild(node);
    }

    public NodeList getPlugins() {
        return this.libTag.getElementsByTagName(TAG_methodPlugins);
    }

    public NodeList getConfigurations() {
        return this.libTag.getElementsByTagName(TAG_predefinedConfigurations);
    }

    public NodeList getResourceDescriptors() {
        return this.resTag.getElementsByTagName(TAG_resourceDescriptors);
    }

    public NodeList getResourceSubManagers() {
        return this.resTag.getElementsByTagName(TAG_resourceSubManagers);
    }

    public void addPlugin(Element node) {
        this.libTag.appendChild(this.getValidNode(node));
    }

    public void addConfiguration(Element node) {
        this.libTag.appendChild(this.getValidNode(node));
    }

    public void addResource(Element node) {
        this.resTag.appendChild(this.getValidNode(node));
    }

    public Node getValidNode(Node node) {
        if (node.getOwnerDocument() == this.document) {
            return node;
        }
        return this.document.importNode(node, true);
    }

    public void removePlugins(List removeList) {
        NodeList nodes = this.getPlugins();
        int i = 0;
        while (i < nodes.getLength()) {
            Element node = (Element)nodes.item(i);
            String guid = node.getAttribute("xmi:id");
            if (removeList.contains(guid)) {
                this.libTag.removeChild(node);
                continue;
            }
            ++i;
        }
    }

    public void removeConfigurations(List removeList) {
        NodeList nodes = this.getConfigurations();
        int i = 0;
        while (i < nodes.getLength()) {
            Element node = (Element)nodes.item(i);
            String guid = node.getAttribute("xmi:id");
            if (removeList.contains(guid)) {
                this.libTag.removeChild(node);
                continue;
            }
            ++i;
        }
    }

    public void removeResourceEntries(List removeList) {
        String guid;
        Element node;
        NodeList nodes = this.getResourceDescriptors();
        int i = 0;
        while (i < nodes.getLength()) {
            node = (Element)nodes.item(i);
            guid = node.getAttribute(ATTR_id);
            String uri = node.getAttribute(ATTR_uri);
            if (removeList.contains(guid)) {
                this.resTag.removeChild(node);
                File plugn_file = this.getFileFromUri(uri);
                plugn_file.exists();
                continue;
            }
            ++i;
        }
        nodes = this.getResourceSubManagers();
        i = 0;
        while (i < nodes.getLength()) {
            node = (Element)nodes.item(i);
            guid = LibraryDocument.getSubManagerBaseGuid(node.getAttribute(ATTR_href));
            if (removeList.contains(guid)) {
                this.resTag.removeChild(node);
                continue;
            }
            ++i;
        }
    }

    public File getFileFromUri(String uri) {
        try {
            uri = URLDecoder.decode(uri, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        int i = uri.indexOf("#");
        if (i > 0) {
            uri = uri.substring(0, i);
        }
        return new File(this.libFile.getParentFile(), uri);
    }

    public void save() throws Exception {
        this.saveAs(this.libFile.getAbsolutePath());
    }

    public void saveAs(String filePathName) throws Exception {
        XMLUtil.saveDocument((Document)this.document, (String)filePathName);
    }

    public boolean isConfigSpecsOnly() {
        NodeList nodes = this.getResourceDescriptors();
        if (nodes == null || nodes.getLength() == 0) {
            return true;
        }
        int i = 0;
        while (i < nodes.getLength()) {
            Element node = (Element)nodes.item(i);
            String uri = node.getAttribute(ATTR_uri);
            File plugn_file = this.getFileFromUri(uri);
            if (!plugn_file.exists()) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static String getSubManagerBaseGuid(String href) {
        Pattern p = Pattern.compile("uma://(.*?)#(.*?)", 34);
        Matcher m = p.matcher(href);
        if (m.find()) {
            return m.group(1);
        }
        return href;
    }

    public static String getChildValue(Element tag, String childTagName) {
        NodeList nodes = tag.getChildNodes();
        if (nodes == null || nodes.getLength() == 0) {
            return "";
        }
        int size = nodes.getLength();
        int i = 0;
        while (i < size) {
            Node node = nodes.item(i);
            if (node instanceof Element && ((Element)node).getTagName().equals(childTagName)) {
                return LibraryDocument.getNodeText((Element)node);
            }
            ++i;
        }
        return "";
    }

    public static String getNodeText(Element tag) {
        NodeList nodes = tag.getChildNodes();
        if (nodes == null || nodes.getLength() == 0) {
            return "";
        }
        int size = nodes.getLength();
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        while (i < size) {
            Node node = nodes.item(i);
            if (node.getNodeType() == 3) {
                buffer.append(node.getNodeValue());
            }
            ++i;
        }
        return buffer.toString();
    }

    public static String getGuidFromHref(String href) {
        int i = href.indexOf("#");
        if (i > 0) {
            return href.substring(i + 1);
        }
        return href;
    }

    public ConfigurationSpec getConfigurationSpec(Element config) {
        String guid;
        Element node;
        int i;
        ConfigurationSpec spec = new ConfigurationSpec();
        spec.guid = config.getAttribute("xmi:id");
        spec.name = config.getAttribute("name");
        spec.brief_desc = config.getAttribute("briefDescription");
        NodeList nodes = config.getElementsByTagName("methodPluginSelection");
        if (nodes != null) {
            i = 0;
            while (i < nodes.getLength()) {
                node = (Element)nodes.item(i);
                guid = LibraryDocument.getGuidFromHref(node.getAttribute(ATTR_href));
                spec.pluginIds.add(guid);
                ++i;
            }
        }
        if ((nodes = config.getElementsByTagName("methodPackageSelection")) != null) {
            i = 0;
            while (i < nodes.getLength()) {
                node = (Element)nodes.item(i);
                guid = LibraryDocument.getGuidFromHref(node.getAttribute(ATTR_href));
                spec.packageIds.add(guid);
                ++i;
            }
        }
        if ((nodes = config.getElementsByTagName("processViews")) != null) {
            i = 0;
            while (i < nodes.getLength()) {
                node = (Element)nodes.item(i);
                guid = LibraryDocument.getGuidFromHref(node.getAttribute(ATTR_href));
                spec.viewIds.add(guid);
                ++i;
            }
        }
        return spec;
    }
}

