/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.commands;

import java.util.Collection;
import org.eclipse.core.commands.Category;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.CommandManager;
import org.eclipse.core.commands.IExecutionListener;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.internal.commands.CommandPersistence;

public final class CommandService
implements ICommandService {
    private final CommandManager commandManager;

    public CommandService(CommandManager commandManager) {
        if (commandManager == null) {
            throw new NullPointerException("Cannot create a command service with a null manager");
        }
        this.commandManager = commandManager;
    }

    public final void addExecutionListener(IExecutionListener listener) {
        this.commandManager.addExecutionListener(listener);
    }

    public final Category getCategory(String categoryId) {
        return this.commandManager.getCategory(categoryId);
    }

    public final Command getCommand(String commandId) {
        return this.commandManager.getCommand(commandId);
    }

    public final Collection getDefinedCategoryIds() {
        return this.commandManager.getDefinedCategoryIds();
    }

    public final Collection getDefinedCommandIds() {
        return this.commandManager.getDefinedCommandIds();
    }

    public final void readRegistry() {
        CommandPersistence.read(this.commandManager);
    }

    public final void removeExecutionListener(IExecutionListener listener) {
        this.commandManager.removeExecutionListener(listener);
    }
}

