/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.part;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IPersistable;
import org.eclipse.ui.IPropertyListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPart2;
import org.eclipse.ui.internal.components.framework.Components;
import org.eclipse.ui.internal.components.framework.IDisposable;
import org.eclipse.ui.internal.part.IPartPropertyProvider;
import org.eclipse.ui.internal.part.StandardWorkbenchServices;
import org.eclipse.ui.internal.part.components.interfaces.IFocusable;
import org.eclipse.ui.internal.part.components.services.INameable;
import org.eclipse.ui.internal.part.components.services.IStatusFactory;

public abstract class OldPartToNewWrapper
implements IFocusable,
IAdaptable,
IDisposable,
IPersistable,
IPartPropertyProvider {
    private INameable nameable;
    private IWorkbenchPart part;
    private IWorkbenchPart2 wb2;
    private IStatusFactory errorContext;
    private Image lastImage = null;
    private IMemento savedState = null;
    private Composite control;
    private IPropertyListener propertyListener = new IPropertyListener(){

        public void propertyChanged(Object source, int propId) {
            OldPartToNewWrapper.this.propertyChanged(propId);
        }
    };
    private Map listenerMap = new HashMap();

    public OldPartToNewWrapper(StandardWorkbenchServices services) {
        this.control = services.getParentComposite();
        this.nameable = services.getNameable();
        this.savedState = services.getState();
        this.errorContext = services.getStatusFactory();
    }

    protected void setPart(IWorkbenchPart newPart) {
        this.part = newPart;
        if (this.part instanceof IWorkbenchPart2) {
            this.wb2 = (IWorkbenchPart2)this.part;
        }
        this.part.addPropertyListener(this.propertyListener);
        this.savedState = null;
    }

    protected IStatusFactory getErrorContext() {
        return this.errorContext;
    }

    protected IWorkbenchPart getPart() {
        return this.part;
    }

    private void propertyChanged(int propId) {
        switch (propId) {
            case 1: {
                if (this.part.getTitleImage() != this.lastImage) {
                    this.lastImage = this.part.getTitleImage();
                    this.nameable.setImage(ImageDescriptor.createFromImage((Image)this.part.getTitleImage(), (Device)Display.getCurrent()));
                }
                this.nameable.setTooltip(this.part.getTitleToolTip());
                if (this.wb2 != null) break;
                this.nameable.setContentDescription(this.part.getTitle());
                break;
            }
            case 260: {
                if (this.wb2 == null) break;
                this.nameable.setName(this.wb2.getPartName());
                break;
            }
            case 261: {
                if (this.wb2 == null) break;
                this.nameable.setContentDescription(this.wb2.getContentDescription());
            }
        }
    }

    public void dispose() {
        if (this.part != null) {
            this.part.dispose();
            Iterator iter = this.listenerMap.values().iterator();
            while (iter.hasNext()) {
                IPropertyListener listener = (IPropertyListener)iter.next();
                this.part.removePropertyListener(listener);
            }
            this.listenerMap.clear();
        }
    }

    public boolean setFocus() {
        if (this.part != null) {
            this.part.setFocus();
            return true;
        }
        return false;
    }

    public Object getAdapter(Class adapter) {
        if (adapter.isInstance(this)) {
            return this;
        }
        return Components.getAdapter(this.part, adapter);
    }

    public void saveState(IMemento memento) {
        if (this.part != null) {
            if (this.part instanceof IPersistable) {
                IPersistable persistable = (IPersistable)((Object)this.part);
                persistable.saveState(memento);
            }
        } else if (this.savedState != null) {
            memento.putMemento(this.savedState);
        }
    }

    public void addPropertyListener(IWorkbenchPart part, IPropertyListener l) {
        if (part != null) {
            ListenerWrapper wrapper = new ListenerWrapper(part, l);
            part.addPropertyListener(wrapper);
            this.listenerMap.put(l, wrapper);
        }
    }

    public void removePropertyListener(IWorkbenchPart part, IPropertyListener l) {
        IPropertyListener wrapper;
        if (part != null && (wrapper = (IPropertyListener)this.listenerMap.get(l)) != null) {
            part.removePropertyListener(wrapper);
            this.listenerMap.remove(l);
        }
    }

    public String getTitleToolTip() {
        return this.part.getTitleToolTip();
    }

    public Image getTitleImage() {
        return this.part.getTitleImage();
    }

    public String getTitle() {
        return this.part.getTitle();
    }

    private static final class ListenerWrapper
    implements IPropertyListener {
        IWorkbenchPart part;
        IPropertyListener listener;

        public ListenerWrapper(IWorkbenchPart part, IPropertyListener listener) {
            this.part = part;
            this.listener = listener;
        }

        public void propertyChanged(Object source, int propId) {
            this.listener.propertyChanged(source, propId);
        }
    }
}

