/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.layout;

import com.ibm.uma.MethodConfiguration;
import com.ibm.uma.MethodElement;
import java.io.File;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.epf.library.LibraryResources;
import org.eclipse.epf.library.layout.IContentValidator;
import org.eclipse.epf.library.layout.LinkInfo;
import org.eclipse.epf.library.util.LibraryUtil;

public class DefaultContentValidator
implements IContentValidator {
    protected PrintStream info;
    protected PrintStream warning;
    protected PrintStream error;
    protected String pubDir;

    public DefaultContentValidator() {
        this(null);
    }

    public DefaultContentValidator(String pubDir) {
        this.pubDir = pubDir;
        this.info = System.out;
        this.warning = System.out;
        this.error = System.err;
    }

    public void setPublishDir(String pubDir) {
        this.pubDir = pubDir;
    }

    public String getPublishDir() {
        return this.pubDir;
    }

    public LinkInfo validateLink(MethodElement owner, String attributes, String text, MethodConfiguration config) {
        LinkInfo info = new LinkInfo(owner, this, this.pubDir);
        info.validateLink(attributes, text, config);
        return info;
    }

    public void logInfo(MethodElement owner, String message) {
        this.info.println(LibraryResources.formatString("Library.DefaultContentValidator.MSG1", String.valueOf(owner == null ? "" : LibraryUtil.getTypeName(owner)) + ": " + message));
        this.info.flush();
    }

    public void logWarning(MethodElement owner, String message) {
        this.warning.println(LibraryResources.formatString("Library.DefaultContentValidator.MSG4", String.valueOf(owner == null ? "" : LibraryUtil.getTypeName(owner)) + ": " + message));
        this.warning.flush();
    }

    public void logError(MethodElement owner, String message, Throwable th) {
        this.error.println(LibraryResources.formatString("Library.DefaultContentValidator.MSG7", String.valueOf(owner == null ? "" : LibraryUtil.getTypeName(owner)) + ": " + message));
        if (th != null) {
            th.printStackTrace(this.error);
        }
        this.error.flush();
    }

    public void logInfo(String message) {
        this.logInfo(null, message);
    }

    public void logWarning(String message) {
        this.logWarning(null, message);
    }

    public void logError(String message, Throwable th) {
        this.logError(null, message, th);
    }

    public void logMissingReference(MethodElement owner, MethodElement refElement) {
        this.logWarning(owner, LibraryResources.formatString("Library.DefaultContentValidator.MSG10", LibraryUtil.getTypeName(refElement)));
    }

    public void logMissingReference(MethodElement owner, String guid, String linkedText) {
        this.logWarning(owner, LibraryResources.formatString("Library.DefaultContentValidator.MSG11", guid));
    }

    public void logMissingResource(MethodElement owner, File resourceFile, String url) {
        String msg = resourceFile != null ? LibraryResources.formatString("Library.DefaultContentValidator.MSG12", resourceFile.getPath(), url) : LibraryResources.formatString("Library.DefaultContentValidator.MSG15", url);
        this.logWarning(owner, msg);
    }

    public void logInvalidExternalLink(MethodElement owner, String url, String message) {
        String text = message != null && message.length() > 0 ? LibraryResources.formatString("Library.DefaultContentValidator.MSG19", url, message) : LibraryResources.formatString("Library.DefaultContentValidator.MSG17", url);
        this.logWarning(owner, text);
    }

    public boolean isDiscarded(MethodElement e) {
        return false;
    }

    public void dispose() {
    }

    public void addReferencedElement(MethodElement e) {
    }

    public List getReferencedElements() {
        return new ArrayList();
    }
}

