/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.layout;

import com.ibm.uma.MethodConfiguration;
import com.ibm.uma.MethodElement;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.URLDecoder;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.epf.common.xml.XSLTProcessor;
import org.eclipse.epf.library.LibraryPlugin;
import org.eclipse.epf.library.configuration.ConfigurationHelper;
import org.eclipse.epf.library.layout.IContentValidator;
import org.eclipse.epf.library.layout.LayoutResources;
import org.eclipse.epf.library.layout.util.XmlElement;
import org.eclipse.epf.library.layout.util.XmlHelper;
import org.eclipse.epf.library.services.LibraryProcessor;
import org.eclipse.epf.library.util.LibraryUtil;
import org.eclipse.epf.library.util.ResourceHelper;

public class LinkInfo {
    public static final String LINK_ATTR_CLASS = "class";
    public static final String LINK_ATTR_GUID = "guid";
    public static final String LINK_ATTR_HREF = "href";
    public static final String LINK_ATTR_KEY = "key";
    public static final String LINK_ATTR_TEXT = "text";
    public static final String LINK_ATTR_NAME = "name";
    private String linkedText = "";
    private MethodElement linkElement = null;
    private MethodElement ownerElement = null;
    private boolean isMissingReference = false;
    private Map attributeMap = new LinkedHashMap();
    private IContentValidator validator;
    private String pubDir;
    protected static final Pattern p_link_attributes = Pattern.compile("(.*?)\\s*=\\s*\"(.*?)\"", 34);

    public LinkInfo(MethodElement owner, IContentValidator validator, String pubDir) {
        this.ownerElement = owner;
        this.validator = validator;
        this.pubDir = pubDir;
    }

    public boolean isElementLink() {
        return ResourceHelper.isElementLink(this.getElementLinkType());
    }

    public String getElementLinkType() {
        return this.getAttribute(LINK_ATTR_CLASS);
    }

    public String getGuid() {
        return this.getAttribute(LINK_ATTR_GUID);
    }

    public String getUrl() {
        return this.getAttribute(LINK_ATTR_HREF);
    }

    public String getLinkedText() {
        return this.linkedText;
    }

    public MethodElement getLinkedElement() {
        return this.linkElement;
    }

    public StringBuffer getHtml() {
        StringBuffer buffer = new StringBuffer();
        if (this.isMissingReference && this.pubDir != null) {
            String url = this.getMissingElementUrl();
            buffer.append("<img alt=\"\" src=\"" + ResourceHelper.getBackPath(this.ownerElement) + "images/no_rup.gif\">&#160;");
            this.setUrl(url);
        }
        buffer.append("<a");
        Iterator it = this.attributeMap.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            buffer.append(" ").append(entry.getKey()).append("=").append("\"").append(entry.getValue()).append("\"");
        }
        buffer.append(">").append(this.linkedText).append("</a>");
        return buffer;
    }

    public void validateLink(String attributes, String text, MethodConfiguration config) {
        String url;
        this.linkedText = text;
        Matcher m2 = p_link_attributes.matcher(attributes);
        while (m2.find()) {
            String attrName = m2.group(1).trim().toLowerCase();
            String attrValue = m2.group(2).trim();
            if (attrName.equals(LINK_ATTR_HREF)) {
                try {
                    attrValue = URLDecoder.decode(attrValue, "UTF-8");
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            this.attributeMap.put(attrName, attrValue);
        }
        String guid = this.getGuid();
        if (guid == null && (guid = ResourceHelper.getGuidFromFileName(url = this.getUrl())) != null) {
            this.setGuid(guid);
        }
        this.validateElementUrl(config);
    }

    public String getAttribute(String name) {
        return (String)this.attributeMap.get(name);
    }

    public void setGuid(String guid) {
        this.attributeMap.put(LINK_ATTR_GUID, guid);
    }

    private void setUrl(String url) {
        this.attributeMap.put(LINK_ATTR_HREF, url);
    }

    private void validateElementUrl(MethodConfiguration config) {
        String guid = this.getGuid();
        if (guid != null) {
            MethodElement e = LibraryProcessor.getInstance().getElement(guid);
            if (e != null) {
                if (this.validator.isDiscarded(e)) {
                    this.isMissingReference = true;
                    this.validator.logMissingReference(this.ownerElement, e);
                } else if (config != null) {
                    MethodElement e1 = ConfigurationHelper.getCalculatedElement(e, config);
                    if (e1 != null) {
                        e = e1;
                    } else {
                        this.isMissingReference = true;
                        this.validator.logMissingReference(this.ownerElement, e);
                    }
                }
            } else {
                this.isMissingReference = true;
                this.validator.logMissingReference(this.ownerElement, guid, this.linkedText);
            }
            this.linkElement = e;
            if (e != null) {
                String text;
                guid = e.getGuid();
                this.setGuid(guid);
                String url = this.getUrl();
                if (url != null && !(url = url.trim()).toLowerCase().startsWith("javascript:")) {
                    url = ResourceHelper.getUrl(e, this.ownerElement, ".html", url);
                    this.setUrl(url);
                }
                if (this.isElementLink() && (text = ResourceHelper.getLinkText(e, this.getElementLinkType())) != null) {
                    this.linkedText = text;
                }
            }
        }
    }

    private String getMissingElementUrl() {
        if (!this.isMissingReference) {
            return "";
        }
        String url = null;
        url = "pages_not_installed/pages_not_installed.html";
        File f = new File(this.pubDir, url);
        File dir = f.getParentFile();
        if (!dir.exists()) {
            dir.mkdirs();
        }
        XmlElement xml = new XmlElement("Element");
        if (this.linkElement == null) {
            xml.setAttribute("invalidLink", "true").setAttribute(LINK_ATTR_GUID, this.getGuid()).setAttribute(LINK_ATTR_NAME, this.linkedText);
        } else {
            xml.setAttribute(LINK_ATTR_GUID, this.getGuid()).setAttribute("type", this.linkElement.getType().getName()).setAttribute(LINK_ATTR_NAME, this.linkElement.getName()).setAttribute("pluginName", LibraryUtil.getMethodPlugin((EObject)this.linkElement).getName());
        }
        String xslPath = LayoutResources.getXslUri("page_not_installed", null);
        this.saveHtml(xml, xslPath, f);
        return String.valueOf(ResourceHelper.getBackPath(this.ownerElement).replace(File.separatorChar, '/')) + url;
    }

    public void saveHtml(XmlElement xmlElement, String xsl_uri, File outputFile) {
        try {
            StringBuffer xml = new StringBuffer();
            xml.append(XmlHelper.XML_HEADER).append(xmlElement.toXml());
            OutputStreamWriter output = new OutputStreamWriter((OutputStream)new FileOutputStream(outputFile), "utf-8");
            Properties xslParams = LibraryPlugin.getDefault().getProperties("/layout/xsl/resources.properties");
            XSLTProcessor.transform((String)xsl_uri, (String)xml.toString(), (Properties)xslParams, (Writer)output);
            output.flush();
            output.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

