/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.layout.elements;

import com.ibm.uma.Activity;
import com.ibm.uma.ContentDescription;
import com.ibm.uma.ContentElement;
import com.ibm.uma.DescribableElement;
import com.ibm.uma.MethodConfiguration;
import com.ibm.uma.MethodElement;
import com.ibm.uma.MethodLibrary;
import com.ibm.uma.UmaPackage;
import com.ibm.uma.WorkOrder;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.epf.common.utils.NetUtil;
import org.eclipse.epf.library.LibraryPlugin;
import org.eclipse.epf.library.configuration.ConfigurationHelper;
import org.eclipse.epf.library.edit.util.TngUtil;
import org.eclipse.epf.library.layout.ElementLayoutManager;
import org.eclipse.epf.library.layout.IElementLayout;
import org.eclipse.epf.library.layout.LayoutInfo;
import org.eclipse.epf.library.layout.LayoutResources;
import org.eclipse.epf.library.layout.util.XmlElement;
import org.eclipse.epf.library.services.LibraryProcessor;
import org.eclipse.epf.library.util.ResourceHelper;
import org.eclipse.epf.uma.ecore.util.OppositeFeature;

public abstract class AbstractElementLayout
implements IElementLayout {
    protected ElementLayoutManager layoutManager;
    protected MethodElement element;
    protected MethodElement ownerElement;
    protected String url = null;
    protected String elementPath = "";
    protected String backPath = "";
    protected List layouts = null;
    protected MethodElement targetElement = null;
    protected boolean debug = LibraryPlugin.getDefault().isDebugging();
    static /* synthetic */ Class class$0;

    public void setContentTarget(MethodElement targetElement) {
        this.targetElement = targetElement;
    }

    public void setElementOwner(MethodElement owner) {
        this.ownerElement = owner;
    }

    public abstract void init(ElementLayoutManager var1, MethodElement var2);

    protected void __init(ElementLayoutManager layoutManager, MethodElement element) {
        this.layoutManager = layoutManager;
        this.element = element;
        if (!ConfigurationHelper.isDescriptionElement(element)) {
            this.buildPath();
            this.url = String.valueOf(this.elementPath) + this.getFileName(".html");
        }
        if (!(this.layoutManager.isPublishingMode() || element instanceof ContentDescription || element.eContainer() instanceof ContentDescription || element instanceof MethodConfiguration)) {
            try {
                String html_file = String.valueOf(this.layoutManager.getPublishDir()) + this.getFilePath() + this.getFileName(".html");
                File f = new File(html_file);
                if (!f.exists()) {
                    f.getParentFile().mkdirs();
                    f.createNewFile();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    protected void setLayoutInfo(LayoutInfo info) {
        if (this.layouts == null) {
            this.layouts = new ArrayList();
        }
        this.layouts.add(info);
    }

    public List getLayouts() {
        return this.layouts;
    }

    public ElementLayoutManager getLayoutMgr() {
        return this.layoutManager;
    }

    public MethodElement getElement() {
        return this.element;
    }

    public String getType() {
        return this.element.getType().getName();
    }

    public String getName() {
        return this.element.getName();
    }

    public String getDisplayName() {
        return TngUtil.getPresentationName((Object)this.element);
    }

    public String getId() {
        return this.element.getGuid();
    }

    public String getUrl() {
        return this.url;
    }

    public String getBackPath() {
        return this.backPath;
    }

    public String getFilePath() {
        return this.elementPath;
    }

    public String getFilePath(IElementLayout relativeTo) {
        return String.valueOf(relativeTo.getBackPath()) + this.getFilePath();
    }

    public String getFileName(String ext) {
        return ResourceHelper.getFileName(this.element, ext);
    }

    public String getXslUrl() {
        if (this.element instanceof ContentElement) {
            return LayoutResources.getXslUri(this.getType().toLowerCase(), "contentelement");
        }
        return LayoutResources.getXslUri(this.getType().toLowerCase(), null);
    }

    private void buildPath() {
        this.elementPath = "";
        this.backPath = "./";
        if (!(this.element instanceof MethodConfiguration) && !(this.element instanceof MethodLibrary)) {
            this.elementPath = ResourceHelper.getElementPath(this.element).replace(File.separatorChar, '/');
            this.backPath = ResourceHelper.getBackPath(this.element);
        }
    }

    public boolean needContentScan(String xslUrl) {
        return true;
    }

    protected IElementLayout getChildLayout(MethodElement child) {
        return this.layoutManager.getLayout(child, true);
    }

    protected void processChild(XmlElement parent, MethodElement e, boolean includeReferences) {
        IElementLayout l;
        if (e != null && (l = this.getChildLayout(e)) != null) {
            boolean isContent;
            boolean bl = isContent = e instanceof MethodElement && ConfigurationHelper.isDescriptionElement(e);
            if (isContent) {
                if (this.targetElement != null) {
                    l.setContentTarget(this.targetElement);
                }
                l.setElementOwner(this.element);
            }
            parent.addChild(l.getXmlElement(includeReferences));
        }
    }

    protected void processChild(XmlElement parent, List items, boolean includeReferences) {
        if (items != null && items.size() > 0) {
            Iterator it = items.iterator();
            while (it.hasNext()) {
                IElementLayout l;
                MethodElement me;
                Object e = it.next();
                if (!(e instanceof MethodElement) || (e = ConfigurationHelper.getCalculatedElement(me = (MethodElement)e, this.layoutManager.getConfiguration())) == null || (l = this.getChildLayout(me)) == null) continue;
                parent.addChild(l.getXmlElement(ConfigurationHelper.isDescriptionElement(me) ? true : includeReferences));
            }
        }
    }

    public void calculate0nReferences(XmlElement elementXml, boolean includeReferences) {
        List properties = this.element.getInstanceProperties();
        if (properties != null) {
            int i = 0;
            while (i < properties.size()) {
                EStructuralFeature feature = (EStructuralFeature)properties.get(i);
                if (feature.isMany()) {
                    this.loadFeature(feature, elementXml, includeReferences);
                }
                ++i;
            }
        }
    }

    protected XmlElement getXmlElement() {
        XmlElement elementXml = new XmlElement("Element").setAttribute("Type", this.getType()).setAttribute("TypeName", TngUtil.getTypeText((EObject)this.element)).setAttribute("Name", this.getName()).setAttribute("Url", this.getUrl()).setAttribute("BackPath", this.getBackPath()).setAttribute("ShapeiconUrl", this.getShapeiconUrl()).setAttribute("DisplayName", this.getDisplayName());
        return elementXml;
    }

    /*
     * Unable to fully structure code
     */
    public void loadAttributes(XmlElement elementXml) {
        block6: {
            isActivityAttribute = this.element instanceof Activity != false || this.element instanceof ContentDescription != false && this.element.eContainer() instanceof Activity != false;
            properties = this.element.getInstanceProperties();
            if (properties == null) break block6;
            i = 0;
            while (i < properties.size()) {
                block7: {
                    block9: {
                        block8: {
                            p = (EStructuralFeature)properties.get(i);
                            if (!(p instanceof EAttribute)) break block7;
                            attrib = (EAttribute)p;
                            name = p.getName();
                            if (!name.equals("presentationName")) break block8;
                            value = ConfigurationHelper.getPresentationName(this.element, this.layoutManager.getConfiguration());
                            break block9;
                        }
                        if (!isActivityAttribute) ** GOTO lbl-1000
                        v0 = AbstractElementLayout.class$0;
                        if (v0 == null) {
                            try {
                                v0 = Class.forName("java.lang.String");
                            }
                            catch (ClassNotFoundException v1) {
                                throw new NoClassDefFoundError(v1.getMessage());
                            }
                        }
                        if (v0.isAssignableFrom(attrib.getEAttributeType().getInstanceClass())) {
                            value = ConfigurationHelper.getActivityStringAttribute(this.element, attrib);
                        } else lbl-1000:
                        // 2 sources

                        {
                            value = this.getAttributeFeatureValue(p);
                        }
                    }
                    elementXml.newChild("attribute").setAttribute("name", name).setValue(value == null ? "" : value.toString());
                }
                ++i;
            }
        }
    }

    protected Object getAttributeFeatureValue(EStructuralFeature feature) {
        Object value = ConfigurationHelper.calcAttributeFeatureValue(this.element, this.ownerElement, feature, this.layoutManager.getConfiguration());
        if (this.targetElement != null && value != null && value.toString().length() > 0) {
            String contentPath = ResourceHelper.getElementPath(this.element instanceof ContentDescription ? (MethodElement)this.element.eContainer() : this.element);
            String backPath = ResourceHelper.getBackPath(this.targetElement instanceof ContentDescription ? (MethodElement)this.targetElement.eContainer() : this.targetElement);
            value = ResourceHelper.fixContentUrlPath(value.toString(), contentPath, backPath);
        }
        return value;
    }

    public void loadCopyright(XmlElement elementXml) {
        String copyright = ConfigurationHelper.getCopyrightText(this.element, this.layoutManager.getConfiguration());
        if (copyright != null && copyright.length() > 0) {
            elementXml.newChild("copyright").setValue(copyright);
        }
    }

    public void calculate01References(XmlElement elementXml, boolean includeReferences) {
        List properties = this.element.getInstanceProperties();
        if (properties != null) {
            int i = 0;
            while (i < properties.size()) {
                EStructuralFeature p = (EStructuralFeature)properties.get(i);
                EClassifier type = p.getEType();
                if (type instanceof EClass && !p.isMany()) {
                    this.loadFeature(p, elementXml, includeReferences);
                }
                ++i;
            }
        }
    }

    public void loadFeature(EStructuralFeature feature, XmlElement elementXml, boolean includeReferences) {
        List pv;
        if (!(feature.getEType() instanceof EClass)) {
            return;
        }
        String name = feature.getName();
        if (!feature.isMany()) {
            MethodElement e = ConfigurationHelper.calc01FeatureValue(this.element, feature, this.layoutManager.getElementRealizer());
            if (e != null && e != this.element) {
                boolean showDetail;
                boolean bl = showDetail = ConfigurationHelper.isDescriptionElement(e) ? true : includeReferences;
                if (this.acceptFeatureValue(feature, (Object)e)) {
                    this.processChild(elementXml.newChild("reference").setAttribute("name", name), e, showDetail);
                }
            }
        } else if (feature.isMany() && this.acceptFeatureValue(feature, (Object)(pv = ConfigurationHelper.calc0nFeatureValue(this.element, feature, this.layoutManager.getElementRealizer())))) {
            this.addReferences(elementXml, name, pv);
        }
    }

    public void loadFeature(OppositeFeature feature, XmlElement elementXml, boolean includeReferences) {
        List pv;
        String name = feature.getName();
        if (!feature.isMany()) {
            MethodElement e = ConfigurationHelper.calc01FeatureValue(this.element, feature, this.layoutManager.getConfiguration());
            if (e != null && e != this.element) {
                boolean showDetail;
                boolean bl = showDetail = ConfigurationHelper.isDescriptionElement(e) ? true : includeReferences;
                if (this.acceptFeatureValue(feature, (Object)e)) {
                    this.processChild(elementXml.newChild("reference").setAttribute("name", name), e, showDetail);
                }
            }
        } else if (feature.isMany() && this.acceptFeatureValue(feature, (Object)(pv = ConfigurationHelper.calc0nFeatureValue(this.element, feature, this.layoutManager.getConfiguration()))) && pv.size() > 0) {
            this.addReferences(elementXml, name, pv);
        }
    }

    public void loadReferences(XmlElement elementXml, boolean includeReferences) {
        List properties = this.element.getInstanceProperties();
        if (properties != null) {
            int i = 0;
            while (i < properties.size()) {
                EStructuralFeature feature = (EStructuralFeature)properties.get(i);
                if (feature.getEType() instanceof EClass) {
                    this.loadFeature(feature, elementXml, includeReferences);
                }
                ++i;
            }
        }
    }

    public void addReference(XmlElement elementXml, String referenceName, MethodElement element) {
        this.processChild(elementXml.newChild("reference").setAttribute("name", referenceName), element, false);
    }

    public void addReferences(XmlElement elementXml, String referenceName, List items) {
        this.processChild(elementXml.newChild("referenceList").setAttribute("name", referenceName), items, false);
    }

    public XmlElement getXmlElement(boolean includeReferences) {
        XmlElement elementXml = this.getXmlElement();
        if (includeReferences) {
            this.loadCopyright(elementXml);
            this.loadAttributes(elementXml);
            this.loadReferences(elementXml, false);
        }
        return elementXml;
    }

    protected boolean acceptFeatureValue(EStructuralFeature feature, Object value) {
        return true;
    }

    protected boolean acceptFeatureValue(OppositeFeature feature, Object value) {
        return true;
    }

    public String getShapeiconUrl() {
        String imageUrl;
        URI uri = null;
        if (this.element instanceof DescribableElement) {
            uri = ((DescribableElement)this.element).getShapeicon();
        }
        if (uri == null) {
            imageUrl = this.getDefaultShapeiconUrl();
        } else {
            URI imageUri = ResourceHelper.getRelativeURI(uri, LibraryProcessor.getInstance().getLibraryRootPath().toURI());
            imageUrl = NetUtil.decodedFileUrl((String)imageUri.toString());
        }
        if (!imageUrl.startsWith("images/")) {
            File source = new File(LibraryProcessor.getInstance().getLibraryRootPath(), imageUrl);
            File dest = new File(this.getLayoutMgr().getPublishDir(), imageUrl);
            ResourceHelper.copyFile(source, dest);
        }
        return imageUrl;
    }

    public String getNodeiconUrl() {
        return "";
    }

    public String getDefaultShapeiconUrl() {
        return LayoutResources.getDefaultShapeiconUrl(this.element.getType().getName().toLowerCase());
    }

    public String getDiagramiconUrl() {
        return "icons/" + this.element.getType().getName() + ".gif";
    }

    protected void loadWorkOrder(XmlElement elementXml) {
        EReference feature = UmaPackage.eINSTANCE.getWorkBreakdownElement_LinkToPredecessor();
        List items = ConfigurationHelper.calc0nFeatureValue(this.element, (EStructuralFeature)feature, this.layoutManager.getElementRealizer());
        XmlElement predecessorXml = elementXml.newChild("referenceList").setAttribute("name", feature.getName());
        if (items != null && items.size() > 0) {
            Iterator it = items.iterator();
            while (it.hasNext()) {
                IElementLayout l;
                WorkOrder wo = (WorkOrder)it.next();
                MethodElement me = ConfigurationHelper.calc01FeatureValue((MethodElement)wo, (EStructuralFeature)UmaPackage.eINSTANCE.getWorkOrder_Pred(), this.layoutManager.getElementRealizer());
                if (me == null || (l = this.getChildLayout(me)) == null) continue;
                predecessorXml.addChild(l.getXmlElement(false));
            }
        }
    }
}

