/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.services;

import com.ibm.uma.ContentElement;
import com.ibm.uma.MethodElement;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.epf.library.events.ILibraryChangeListener;
import org.eclipse.epf.library.services.GeneralReference;
import org.eclipse.epf.library.services.LibraryProcessor;
import org.eclipse.epf.library.services.PackageDependency;
import org.eclipse.epf.library.services.PackageReference;
import org.eclipse.epf.library.services.VariabilityElementReference;
import org.eclipse.epf.library.util.LibraryUtil;

public class DependencyManager {
    private LibraryProcessor libProc;
    private ILibraryChangeListener libListener = null;
    protected Map dependencyMap = new HashMap();

    public DependencyManager(LibraryProcessor libProc) {
        this.libProc = libProc;
        this.refresh();
        this.libListener = new ILibraryChangeListener(){

            public void libraryChanged(int option, Collection changedItems) {
                if (option == 1 || option == 4) {
                    DependencyManager.this.refresh();
                } else if (option == 16) {
                    DependencyManager.this.handleDeletedElement(changedItems);
                } else if ((option == 8 || option == 32) && changedItems != null && changedItems.size() > 0) {
                    Iterator it = changedItems.iterator();
                    while (it.hasNext()) {
                        try {
                            Object e = it.next();
                            if (e instanceof MethodElement) {
                                DependencyManager.this.buildDependencyFor((MethodElement)e);
                                continue;
                            }
                            System.out.println(e + " is not a method element");
                        }
                        catch (Exception ex) {
                            ex.printStackTrace();
                        }
                    }
                }
            }
        };
        this.libProc.addListener(this.libListener);
    }

    public void clear() {
        this.dependencyMap.clear();
    }

    public void refresh() {
        this.clear();
    }

    private void buildDependency(MethodElement input) {
        if (input == null) {
            return;
        }
        try {
            PackageDependency dep = this.buildDependencyFor(input);
            EList elements = input.eContents();
            if (elements != null) {
                Iterator it = elements.iterator();
                while (it.hasNext()) {
                    MethodElement element = (MethodElement)it.next();
                    if (element == null || LibraryUtil.selectable((EObject)element)) continue;
                    this.buildDependencyFor(element);
                }
            }
            dep.setLoaded(true);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public PackageDependency getDependency(MethodElement element) {
        if (!LibraryUtil.selectable((EObject)element)) {
            return null;
        }
        PackageDependency dep = this.getDependency((EObject)element, false);
        if (dep == null || !dep.isLoaded()) {
            this.buildDependency(element);
        }
        return this.getDependency((EObject)element, false);
    }

    private PackageDependency buildDependencyFor(MethodElement element) {
        EList references;
        EObject selectableBase;
        if (element == null) {
            return null;
        }
        EObject selectableElement = LibraryUtil.getSelectable((EObject)element);
        if (selectableElement == null) {
            return null;
        }
        PackageDependency theDep = this.getDependency(selectableElement, true);
        theDep.removeReference(element);
        ContentElement baseElement = null;
        if (element instanceof ContentElement && (baseElement = (ContentElement)((ContentElement)element).getVariabilityBasedOnElement()) != null && (selectableBase = LibraryUtil.getSelectable((EObject)baseElement)) != null) {
            PackageReference pkgRef = theDep.getReference(selectableBase, true);
            if (!pkgRef.hasReference(element, baseElement)) {
                VariabilityElementReference ref = new VariabilityElementReference(element, baseElement);
                pkgRef.addReference(ref);
            }
            this.getDependency(selectableBase, true).addDependent(selectableElement);
        }
        if ((references = element.eCrossReferences()) != null && references.size() > 0) {
            Iterator it = references.iterator();
            while (it.hasNext()) {
                EObject refElement = (EObject)it.next();
                EObject selectableRef = LibraryUtil.getSelectable(refElement);
                if (selectableRef == null) continue;
                PackageReference pkgRef = theDep.getReference(selectableRef, true);
                if (element == selectableElement && refElement == selectableRef) continue;
                if (!pkgRef.hasReference(element, refElement)) {
                    GeneralReference ref = new GeneralReference(element, refElement);
                    pkgRef.addReference(ref);
                }
                this.getDependency(selectableRef, true).addDependent(selectableElement);
            }
        }
        return theDep;
    }

    private PackageDependency getDependency(EObject element, boolean create) {
        if (!LibraryUtil.selectable(element)) {
            System.out.println("Error, Selectable element required: " + element);
            return null;
        }
        PackageDependency dep = (PackageDependency)this.dependencyMap.get(element);
        if (dep == null && create) {
            dep = new PackageDependency(element);
            this.dependencyMap.put(element, dep);
        }
        return dep;
    }

    private void handleDeletedElement(Collection changedItems) {
        Iterator it = changedItems.iterator();
        while (it.hasNext()) {
            Object e = it.next();
            if (!(e instanceof MethodElement)) continue;
            this.removeReference((MethodElement)e);
        }
    }

    private void removeReference(MethodElement element) {
        PackageDependency dep = null;
        MethodElement pkg = (MethodElement)LibraryUtil.getSelectable((EObject)element);
        if (pkg == null || (dep = this.getDependency((EObject)pkg, false)) == null) {
            return;
        }
        dep.removeReference(element);
    }

    public void print() {
        Iterator it = this.dependencyMap.values().iterator();
        while (it.hasNext()) {
            ((PackageDependency)it.next()).print();
        }
    }
}

