/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.util;

import com.ibm.uma.ContentDescription;
import com.ibm.uma.ContentElement;
import com.ibm.uma.ContentPackage;
import com.ibm.uma.Guidance;
import com.ibm.uma.MethodElement;
import com.ibm.uma.UmaFactory;
import com.ibm.uma.util.ContentDescriptionFactory;
import com.ibm.uma.util.IMethodLibraryPersister;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.epf.common.utils.StrUtil;
import org.eclipse.epf.library.LibraryPlugin;
import org.eclipse.epf.library.LibraryResources;
import org.eclipse.epf.library.edit.command.DeleteMethodElementCommand;
import org.eclipse.epf.library.edit.util.TngUtil;
import org.eclipse.epf.library.services.LibraryProcessor;
import org.eclipse.epf.library.util.ContentResourceScanner;
import org.eclipse.epf.persistence.MethodLibraryPersister;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.ListDialog;

public class ConvertGuidanceType {
    private static int[] compatibleGuidances = new int[]{72, 75, 81};
    private static List compatibleGuidancesList = new ArrayList();

    static {
        int i = 0;
        while (i < compatibleGuidances.length) {
            compatibleGuidancesList.add(new Integer(compatibleGuidances[i]));
            ++i;
        }
    }

    public static Guidance convertGuidance(Guidance oldGuidance, Shell shell, DeleteMethodElementCommand command) {
        if (shell == null) {
            shell = Display.getCurrent().getActiveShell();
        }
        ListDialog dlg = new ListDialog(shell);
        dlg.setHeightInChars(5);
        dlg.setContentProvider((IStructuredContentProvider)new ArrayContentProvider());
        dlg.setLabelProvider((ILabelProvider)new LabelProvider(){

            public String getText(Object element) {
                switch ((Integer)element) {
                    case 72: {
                        return LibraryResources.getString("Library.concept.text");
                    }
                    case 73: {
                        return LibraryResources.getString("Library.checklist.text");
                    }
                    case 74: {
                        return LibraryResources.getString("Library.example.text");
                    }
                    case 75: {
                        return LibraryResources.getString("Library.guideline.text");
                    }
                    case 76: {
                        return LibraryResources.getString("Library.estimate.text");
                    }
                    case 77: {
                        return LibraryResources.getString("Library.estimatingMetric.text");
                    }
                    case 78: {
                        return LibraryResources.getString("Library.estimationConsiderations.text");
                    }
                    case 79: {
                        return LibraryResources.getString("Library.report.text");
                    }
                    case 80: {
                        return LibraryResources.getString("Library.template.text");
                    }
                    case 81: {
                        return LibraryResources.getString("Library.supportingMaterial.text");
                    }
                    case 82: {
                        return LibraryResources.getString("Library.toolMentor.text");
                    }
                    case 83: {
                        return LibraryResources.getString("Library.whitepaper.text");
                    }
                    case 84: {
                        return LibraryResources.getString("Library.termDefinition.text");
                    }
                    case 85: {
                        return LibraryResources.getString("Library.practice.text");
                    }
                    case 86: {
                        return LibraryResources.getString("Library.reusableAsset.text");
                    }
                }
                return LibraryResources.getString("Library.unknownGuidance.text");
            }
        });
        List newGuidanceTypeList = ConvertGuidanceType.getValidNewGuidanceTypes(oldGuidance);
        if (newGuidanceTypeList == null) {
            LibraryPlugin.getDefault().getMsgDialog().displayError(LibraryResources.getString("Library.convertGuidanceError.title"), LibraryResources.getString("Library.unsupportedGuidanceTypeError.msg"), LibraryResources.formatString("Library.unsupportedGuidanceTypeError.reason", StrUtil.toLower((String)TngUtil.getTypeText((EObject)oldGuidance))));
            return null;
        }
        dlg.setInput((Object)newGuidanceTypeList);
        dlg.setTitle(LibraryResources.getString("Library.convertGuidanceDialog.title"));
        dlg.setMessage(LibraryResources.getString("Library.convertGuidanceDialog.text"));
        if (dlg.open() == 1) {
            return null;
        }
        Object[] selectionResult = dlg.getResult();
        if (selectionResult == null) {
            return null;
        }
        int chosenGuidance = (Integer)selectionResult[0];
        Guidance newGuidance = ConvertGuidanceType.doConvert(oldGuidance, chosenGuidance, command);
        return newGuidance;
    }

    private static Guidance doConvert(Guidance oldGuidance, int newGuidanceType, DeleteMethodElementCommand command) {
        Guidance newGuidance = null;
        try {
            File oldGuidancePathFile = new File(LibraryProcessor.getInstance().getLibraryRootPath(), MethodLibraryPersister.getElementPath((MethodElement)oldGuidance));
            newGuidance = ConvertGuidanceType.createNewGuidance(newGuidanceType);
            Iterator iter = oldGuidance.eClass().getEAllStructuralFeatures().iterator();
            while (iter.hasNext()) {
                EStructuralFeature feature = (EStructuralFeature)iter.next();
                Object o = oldGuidance.eGet(feature);
                if (feature.getFeatureID() == 7 || feature.getFeatureID() == 1) continue;
                newGuidance.eSet(feature, o);
            }
            String oldGuidanceGuid = oldGuidance.getGuid();
            ContentPackage oldGuidanceContainer = (ContentPackage)oldGuidance.eContainer();
            oldGuidanceContainer.getContentElements().add(newGuidance);
            ContentDescription newContentDesc = ContentDescriptionFactory.createContentDescription((ContentElement)newGuidance);
            newGuidance.setPresentation(newContentDesc);
            File newGuidancePathFile = new File(LibraryProcessor.getInstance().getLibraryRootPath(), MethodLibraryPersister.getElementPath((MethodElement)newGuidance));
            ContentResourceScanner scanner = new ContentResourceScanner(oldGuidancePathFile);
            scanner.setTargetRootPath(newGuidancePathFile);
            ContentDescription oldContentDesc = oldGuidance.getPresentation();
            iter = oldContentDesc.eClass().getEAllAttributes().iterator();
            while (iter.hasNext()) {
                EAttribute attrib = (EAttribute)iter.next();
                Object o = oldContentDesc.eGet((EStructuralFeature)attrib);
                if (o instanceof String && ((String)o).trim().length() > 0) {
                    scanner.resolveResources((MethodElement)newGuidance, (String)o, "");
                }
                newContentDesc.eSet((EStructuralFeature)attrib, o);
            }
            command.execute();
            if (!command.executed || command.failed) {
                oldGuidanceContainer.getContentElements().remove(newGuidance);
                newGuidance = null;
                newContentDesc = null;
                return null;
            }
            newGuidance.setGuid(oldGuidanceGuid);
            IMethodLibraryPersister.FailSafeMethodLibraryPersister persister = ContentDescriptionFactory.getMethodLibraryPersister().getFailSafePersister();
            try {
                if (newGuidance.eResource() != null) {
                    persister.save(newGuidance.eResource());
                }
                if (newGuidance.getPresentation().eResource() != null) {
                    persister.save(newGuidance.getPresentation().eResource());
                }
                if (oldGuidanceContainer.eResource() != null) {
                    persister.save(oldGuidanceContainer.eResource());
                }
                persister.commit();
            }
            catch (Exception e) {
                persister.rollback();
                command.undo();
                LibraryPlugin.getDefault().getMsgDialog().displayError(LibraryResources.getString("Library.convertGuidanceError.title"), LibraryResources.formatString("Library.saveConvertedGuidanceError.msg", newGuidance.getName()), LibraryResources.getString("Library.error.reason"), (Throwable)e);
                newGuidance = null;
            }
        }
        catch (Exception ex) {
            command.undo();
            LibraryPlugin.getDefault().getMsgDialog().displayError(LibraryResources.getString("Library.convertGuidanceError.title"), LibraryResources.formatString("Library.convertGuidanceError.msg", newGuidance.getName()), LibraryResources.getString("Library.error.reason"), (Throwable)ex);
            newGuidance = null;
        }
        return newGuidance;
    }

    private static Guidance createNewGuidance(int newGuidanceType) {
        switch (newGuidanceType) {
            case 72: {
                return UmaFactory.eINSTANCE.createConcept();
            }
            case 73: {
                return UmaFactory.eINSTANCE.createChecklist();
            }
            case 74: {
                return UmaFactory.eINSTANCE.createExample();
            }
            case 75: {
                return UmaFactory.eINSTANCE.createGuideline();
            }
            case 76: {
                return UmaFactory.eINSTANCE.createEstimate();
            }
            case 77: {
                return UmaFactory.eINSTANCE.createEstimatingMetric();
            }
            case 78: {
                return UmaFactory.eINSTANCE.createEstimationConsiderations();
            }
            case 79: {
                return UmaFactory.eINSTANCE.createReport();
            }
            case 80: {
                return UmaFactory.eINSTANCE.createTemplate();
            }
            case 81: {
                return UmaFactory.eINSTANCE.createSupportingMaterial();
            }
            case 82: {
                return UmaFactory.eINSTANCE.createToolMentor();
            }
            case 83: {
                return UmaFactory.eINSTANCE.createWhitepaper();
            }
            case 84: {
                return UmaFactory.eINSTANCE.createTermDefinition();
            }
            case 85: {
                return UmaFactory.eINSTANCE.createPractice();
            }
            case 86: {
                return UmaFactory.eINSTANCE.createReusableAsset();
            }
        }
        return null;
    }

    public static List getValidNewGuidanceTypes(Guidance oldGuidance) {
        if (oldGuidance == null) {
            return null;
        }
        Integer oldGuidanceClassID = new Integer(oldGuidance.eClass().getClassifierID());
        if (!compatibleGuidancesList.contains(oldGuidanceClassID)) {
            return null;
        }
        ArrayList<Integer> guidanceList = new ArrayList<Integer>();
        int i = 0;
        while (i < compatibleGuidances.length) {
            Integer compatibleGuidanceTypeClassID = new Integer(compatibleGuidances[i]);
            if (!oldGuidanceClassID.equals(compatibleGuidanceTypeClassID)) {
                guidanceList.add(compatibleGuidanceTypeClassID);
            }
            ++i;
        }
        return guidanceList;
    }
}

