/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.util;

import com.ibm.uma.MethodPlugin;
import com.ibm.uma.util.AssociationHelper;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.epf.library.util.ModelStorage;

public class PluginReferenceChecker {
    public static List checkCircularDependentPluginsInLibrary() {
        ArrayList<MethodPlugin> cdList = new ArrayList<MethodPlugin>();
        List allPluginList = ModelStorage.getBaseModels();
        Iterator iter = allPluginList.iterator();
        while (iter.hasNext()) {
            MethodPlugin element = (MethodPlugin)iter.next();
            if (!PluginReferenceChecker.hasCircularConflictWithPlugin(element)) continue;
            cdList.add(element);
        }
        return cdList;
    }

    public static boolean hasCircularConflictWithPlugin(MethodPlugin aPlugin) {
        List extendedBaseList;
        boolean answer = false;
        List allowableBaseList = PluginReferenceChecker.getApplicableBasePlugins(aPlugin);
        if (!allowableBaseList.containsAll(extendedBaseList = aPlugin.getBases())) {
            System.out.println("$$$: circular dependency detected for " + aPlugin.getName());
            PluginReferenceChecker.printPluginList("allowable plugin list", allowableBaseList);
            PluginReferenceChecker.printPluginList("current base list", extendedBaseList);
            answer = true;
        }
        return answer;
    }

    public static List getApplicableBasePlugins(MethodPlugin aPlugin) {
        List models = ModelStorage.getBaseModels();
        List descendantList = PluginReferenceChecker.getDescendants(aPlugin);
        Iterator iter = descendantList.iterator();
        while (iter.hasNext()) {
            MethodPlugin element = (MethodPlugin)iter.next();
            models.remove(element);
        }
        return models;
    }

    private static List getDescendants(MethodPlugin methodObject) {
        ArrayList descendantList = new ArrayList();
        ArrayList<MethodPlugin> objList = new ArrayList<MethodPlugin>();
        objList.add(methodObject);
        PluginReferenceChecker.getDescendants(descendantList, objList);
        return descendantList;
    }

    private static List getDescendants(List allDescendantList, List methodObjectList) {
        if (methodObjectList.isEmpty()) {
            return allDescendantList;
        }
        ArrayList combDescendantList = new ArrayList();
        Iterator iter = methodObjectList.iterator();
        while (iter.hasNext()) {
            MethodPlugin element = (MethodPlugin)iter.next();
            List descendantList = AssociationHelper.getPluginDirectExtensions((MethodPlugin)element);
            combDescendantList.addAll(descendantList);
        }
        allDescendantList.addAll(methodObjectList);
        ArrayList nextCheckList = new ArrayList();
        Iterator iter2 = combDescendantList.iterator();
        while (iter2.hasNext()) {
            Object element = iter2.next();
            if (allDescendantList.contains(element)) continue;
            nextCheckList.add(element);
        }
        return PluginReferenceChecker.getDescendants(allDescendantList, nextCheckList);
    }

    public static void printPluginList(String desc, List pluginList) {
        System.out.print("$$$ " + desc + ": [");
        Iterator iterator = pluginList.iterator();
        while (iterator.hasNext()) {
            MethodPlugin plugin = (MethodPlugin)iterator.next();
            System.out.print(String.valueOf(plugin.getName()) + ", ");
        }
        System.out.println("]");
    }
}

